/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CreatePayDetailType;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.PayDetailResult;

public class SWCPayDetailResendList
extends AbstractListPlugin {
    private static final String RESEND_PAYDETAIL = "recreatedetail";
    private static final String OP_RESEND_PAYDETAIL = "op_recreatedetail";
    private static final String CALLBACKID_RESENDPAYDETAIL = "callbackid_resendpaydetail";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "op_recreatedetail": {
                formOperate.getOption().setVariableValue("pageId", this.getView().getPageId());
                break;
            }
            case "recreatedetail": {
                this.openCheckForm();
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "op_recreatedetail": {
                OperationResult operationResult = args.getOperationResult();
                ISWCAppCache cache = SWCAppCache.get((String)this.getView().getPageId());
                String calTaskPersonIdMap = (String)cache.get("calTaskPersonIdMap", String.class);
                PayDetailResult result = this.resendPayDetail(calTaskPersonIdMap);
                operationResult.setShowMessage(false);
                ArrayList<String> failList = new ArrayList<String>(10);
                Boolean isError = (Boolean)cache.get("isError", Boolean.class);
                isError = isError == null ? Boolean.FALSE : isError;
                String errorMsg = ResManager.loadKDString((String)"\u91cd\u65b0\u751f\u6210\u660e\u7ec6\u5931\u8d25\u3002\u9009\u4e2d\u660e\u7ec6\u5173\u8054\u7684\u6838\u7b97\u8bb0\u5f55\u751f\u6210\u7684\u6240\u6709\u660e\u7ec6\u6ee1\u8db3\u4ee5\u4e0b\u6240\u6709\u6761\u4ef6\uff0c\u624d\u53ef\u91cd\u65b0\u751f\u6210\u660e\u7ec6\uff1a\u2460\u4ed8\u6b3e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\uff0c\u4e14\u4e0d\u5728\u5ba1\u6279\u6d41\u7a0b\u4e2d\u7684\u53d1\u653e\u660e\u7ec6\uff1b\u6216\u4ed8\u6b3e\u72b6\u6001\u4e3a\u201c\u5f85\u4ed8\u6b3e\u201d\uff0c\u4e14\u672a\u5728\u4ed8\u6b3e\u6d41\u7a0b\u4e2d\uff1b\u6216\u4ed8\u6b3e\u72b6\u6001\u4e3a\u201c\u4ed8\u6b3e\u5931\u8d25\u201d\uff1b\u2461\u505c\u7f13\u53d1\u72b6\u6001\u4e3a\u7a7a\u6216\u201c\u89e3\u201d\uff1b\u2462\u94f6\u884c\u5361\u53d8\u66f4\u72b6\u6001\u4e3a\u7a7a\u6216\u5ba1\u6279\u4e0d\u901a\u8fc7\uff1b\u2463\u662f\u5426\u5e9f\u5f03\u4e3a\u201c\u5426\u201d\u3002", (String)"SWCPayDetailResendList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                if (result == null) {
                    if (isError.booleanValue()) {
                        this.getView().showErrorNotification(errorMsg);
                    } else {
                        this.getView().showOperationResult(operationResult);
                    }
                    this.clear(cache);
                    return;
                }
                if (isError.booleanValue()) {
                    failList.add(errorMsg);
                }
                String totalCalPersonSet = (String)cache.get("totalCalPersonSet", String.class);
                Integer totalNum = ((Set)JSON.parseObject((String)totalCalPersonSet, Set.class)).size();
                String operateName = formOperate.getOperateName().getLocaleValue();
                this.showResendPayDetailResult(operateName, result, failList, totalNum);
                this.clear(cache);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "callbackid_resendpaydetail": {
                if (!e.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.getView().invokeOperation(OP_RESEND_PAYDETAIL);
                break;
            }
        }
    }

    private PayDetailResult resendPayDetail(String calTaskPersonIdMap) {
        if (SWCStringUtils.isEmpty((String)calTaskPersonIdMap)) {
            return null;
        }
        Map calTaskMap = (Map)JSON.parseObject((String)calTaskPersonIdMap, Map.class);
        if (calTaskMap.isEmpty()) {
            return null;
        }
        PayDetailResult result = PayDetailResult.getInstance();
        calTaskMap.forEach((calTaskId, calPersonIdList) -> {
            List idList = calPersonIdList.stream().distinct().collect(Collectors.toList());
            PayDetailResult resendResult = (PayDetailResult)SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"IPayDetailService", (String)"synCreatePayDetail", (Object[])new Object[]{idList, CreatePayDetailType.RESEND, calTaskId});
            result.addResult(resendResult);
        });
        return result;
    }

    private void showResendPayDetailResult(String operateName, PayDetailResult operationResult, List<String> failList, Integer totalNum) {
        failList.addAll(operationResult.getErrorList());
        int successCount = operationResult.getSuccessNum();
        int failCount = totalNum - successCount;
        String format = ResManager.loadKDString((String)"\u9009\u4e2d\u660e\u7ec6\u5173\u8054\u6838\u7b97\u8bb0\u5f55\u5171{0}\u6761\uff0c{1}\u6761\u6210\u529f\uff0c{2}\u6761\u5931\u8d25\u3002", (String)"HSASCalTableListPayPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String title = MessageFormat.format(format, totalNum, successCount, failCount);
        FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operateName, (String)title, failList);
        this.getView().showForm(parameters);
        this.getView().invokeOperation("refresh");
    }

    private void openCheckForm() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u7cfb\u7edf\u5c06\u5bf9\u60a8\u9009\u4e2d\u7684\u660e\u7ec6\u5173\u8054\u7684\u6240\u6709\u6838\u7b97\u8bb0\u5f55\uff0c\u91cd\u65b0\u83b7\u53d6\u4eba\u5458\u85aa\u8d44\u6863\u6848\u4e2d\u6700\u65b0\u7684\u85aa\u8d44\u53d1\u653e\u8bbe\u7f6e\u751f\u6210\u53d1\u653e\u660e\u7ec6\u3002\u65e7\u7684\u660e\u7ec6\u6570\u636e\u5c06\u88ab\u5e9f\u5f03\u3002\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"SWCPayDetailResendList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_RESENDPAYDETAIL));
    }

    private void clear(ISWCAppCache cache) {
        cache.remove("totalCalPersonSet");
        cache.remove("isError");
        cache.remove("calTaskPersonIdMap");
    }
}

