/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail.assignbankcard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.assignbankcard.AssignBankCardDTO;
import kd.swc.hsas.business.assignbankcard.AssignBankCardHelper;
import kd.swc.hsas.common.constants.AssignBankCardConstants;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class AssignBankCardEdit
extends SWCDataBaseEdit
implements AssignBankCardConstants {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        String clkKey;
        super.beforeClick(evt);
        switch (clkKey = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.checkAndSaveDetail();
            }
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null || customParams.size() == 0) {
            return;
        }
        List payDetailIds = (List)customParams.get("payDetailIds");
        Map payDetailSalaryFileMap = (Map)customParams.get("payDetailSalaryFileMap");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("paydetail", new Object[0]);
        setter.addField("salaryfile", new Object[0]);
        setter.addField("perbankcard", new Object[0]);
        payDetailIds.forEach(payDetailId -> setter.addRow(new Object[]{payDetailId, payDetailSalaryFileMap.getOrDefault(payDetailId, 0L)}));
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "donothing_assignbankcard": {
                this.openPerBankCardF7();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "deleteentry": {
                Boolean noEntry = this.checkIfNoEntry();
                if (!noEntry.booleanValue()) break;
                FormShowParameter assignParameter = this.getView().getFormShowParameter();
                assignParameter.setCustomParam("closeConfirm", (Object)Boolean.TRUE);
                this.getView().close();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        FormShowParameter assignParameter = this.getView().getFormShowParameter();
        Boolean closeConfirm = (Boolean)assignParameter.getCustomParam("closeConfirm");
        if (closeConfirm == null || !closeConfirm.booleanValue()) {
            event.setCancel(true);
            this.openCloseConfirm();
        }
    }

    private void openPerBankCardF7() {
        ListShowParameter perBankCardShowParameter = ShowFormHelper.createShowListForm((String)"hsas_perbankcardadd", (boolean)false);
        int currentRowIndex = ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).getEntryState("entryentity").getFocusRow();
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)16);
        Long salaryFileId = this.getModel().getEntryRowEntity("entryentity", currentRowIndex).getLong("paydetail.salaryfilehis.id");
        SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter salaryFileFilter = new QFilter("id", "=", (Object)salaryFileId);
        DynamicObject salaryFileQuery = salaryFileHelper.queryOne("id,employee.id,person.id", new QFilter[]{salaryFileFilter});
        Long employeeId = 0L;
        Long personId = 0L;
        if (salaryFileQuery != null) {
            employeeId = salaryFileQuery.getLong("employee.id");
            personId = salaryFileQuery.getLong("person.id");
        }
        customParams.put("person.id", personId);
        customParams.put("employee.id", employeeId);
        customParams.put("parententitynumber", "hsas_assignbankcard");
        customParams.put("currentrowindex", currentRowIndex);
        customParams.put("acctmodifyway", 4);
        List perBankCardFilters = perBankCardShowParameter.getListFilterParameter().getQFilters();
        QFilter perBankCardFilter = new QFilter("isdelete", "=", (Object)"0");
        perBankCardFilter.and("person.id", "=", (Object)personId);
        BaseDataHisHelper.addHisCurrFilter((QFilter)perBankCardFilter);
        perBankCardFilters.add(perBankCardFilter);
        perBankCardShowParameter.setListFilterParameter(new ListFilterParameter(perBankCardFilters, null));
        perBankCardShowParameter.setCustomParams((Map)customParams);
        perBankCardShowParameter.setShowTitle(true);
        perBankCardShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        perBankCardShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_perbankcardadd"));
        this.getView().showForm((FormShowParameter)perBankCardShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "hsas_perbankcardadd": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                this.setPerBankCard(returnData);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "close": {
                if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) break;
                FormShowParameter assignParameter = this.getView().getFormShowParameter();
                assignParameter.setCustomParam("closeConfirm", (Object)Boolean.TRUE);
                this.getView().close();
                break;
            }
        }
    }

    private void setPerBankCard(Map<String, Object> returnData) {
        Boolean isOk;
        if (returnData != null && returnData.size() > 0 && (isOk = (Boolean)returnData.get("isOk")).booleanValue()) {
            Long perBankCardSourceVId = (Long)returnData.get("perBankCardSourceVId");
            Integer currentRowIndex = (Integer)returnData.get("currentRowIndex");
            this.getModel().setValue("perbankcard", (Object)perBankCardSourceVId, currentRowIndex.intValue());
            this.getView().updateView("entryentity", currentRowIndex.intValue());
        }
    }

    private void openCloseConfirm() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("close", (IFormPlugin)this);
        String confirmTip = ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa\u5c06\u4e0d\u5904\u7406\u9700\u624b\u5de5\u6307\u5b9a\u94f6\u884c\u5361\u7684\u53d1\u653e\u660e\u7ec6\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AssignBankCardEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
    }

    private Boolean checkIfNoEntry() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null || entryEntity.size() == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void checkAndSaveDetail() {
        HashMap payDetailIdBankCardMap = Maps.newHashMapWithExpectedSize((int)16);
        long userId = RequestContext.get().getCurrUserId();
        boolean permFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_paydetail", (String)"2GIBYCJDRF+T");
        if (!permFlag) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u53d1\u653e\u660e\u7ec6\u201d\u7684\u201c\u8865\u5145\u94f6\u884c\u5361\u201d\u6743\u9650\u3002", (String)"AssignBankCardEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        Boolean checkMustInput = this.checkMustInput();
        if (checkMustInput.booleanValue()) {
            DynamicObject[] detailAbleToAssign = this.checkDataStatus(payDetailIdBankCardMap);
            List<DynamicObject> detailAbleToAssignList = Arrays.asList(detailAbleToAssign);
            this.saveBankCardForBatch(detailAbleToAssignList, payDetailIdBankCardMap);
        }
    }

    private Boolean checkMustInput() {
        String titleMSG;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Boolean allWereInput = Boolean.TRUE;
        ArrayList errorList = Lists.newArrayListWithExpectedSize((int)10);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            Long perBankCardId = entry.getLong("perbankcard.id");
            if (perBankCardId != null && perBankCardId != 0L) continue;
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff1a\u8bf7\u5148\u6307\u5b9a\u94f6\u884c\u5361\u3002", (String)"AssignBankCardEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            String format = MessageFormat.format(msg, i + 1);
            errorList.add(format);
            allWereInput = Boolean.FALSE;
        }
        String titleformat = "";
        if (errorList.size() != entryEntity.size()) {
            titleMSG = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6821\u9a8c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"AssignBankCardEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            titleformat = MessageFormat.format(titleMSG, entryEntity.size(), entryEntity.size() - errorList.size(), errorList.size());
        } else {
            titleMSG = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6821\u9a8c\u5931\u8d25{1}\u6761\u3002", (String)"AssignBankCardEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            titleformat = MessageFormat.format(titleMSG, entryEntity.size(), errorList.size());
        }
        FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter(null, (String)titleformat, (List)errorList);
        this.getView().showForm(parameters);
        return allWereInput;
    }

    private DynamicObject[] checkDataStatus(Map<Long, DynamicObject> payDetailIdBankCardMap) {
        ArrayList payDetailIds = Lists.newArrayListWithExpectedSize((int)10);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        entryEntity.forEach(entry -> {
            Long payDetailId = entry.getDynamicObject("paydetail").getLong("id");
            DynamicObject perBankCard = entry.getDynamicObject("perbankcard");
            payDetailIdBankCardMap.put(payDetailId, perBankCard);
            payDetailIds.add(payDetailId);
        });
        DynamicObject[] detailAbleToAssign = AssignBankCardHelper.findDetailAbleToAssign((List)payDetailIds);
        return detailAbleToAssign;
    }

    private void saveBankCardForBatch(List<DynamicObject> detailAbleToAssignList, Map<Long, DynamicObject> payDetailIdBankCardMap) {
        Integer successNum = detailAbleToAssignList.size();
        Integer failNum = this.getModel().getEntryEntity("entryentity").size() - successNum;
        HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
        if (successNum != 0) {
            ArrayList dtoForSetCardList = Lists.newArrayListWithExpectedSize((int)10);
            detailAbleToAssignList.forEach(paydetail -> {
                Long payDetailId = paydetail.getLong("id");
                DynamicObject perBankCard = (DynamicObject)payDetailIdBankCardMap.get(payDetailId);
                AssignBankCardDTO assignBankCardDTO = new AssignBankCardDTO();
                assignBankCardDTO.setPayDetail(paydetail);
                assignBankCardDTO.setChosenPerBankCard(Long.valueOf(perBankCard.getLong("id")));
                assignBankCardDTO.setChosenBankId(Long.valueOf(perBankCard.getLong("bankdeposit.id")));
                dtoForSetCardList.add(assignBankCardDTO);
            });
            AssignBankCardHelper.setBankCardForBatchDetail((List)dtoForSetCardList);
        }
        returnData.put("successNum", successNum);
        returnData.put("failNum", failNum);
        this.getView().getFormShowParameter().setCustomParam("closeConfirm", (Object)Boolean.TRUE);
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }
}

