/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail.bankoffer;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.agencypay.AgencyPayWriteBackService;
import kd.swc.hsas.business.bankoffer.BankOfferHelper;
import kd.swc.hsas.common.dto.BankOfferBatchExportDTO;
import kd.swc.hsas.common.dto.BankOfferExportErrorDTO;
import kd.swc.hsas.common.dto.BankOfferProgressInfo;
import kd.swc.hsas.common.enums.BankOfferEnum;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class BankOfferExportProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static Log logger = LogFactory.getLog(BankOfferExportProgressPlugin.class);
    private static final String EXPORTPROGRESSBAR = "exportprogressbar";
    private static final String KEY_BTNMIN = "btn_min";
    private static final String KEY_BTNOK = "btn_ok";
    private static final String KEY_BTNGIVEUP = "btn_giveup";
    private static final String KEY_FAILDETAILLAB = "labelfaildetail";
    private static final String KEY_FAILDATAILURL = "failDetailUrl";
    private static final String KEY_FILEISDOWN = "fileIsDown";
    private static final String TASK_RECORD = "task_record_%s";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.init();
    }

    public void initialize() {
        ProgressBar progressBar = (ProgressBar)this.getControl(EXPORTPROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Label failDetailLabel = (Label)this.getView().getControl(KEY_FAILDETAILLAB);
        failDetailLabel.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        ProgressBar progressBar = (ProgressBar)this.getControl(EXPORTPROGRESSBAR);
        progressBar.start();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control sControl = (Control)evt.getSource();
        switch (sControl.getKey()) {
            case "labelfaildetail": {
                this.downloadFailExcel();
                break;
            }
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        if (StringUtils.equals((CharSequence)progressKey, (CharSequence)EXPORTPROGRESSBAR)) {
            this.queryAndSetProgressDetails(progressEvent);
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        this.getView().setReturnData((Object)"refresh");
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("customMap");
        String recordId = (String)map.get("recordId");
        Boolean isFromBall = (Boolean)this.getView().getFormShowParameter().getCustomParam("isFromBall");
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_BANKOFFER_%s", recordId));
        BankOfferProgressInfo progress = (BankOfferProgressInfo)appCache.get("cache_bankreport_key", BankOfferProgressInfo.class);
        String floatingTaskId = (String)appCache.get("platformTaskInfo", String.class);
        if (progress != null) {
            int status = progress.getStatus();
            if (StringUtils.isEmpty((CharSequence)floatingTaskId)) {
                return;
            }
            HRBackgroundTaskHelper.getInstance().removeProgressPageId(this.getView(), floatingTaskId);
            Boolean isBackground = (Boolean)this.getView().getFormShowParameter().getCustomParam("isBackground");
            if (status != 2) {
                if (isBackground == null) {
                    HRBackgroundTaskHelper.getInstance().showBaskgroundTask(floatingTaskId);
                }
            } else {
                HRBackgroundTaskHelper.getInstance().confirmEndTask(floatingTaskId, "COMPLETED");
            }
            if (isFromBall != null && isFromBall.booleanValue()) {
                appCache.put(String.format(Locale.ROOT, "isProgressBall_%s", recordId), (Object)Boolean.FALSE);
            } else {
                appCache.put(String.format(Locale.ROOT, "isProgressBall_%s", recordId), (Object)Boolean.TRUE);
            }
        } else {
            Boolean isCancel = (Boolean)appCache.get(String.format(Locale.ROOT, "isCancel_%s", recordId), Boolean.class);
            if (isCancel != null && isCancel.booleanValue()) {
                HRBackgroundTaskHelper.getInstance().confirmEndTask(floatingTaskId, "ABORTED");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("donothing_giveup".equals(operateKey)) {
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            ConfirmCallBackListener callBack = new ConfirmCallBackListener("giveUp", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u653e\u5f03\u5bfc\u51fa\uff1f", (String)"BankOfferExportProgressPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), options, callBack);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "giveUp": {
                if (!messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.exportGiveUp();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportGiveUp() {
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("customMap");
        String recordId = (String)map.get("recordId");
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_BANKOFFER_%s", recordId));
        List payDetailEnableIds = (List)appCache.get("calPayDetailEnableList", List.class);
        BankOfferProgressInfo progress = (BankOfferProgressInfo)appCache.get("cache_bankreport_key", BankOfferProgressInfo.class);
        if (progress == null || progress.getStatus() == 2 || progress.getTotal() == progress.getFinish()) {
            return;
        }
        appCache.put(String.format(Locale.ROOT, "isCancel_%s", recordId), (Object)Boolean.TRUE);
        appCache.remove("cache_bankreport_key");
        try (TXHandle txHandle = TX.requiresNew();){
            this.updateBankOfferRec(recordId);
            this.updatePayDetailBankOfferStatus(payDetailEnableIds);
            AgencyPayWriteBackService service = new AgencyPayWriteBackService();
            Set calTableIds = (Set)appCache.get("calTableIds", Set.class);
            service.updateCaltablePayState(calTableIds);
        }
        this.getView().close();
    }

    private void updateBankOfferRec(String recordId) {
        DynamicObject[] query;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankofferrrec");
        String selectProperties = "id,reportstatus,reportoperation";
        QFilter filter = new QFilter("reportoperation", "=", (Object)recordId);
        for (DynamicObject dynamicObject : query = helper.query(selectProperties, new QFilter[]{filter})) {
            dynamicObject.set("reportstatus", (Object)BankOfferEnum.UNDEXPORT.getCode());
        }
        helper.save(query);
    }

    private void updatePayDetailBankOfferStatus(List<Long> payDetailEnableIds) {
        DynamicObject[] query;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        String selectProperties = "id,bankofferstatus,bankofferlog";
        QFilter filter = new QFilter("id", "in", payDetailEnableIds);
        for (DynamicObject dynamicObject : query = helper.query(selectProperties, new QFilter[]{filter})) {
            long bankOfferLogId = dynamicObject.getLong("bankofferlog.id");
            if (bankOfferLogId == 0L) {
                dynamicObject.set("bankofferstatus", (Object)BankOfferEnum.UNDEXPORT.getCode());
                continue;
            }
            dynamicObject.set("bankofferstatus", (Object)BankOfferEnum.INVALIDED.getCode());
        }
        helper.update(query);
    }

    private void init() {
        Label stateLabel = (Label)this.getView().getControl("statelabel");
        stateLabel.setText(ResManager.loadKDString((String)"\u62a5\u76d8\u6587\u4ef6\u5bfc\u51fa\u4e2d\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"BankOfferExportProgressPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map map = (Map)formShowParameter.getCustomParam("customMap");
        if (map == null) {
            return;
        }
        Label labelTotal = (Label)this.getView().getControl("totalnum");
        String totalNum = String.valueOf(map.get("totalNum"));
        labelTotal.setText(totalNum);
        Label labelSuccess = (Label)this.getView().getControl("successnum");
        labelSuccess.setText("0");
        Label labelFail = (Label)this.getView().getControl("failnum");
        labelFail.setText("0");
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTNMIN, KEY_BTNGIVEUP});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNOK, "detailpanel", "stateimage"});
    }

    private void queryAndSetProgressDetails(ProgressEvent progressEvent) {
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("customMap");
        String recordId = (String)map.get("recordId");
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_BANKOFFER_%s", recordId));
        BankOfferProgressInfo progress = (BankOfferProgressInfo)appCache.get("cache_bankreport_key", BankOfferProgressInfo.class);
        if (progress == null) {
            this.stopProgress(progressEvent, recordId);
            return;
        }
        int status = progress.getStatus();
        int total = progress.getTotal();
        int success = progress.getSuccess();
        int fail = progress.getFail();
        int finish = progress.getFinish();
        Label labelSuccess = (Label)this.getView().getControl("successnum");
        labelSuccess.setText(String.valueOf(success));
        Label labelFail = (Label)this.getView().getControl("failnum");
        labelFail.setText(String.valueOf(fail));
        this.setValueToProgressPage(progressEvent, status, total, finish);
        if (status == 2 || total == finish) {
            String errorString;
            this.stopProgress(progressEvent, recordId);
            this.exportResult(progress);
            Boolean isProgressBall = (Boolean)appCache.get(String.format(Locale.ROOT, "isProgressBall_%s", recordId), Boolean.class);
            List batchIds = (List)appCache.get("SWC_BANKOFFER_BATCH_IDS", List.class);
            ArrayList allErrorDTOS = new ArrayList(10);
            if (batchIds != null) {
                for (String batchId : batchIds) {
                    BankOfferBatchExportDTO dto = (BankOfferBatchExportDTO)appCache.get(String.format(Locale.ROOT, "SWC_BANKOFFER_BATCH_%s", batchId), BankOfferBatchExportDTO.class);
                    if (dto == null) {
                        String excelUrl = (String)appCache.get(KEY_FAILDATAILURL, String.class);
                        this.getView().getPageCache().put(KEY_FAILDATAILURL, excelUrl);
                        if (isProgressBall != null && !isProgressBall.booleanValue()) {
                            appCache.clear();
                        }
                        return;
                    }
                    allErrorDTOS.addAll(dto.getExportErrorDTOS());
                    List urls = dto.getUrl();
                    if (appCache.get(KEY_FILEISDOWN, Boolean.class) != null) continue;
                    for (String url : urls) {
                        this.getView().download(url);
                    }
                }
                appCache.put(KEY_FILEISDOWN, (Object)Boolean.TRUE);
            }
            if (SWCStringUtils.isNotEmpty((String)(errorString = (String)appCache.get("bankOfferExportError", String.class)))) {
                List BankOfferBatchExportDTO2 = JSON.parseArray((String)errorString, BankOfferExportErrorDTO.class);
                allErrorDTOS.addAll(BankOfferBatchExportDTO2);
            }
            if (CollectionUtils.isEmpty(allErrorDTOS)) {
                if (fail > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BankOfferExportProgressPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FAILDETAILLAB});
                if (isProgressBall != null && !isProgressBall.booleanValue()) {
                    appCache.clear();
                }
                return;
            }
            Label labels = (Label)this.getView().getControl(KEY_FAILDETAILLAB);
            labels.setText(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u8be6\u60c5", (String)"BankOfferExportProgressPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.TRUE, new String[]{"detailpanel"});
            BankOfferHelper.errorExcelExport(allErrorDTOS, (String)recordId);
            String excelUrl = (String)appCache.get(KEY_FAILDATAILURL, String.class);
            this.getView().getPageCache().put(KEY_FAILDATAILURL, excelUrl);
            if (isProgressBall != null && !isProgressBall.booleanValue()) {
                appCache.clear();
            }
        }
    }

    private void exportResult(BankOfferProgressInfo progress) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"detailpanel", "stateimage"});
        Label stateLabel = (Label)this.getView().getControl("statelabel");
        stateLabel.setText(ResManager.loadKDString((String)"\u5bfc\u51fa\u5b8c\u6210", (String)"BankOfferExportProgressPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        Image stateImage = (Image)this.getView().getControl("stateimage");
        stateImage.setUrl("/icons/pc/state/success_28_28.png");
        int total = progress.getTotal();
        int success = progress.getSuccess();
        int fail = progress.getFail();
        MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u5171{0}\u6761\u6570\u636e\uff0c{1}\u6761\u6210\u529f\uff0c{2}\u6761\u5931\u8d25", "BankOfferExportProgressPlugin_2", "swc-hsas-formplugin");
        SWCOpLogServiceHelper.addOpLog((IFormView)this.getView().getParentView(), (String)"donothing_bankoffer", (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[]{String.valueOf(total), String.valueOf(success), String.valueOf(fail)});
    }

    private void stopProgress(ProgressEvent progressEvent, String recordId) {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNMIN});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNGIVEUP});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTNOK});
        ProgressBar bar = (ProgressBar)progressEvent.getSource();
        bar.stop();
    }

    private void setValueToProgressPage(ProgressEvent progressEvent, int status, int total, int finish) {
        int percentage = 0;
        if (status == 2 || total == finish) {
            percentage = 100;
        } else {
            if (status == 0) {
                return;
            }
            if (total > 0) {
                percentage = new BigDecimal(String.valueOf(finish)).divide(new BigDecimal(String.valueOf(total)), 2, 1).multiply(new BigDecimal("100")).intValue();
            }
        }
        progressEvent.setProgress(percentage);
    }

    private void downloadFailExcel() {
        String excelUrl = this.getView().getPageCache().get(KEY_FAILDATAILURL);
        this.getView().download(excelUrl);
    }
}

