/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail.bankoffer;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.form.helper.WebOfficeBrowserHelper;
import kd.bos.mvc.form.helper.WebOfficeBrowserParam;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BankOfferLogList
extends AbstractListPlugin {
    private static final String BANK_OFFER_RECORD = "donothing_record";
    private static final String OP_BANK_OFFER_RECORD = "batch_record";
    private static final String BANK_OFFER_INVALID = "donothing_invalid";
    private static final String BANK_OFFER_PREVIEW = "donothing_preview";
    private static final String BANK_OFFER_DOWN = "donothing_down";
    private static final String OP_BANK_OFFER_INVALID = "batch_invalid";
    private static final String CALLBACKID_BANKOFFERINVALIDSECOND = "callbackid_bankofferinvalidsecond";
    private static final String CALLBACKID_BANKOFFERINVALIDREASON = "callbackid_bankofferinvalidreason";
    private static final String CALLBACKID_BANKOFFERRECORD = "callbackid_bankofferrecord";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List logIds = (List)formShowParameter.getCustomParam("defaultLogNumbers");
        if (logIds != null) {
            List qFilters = setFilterEvent.getQFilters();
            QFilter idFilter = new QFilter("bankofferrrec", "in", (Object)logIds);
            qFilters.add(idFilter);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("bankoffertpl.id".equals(fieldName)) {
            List qFilters = args.getQfilters();
            QFilter filter = new QFilter("datastatus", "!=", (Object)"-5");
            qFilters.add(filter);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        List columns = args.getListColumns();
        for (IListColumn iListColumn : columns) {
            String listFieldKey = iListColumn.getListFieldKey();
            if (!"number".equals(listFieldKey) && !"modifier.name".equals(listFieldKey)) continue;
            iListColumn.setFixed(true);
        }
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)packageDataEvent.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if ("listoperationcolumnap".equals(fieldKey)) {
            DynamicObject rowData = packageDataEvent.getRowData();
            Long modifierId = rowData.getLong("modifier.id");
            boolean isFailure = rowData.getBoolean("isfailure");
            Long userId = RequestContext.get().getCurrUserId();
            if (!userId.equals(modifierId)) {
                ArrayList list = (ArrayList)packageDataEvent.getFormatValue();
                for (OperationColItem item2 : list) {
                    item2.setVisible(false);
                }
                packageDataEvent.setFormatValue((Object)list);
            } else if (isFailure) {
                ArrayList list = (ArrayList)packageDataEvent.getFormatValue();
                list.stream().forEach(item -> {
                    if (BANK_OFFER_DOWN.equals(item.getOperationKey())) {
                        item.setVisible(false);
                    }
                });
                packageDataEvent.setFormatValue((Object)list);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (SWCStringUtils.equals((String)"bankoffertpl_name", (String)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            IListView listView = (IListView)this.getView();
            Long logId = (Long)listView.getFocusRowPkId();
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankreportlog");
            QFilter filter = new QFilter("id", "=", (Object)logId);
            DynamicObject logObj = helper.queryOne("bankoffertpl", new QFilter[]{filter});
            long tplHisId = logObj.getLong("bankoffertpl.id");
            filter = new QFilter("id", "=", (Object)tplHisId);
            helper = new SWCDataServiceHelper("hsas_bankoffertpl");
            DynamicObject dynamicObject = helper.queryOne("id", new QFilter[]{filter});
            if (dynamicObject == null) {
                String errorTips = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CalPayrollTaskList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorTips);
                return;
            }
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setFormId("hsas_bankoffertpl");
            parameter.setPkId((Object)tplHisId);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ((AbstractListView)this.getView()).getGridState().put("fieldKey", null);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection coll = args.getListSelectedData();
        Object[] ids = coll.getPrimaryKeyValues();
        switch (operateKey) {
            case "donothing_record": {
                int enableNum = this.getBankOfferLogRecordCountByIds(ids);
                this.openConfirmForm(enableNum, args);
                break;
            }
            case "donothing_invalid": {
                int enableInvalidNum = this.getBankOfferLogInvalidCountByIds(ids);
                this.checkInvalidValue(enableInvalidNum, args);
                break;
            }
            case "donothing_down": {
                IListView listView = (IListView)this.getView();
                Long id = (Long)listView.getFocusRowPkId();
                DynamicObject dynamicObject = this.downFileById(id);
                String url = dynamicObject.getString("bankofferurl");
                this.getView().download(url);
                break;
            }
            case "donothing_preview": {
                IListView listView = (IListView)this.getView();
                Long id = (Long)listView.getFocusRowPkId();
                DynamicObject dynamicObject = this.downFileById(id);
                this.previewFileByUrl(dynamicObject);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        operationResult.setShowMessage(false);
        switch (operateKey) {
            case "batch_record": {
                String msg = ResManager.loadKDString((String)"\u62a5\u76d8\u7ed3\u679c\u8bb0\u5f55\u6210\u529f\u3002", (String)"BankOfferLogList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u62a5\u76d8\u8bb0\u5f55\uff0c{1}\u6761\u8bb0\u5f55\u7ed3\u679c\u6210\u529f\uff0c{2}\u6761\u5931\u8d25\u3002", (String)"BankOfferLogList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.openOperationConfirmForm(operationResult, msg, title);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "batch_invalid": {
                String msg = ResManager.loadKDString((String)"\u62a5\u76d8\u5931\u6548\u6210\u529f\u3002", (String)"SWCPayDetailBankOfferList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u62a5\u76d8\u8bb0\u5f55\uff0c{1}\u6761\u5931\u6548\u6210\u529f\uff0c{2}\u6761\u5931\u8d25\u3002", (String)"BankOfferLogList_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.openOperationConfirmForm(operationResult, msg, title);
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "callbackid_bankofferrecord": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData == null || !((Boolean)returnData.get("isOk")).booleanValue()) break;
                this.operationData(OP_BANK_OFFER_RECORD, (String)returnData.get("result"));
                break;
            }
            case "callbackid_bankofferinvalidreason": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData == null || !((Boolean)returnData.get("isOk")).booleanValue()) break;
                this.operationData(OP_BANK_OFFER_INVALID, (String)returnData.get("reason"));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "callbackid_bankofferinvalidsecond": {
                if (!event.getResult().equals((Object)MessageBoxResult.Yes)) break;
                FormShowParameter para = new FormShowParameter();
                para.setFormId("hsas_bankofferinvareason");
                para.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACKID_BANKOFFERINVALIDREASON);
                para.setCloseCallBack(closeCallBack);
                this.getView().showForm(para);
                break;
            }
        }
    }

    private DynamicObject downFileById(Long id) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankreportlog");
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = helper.queryOne("bankofferurl,bankoffertpl", new QFilter[]{filter});
        return dynamicObject;
    }

    private void previewFileByUrl(DynamicObject dynamicObject) {
        String url = dynamicObject.getString("bankofferurl");
        String fileType = dynamicObject.getString("bankoffertpl.filetype");
        if ("1".equals(fileType)) {
            SWCAppCache.get((String)"hsas").put(String.format(Locale.ROOT, "bankOfferUrl%s", RequestContext.get().getCurrUserId()), (Object)url);
            HashMap customParams = new HashMap();
            WebOfficeBrowserParam webOfficeBrowserParam = new WebOfficeBrowserParam("hsas_boexcelpreview");
            webOfficeBrowserParam.setParams(customParams);
            webOfficeBrowserParam.setHideAddressBar(true);
            String previewUrl = WebOfficeBrowserHelper.buildUrl((WebOfficeBrowserParam)webOfficeBrowserParam);
            this.getView().openUrl(previewUrl);
        } else {
            url = url.replaceFirst("download.do", "preview.do");
            this.getView().openUrl(url);
        }
    }

    private int getBankOfferLogInvalidCountByIds(Object[] ids) {
        QFilter filter = new QFilter("id", "in", (Object)ids);
        QFilter abandonedFilter = new QFilter("isfailure", "=", (Object)Boolean.FALSE);
        abandonedFilter.or(new QFilter("isfailure", "is null", null));
        filter.and(abandonedFilter);
        Long userId = RequestContext.get().getCurrUserId();
        filter.and(new QFilter("creator", "=", (Object)userId));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankreportlog");
        int count = helper.count(new QFilter[]{filter});
        return count;
    }

    private void checkInvalidValue(int enableNum, BeforeDoOperationEventArgs args) {
        if (0 == enableNum) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u76d8\u8bb0\u5f55\u4e3a\u975e\u672c\u4eba\u64cd\u4f5c\u6570\u636e\u6216\u5df2\u5931\u6548\uff0c\u64cd\u4f5c\u62a5\u76d8\u5931\u6548\u5931\u8d25\u3002", (String)"BankOfferLogList_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u62a5\u76d8\u6587\u4ef6\u4e2d\u660e\u7ec6\u5747\u672a\u4ed8\u6b3e\uff0c\u907f\u514d\u91cd\u590d\u652f\u4ed8\u3002\u62a5\u76d8\u5931\u6548\u540e\uff0c\u53ef\u5bf9\u6587\u4ef6\u5185\u660e\u7ec6\u518d\u6b21\u5bfc\u51fa\u62a5\u76d8\u6216\u5bf9\u63a5\u51fa\u7eb3\u4ed8\u6b3e\u3002\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"BankOfferLogList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_BANKOFFERINVALIDSECOND));
    }

    private void openOperationConfirmForm(OperationResult operationResult, String msg, String title) {
        int enableNum;
        int totalNum = operationResult.getBillCount();
        int unEnableNum = totalNum - (enableNum = operationResult.getSuccessPkIds().size());
        if (0 == unEnableNum) {
            this.getView().showSuccessNotification(msg);
            return;
        }
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        List<String> failList = errorInfos.stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
        this.openOperationResultForm(totalNum, enableNum, unEnableNum, title, failList);
    }

    private void openOperationResultForm(int totalNum, int enableNum, int unEnableNum, String title, List<String> failList) {
        title = String.format(title, totalNum, enableNum, unEnableNum);
        FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter(null, (String)title, failList);
        this.getView().showForm(parameters);
    }

    private void operationData(String operation, String text) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("text", text);
        this.getView().invokeOperation(operation, operateOption);
    }

    private int getBankOfferLogRecordCountByIds(Object[] ids) {
        Long userId = RequestContext.get().getCurrUserId();
        QFilter filter = new QFilter("id", "in", (Object)ids);
        filter.and(new QFilter("creator", "=", (Object)userId));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankreportlog");
        int count = helper.count(new QFilter[]{filter});
        return count;
    }

    private void openConfirmForm(int enableNum, BeforeDoOperationEventArgs args) {
        if (0 == enableNum) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bf9\u975e\u672c\u4eba\u64cd\u4f5c\u7684\u94f6\u884c\u62a5\u76d8\u8fdb\u884c\u7ed3\u679c\u8bb0\u5f55\u3002", (String)"BankOfferLogList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormShowParameter para = new FormShowParameter();
        para.setFormId("hsas_bankofferresult");
        para.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACKID_BANKOFFERRECORD);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }
}

