/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail.bankoffer;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.common.dto.BankOfferSelectTplDTO;
import kd.swc.hsas.formplugin.web.AbstractDyFormPlugin;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BankOfferSelectCommonEdit
extends AbstractDyFormPlugin {
    protected static final String EXPORT = "donothing_export";
    protected static final String BANKCGSETTING = "bankcgsetting";
    protected static final String BANKOFFERTPL = "bankoffertpl";
    protected static final String BANKOFFERDESC = "bankofferdesc";
    protected static final String NOACCOUNTEXPORT = "noaccountexport";
    protected static final String CLOSE_TRUE = "1";

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)EXPORT, (String)operateKey)) {
            HashSet<String> error = new HashSet<String>(16);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            this.checkMustInput(dataEntity, error);
            if (!error.isEmpty()) {
                StringJoiner joiner = new StringJoiner("\u201d \u3001\u201c", "\u201c", "\u201d");
                error.forEach(joiner::add);
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"BankOfferSelectCommonEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), joiner.toString()));
                args.setCancel(true);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        String closeTrue = this.getPageCache().get("isClose");
        if (SWCStringUtils.isEmpty((String)closeTrue)) {
            HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
            returnData.put("isOk", Boolean.FALSE);
            this.getView().returnDataToParent((Object)returnData);
        }
    }

    protected boolean checkHasTpl(QFilter filter) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankoffertpl");
        QFilter enableFilter = new QFilter("enable", "=", (Object)CLOSE_TRUE);
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
        return helper.count(new QFilter[]{filter, enableFilter, auditFilter, hisCurrFilter}) > 0;
    }

    protected void saveDataValueIfUsed(List<BankOfferSelectTplDTO> selectBankList, Boolean isMul) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankoffertplrec");
        Long userId = RequestContext.get().getCurrUserId();
        Date nowDate = new Date();
        DynamicObject dynamicObject = helper.generateEmptyDynamicObject();
        dynamicObject.set("ismul", (Object)isMul);
        dynamicObject.set("createtime", (Object)nowDate);
        dynamicObject.set("modifytime", (Object)nowDate);
        dynamicObject.set("creator", (Object)userId);
        dynamicObject.set("modifier", (Object)userId);
        dynamicObject.set("modifier", (Object)userId);
        DynamicObjectCollection entryDyCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        selectBankList.forEach(data -> {
            DynamicObject entry = helper.generateEmptyEntryDynamicObject("entryentity");
            entry.set(BANKCGSETTING, (Object)data.getBankCgSettingId());
            entry.set(BANKOFFERTPL, (Object)data.getBankOfferTplId());
            entry.set(BANKOFFERDESC, (Object)data.getBankOfferDesc());
            entry.set(NOACCOUNTEXPORT, (Object)data.getNoAcctExport());
            entryDyCollection.add((Object)entry);
        });
        helper.saveOne(dynamicObject);
    }

    private void checkMustInput(DynamicObject dataEntity, Set<String> error) {
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        properties.forEach(property -> {
            String name = property.getName();
            boolean isMustInput = false;
            if (dataEntity.get(name) == null) {
                if (property instanceof FieldProp) {
                    FieldProp fieldProp = (FieldProp)property;
                    isMustInput = fieldProp.isMustInput();
                }
                if (property instanceof BasedataProp) {
                    BasedataProp basedataProp = (BasedataProp)property;
                    isMustInput = basedataProp.isMustInput();
                }
            }
            if (property instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)property;
                isMustInput = entryProp.isEntryMustInput();
                DynamicObjectCollection collection = (DynamicObjectCollection)dataEntity.get(name);
                for (DynamicObject data : collection) {
                    this.checkMustInput(data, error);
                }
            }
            if (isMustInput) {
                error.add(property.getDisplayName().getLocaleValue());
            }
        });
    }
}

