/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail.bankoffer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.common.dto.BankOfferSelectTplDTO;
import kd.swc.hsas.formplugin.web.basedata.paydetail.bankoffer.BankOfferSelectCommonEdit;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class BankOfferSelectMulEdit
extends BankOfferSelectCommonEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(BankOfferSelectMulEdit.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit tpl = (BasedataEdit)this.getControl("bankoffertpl");
        tpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit setting = (BasedataEdit)this.getControl("bankcgsetting");
        setting.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.setDataValueIfUsed();
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey = arg.getProperty().getName();
        if (SWCStringUtils.equals((String)"bankoffertpl", (String)fieldKey)) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            int index = proxy.getEntryState("entryentity").getFocusRow();
            DynamicObject bankcgSetting = this.getModel().getEntryRowEntity("entryentity", index).getDynamicObject("bankcgsetting");
            if (bankcgSetting == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u62a5\u76d8\u94f6\u884c\u3002", (String)"BankOfferSelectEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                arg.setCancel(true);
                return;
            }
            ListShowParameter param = (ListShowParameter)arg.getFormShowParameter();
            QFilter commonFilter = new QFilter("banktype", "=", (Object)"1");
            QFilter allocateFilter = new QFilter("banktype", "=", (Object)"2");
            allocateFilter.and(new QFilter("bankcgsettingid", "=", (Object)bankcgSetting.getLong("id")));
            commonFilter.or(allocateFilter);
            if (!this.checkHasTpl(commonFilter)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u9009\u62a5\u76d8\u6a21\u677f\uff0c\u8bf7\u524d\u5f80\u201c\u85aa\u8d44\u53d1\u653e>\u53d1\u653e\u914d\u7f6e>\u94f6\u884c\u62a5\u76d8\u6a21\u677f\u201d\u7ef4\u62a4\u62a5\u76d8\u6a21\u677f\uff0c\u6216\u5728\u53d1\u653e\u660e\u7ec6\u8868\u70b9\u51fb\u201c\u62a5\u76d8\u6a21\u677f\u914d\u7f6e\u201d\u3002", (String)"BankOfferSelectEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                arg.setCancel(true);
                return;
            }
            param.getListFilterParameter().setFilter(commonFilter);
        }
        if (SWCStringUtils.equals((String)"bankcgsetting", (String)fieldKey)) {
            ListShowParameter param = (ListShowParameter)arg.getFormShowParameter();
            List ids = this.getModel().getEntryEntity("entryentity").stream().map(data -> data.getLong("bankcgsetting.id")).collect(Collectors.toList());
            param.getListFilterParameter().setFilter(new QFilter("id", "not in", ids));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if ("noaccountexport".equals(name)) {
            ChangeData[] datas = args.getChangeSet();
            String export = (String)datas[0].getNewValue();
            boolean isExport = "1".equals(export);
            this.getView().setVisible(Boolean.valueOf(isExport), new String[]{"bankoffertplnoaccount", "bankofferdescnoaccount"});
            ((BasedataEdit)this.getControl("bankoffertplnoaccount")).setMustInput(isExport);
            if (!isExport) {
                this.getModel().setValue("bankoffertplnoaccount", null);
                this.getModel().setValue("bankofferdescnoaccount", null);
            }
        }
        if ("bankcgsetting".equals(name)) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            int index = proxy.getEntryState("entryentity").getFocusRow();
            DynamicObject tpl = this.getModel().getEntryRowEntity("entryentity", index).getDynamicObject("bankoffertpl");
            if (tpl != null && "2".equals(tpl.getString("banktype"))) {
                this.getModel().setValue("bankoffertpl", null);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)"donothing_export", (String)operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            boolean isExport = "1".equals(dataEntity.getString("noaccountexport"));
            DynamicObjectCollection bankCol = dataEntity.getDynamicObjectCollection("entryentity");
            if (!isExport && bankCol.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4e3a\u4e00\u4e2a\u94f6\u884c\u8bbe\u7f6e\u62a5\u76d8\u6a21\u677f\u3002", (String)"BankOfferSelectMulEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!args.getOperationResult().isSuccess()) {
                return;
            }
            ArrayList<BankOfferSelectTplDTO> selectBankList = new ArrayList<BankOfferSelectTplDTO>(bankCol.size());
            bankCol.forEach(bankData -> {
                BankOfferSelectTplDTO bankDTO = new BankOfferSelectTplDTO(Long.valueOf(bankData.getLong("bankcgsetting.id")), bankData.getString("bankcgsetting.name"), bankData.getString("bankofferdesc"), Long.valueOf(bankData.getLong("bankoffertpl.id")), Long.valueOf(bankData.getLong("bankoffertpl.sourcevid")), bankData.getString("bankoffertpl.name"), bankData.getString("bankcgsetting.type_code"), Boolean.FALSE, Boolean.TRUE);
                selectBankList.add(bankDTO);
            });
            if (isExport) {
                selectBankList.add(new BankOfferSelectTplDTO(Long.valueOf(0L), "", dataEntity.getString("bankofferdescnoaccount"), Long.valueOf(dataEntity.getLong("bankoffertplnoaccount.id")), Long.valueOf(dataEntity.getLong("bankoffertplnoaccount.sourcevid")), dataEntity.getString("bankoffertplnoaccount.name"), "", Boolean.TRUE, Boolean.TRUE));
            }
            HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
            returnData.put("isOk", Boolean.TRUE);
            returnData.put("bankOfferData", selectBankList);
            this.saveDataValueIfUsed(selectBankList, Boolean.TRUE);
            this.getPageCache().put("isClose", "1");
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        }
    }

    private void setDataValueIfUsed() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankoffertplrec");
        Long userid = RequestContext.get().getCurrUserId();
        QFilter creatorFilter = new QFilter("creator", "=", (Object)userid);
        creatorFilter.and(new QFilter("ismul", "=", (Object)Boolean.TRUE));
        DynamicObject selectObject = helper.queryOne("bankcgsetting.id,bankcgsetting.enable,bankoffertpl.enable,bankoffertpl.id,bankoffertpl.status,noaccountexport,bankofferdesc", new QFilter[]{creatorFilter}, "createtime desc");
        Boolean isExport = Boolean.FALSE;
        JSONObject customMap = (JSONObject)this.getView().getFormShowParameter().getCustomParam("customMap");
        JSONArray agentpaybankIdsJsonArray = (JSONArray)customMap.get((Object)"agentpaybankIds");
        List agentpaybankIds = agentpaybankIdsJsonArray.toJavaList(Long.class);
        SWCDataServiceHelper bankOfferTplHelper = new SWCDataServiceHelper("hsas_bankoffertpl");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        QFilter banktype = new QFilter("banktype", "=", (Object)"1");
        banktype.or(new QFilter("bankcgsettingid", "in", (Object)agentpaybankIds));
        QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
        DynamicObject[] dynamicObjects = bankOfferTplHelper.query("id,banktype,bankcgsettingid", new QFilter[]{enableFilter, auditFilter, hisCurrFilter, banktype});
        DynamicObjectCollection dataCol = new DynamicObjectCollection();
        if (!SWCObjectUtils.isEmpty((Object)selectObject)) {
            dataCol = selectObject.getDynamicObjectCollection("entryentity");
            isExport = dataCol.stream().anyMatch(data -> data.getBoolean("noaccountexport"));
            this.getView().setVisible(isExport, new String[]{"bankoffertplnoaccount", "bankofferdescnoaccount"});
            ((BasedataEdit)this.getControl("bankoffertplnoaccount")).setMustInput(isExport.booleanValue());
        }
        this.setDataEntry(dataCol, agentpaybankIds, dynamicObjects);
        this.getView().setVisible(isExport, new String[]{"bankoffertplnoaccount", "bankofferdescnoaccount"});
    }

    private void setDataEntry(@NotNull DynamicObjectCollection dataCol, List<Long> agentpaybankIds, DynamicObject[] dynamicObjects) {
        List resultList;
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("bankcgsetting", new Object[0]);
        setter.addField("bankoffertpl", new Object[0]);
        setter.addField("bankofferdesc", new Object[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        List bankOfferTplIds = Arrays.stream(dynamicObjects).filter(dy -> SWCStringUtils.equals((String)"1", (String)dy.getString("banktype"))).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        logger.info("setDataEntry bankOfferTplIds:{}", bankOfferTplIds);
        Map<Object, Object> dataColMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!CollectionUtils.isEmpty((Collection)dataCol)) {
            dataColMap = dataCol.stream().collect(Collectors.toMap(data -> data.getLong("bankcgsetting.id"), Function.identity(), (o1, o2) -> o2));
            List bankcgSettingIds = dataCol.stream().map(data -> data.getLong("bankcgsetting.id")).collect(Collectors.toList());
            logger.info("setDataEntry bankcgSettingIds:{}", bankcgSettingIds);
            logger.info("setDataEntry agentpaybankIds:{}", agentpaybankIds);
            resultList = (List)CollectionUtils.intersection(bankcgSettingIds, agentpaybankIds);
            List subtractList = (List)CollectionUtils.subtract((Collection)agentpaybankIds, bankcgSettingIds);
            resultList.addAll(subtractList);
        } else {
            resultList = agentpaybankIds;
        }
        logger.info("setDataEntry \u6700\u540e\u5339\u914d\u7ed3\u679c:{}", resultList);
        for (Long bankCgId : resultList) {
            Long bankoffertplId;
            if (bankCgId == 0L) continue;
            List bankOfferTplSetIds = Arrays.stream(dynamicObjects).filter(dy -> bankCgId.longValue() == dy.getLong("bankcgsettingid.id")).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            logger.info("setDataEntry bankOfferTplSetIds:{}", bankOfferTplSetIds);
            bankOfferTplSetIds.addAll(bankOfferTplIds);
            logger.info("setDataEntry bankOfferTplSetIds 2:{}", bankOfferTplSetIds);
            Long bankOfferTplId = null;
            String bankOfferDesc = null;
            DynamicObject bankCg = (DynamicObject)dataColMap.get(bankCgId);
            if (bankOfferTplSetIds.size() == 1) {
                bankOfferTplId = (Long)bankOfferTplSetIds.get(0);
            } else if (!SWCObjectUtils.isEmpty((Object)bankCg) && bankOfferTplSetIds.contains(bankoffertplId = Long.valueOf(bankCg.getLong("bankoffertpl.id")))) {
                bankOfferTplId = bankoffertplId;
            }
            if (!SWCObjectUtils.isEmpty((Object)bankCg)) {
                bankOfferDesc = bankCg.getString("bankofferdesc");
            }
            setter.addRow(new Object[]{bankCgId, bankOfferTplId, bankOfferDesc});
        }
        if (!CollectionUtils.isEmpty((Collection)dataCol)) {
            dataCol.forEach(data -> {
                if (data.getBoolean("noaccountexport")) {
                    this.getModel().setValue("noaccountexport", (Object)"1");
                    this.getModel().setValue("bankofferdescnoaccount", data.get("bankofferdesc"));
                    if ("1".equals(data.getString("bankoffertpl.enable"))) {
                        this.getModel().setValue("bankoffertplnoaccount", data.get("bankoffertpl.id"));
                    }
                }
            });
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
        this.getView().updateView("noaccountexport");
        this.getView().updateView("bankofferdescnoaccount");
        this.getView().updateView("bankoffertplnoaccount");
    }
}

