/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail.modifybankaccount;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.sdk.swc.hsas.common.events.paydetail.BankAccountModifyFilterEvent;
import kd.swc.hsas.business.modifybankaccount.helper.BankAccountModifyHelper;
import kd.swc.hsas.business.modifybankaccount.view.SetCommonViewProperties;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.util.SWCGridUtils;
import kd.swc.hsbp.common.util.SWCListUtils;

public class SWCBankAccountModifyF7Plugin
extends AbstractListPlugin
implements SetCommonViewProperties {
    private static final String GEN_MODIFY_BILL_CONFIRM_KEY = "genBankAccountModifyBillConfirmKey";
    private static final String VALID_PAY_DETAIL_ID_SET = "validPayDetailIdSet";
    public static final Log logger = LogFactory.getLog(SWCBankAccountModifyF7Plugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"batchoperate"});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] payDetailInfoArr;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null || customParams.size() == 0) {
            return;
        }
        int invalidPkIdSize = (Integer)customParams.get("failedPkIdSet");
        Set validPayDetailPkIdSet = ((JSONArray)customParams.get("successPkIdSet")).stream().map(pkId -> (Long)pkId).collect(Collectors.toSet());
        if (invalidPkIdSize > 0) {
            String errMsg = ResManager.loadKDString((String)"\u5171\u5904\u7406{0}\u6761\u53d1\u653e\u660e\u7ec6\uff0c{1}\u6761\u5df2\u5728\u4ed8\u6b3e\u6d41\u7a0b\u4e2d\u6216\u5df2\u8fdb\u884c\u505c\u7f13\u53d1\u6216\u5df2\u5728\u8fdb\u884c\u94f6\u884c\u5361\u53d8\u66f4\u6216\u5df2\u5e9f\u5f03\u6216\u4e0d\u9700\u8981\u94f6\u884c\u5361\u4fe1\u606f\uff0c\u5df2\u4e3a\u60a8\u81ea\u52a8\u6392\u9664\u3002", (String)"SWCBankAccountModifyF7Plugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            errMsg = MessageFormat.format(errMsg, validPayDetailPkIdSet.size() + invalidPkIdSize, invalidPkIdSize);
            this.getView().showTipNotification(errMsg);
        }
        if ((payDetailInfoArr = BankAccountModifyHelper.getPayDetailInfoArr(validPayDetailPkIdSet)) == null || payDetailInfoArr.length == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        this.createBankAccountEntity(payDetailInfoArr);
        this.getView().scrollIntoView("auditor");
        model.endInit();
        this.getView().updateView("paydetail");
    }

    public void initialize() {
        this.setOperationColumnVisibleOrNot();
    }

    private void setOperationColumnVisibleOrNot() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(pkEvent -> {
            if (pkEvent.getSource() instanceof OperationColumn && "operationcolumnap".equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                DynamicObject rowData = pkEvent.getRowData();
                String modifyWay = rowData.getString("acctmodifyway");
                List operationColItems = (List)pkEvent.getFormatValue();
                String payDetailId = rowData.getString("paydetail.id");
                String lastCacheJsonStr = this.getView().getPageCache().get("last" + payDetailId);
                for (OperationColItem item : operationColItems) {
                    if ("3".equals(modifyWay)) {
                        item.setVisible(!"history".equals(item.getOperationKey()) || lastCacheJsonStr != null);
                        continue;
                    }
                    item.setVisible(false);
                }
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("acctmodifyway".equals(e.getProperty().getName())) {
            this.resetBankAccountInfoAndAuditor(e.getChangeSet());
            this.setFontColorForModifiedRows();
            this.getView().updateView("entryentity", 0);
        }
    }

    private void resetBankAccountInfoAndAuditor(ChangeData[] changeDataArr) {
        if (changeDataArr == null || changeDataArr.length == 0) {
            return;
        }
        HashMap idMaps = Maps.newHashMapWithExpectedSize((int)16);
        List personIds = Arrays.stream(changeDataArr).map(obj -> obj.getDataEntity().getLong("salaryfilehis.person.id")).collect(Collectors.toList());
        idMaps.put("person", personIds);
        Map personBosUserMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        Map bosUserIdMap = (Map)personBosUserMap.get("data");
        for (ChangeData changeData : changeDataArr) {
            DynamicObject dynamicObject = changeData.getDataEntity();
            this.setCurrAuditor(dynamicObject, changeData.getRowIndex(), bosUserIdMap);
            String modifyWay = dynamicObject.getString("acctmodifyway");
            long payDetailId = dynamicObject.getLong("paydetail.id");
            this.reSetBankCardInfo(changeData.getRowIndex(), modifyWay, payDetailId);
        }
    }

    private void reSetBankCardInfo(int rowIndex, String modifyWay, long payDetailId) {
        if (modifyWay == null) {
            return;
        }
        IPageCache pageCache = this.getView().getPageCache();
        IClientViewProxy clientService = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        String firstCacheJsonStr = pageCache.get("first" + payDetailId);
        String lastCacheJsonStr = pageCache.get("last" + payDetailId);
        if (lastCacheJsonStr != null && firstCacheJsonStr != null) {
            if ("3".equals(modifyWay)) {
                JSON.parseObject((String)lastCacheJsonStr).forEach((key, val) -> this.getModel().setValue(key, val, rowIndex));
            } else {
                JSON.parseObject((String)firstCacheJsonStr).forEach((key, val) -> this.getModel().setValue(key, val, rowIndex));
                BANK_ACCOUNT_PROS.forEach(proKey -> SWCGridUtils.setGridStyle((IClientViewProxy)clientService, (String)"entryentity", (int)rowIndex, (String)proKey, (String)"#333333"));
            }
        }
    }

    private void setCurrAuditor(DynamicObject dynamicObject, int rowIndex, Map<Long, Map<String, Long>> bosUserIdMap) {
        String modifyWay = dynamicObject.getString("acctmodifyway");
        if ("3".equals(modifyWay)) {
            this.getModel().setValue("auditor", (Object)RequestContext.get().getCurrUserId(), rowIndex);
        } else if ("1".equals(modifyWay)) {
            Map<String, Long> idValueMap;
            Long personId = dynamicObject.getLong("salaryfilehis.person.id");
            if (bosUserIdMap != null && (idValueMap = bosUserIdMap.get(personId)) != null) {
                personId = idValueMap.get("user");
            }
            this.getModel().setValue("auditor", (Object)personId, rowIndex);
        } else if ("2".equals(modifyWay)) {
            this.getModel().setValue("auditor", null, rowIndex);
        }
        this.getView().updateView("auditor", rowIndex);
    }

    private void setFontColorForModifiedRows() {
        IPageCache pageCache = this.getView().getPageCache();
        IClientViewProxy clientService = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int rowIndex = 0; rowIndex < entryEntity.size(); ++rowIndex) {
            boolean needModifyColor;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndex);
            String modifyWay = dynamicObject.getString("acctmodifyway");
            long payDetailId = dynamicObject.getLong("paydetail.id");
            String firstCacheJsonStr = pageCache.get("first" + payDetailId);
            String lastCacheJsonStr = pageCache.get("last" + payDetailId);
            boolean bl = needModifyColor = firstCacheJsonStr != null && lastCacheJsonStr != null && "3".equals(modifyWay);
            if (!needModifyColor) continue;
            for (String bankAccountPro : BANK_ACCOUNT_PROS) {
                SWCGridUtils.setGridStyle((IClientViewProxy)clientService, (String)"entryentity", (int)rowIndex, (String)bankAccountPro, (String)"#26B175");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "modify": {
                this.openBankAccountView();
                break;
            }
            case "history": {
                this.openBankAccountHistoryView();
                break;
            }
            case "batchoperate": {
                this.openBatchInputF7();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "makesure": {
                this.checkModifyInfo(args);
                break;
            }
            case "deleteentry": {
                this.closeViewIfNoValidRow();
                break;
            }
        }
    }

    private void closeViewIfNoValidRow() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.size() == 0) {
            this.getView().close();
        }
    }

    private void checkModifyInfo(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        if (!operationResult.isSuccess()) {
            this.showOperationResultMulti(operationResult);
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        IPageCache pageCache = this.getView().getPageCache();
        ArrayList<String> errSeqList = new ArrayList<String>(10);
        HashSet<Long> allPayDetailIdSet = new HashSet<Long>(16);
        for (DynamicObject entryRowEntity : entryEntity) {
            String lastModifyInfoJsonStr;
            long payDetailId = entryRowEntity.getLong("paydetail.id");
            allPayDetailIdSet.add(payDetailId);
            if (!"3".equals(entryRowEntity.getString("acctmodifyway")) || (lastModifyInfoJsonStr = pageCache.get("last" + payDetailId)) != null) continue;
            errSeqList.add(entryRowEntity.getInt("seq") + "");
        }
        if (errSeqList.size() > 0) {
            this.showBankCardInfoOperationResult(errSeqList);
            return;
        }
        Set<Long> validPayDetailIdSet = this.getValidPayDetailIdList(args, allPayDetailIdSet);
        if (validPayDetailIdSet.size() == 0) {
            this.getView().returnDataToParent((Object)"successfully");
            this.getView().close();
            return;
        }
        JSONObject validPayDetailIdJSON = new JSONObject();
        validPayDetailIdJSON.put(VALID_PAY_DETAIL_ID_SET, validPayDetailIdSet);
        this.getView().getPageCache().put(VALID_PAY_DETAIL_ID_SET, validPayDetailIdJSON.toJSONString());
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(GEN_MODIFY_BILL_CONFIRM_KEY, (IFormPlugin)this);
        String tipMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u5c06\u5411\u5458\u5de5\u672c\u4eba\u548c\u6307\u5b9a\u5904\u7406\u4eba\u53d1\u9001\u94f6\u884c\u5361\u53d8\u66f4\u7684\u5f85\u529e\u4efb\u52a1\uff1b\u5bf9\u4e8e\u76f4\u63a5\u53d8\u66f4\u7684\u94f6\u884c\u5361\u4fe1\u606f\uff0c\u5c06\u76f4\u63a5\u5ba1\u6279\u901a\u8fc7\uff0c\u5e76\u5e94\u7528\u53d8\u66f4\u540e\u7684\u94f6\u884c\u5361\u4fe1\u606f\u91cd\u65b0\u751f\u6210\u53d1\u653e\u660e\u7ec6\u5e76\u5e9f\u5f03\u539f\u6709\u660e\u7ec6\u3002\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"SWCBankAccountModifyF7Plugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(tipMsg, MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    private void showOperationResultMulti(OperationResult operationResult) {
        String format = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6821\u9a8c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"SWCBankAccountModifyF7Plugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        HashSet failSizeSet = new HashSet(16);
        Optional.ofNullable(operationResult).map(OperationResult::getValidateResult).map(ValidateResultCollection::getValidateErrors).ifPresent(validateErrorList -> validateErrorList.stream().filter(validateError -> validateError.getAllErrorInfo() != null).forEach(validateError -> validateError.getAllErrorInfo().forEach(errorInfo -> failSizeSet.add(errorInfo.getRowIndex()))));
        if (failSizeSet.size() <= 1) {
            return;
        }
        operationResult.setShowMessage(false);
        int totalSize = this.getModel().getEntryEntity("entryentity").size();
        String title = MessageFormat.format(format, totalSize, totalSize - failSizeSet.size(), failSizeSet.size());
        String operateName = ResManager.loadKDString((String)"\u786e\u5b9a", (String)"SWCBankAccountModifyF7Plugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        ArrayList<String> failMsgList = new ArrayList<String>(10);
        List errorInfoList = operationResult.getAllErrorOrValidateInfo();
        for (IOperateInfo iOperateInfo : errorInfoList) {
            failMsgList.add(iOperateInfo.getMessage());
        }
        FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operateName, (String)title, failMsgList);
        this.getView().showForm(parameters);
    }

    private void showBankCardInfoOperationResult(List<String> errSeqList) {
        String detailErrMsg = ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u8bf7\u5148\u66f4\u6b63\u94f6\u884c\u5361\u4fe1\u606f\u3002", (String)"SWCBankAccountModifyF7Plugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        if (errSeqList.size() == 1) {
            this.getView().showErrorNotification(String.format(Locale.ROOT, detailErrMsg, errSeqList.get(0)));
        } else {
            int totalSize = this.getModel().getEntryEntity("entryentity").size();
            String format = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6821\u9a8c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"SWCBankAccountModifyF7Plugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            ArrayList<String> failMsgList = new ArrayList<String>(10);
            for (String seq : errSeqList) {
                failMsgList.add(String.format(Locale.ROOT, detailErrMsg, seq));
            }
            String title = MessageFormat.format(format, totalSize, totalSize - errSeqList.size(), errSeqList.size());
            String operateName = ResManager.loadKDString((String)"\u786e\u5b9a", (String)"SWCBankAccountModifyF7Plugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operateName, (String)title, failMsgList);
            this.getView().showForm(parameters);
        }
    }

    private Set<Long> getValidPayDetailIdList(AfterDoOperationEventArgs args, Set<Long> allPayDetailIdSet) {
        BankAccountModifyFilterEvent filterEvent = BankAccountModifyHelper.beforeBankAccountModifyFilterEvent();
        DynamicObject[] pkDyObjArr = BankAccountModifyHelper.queryValidPkIdList(allPayDetailIdSet, (BankAccountModifyFilterEvent)filterEvent);
        HashSet<Long> validPayDetailIdSet = new HashSet<Long>(16);
        if (pkDyObjArr == null || pkDyObjArr.length == 0) {
            return validPayDetailIdSet;
        }
        for (DynamicObject pkDyObj : pkDyObjArr) {
            validPayDetailIdSet.add(pkDyObj.getLong("id"));
        }
        return validPayDetailIdSet;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (GEN_MODIFY_BILL_CONFIRM_KEY.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.genBankAccountModifyBillList();
        }
    }

    private void genBankAccountModifyBillList() {
        IPageCache pageCache = this.getView().getPageCache();
        String validPayDetailIdJSONStr = pageCache.get(VALID_PAY_DETAIL_ID_SET);
        if (validPayDetailIdJSONStr == null) {
            return;
        }
        JSONArray validPayDetailIdJsonArr = (JSONArray)JSON.parseObject((String)validPayDetailIdJSONStr).get((Object)VALID_PAY_DETAIL_ID_SET);
        Set validPayDetailIdSet = validPayDetailIdJsonArr.stream().map(id -> (Long)id).collect(Collectors.toSet());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Map<String, Map<String, List<DynamicObject>>> entityGroup = entryEntity.stream().filter(entry -> validPayDetailIdSet.contains(entry.getLong("paydetail.id"))).collect(Collectors.groupingBy(this.getModifyWay(), Collectors.groupingBy(this.getAuditorAndModifyWay())));
        String errorLevel = null;
        try {
            errorLevel = BankAccountModifyHelper.generateBankAccountModifyBill(entityGroup, (IPageCache)this.getView().getPageCache());
        }
        catch (Exception exception) {
            logger.error("SWCBankAccountModifyF7Plugin.genBankAccountModifyBillList: ", (Throwable)exception);
            String codeRuleInfo = CodeRuleHelper.getCodeRuleExceptionInfo((Exception)exception);
            if (codeRuleInfo != null) {
                this.getView().showErrorNotification(codeRuleInfo);
                return;
            }
            throw exception;
        }
        if ("system error".equals(errorLevel)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SWCBankAccountModifyF7Plugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("work flow generate error".equals(errorLevel)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u63d0\u4ea4\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u201c\u94f6\u884c\u5361\u53d8\u66f4\u5355\u201d\u5217\u8868\u624b\u52a8\u63d0\u4ea4\u3002", (String)"SWCBankAccountModifyF7Plugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (entryEntity.size() > validPayDetailIdSet.size()) {
            JSONObject returnData = new JSONObject();
            returnData.put("allSize", (Object)entryEntity.size());
            returnData.put("invalidSize", (Object)(entryEntity.size() - validPayDetailIdSet.size()));
            this.getView().getParentView().returnDataToParent((Object)returnData.toJSONString());
        } else {
            this.getView().returnDataToParent((Object)"successfully");
        }
        this.getView().close();
    }

    private Function<DynamicObject, String> getModifyWay() {
        return entry -> "3".equals(entry.getString("acctmodifyway")) ? "3" : "2";
    }

    private Function<DynamicObject, String> getAuditorAndModifyWay() {
        return entry -> entry.getLong("auditor.id") + "," + entry.getString("acctmodifyway");
    }

    private void TransmitCacheDataToOp(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        IPageCache pageCache = this.getView().getPageCache();
        JSONObject allLastBankInfoJson = new JSONObject();
        Map allPageCache = pageCache.getAll();
        allPageCache.forEach((key, val) -> {
            if (key.contains("last")) {
                allLastBankInfoJson.put(key, val);
            }
        });
        formOperate.getOption().setVariableValue("lastCacheJson", allLastBankInfoJson.toJSONString());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "hsas_auditorbatchinput": {
                this.setModifyInfoForEntitySelectedRows(returnData);
                break;
            }
            case "hsas_perbankcardadd": {
                this.updatePersonBankAccountInfo(returnData);
                break;
            }
        }
    }

    private void openBatchInputF7() {
        int[] selectedRows = this.getEntitySelectedRows();
        if (!this.checkSelectedRowsValid(selectedRows)) {
            return;
        }
        this.openPopupOfF7Name("hsas_auditorbatchinput", (AbstractFormPlugin)this, null, true);
    }

    private int[] getEntitySelectedRows() {
        EntryGrid bankAccountModifyEntity = (EntryGrid)this.getControl("entryentity");
        return bankAccountModifyEntity.getSelectRows();
    }

    private boolean checkSelectedRowsValid(int[] selectedRows) {
        if (selectedRows.length == 0) {
            String tipMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SWCBankAccountModifyF7Plugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tipMsg, Integer.valueOf(2000));
            return false;
        }
        return true;
    }

    private void openBankAccountView() {
        int currentRowIndex = ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).getEntryState("entryentity").getFocusRow();
        int acctmodifyway = this.getModel().getEntryRowEntity("entryentity", currentRowIndex).getInt("acctmodifyway");
        Map<String, Object> customParams = this.cacheFirstBankInfoForCurrRow(currentRowIndex);
        Long personId = this.getModel().getEntryRowEntity("entryentity", currentRowIndex).getLong("salaryfilehis.person.id");
        Long employeeId = this.getModel().getEntryRowEntity("entryentity", currentRowIndex).getLong("salaryfilehis.employee.id");
        customParams.put("person.id", personId);
        customParams.put("employee.id", employeeId);
        customParams.put("parententitynumber", "hsas_perbankcardadd");
        customParams.put("acctmodifyway", acctmodifyway);
        logger.info("SWCBankAccountModifyF7Plugin.openBankAccountView: the person id is {} , and the employee id is {}", (Object)personId, (Object)employeeId);
        this.openPopupListOfF7Name("hsas_perbankcardadd", (AbstractFormPlugin)this, customParams);
    }

    public void setCustomParamForPopupList(ListShowParameter showParameter, String mark, Map<String, Object> customParams) {
        if ("hsas_perbankcardadd".equals(mark)) {
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            QFilter qFilter = new QFilter("employee.id", "=", customParams.get("employee.id"));
            qFilters.add(qFilter);
            showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        }
    }

    private Map<String, Object> cacheFirstBankInfoForCurrRow(int currentRowIndex) {
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)8);
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("hsas_perbankcardadd", currentRowIndex + "");
        long payDetailId = this.getPayDetailId(currentRowIndex);
        customParams.put("paydetail", payDetailId);
        String firstCacheMark = "first" + payDetailId;
        String firstBankInfo = pageCache.get(firstCacheMark);
        if (firstBankInfo != null) {
            customParams.put("first", firstBankInfo);
            return customParams;
        }
        JSONObject bankInfoJson = new JSONObject();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
        bankInfoJson.put("receivername", (Object)entryRowEntity.getString("receivername"));
        bankInfoJson.put("payrollacrel", entryRowEntity.get("payrollacrel.id"));
        bankInfoJson.put("bankaccount", (Object)entryRowEntity.getString("bankaccount"));
        bankInfoJson.put("bebank", entryRowEntity.get("bebank.id"));
        bankInfoJson.put("perbankcard", entryRowEntity.get("perbankcard.id"));
        firstBankInfo = bankInfoJson.toJSONString();
        pageCache.put(firstCacheMark, firstBankInfo);
        customParams.put("first", firstBankInfo);
        return customParams;
    }

    private long getPayDetailId(int currentRowIndex) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
        return entryRowEntity.getLong("paydetail.id");
    }

    private void openBankAccountHistoryView() {
        int currentRowIndex = ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).getEntryState("entryentity").getFocusRow();
        IPageCache pageCache = this.getView().getPageCache();
        long payDetailId = this.getPayDetailId(currentRowIndex);
        String firstCacheJson = pageCache.get("first" + payDetailId);
        String lastCacheJson = pageCache.get("last" + payDetailId);
        if (firstCacheJson == null || lastCacheJson == null) {
            return;
        }
        HashMap customParamMap = Maps.newHashMapWithExpectedSize((int)2);
        customParamMap.put("first", firstCacheJson);
        customParamMap.put("last", lastCacheJson);
        this.openPopupOfF7Name("hsas_bankacctinfocompare", (AbstractFormPlugin)this, customParamMap, false);
    }

    private void createBankAccountEntity(DynamicObject[] payDetailInfoArr) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        Map<Long, Long> salaryAndHrPersonMap = this.tranSwcPersonToHrPerson(Arrays.asList(payDetailInfoArr));
        Map perContactMap = BankAccountModifyHelper.getPerContactMapByPersonIds(new ArrayList<Long>(salaryAndHrPersonMap.keySet()));
        for (int i = 0; i < payDetailInfoArr.length; ++i) {
            DynamicObject payDetailInfo = payDetailInfoArr[i];
            Long payDetailId = payDetailInfo.getLong("id");
            Long salaryFileHisId = this.getPrimaryValue(payDetailInfo, "salaryfilehis");
            String receiverName = payDetailInfo.getString("perbankcard.username");
            String bankAccount = payDetailInfo.getString("perbankcard.bankcardnum");
            Long payRollAcrel = payDetailInfo.getLong("perbankcard.accountrelation.id");
            Long beRank = payDetailInfo.getLong("perbankcard.bankdeposit.id");
            Long perBankCard = payDetailInfo.getLong("perbankcard.id");
            Long personId = salaryAndHrPersonMap.get(payDetailInfo.getLong("salaryfilehis.person.id"));
            Long perContactId = perContactMap.getOrDefault(payDetailInfo.getLong("salaryfilehis.person.id"), 0L);
            vs.set("auditor", (Object)personId, i);
            vs.set("paydetail", (Object)payDetailId, i);
            vs.set("salaryfilehis", (Object)salaryFileHisId, i);
            vs.set("receivername", (Object)receiverName, i);
            vs.set("payrollacrel", (Object)payRollAcrel, i);
            vs.set("bebank", (Object)beRank, i);
            vs.set("bankaccount", (Object)bankAccount, i);
            vs.set("perbankcard", (Object)perBankCard, i);
            vs.set("percontact", (Object)perContactId, i);
        }
        model.batchCreateNewEntryRow("entryentity", vs);
    }

    private Long getPrimaryValue(DynamicObject payDetailInfo, String ctrlLable) {
        Long primaryVal = Optional.ofNullable(payDetailInfo).map(hisInfo -> hisInfo.getDynamicObject(ctrlLable)).map(info -> info.getLong("id")).orElse(null);
        return primaryVal;
    }

    private void updatePersonBankAccountInfo(Object returnData) {
        IPageCache pageCache = this.getView().getPageCache();
        String rowIndexStr = pageCache.get("hsas_perbankcardadd");
        if (rowIndexStr == null) {
            return;
        }
        Long primaryKeyId = this.getPrimaryKeyValueOfFromList(returnData).orElse(null);
        if (primaryKeyId == null) {
            return;
        }
        int rowIndex = Integer.parseInt(rowIndexStr);
        long payDetailId = this.getPayDetailId(rowIndex);
        String lastBankInfo = this.getView().getPageCache().get("last" + payDetailId + primaryKeyId);
        if (lastBankInfo == null) {
            return;
        }
        this.getView().getPageCache().put("last" + payDetailId, lastBankInfo);
        this.getView().getPageCache().remove("last" + payDetailId + primaryKeyId);
        JSONObject bankInfoJson = JSON.parseObject((String)lastBankInfo);
        this.setCurrIndexVal(rowIndex, bankInfoJson);
        this.setFontColorForModifiedRows();
        this.getView().updateView("entryentity", rowIndex);
    }

    private void setCurrIndexVal(int rowIndex, JSONObject bankInfoJson) {
        this.getModel().setValue("perbankcard", bankInfoJson.get((Object)"perbankcard"), rowIndex);
        this.getModel().setValue("receivername", bankInfoJson.get((Object)"receivername"), rowIndex);
        this.getModel().setValue("payrollacrel", bankInfoJson.get((Object)"payrollacrel"), rowIndex);
        this.getModel().setValue("bankaccount", bankInfoJson.get((Object)"bankaccount"), rowIndex);
        this.getModel().setValue("bebank", bankInfoJson.get((Object)"bebank"), rowIndex);
    }

    private void setModifyInfoForEntitySelectedRows(Object returnData) {
        Map returnMap = (Map)returnData;
        if (!"B".equals(returnMap.get("status"))) {
            return;
        }
        returnMap.remove("status");
        Map<Integer, Long> selectRowInfo = this.getSelectRowAndRelativePersonId();
        IDataModel model = this.getModel();
        for (Map.Entry<Integer, Long> entry : selectRowInfo.entrySet()) {
            this.getAuditorIdByBankAccountModifyWay(returnMap, entry.getValue());
            returnMap.forEach((key, val) -> {
                if (val != null) {
                    model.beginInit();
                    model.setValue(key, val, ((Integer)entry.getKey()).intValue());
                    model.endInit();
                    this.getView().updateView(key, ((Integer)entry.getKey()).intValue());
                }
            });
            long payDetailId = this.getModel().getEntryRowEntity("entryentity", entry.getKey().intValue()).getLong("paydetail.id");
            this.reSetBankCardInfo(entry.getKey(), (String)returnMap.get("acctmodifyway"), payDetailId);
        }
        this.setFontColorForModifiedRows();
        this.getView().updateView("entryentity", 0);
    }

    private Map<Integer, Long> getSelectRowAndRelativePersonId() {
        EntryGrid bankAccountModifyEntity = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = bankAccountModifyEntity.getSelectRows();
        HashMap selectRowAndSwcPersonMap = Maps.newHashMapWithExpectedSize((int)selectRows.length);
        IDataModel model = this.getModel();
        ArrayList<DynamicObject> bankAccountModifyDys = new ArrayList<DynamicObject>(selectRows.length);
        for (int selectRow : selectRows) {
            DynamicObject bankAccountModifyDy = model.getEntryRowEntity("entryentity", selectRow);
            bankAccountModifyDys.add(bankAccountModifyDy);
            long salaryPersonId = bankAccountModifyDy.getLong("salaryfilehis.person.id");
            selectRowAndSwcPersonMap.put(selectRow, salaryPersonId);
        }
        Map<Long, Long> swcAndHrPersonMap = this.tranSwcPersonToHrPerson(bankAccountModifyDys);
        HashMap selectRowAndHrPersonMap = Maps.newHashMapWithExpectedSize((int)selectRows.length);
        for (int selectRow : selectRows) {
            Long swcPersonId = (Long)selectRowAndSwcPersonMap.get(selectRow);
            selectRowAndHrPersonMap.put(selectRow, swcAndHrPersonMap.get(swcPersonId));
        }
        return selectRowAndHrPersonMap;
    }

    private void getAuditorIdByBankAccountModifyWay(Map<String, Object> returnMap, Long userID) {
        Long auditorId = null;
        String bankAccountModifyWay = (String)returnMap.get("acctmodifyway");
        if ("1".equals(bankAccountModifyWay)) {
            auditorId = userID;
        } else if ("2".equals(bankAccountModifyWay)) {
            auditorId = (Long)returnMap.get("auditor");
        } else if ("3".equals(bankAccountModifyWay)) {
            auditorId = RequestContext.get().getCurrUserId();
        }
        returnMap.put("auditor", auditorId);
    }

    private Map<Long, Long> tranSwcPersonToHrPerson(List<DynamicObject> payDetailDys) {
        Set salaryPersonIds;
        if (SWCListUtils.isEmpty(payDetailDys) || (salaryPersonIds = payDetailDys.stream().map(obj -> obj.getLong("salaryfilehis.person.id")).collect(Collectors.toSet())).isEmpty()) {
            return new HashMap<Long, Long>(0);
        }
        HashMap<Long, Long> salaryAndHrPersonMap = new HashMap<Long, Long>(payDetailDys.size());
        HashMap hrParamMap = Maps.newHashMapWithExpectedSize((int)16);
        hrParamMap.put("person", new ArrayList(salaryPersonIds));
        try {
            Map personBosUserMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{hrParamMap});
            Map bosUserIdMap = null;
            if (personBosUserMap != null && !personBosUserMap.isEmpty() && (bosUserIdMap = (Map)personBosUserMap.get("data")) != null && !bosUserIdMap.isEmpty()) {
                Iterator iterator = salaryPersonIds.iterator();
                while (iterator.hasNext()) {
                    Long salaryPersonId;
                    Map hrPersonMap = (Map)bosUserIdMap.get(salaryPersonId = (Long)iterator.next());
                    salaryAndHrPersonMap.put(salaryPersonId, hrPersonMap == null ? null : (Long)hrPersonMap.get("user"));
                }
            }
            logger.info("SWCBankAccountModifyF7Plugin.tranToCommonPerson: the detail info is {}, and person info is {}", (Object)JSONObject.toJSONString((Object)personBosUserMap), (Object)JSONObject.toJSONString(bosUserIdMap));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return salaryAndHrPersonMap;
    }
}

