/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail.modifybankaccount;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Optional;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.modifybankaccount.helper.BankAccountModifyHelper;
import kd.swc.hsas.business.modifybankaccount.view.SetCommonViewProperties;
import kd.swc.hsas.formplugin.web.bankcardoperating.BankCardOpUpdateSettingPlugin;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class SWCModifyBankAccountListPlugin
extends BankCardOpUpdateSettingPlugin
implements SetCommonViewProperties {
    public static final Log logger = LogFactory.getLog(SWCModifyBankAccountListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        FormShowParameter perBankCardShowParameter = this.getView().getFormShowParameter();
        String parentEntityNumber = (String)perBankCardShowParameter.getCustomParam("parententitynumber");
        String clkKey = ((Control)evt.getSource()).getKey();
        if ("billlistap".equals(clkKey) && !this.sendDataToParentViewSuccessfully()) {
            evt.setCancel(true);
        }
        if ("billlistap".equals(clkKey) && parentEntityNumber.equals("hsas_assignbankcard")) {
            evt.setCancel(true);
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection currentSelectedRows = billList.getSelectedRows();
            this.sendDataToAssignBankCardView(currentSelectedRows, perBankCardShowParameter);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String clkKey;
        super.beforeClick(evt);
        switch (clkKey = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.manageByParentViewId(evt);
                break;
            }
        }
    }

    private void manageByParentViewId(BeforeClickEvent evt) {
        FormShowParameter perBankCardShowParameter = this.getView().getFormShowParameter();
        String parentEntityNumber = (String)perBankCardShowParameter.getCustomParam("parententitynumber");
        Boolean assignBankCard = parentEntityNumber.equals("hsas_assignbankcard");
        Boolean modifyBankCard = parentEntityNumber.equals("hsas_perbankcardadd") && !this.sendDataToParentViewSuccessfully();
        if (assignBankCard.booleanValue() || modifyBankCard.booleanValue()) {
            evt.setCancel(true);
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection currentSelectedRows = billList.getSelectedRows();
            if (currentSelectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"SWCModifyBankAccountListPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            } else if (assignBankCard.booleanValue()) {
                this.sendDataToAssignBankCardView(currentSelectedRows, perBankCardShowParameter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "donothing_new": {
                this.newPerBankCard();
                break;
            }
        }
    }

    private void newPerBankCard() {
        FormShowParameter perBankCardListShowParameter = this.getView().getFormShowParameter();
        String parentEntityNumber = (String)perBankCardListShowParameter.getCustomParam("parententitynumber");
        Long employeeId = 0L;
        Long personId = 0L;
        int acctmodifyway = 0;
        String formId = "hsas_perbankcardext";
        switch (parentEntityNumber) {
            case "hsas_acctmodifybill": {
                acctmodifyway = (Integer)perBankCardListShowParameter.getCustomParam("acctmodifyway");
                formId = "hsas_perbankcardadd";
                break;
            }
        }
        Object personIdObject = perBankCardListShowParameter.getCustomParam("person.id");
        Object employeeIdObject = perBankCardListShowParameter.getCustomParam("employee.id");
        if (personIdObject != null && employeeIdObject != null) {
            personId = Long.parseLong(String.valueOf(personIdObject));
            employeeId = Long.parseLong(String.valueOf(employeeIdObject));
        }
        BaseShowParameter perBankCardFormShowParameter = new BaseShowParameter();
        if (acctmodifyway == 1) {
            perBankCardFormShowParameter.setHasRight(true);
            logger.info("get addnew right when opening addnew form for modifying by themselves");
        } else {
            logger.info("can not get addnew right when opening addnew form for modifying by others");
        }
        perBankCardFormShowParameter.setStatus(OperationStatus.ADDNEW);
        perBankCardFormShowParameter.setFormId(formId);
        perBankCardFormShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        perBankCardFormShowParameter.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u5361", (String)"SWCModifyBankAccountListPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        perBankCardFormShowParameter.setCustomParam("parententitynumber", (Object)"hsas_perbankcardadd");
        perBankCardFormShowParameter.setCustomParam("isUpdate", (Object)(!"hsas_acctmodifybill".equals(parentEntityNumber) ? 1 : 0));
        perBankCardFormShowParameter.setCustomParam("employee", (Object)employeeId);
        perBankCardFormShowParameter.setCustomParam("personid", (Object)personId);
        perBankCardFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "confirmaddform"));
        this.getView().showForm((FormShowParameter)perBankCardFormShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "confirmaddform": {
                this.getView().updateView();
                break;
            }
        }
    }

    private boolean sendDataToParentViewSuccessfully() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter != null && formShowParameter.getCustomParam("first") != null) {
            Long payDetailId;
            String firstBankCardInfo = (String)formShowParameter.getCustomParam("first");
            return !this.checkWhetherBankCardInfoDuplicate(firstBankCardInfo, payDetailId = (Long)formShowParameter.getCustomParam("paydetail"));
        }
        return true;
    }

    private boolean checkWhetherBankCardInfoDuplicate(String firstBankCardInfo, Long payDetailId) {
        IListView listView = (IListView)this.getView();
        Long primaryKeyId = Optional.ofNullable(listView).map(IListView::getCurrentSelectedRowInfo).map(info -> (Long)info.getPrimaryKeyValue()).orElse(null);
        if (primaryKeyId == null) {
            return true;
        }
        DynamicObject dynamicObject = BankAccountModifyHelper.queryPersonBankAccountInfo((Long)primaryKeyId);
        if (dynamicObject == null) {
            return true;
        }
        String currBankCardInfo = this.getCurrBankCardInfo(dynamicObject);
        if (firstBankCardInfo.equals(currBankCardInfo)) {
            this.showTips();
            return true;
        }
        this.getView().getParentView().getPageCache().put("last" + payDetailId + primaryKeyId, currBankCardInfo);
        return false;
    }

    private void showTips() {
        String errMsg = ResManager.loadKDString((String)"\u9009\u62e9\u7684\u94f6\u884c\u5361\u4fe1\u606f\u4e0e\u539f\u94f6\u884c\u5361\u4fe1\u606f\u4e00\u81f4\uff0c\u66f4\u6b63\u7ed3\u679c\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SWCModifyBankAccountListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.getView().showErrorNotification(errMsg);
    }

    private String getCurrBankCardInfo(DynamicObject bankAccountInfo) {
        JSONObject currBankInfoJson = new JSONObject();
        currBankInfoJson.put("receivername", (Object)bankAccountInfo.getString("username"));
        currBankInfoJson.put("payrollacrel", bankAccountInfo.get("accountrelation.id"));
        currBankInfoJson.put("bankaccount", (Object)bankAccountInfo.getString("bankcardnum"));
        currBankInfoJson.put("bebank", bankAccountInfo.get("bankdeposit.id"));
        currBankInfoJson.put("perbankcard", bankAccountInfo.get("sourcevid"));
        return currBankInfoJson.toJSONString();
    }

    private void sendDataToAssignBankCardView(ListSelectedRowCollection currentSelectedRows, FormShowParameter perBankCardShowParameter) {
        SWCDataServiceHelper perBankCardHelper = new SWCDataServiceHelper("hrpi_perbankcard");
        Long primaryKeyValue = (Long)currentSelectedRows.get(0).getPrimaryKeyValue();
        QFilter[] perBankCardFilters = new QFilter[]{new QFilter("id", "=", (Object)primaryKeyValue)};
        DynamicObject[] perBankCardQuery = perBankCardHelper.query("sourcevid", perBankCardFilters);
        HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
        Object currentRowIndex = perBankCardShowParameter.getCustomParam("currentrowindex");
        returnData.put("isOk", Boolean.TRUE);
        returnData.put("currentRowIndex", currentRowIndex);
        returnData.put("perBankCardSourceVId", perBankCardQuery[0].getLong("sourcevid"));
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }
}

