/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail.personalbankcardeditbill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.swc.hsas.business.workflow.WorkflowHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import org.apache.commons.collections.MapUtils;

public class PersonalBankCardEditBillList
extends AbstractListPlugin {
    private Map<String, String> auditorsMap;
    private static final String VIEW_FLOWCAHRT_PERMID = "0K6+MBJ9Z+KL";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedFieldKeyList = this.getFixFieldList();
        List columns = args.getListColumns();
        for (IListColumn iListColumn : columns) {
            String listFieldKey = iListColumn.getListFieldKey();
            if (!fixedFieldKeyList.contains(listFieldKey)) continue;
            iListColumn.setFixed(true);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection collection = super.getData(arg0, arg1);
                ArrayList pkIds = new ArrayList(10);
                collection.forEach(obj -> pkIds.add(String.valueOf(obj.getPkValue())));
                if (!pkIds.isEmpty()) {
                    PersonalBankCardEditBillList.this.auditorsMap = WorkflowHelper.getNextAuditors(pkIds);
                }
                return collection;
            }
        });
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc columnDesc;
        String key;
        super.packageData(e);
        if (e.getSource() instanceof ColumnDesc && "currenthandler".equals(key = (columnDesc = (ColumnDesc)e.getSource()).getKey()) && MapUtils.isNotEmpty(this.auditorsMap)) {
            String auditor = this.auditorsMap.get(e.getRowData().getPkValue().toString());
            e.setFormatValue((Object)auditor);
        }
        this.getPageCache().put("isVisibleCollapse", null);
        this.getPageCache().put("isneedcollapse", "true");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        HyperLinkClickEvent linkClick = args.getHyperLinkClickEvent();
        BillList billList = (BillList)linkClick.getSource();
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        if (selectedRow != null && "currenthandler".equals(linkClick.getFieldName())) {
            args.setCancel(true);
            long userId = RequestContext.get().getCurrUserId();
            boolean permFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_perbceditbill", (String)VIEW_FLOWCAHRT_PERMID);
            if (!permFlag) {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u94f6\u884c\u5361\u53d8\u66f4\u5355-\u5458\u5de5\u81ea\u52a9\u53d8\u66f4\u201d\u7684\u201c\u67e5\u770b\u6d41\u7a0b\u56fe\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonalBankCardEditBillList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            ListShowParameter listShow = (ListShowParameter)this.getView().getFormShowParameter();
            String pageId = listShow.getPageId();
            WorkflowServiceHelper.viewFlowchart((String)pageId, (Object)selectedRow.getPrimaryKeyValue());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("close");
            this.getView().sendFormAction(parentView);
        }
    }

    protected List<String> getFixFieldList() {
        ArrayList<String> fieldList = new ArrayList<String>(4);
        fieldList.add("billno");
        fieldList.add("person.name");
        fieldList.add("person.number");
        return fieldList;
    }
}

