/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.payrollgroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.EntryGridSetRowDataEvent;
import kd.bos.form.control.events.EntryGridSetRowDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hsas.business.payrollgrp.helper.PayRollGrpHelper;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsas.common.enums.HSASErrInfoEnum;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCEntryEntityCopyUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PayRollSceneControlEdit
extends AbstractBasePlugIn
implements EntryGridBindDataListener,
EntryGridSetRowDataListener {
    private static final String ADD_PAY_ROLL_SCENE = "add_items";
    private static final String PAY_ROLL_SCENE_ENTRY = "payrollsceneentry";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{ADD_PAY_ROLL_SCENE});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(PAY_ROLL_SCENE_ENTRY);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        entryGrid.addSetRowDataListener((EntryGridSetRowDataListener)this);
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(PAY_ROLL_SCENE_ENTRY);
        IPageCache pageCache = entryGrid.getView().getPageCache();
        if (pageCache != null) {
            pageCache.put("BOS.setRowDataByNumberAutoAddRow", Boolean.FALSE.toString());
        }
    }

    public void setView(IFormView formView) {
        super.setView(formView);
        SWCPayRollSceneService.createInstance().lockCommonFields(this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "add_items": {
                this.openPayRollSceneView(args);
                break;
            }
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.lockCellIfNeeded();
    }

    public void entryGridBindData(EntryGridBindDataEvent event) {
        this.lockCellIfNeeded();
    }

    public void entryGridSetRowData(EntryGridSetRowDataEvent event) {
        Map columnMap = event.getValues();
        if (columnMap == null || columnMap.isEmpty()) {
            return;
        }
        columnMap.remove("payrollscene");
        Map customColumnMap = SWCEntryEntityCopyUtils.getRowColumnVal((Map)columnMap);
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(PAY_ROLL_SCENE_ENTRY);
        this.getModel().beginInit();
        for (Map.Entry customColumnEntry : customColumnMap.entrySet()) {
            Boolean needPublisSalSlip;
            if (customColumnEntry.getKey() == null || (Integer)customColumnEntry.getKey() > entryEntity.size()) continue;
            Integer index = (Integer)customColumnEntry.getKey();
            DynamicObject entity = (DynamicObject)entryEntity.get(index.intValue());
            Map cellsInCurrRow = (Map)customColumnEntry.getValue();
            boolean publishSalSlipSwitchExists = cellsInCurrRow.containsKey("lssuepayslip");
            String publishSalSlipVal = !publishSalSlipSwitchExists ? entity.getString("lssuepayslip") : (String)cellsInCurrRow.get("lssuepayslip");
            if (publishSalSlipSwitchExists) {
                this.getModel().setValue("lssuepayslip", (Object)publishSalSlipVal, index.intValue());
            }
            if (!(needPublisSalSlip = Boolean.valueOf("1".equals(publishSalSlipVal))).booleanValue()) {
                this.getModel().setValue("releasesalaryslip", null, index.intValue());
                this.getModel().setValue("salaryslipview", null, index.intValue());
                List salSlipViewTuples = (List)columnMap.get("salaryslipview");
                if (salSlipViewTuples != null && !salSlipViewTuples.isEmpty()) {
                    salSlipViewTuples.removeIf(salSlipViewTuple -> index.equals(salSlipViewTuple.item1));
                }
            } else {
                String releaseSalSlip = (String)cellsInCurrRow.get("releasesalaryslip");
                this.getModel().setValue("releasesalaryslip", (Object)releaseSalSlip, index.intValue());
            }
            this.getView().setEnable(needPublisSalSlip, index.intValue(), new String[]{"releasesalaryslip", "salaryslipview"});
        }
        this.getModel().endInit();
        this.getView().updateView(PAY_ROLL_SCENE_ENTRY);
        this.lockCellIfNeeded();
        columnMap.remove("lssuepayslip");
        columnMap.remove("releasesalaryslip");
    }

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData changeData;
        if (SWCArrayUtils.isEmpty((Object[])args.getChangeSet()) || (changeData = args.getChangeSet()[0]) == null) {
            return;
        }
        switch (args.getProperty().getName()) {
            case "country": {
                DynamicObject oldDyObj;
                DynamicObject newDyObj = (DynamicObject)changeData.getNewValue();
                if (newDyObj != null && (oldDyObj = (DynamicObject)changeData.getOldValue()) != null && newDyObj.getLong("id") == oldDyObj.getLong("id")) break;
                this.getModel().deleteEntryData(PAY_ROLL_SCENE_ENTRY);
                break;
            }
            case "prorationcal": {
                String prorationCal = (String)changeData.getNewValue();
                int parentRowIndex = args.getChangeSet()[0].getParentRowIndex();
                int rowIndex = args.getChangeSet()[0].getRowIndex();
                if (!"0".equals(prorationCal)) break;
                this.getModel().setValue("prorationgenrule", null, rowIndex, parentRowIndex);
                break;
            }
            case "lssuepayslip": {
                for (ChangeData currChangeData : args.getChangeSet()) {
                    if (currChangeData == null) continue;
                    Boolean visible = "1".equals(currChangeData.getNewValue());
                    int rowIndex = currChangeData.getRowIndex();
                    if (visible.booleanValue()) continue;
                    this.getModel().beginInit();
                    this.getModel().setValue("releasesalaryslip", null, rowIndex);
                    this.getModel().setValue("salaryslipview", null, rowIndex);
                    this.getModel().endInit();
                }
                this.lockCellIfNeeded();
                this.getView().updateView(PAY_ROLL_SCENE_ENTRY);
                break;
            }
            case "issalaryslipsum": {
                if (!Boolean.TRUE.equals(changeData.getNewValue())) break;
                DynamicObjectCollection payRollSceneEntry = this.getModel().getEntryEntity(PAY_ROLL_SCENE_ENTRY);
                boolean existsOpenSwitch = false;
                boolean allCloseSwitch = true;
                ArrayList<Long> payRollSceneIds = new ArrayList<Long>(payRollSceneEntry.size());
                for (DynamicObject sceneEntry : payRollSceneEntry) {
                    String publishSalSlip = sceneEntry.getString("lssuepayslip");
                    existsOpenSwitch = existsOpenSwitch || "1".equals(sceneEntry.getString("lssuepayslip"));
                    boolean bl = allCloseSwitch = allCloseSwitch && "0".equals(publishSalSlip);
                    if (!SWCStringUtils.isEmpty((String)publishSalSlip)) continue;
                    payRollSceneIds.add(sceneEntry.getLong("payrollscene.id"));
                }
                if (existsOpenSwitch) break;
                HRBaseServiceHelper helper = new HRBaseServiceHelper("hsas_payrollscene");
                QFilter filter = new QFilter("id", "in", payRollSceneIds);
                filter.and("enable", "=", (Object)"1");
                filter.and("status", "=", (Object)"C");
                filter.and("datastatus", "=", (Object)"1");
                filter.and("lssuepayslip", "=", (Object)"1");
                if (!allCloseSwitch && helper.isExists(filter)) break;
                this.getView().showTipNotification(HSASErrInfoEnum.PAYROLL_GROUP_ERROR_WHEN_OPEN_SAL_SUM_SWITCH.getMsg());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        List<Long> newSelectedPkIdList = null;
        if (returnData instanceof ListSelectedRowCollection) {
            newSelectedPkIdList = ((ListSelectedRowCollection)returnData).stream().map(data -> (Long)data.getPrimaryKeyValue()).collect(Collectors.toList());
        }
        String actionId = closedCallBackEvent.getActionId();
        if (newSelectedPkIdList != null && "hsas_payrollscene".equals(actionId)) {
            this.updateEntryEntity(newSelectedPkIdList);
        }
    }

    private void openPayRollSceneView(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        if (model.getValue("country") == null) {
            this.showCountryMustInputInfo();
            args.setCancel(true);
            return;
        }
        if (model.getValue("org") == null) {
            this.showOrgMustInputInfo();
            args.setCancel(true);
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsas_payrollscene", (boolean)true);
        showParameter.setHasRight(true);
        showParameter.setFormId("hsbp_allowreturnnullf7");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_payrollscene"));
        QFilter sceneQFilter = this.getPayRollSceneQFilter();
        showParameter.setListFilterParameter(new ListFilterParameter(Arrays.asList(sceneQFilter.toArray()), null));
        Object[] selectedPayRollSceneIdArr = this.getSelectedPayRollSceneIdArr();
        if (!SWCArrayUtils.isEmpty((Object[])selectedPayRollSceneIdArr)) {
            showParameter.setSelectedRows(selectedPayRollSceneIdArr);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private QFilter getPayRollSceneQFilter() {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        filter.and(AreaHelper.addCountryFilter((long)dataEntity.getLong("country.id")));
        filter.and("org", "=", (Object)dataEntity.getLong("org.id"));
        return filter;
    }

    private Object[] getSelectedPayRollSceneIdArr() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PAY_ROLL_SCENE_ENTRY);
        if (SWCListUtils.isEmpty((List)entryEntity)) {
            return new Object[0];
        }
        List sceneIdList = entryEntity.stream().map(dyObj -> dyObj.getLong("payrollscene.id")).collect(Collectors.toList());
        if (SWCListUtils.isEmpty(sceneIdList)) {
            return new Object[0];
        }
        QFilter sceneQFilter = this.getPayRollSceneQFilter();
        sceneQFilter.and("id", "in", sceneIdList);
        return PayRollGrpHelper.queryPayRollSceneList((QFilter)sceneQFilter);
    }

    private void showCountryMustInputInfo() {
        String detailErrMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u56fd\u5bb6/\u5730\u533a\u3002", (String)"PayRollSceneControlEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.getView().showTipNotification(detailErrMsg);
    }

    private void showOrgMustInputInfo() {
        String detailErrMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u85aa\u8d44\u4e1a\u52a1\u5355\u5143\u3002", (String)"PayRollSceneControlEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.getView().showTipNotification(detailErrMsg);
    }

    private void updateEntryEntity(List<Long> newSelectedPkIdList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PAY_ROLL_SCENE_ENTRY);
        Iterator iterator = entryEntity.iterator();
        while (iterator.hasNext()) {
            DynamicObject entryDyObj = (DynamicObject)iterator.next();
            long oldPayRollSceneId = entryDyObj.getLong("payrollscene.id");
            if (!newSelectedPkIdList.contains(oldPayRollSceneId)) {
                iterator.remove();
                continue;
            }
            newSelectedPkIdList.remove(oldPayRollSceneId);
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int index = 0;
        for (DynamicObject lastDyObj : entryEntity) {
            vs.set("payrollscene", (Object)lastDyObj.getLong("payrollscene.id"), index);
            vs.set("callistview", (Object)lastDyObj.getLong("callistview.id"), index);
            vs.set("lssuepayslip", (Object)lastDyObj.getString("lssuepayslip"), index);
            vs.set("releasesalaryslip", (Object)lastDyObj.getString("releasesalaryslip"), index);
            vs.set("salaryslipview", (Object)lastDyObj.getLong("salaryslipview.id"), index);
            vs.set("prorationcal", (Object)lastDyObj.getString("prorationcal"), index);
            vs.set("prorationgenrule", (Object)lastDyObj.getLong("prorationgenrule.id"), index);
            ++index;
        }
        for (Long newPayRollSceneId : newSelectedPkIdList) {
            vs.set("payrollscene", (Object)newPayRollSceneId, index);
            vs.set("prorationcal", (Object)"0", index);
            ++index;
        }
        model.deleteEntryData(PAY_ROLL_SCENE_ENTRY);
        model.batchCreateNewEntryRow(PAY_ROLL_SCENE_ENTRY, vs);
        model.endInit();
        this.lockCellIfNeeded();
        this.getView().updateView(PAY_ROLL_SCENE_ENTRY);
    }

    private void lockCellIfNeeded() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(PAY_ROLL_SCENE_ENTRY);
        if (SWCListUtils.isEmpty((List)entryEntity)) {
            return;
        }
        for (DynamicObject entry : entryEntity) {
            int index = entry.getInt("seq") - 1;
            String schemeNumber = entry.getString("payrollscene.schemeaftercal.number");
            if (!SWCStringUtils.equals((String)"1010_S", (String)schemeNumber)) {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"lssuepayslip", "releasesalaryslip", "salaryslipview"});
                continue;
            }
            Boolean needPublisSalSlip = "1".equals(entry.getString("lssuepayslip"));
            this.getView().setEnable(needPublisSalSlip, index, new String[]{"releasesalaryslip", "salaryslipview"});
        }
    }
}

