/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.person;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.swc.hsas.common.entity.ImportEntityRel;
import kd.swc.hsas.business.dataport.PersonImportHelper;
import kd.swc.hsas.business.dataport.salaryfile.SalaryFileImportHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PersonStartImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log log = LogFactory.getLog(PersonStartImportPlugin.class);
    private static final String EVENT_COMMFIREEXPORT = "commfireExport";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"keyfields"});
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityid");
        this.hideImportType(entityId);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        Label title = (Label)this.getControl("title");
        title.setText(mainEntityType.getDisplayName().toString());
    }

    private void hideImportType(String entityId) {
        if (!SWCStringUtils.isEmpty((String)entityId)) {
            switch (entityId) {
                case "hsas_person": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"override"});
                    break;
                }
                case "hsas_salaryfile": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"override"});
                    break;
                }
                case "hsas_taxfiletmp": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"new"});
                    this.getModel().getDataEntity().set("importtype", (Object)"override");
                    break;
                }
            }
        }
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                String entityId = (String)showParameter.getCustomParam("entityid");
                boolean isIncludeTax = this.getIsIncludeTax();
                if (SWCStringUtils.isEmpty((String)entityId)) break;
                String downUrl = "";
                switch (entityId) {
                    case "hsas_salaryfile": {
                        if (isIncludeTax) {
                            ImportEntityRel importEntityRel = PersonImportHelper.getSalaryAndTaxTempImportEntityRel();
                            downUrl = SalaryFileImportHelper.getImportTemplate((ImportEntityRel)importEntityRel);
                            break;
                        }
                        downUrl = SalaryFileImportHelper.getImportTemplate((ImportEntityRel)PersonImportHelper.getSalaryFileImportEntityRel());
                        break;
                    }
                    case "hsas_taxfiletmp": {
                        this.exportTaxTemplate();
                        break;
                    }
                }
                if (SWCStringUtils.isEmpty((String)downUrl)) break;
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.addAction("download", (Object)downUrl);
                break;
            }
            case "btnresetfile": {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue("filepath", (Object)"");
                this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
                break;
            }
        }
    }

    private void exportTaxTemplate() {
        IFormView parentView = this.getView().getParentView();
        BillList billList = (BillList)parentView.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ArrayList selectIds = new ArrayList(selectedRows.size());
        selectedRows.forEach(obj -> selectIds.add((Long)obj.getPrimaryKeyValue()));
        SWCPageCache pageCache = new SWCPageCache(parentView);
        if (selectIds.size() == 0) {
            int count = billList.queryBillDataCount();
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa%d\u5f20\u5355\u636e\uff0c\u662f\u5426\u5bfc\u51fa\uff1f", (String)"PersonStartImportPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), count);
            this.getView().showConfirm(message, MessageBoxOptions.YesNo, new ConfirmCallBackListener(EVENT_COMMFIREEXPORT, (IFormPlugin)this));
            pageCache.put("total", (Object)String.valueOf(count));
            return;
        }
        pageCache.put("selectIds", selectIds);
        pageCache.put("total", (Object)String.valueOf(selectIds.size()));
        this.openExportingPage(false);
    }

    private void openExportingPage(boolean isExportAll) {
        IFormView formView = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_salaryfile_exporting");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("hastaxfileperm", formView.getFormShowParameter().getCustomParam("hastaxfileperm"));
        showParameter.setCustomParam("entityName", (Object)ResManager.loadKDString((String)"\u6a21\u677f", (String)"PersonStartImportPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("targetpageid", (Object)this.getView().getParentView().getPageId());
        showParameter.setCustomParam("isexportall", (Object)isExportAll);
        showParameter.setCustomParam("isimport", (Object)Boolean.TRUE);
        formView.showForm(showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes) {
            switch (e.getCallBackId()) {
                case "commfireExport": {
                    this.openExportingPage(true);
                    break;
                }
            }
        }
    }

    private void importData() {
        String url = (String)this.getModel().getValue("filepath");
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"PersonStartImportPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isDuplicateImport = this.isDuplicateImport(url);
        if (isDuplicateImport) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6837\u540d\u79f0\u7684\u6587\u4ef6\u6b63\u5728\u5bfc\u5165\u4e2d, \u8bf7\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u67e5\u8be2\u3002", (String)"PersonStartImportPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        boolean isOkFormat = this.checkExcelFormat(url);
        if (!isOkFormat) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"PersonStartImportPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        Map<String, Object> transferData = this.getTransferData(url);
        IFormView formView = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_person_importing");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        showParameter.setParentPageId(formView.getFormShowParameter().getParentPageId());
        CloseCallBack closeCallBack = formView.getFormShowParameter().getCloseCallBack();
        if (closeCallBack != null) {
            showParameter.setCloseCallBack(closeCallBack);
        }
        showParameter.setCustomParams(transferData);
        showParameter.setCustomParam("hastaxfileperm", formView.getFormShowParameter().getCustomParam("hastaxfileperm"));
        formView.showForm(showParameter);
    }

    private boolean checkExcelFormat(String url) {
        boolean isIncludeTax = this.getIsIncludeTax();
        FileService service = FileServiceFactory.getAttachmentFileService();
        final ArrayList dataHead = Lists.newArrayListWithCapacity((int)10);
        try {
            InputStream in = service.getInputStream(url);
            Object object = null;
            try {
                ExcelReader excelReader = new ExcelReader();
                excelReader.read(in, new SheetHandler(){

                    public void handleRow(SheetHandler.ParsedRow row) {
                        Map data = row.getData();
                        if (data != null && data.size() > 0) {
                            if (row.getRowNum() <= 2) {
                                dataHead.add(data);
                            } else {
                                throw new KDBizException("break");
                            }
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
        if (isIncludeTax && dataHead.size() >= 3) {
            Map headRow = (Map)dataHead.get(2);
            for (Map.Entry entry : headRow.entrySet()) {
                if (!((String)entry.getValue()).contains("addtaxfilecheckbox")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean getIsIncludeTax() {
        boolean hasTaxFilePerm;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String entityId = (String)showParameter.getCustomParam("entityid");
        boolean bl = hasTaxFilePerm = showParameter.getCustomParam("hastaxfileperm") == null ? false : (Boolean)showParameter.getCustomParam("hastaxfileperm");
        return hasTaxFilePerm && !SWCStringUtils.isEmpty((String)entityId) && "hsas_salaryfile".equals(entityId);
    }

    private Map<String, Object> getTransferData(String url) {
        HashMap<String, Object> importData = new HashMap<String, Object>();
        IFormView formView = this.getView();
        importData.put("entityid", formView.getFormShowParameter().getCustomParam("entityid"));
        importData.put("url", url);
        importData.put("type", "new");
        return importData;
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            IFormView view = this.getView();
            String url = (String)urls[0];
            boolean isDuplicateImport = this.isDuplicateImport(url);
            if (isDuplicateImport) {
                throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6837\u540d\u79f0\u7684\u6587\u4ef6\u6b63\u5728\u5bfc\u5165\u4e2d, \u8bf7\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u67e5\u8be2\u3002", (String)"PersonStartImportPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
            FileService service = FileServiceFactory.getAttachmentFileService();
            boolean isSuccess = this.validateImportFile(view, service, url);
            if (isSuccess) {
                view.setVisible(Boolean.TRUE, new String[]{"filepanel"});
                view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
                IDataModel model = this.getModel();
                model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
                model.setValue("filepath", (Object)url);
            }
        }
    }

    private boolean validateImportFile(final IFormView view, FileService service, String url) {
        boolean isSuccess = true;
        try (InputStream in = service.getInputStream(url);){
            new ExcelReader().read(in, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    PersonStartImportPlugin.this.validateTheFirstLineImportFile(view, row);
                }
            });
            SWCPageCache pageCache = new SWCPageCache(view);
            Boolean startValidate = (Boolean)pageCache.get("startvalidate", Boolean.class);
            if (null == startValidate) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"PersonStartImportPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
        }
        catch (KDException e) {
            view.showErrorNotification(e.getMessage());
            isSuccess = false;
        }
        catch (Throwable e) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"PersonStartImportPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            isSuccess = false;
        }
        return isSuccess;
    }

    private void validateTheFirstLineImportFile(IFormView view, SheetHandler.ParsedRow row) {
        if (row.getRowNum() == 0) {
            if (row.isEmpty() || !row.get(Integer.valueOf(0)).split(" # ")[1].equalsIgnoreCase((String)view.getFormShowParameter().getCustomParam("entityid"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"PersonStartImportPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
            SWCPageCache pageCache = new SWCPageCache(view);
            pageCache.put("startvalidate", (Object)Boolean.TRUE);
        }
    }

    private boolean isDuplicateImport(String url) {
        boolean isDuplicateImport = false;
        ISWCAppCache appCache = SWCAppCache.get((String)"hsasimport");
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityid");
        String userId = RequestContext.get().getUserId();
        Set fileNames = (Set)appCache.get(userId, Set.class);
        if (null != fileNames && fileNames.contains(entityId + "_" + PersonImportHelper.getImportFileName((String)url))) {
            isDuplicateImport = true;
        }
        return isDuplicateImport;
    }
}

