/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.personhr;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.person.PersonPermissionHelper;
import kd.swc.hsas.business.service.HSASPermissionServiceHelper;
import kd.swc.hsas.formplugin.web.bankcardoperating.BankCardOpUpdateSettingPlugin;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.entity.MultiLangEnumBridge;

public class PersonHrSidebarViewEdit
extends BankCardOpUpdateSettingPlugin {
    private static final Log LOGGER = LogFactory.getLog(PersonHrSidebarViewEdit.class);
    private static final String CONENT_PANEL = "conentpanel";
    private static final String CONENT_PANEL1 = "flexpanelap1";
    private static final String PANEL_KEY = "panelkey";
    private static final String TITLE_PANEL_KEY = "titlepanelkey";
    private static final String MARGIN_10 = "10px";
    private static final String MARGIN_40 = "40px";
    private static final String DIRECTION_COLUMN = "column";
    private static final String DIRECTION_ROW = "row";
    private static final String ALIGN_ITEMS_STRETCH = "stretch";
    private static final String ALIGN_ITEMS_CENTER = "center";
    private static final String PANEL_TITLE = "paneltitle";
    private static final String BACK_COLOR_FFFFFF = "#FFFFFF";
    private static final int FONTSIZE_18 = 18;
    private static final int GROW = 0;
    private static final int PAGE_NUM = 10;
    private static final int EMP_PAGE_NUM = 0;
    private static Map<String, String> formIdMap = new HashMap<String, String>();

    private Map<Integer, MultiLangEnumBridge> getNameMap() {
        HashMap<Integer, MultiLangEnumBridge> nameMap = new HashMap<Integer, MultiLangEnumBridge>();
        nameMap.put(2, new MultiLangEnumBridge("\u804c\u4e1a\u4fe1\u606f", "SyncPersonFailLogList_10", "swc-hsas-formplugin"));
        nameMap.put(4, new MultiLangEnumBridge("\u804c\u7ea7\u804c\u7b49", "SyncPersonFailLogList_12", "swc-hsas-formplugin"));
        nameMap.put(5, new MultiLangEnumBridge("\u7ba1\u7406\u8303\u56f4\u8bb0\u5f55", "SyncPersonFailLogList_18", "swc-hsas-formplugin"));
        nameMap.put(6, new MultiLangEnumBridge("\u4efb\u804c\u7ecf\u5386", "SyncPersonFailLogList_16", "swc-hsas-formplugin"));
        nameMap.put(8, new MultiLangEnumBridge("\u6559\u80b2\u7ecf\u5386", "SyncPersonFailLogList_28", "swc-hsas-formplugin"));
        nameMap.put(9, new MultiLangEnumBridge("\u804c\u79f0\u4fe1\u606f", "SyncPersonFailLogList_20", "swc-hsas-formplugin"));
        nameMap.put(10, new MultiLangEnumBridge("\u94f6\u884c\u5361", "PersonSidebarViewEdit_3", "swc-hsas-formplugin"));
        return nameMap;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isHaveViewPerm = SWCPermissionServiceHelper.hasViewPermission((String)"/UHMBBGZQ65X", (String)"hrpi_perbankcard");
        if (!isHaveViewPerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONENT_PANEL1});
        }
        IFormView formView = this.getView();
        Long personId = (Long)this.getView().getFormShowParameter().getCustomParam("person");
        Long employeeId = (Long)this.getView().getFormShowParameter().getCustomParam("employee");
        String styleType = "0";
        if (personId == null) {
            styleType = "1";
            DynamicObject empObj = this.getEmpObj();
            employeeId = empObj.getLong("id");
            personId = empObj.getLong("person.id");
        }
        this.getView().updateControlMetadata(CONENT_PANEL, this.createFlexpanel(styleType).createControl());
        for (int i = 0; i < 10; ++i) {
            String panelkey = PANEL_KEY + i;
            String pageId = formIdMap.get(panelkey);
            if (!HSASPermissionServiceHelper.hasPerm((String)pageId, (String)"47150e89000000ac")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{panelkey});
                continue;
            }
            if (i == 0 || i == 1 || i == 3 || i == 7) {
                this.embedFormPersonPage(formView, personId, employeeId, panelkey, i);
                continue;
            }
            this.embedListInPersonAddPage(formView, personId, employeeId, panelkey);
        }
        this.embedPerBankCardList(formView, personId, employeeId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "donothing_add": {
                this.embedPerBankCardNewPage();
                this.getView().sendFormAction(this.getView());
                break;
            }
        }
    }

    private void embedPerBankCardNewPage() {
        Long personId = (Long)this.getView().getFormShowParameter().getCustomParam("person");
        Long employeeId = (Long)this.getView().getFormShowParameter().getCustomParam("employee");
        if (personId == null) {
            DynamicObject empObj = this.getEmpObj();
            employeeId = empObj.getLong("id");
            personId = empObj.getLong("person.id");
        }
        this.openNewPage(personId, employeeId);
    }

    private DynamicObject getEmpObj() {
        DynamicObject personObj = (DynamicObject)this.getView().getParentView().getModel().getValue("person");
        Long employeeId = (Long)personObj.getPkValue();
        SWCDataServiceHelper empHelper = new SWCDataServiceHelper("hsas_employee");
        return empHelper.queryOne("person", new QFilter[]{new QFilter("id", "=", (Object)employeeId)});
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "confirmaddform": {
                this.reEmbedPerBankCardList();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "isdelete": {
                this.reEmbedPerBankCardList();
                break;
            }
        }
    }

    private void reEmbedPerBankCardList() {
        String cacheKey = this.getView().getPageId() + formIdMap.get("panelkey10");
        String childPageId = this.getView().getPageCache().get(cacheKey);
        this.getView().getView(childPageId).invokeOperation("refresh");
        this.getView().sendFormAction(this.getView().getView(childPageId));
    }

    private LabelAp createTitleLabel(String labelName) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(TITLE_PANEL_KEY);
        labelAp.setName(new LocaleString(labelName));
        labelAp.setFontSize(18);
        return labelAp;
    }

    private FlexPanelAp createFlexpanel(String styleType) {
        String customStyle = "eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cblxuJCA+IGRpdiA+IGRpdiA+IGRpdiB7bWFyZ2luOiAwcHggIWltcG9ydGFudDt9XG5cblxuIn0=";
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(PANEL_KEY);
        flexPanelAp.setDirection(DIRECTION_COLUMN);
        flexPanelAp.setOverflow("visible");
        if ("0".equals(styleType)) {
            Style styleMain = new Style();
            Margin marginMain = new Margin();
            marginMain.setLeft(MARGIN_10);
            marginMain.setRight(MARGIN_10);
            styleMain.setMargin(marginMain);
            flexPanelAp.setStyle(styleMain);
        }
        flexPanelAp.setAlignItems(ALIGN_ITEMS_STRETCH);
        flexPanelAp.setWrap(false);
        for (int i = 0; i < 10; ++i) {
            FlexPanelAp flexPanel = new FlexPanelAp();
            flexPanel.setKey(PANEL_KEY + i);
            if (i >= 1 && "0".equals(styleType)) {
                Style style = new Style();
                Margin margin = new Margin();
                margin.setTop(MARGIN_10);
                style.setMargin(margin);
                flexPanel.setStyle(style);
            }
            if (i == 2 || i > 3 && i != 7) {
                flexPanel.setCollapsible(true);
                flexPanel.setName(new LocaleString(this.getNameMap().get(i).loadKDString()));
            }
            flexPanel.setGrow(0);
            flexPanel.setShrink(0);
            flexPanel.setBackColor(BACK_COLOR_FFFFFF);
            flexPanel.setCustomeStyles(customStyle);
            flexPanelAp.getItems().add(flexPanel);
        }
        return flexPanelAp;
    }

    private void embedFormPersonPage(IFormView formView, Object personId, Long employeeId, String panelKey, int num) {
        StringBuilder logSb = new StringBuilder("embedFormPersonPage");
        logSb.append("personId=").append(personId).append(" employeeId=").append(employeeId).append(" panelKey=").append(panelKey).append(" num=").append(num);
        LOGGER.info(logSb.toString());
        String entityId = formIdMap.get(panelKey);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityId);
        QFilter qFilter = num == 0 || num == 1 ? new QFilter("person", "=", personId) : new QFilter("employee", "=", (Object)employeeId);
        if (!"panelkey10".equals(panelKey)) {
            BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
            qFilter.and("datastatus", "in", (Object)new String[]{"1", "0"});
        }
        DynamicObject currentDy = serviceHelper.queryOne("id", new QFilter[]{qFilter});
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(panelKey);
        showParameter.setCustomParam("personid", (Object)String.valueOf(personId));
        showParameter.setFormId(entityId);
        showParameter.setStatus(OperationStatus.VIEW);
        if (currentDy != null) {
            showParameter.setPkId((Object)currentDy.getLong("id"));
        }
        showParameter.setCustomParam("employee", (Object)employeeId);
        formView.showForm((FormShowParameter)showParameter);
    }

    private void embedListInPersonAddPage(IFormView formView, Object personId, Long employeeId, String panelKey) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(panelKey);
        showParameter.setFormId("hsbp_nosearch_list");
        showParameter.setBillFormId(formIdMap.get(panelKey));
        ListFilterParameter listFilter = showParameter.getListFilterParameter();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        int number = Integer.parseInt(panelKey.substring(panelKey.length() - 1));
        if (number > 7) {
            filterList.add(new QFilter("person.id", "=", personId));
        } else {
            filterList.add(new QFilter("employee.id", "=", (Object)employeeId));
        }
        listFilter.setQFilters(filterList);
        showParameter.setCustomParam("baraddnew", (Object)Boolean.FALSE);
        showParameter.setCustomParam("personid", (Object)String.valueOf(personId));
        showParameter.setCustomParam("employee", (Object)employeeId);
        LOGGER.info("hb--------side---personId:{}", personId);
        LOGGER.info("hb---------side--employeeId:{}", (Object)employeeId);
        formView.showForm((FormShowParameter)showParameter);
    }

    private void embedPerBankCardList(IFormView formView, Object personId, Long employeeId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("panelkey10");
        showParameter.setFormId("hsbp_noline_list");
        showParameter.setHasRight(true);
        showParameter.setBillFormId(formIdMap.get("panelkey10"));
        ListFilterParameter listFilter = showParameter.getListFilterParameter();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("person.id", "=", personId));
        Boolean isDelete = (Boolean)this.getModel().getValue("isdelete");
        if (!isDelete.booleanValue()) {
            filterList.add(new QFilter("isdelete", "=", (Object)"0"));
        }
        filterList.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        listFilter.setQFilters(filterList);
        showParameter.setCustomParam("baraddnew", (Object)Boolean.FALSE);
        showParameter.setCustomParam("personid", (Object)String.valueOf(personId));
        showParameter.setCustomParam("employee", (Object)employeeId);
        LOGGER.info("hb--------side---personId:{}", personId);
        LOGGER.info("hb---------side--employeeId:{}", (Object)employeeId);
        this.getPageCache().put(this.getView().getPageId() + formIdMap.get("panelkey10"), showParameter.getPageId());
        formView.showForm((FormShowParameter)showParameter);
    }

    private boolean checkPermission(String opName) {
        boolean hasPerm = PersonPermissionHelper.hasPersonPerm((String)"47150e89000000ac");
        if (!hasPerm) {
            String errorTips = SWCPermissionServiceHelper.getNoPermTips((String)opName);
            this.getView().showMessage(errorTips);
        }
        return hasPerm;
    }

    static {
        formIdMap.put("panelkey0", "hsas_pernontsprop");
        formIdMap.put("panelkey1", "hsas_pertsprop");
        formIdMap.put("panelkey2", "hsas_empentrel");
        formIdMap.put("panelkey3", "hsas_trialperiod");
        formIdMap.put("panelkey4", "hsas_empjobrel");
        formIdMap.put("panelkey5", "hsas_managingscope");
        formIdMap.put("panelkey6", "hsas_empposorgrelhr");
        formIdMap.put("panelkey7", "hsas_perserlen");
        formIdMap.put("panelkey8", "hsas_pereduexp");
        formIdMap.put("panelkey9", "hsas_perprotitlehr");
        formIdMap.put("panelkey10", "hsas_perbankcardext");
    }
}

