/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.personhr;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.swc.hsas.business.personhr.SyncPersonHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SyncPersonConditionPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(SyncPersonConditionPlugin.class);
    private static final String KEY_SYNC_ALLPERSON = "syncallperson";
    private static final String KEY_EMPNUMBERORNAME = "empnumberorname";
    private static final String KEY_EMPNUMBERORNAME_TAG = "empnumberorname_tag";
    private static final String KEY_ENTERPRISE = "enterprise";
    private static final String KEY_LABORRELTYPE = "laborreltype";
    private static final String KEY_QFILTER = "QFilter_";

    public void registerListener(EventObject eventObject) {
        BasedataEdit enterpriseBD = (BasedataEdit)this.getView().getControl(KEY_ENTERPRISE);
        enterpriseBD.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit laborreltypeBD = (BasedataEdit)this.getView().getControl(KEY_LABORRELTYPE);
        laborreltypeBD.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey = arg.getProperty().getName();
        String permEntity = "hsas_employee";
        String permItemId = "47150e89000000ac";
        long userId = RequestContext.get().getCurrUserId();
        switch (fieldKey) {
            case "enterprise": {
                QFilter entFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)userId, (String)"/UHMBBGZQ65X", (String)permEntity, (String)KEY_ENTERPRISE, (String)permItemId);
                if (entFilter == null) break;
                ListShowParameter param = (ListShowParameter)arg.getFormShowParameter();
                param.getListFilterParameter().setFilter(entFilter);
                break;
            }
            case "laborreltype": {
                QFilter typeFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)userId, (String)"/UHMBBGZQ65X", (String)permEntity, (String)KEY_LABORRELTYPE, (String)permItemId);
                if (typeFilter == null) break;
                ListShowParameter param = (ListShowParameter)arg.getFormShowParameter();
                param.getListFilterParameter().setFilter(typeFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (fieldKey) {
            case "empnumberorname": {
                String newValue2 = String.valueOf(newValue).replace('\n', ' ');
                this.getModel().setValue(KEY_EMPNUMBERORNAME, (Object)newValue2);
                this.getView().updateView(KEY_EMPNUMBERORNAME);
                break;
            }
            case "empnumberorname_tag": {
                String newValue2tag = String.valueOf(newValue).replace('\n', ' ');
                this.getModel().setValue(KEY_EMPNUMBERORNAME_TAG, (Object)newValue2tag);
                this.getView().updateView(KEY_EMPNUMBERORNAME_TAG);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operKey;
        if (this.getView().getParentView().getFormShowParameter().isCancelDataRight()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"SyncPersonConditionPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        switch (operKey = args.getOperateKey()) {
            case "donothing_syncdata": {
                int dataCount = this.queryTotalRows();
                if (dataCount == 0) {
                    return;
                }
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                customParams.put("dataCount", dataCount);
                this.getView().cacheFormShowParameter();
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_SYNC_ALLPERSON);
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                String msg = ResManager.loadKDString((String)"\u5c06\u540c\u6b65\u6240\u6709\u6570\u636e\uff08{0}\u6761\uff09\uff0c\u786e\u5b9a\u540c\u6b65\uff1f", (String)"SyncPersonConditionPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[]{dataCount});
                this.getView().showConfirm(msg, options, confirmCallBacks);
                break;
            }
            case "donothing_query": {
                int dataCount2 = this.queryTotalRows();
                if (dataCount2 == 0) {
                    return;
                }
                this.returnDataToParent("query");
                break;
            }
        }
    }

    private int queryTotalRows() {
        Map<String, Object> returnDataMap = this.getReturnData("syncdata");
        List qfilters = SyncPersonHelper.getReturnDataQFilters(returnDataMap);
        int totalRows = SyncPersonHelper.queryTotalRows((List)qfilters);
        if (totalRows == 0) {
            String msg = ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u51fa\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u786e\u5b9a\u9700\u540c\u6b65\u7684\u4eba\u5458\u6570\u636e\u8303\u56f4\u3002", (String)"DealPersonHrF7List_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
        }
        return totalRows;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (KEY_SYNC_ALLPERSON.equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.returnDataToParent("syncdata");
        }
    }

    private void returnDataToParent(String type) {
        Map<String, Object> returnData = this.getReturnData(type);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private Map<String, Object> getReturnData(String type) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("type", type);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        returnData.put("dataCount", customParams.getOrDefault("dataCount", 0));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        MulBasedataDynamicObjectCollection enterprise = (MulBasedataDynamicObjectCollection)dataEntity.get(KEY_ENTERPRISE);
        List enterpriseIds = enterprise.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList());
        MulBasedataDynamicObjectCollection laborreltype = (MulBasedataDynamicObjectCollection)dataEntity.get(KEY_LABORRELTYPE);
        List laborreltypeIds = laborreltype.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList());
        Date startdate = (Date)dataEntity.get("daterange_startdate");
        Date enddate = (Date)dataEntity.get("daterange_enddate");
        String empNumberOrName = dataEntity.getString(KEY_EMPNUMBERORNAME_TAG);
        List<String> empNumberOrNameList = this.getEmpNumberOrNameList(empNumberOrName);
        if (SWCStringUtils.isNotEmpty((String)empNumberOrName)) {
            returnData.put("empNumberOrNameList", empNumberOrNameList);
        }
        if (CollectionUtils.isNotEmpty(enterpriseIds)) {
            returnData.put(KEY_ENTERPRISE, enterpriseIds);
        }
        returnData.put("QFilter_enterprise", customParams.get("QFilter_enterprise"));
        if (CollectionUtils.isNotEmpty(laborreltypeIds)) {
            returnData.put(KEY_LABORRELTYPE, laborreltypeIds);
        }
        returnData.put("QFilter_laborreltype", customParams.get("QFilter_laborreltype"));
        if (startdate != null) {
            returnData.put("startdate", startdate);
        }
        if (enddate != null) {
            returnData.put("enddate", enddate);
        }
        return returnData;
    }

    private List<String> getEmpNumberOrNameList(String empNumberOrName) {
        String[] numberArr;
        if (SWCStringUtils.isEmpty((String)empNumberOrName)) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>(10);
        for (String number : numberArr = empNumberOrName.split(" ")) {
            String[] numberArr2;
            if (SWCStringUtils.isEmpty((String)number)) continue;
            for (String number2 : numberArr2 = number.split("\n")) {
                if (SWCStringUtils.isEmpty((String)number2)) continue;
                nameList.add(number2);
            }
        }
        return nameList;
    }
}

