/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.personhr;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.formplugin.web.basedata.personhr.SyncPersonDataTask;
import kd.swc.hsbp.business.threadpool.SWCUnifiedThreadPoolFactory;
import kd.swc.hsbp.common.enums.SWCUnifiedTaskTypeEnum;

public class SyncPersonMultiThreadService {
    protected static final Log logger = LogFactory.getLog(SyncPersonMultiThreadService.class);
    public static final int DEFAULT_SIZE = 20000;
    private static final int BATCH_COUNT = 3;

    private SyncPersonMultiThreadService() {
    }

    public SyncPersonMultiThreadService(String monitorNumber) {
    }

    public void syncData(int way, List<Map<Long, Long>> empIds, String monitorNumber) throws Exception {
        logger.info("SyncPersonMultiThreadService.syncData...DEFAULT_SIZE={}", (Object)20000);
        int batchSize = 20000;
        int total = empIds.size();
        if (total > 60000) {
            batchSize = total / 3 + 1;
        }
        logger.info("SyncPersonMultiThreadService.syncData...batchSize={}", (Object)batchSize);
        List subList = Lists.partition(empIds, (int)batchSize);
        logger.info("SyncPersonMultiThreadService.syncData...empIds.size()={}", (Object)empIds.size());
        logger.info("SyncPersonMultiThreadService.syncData...subList.size()={}", (Object)subList.size());
        ArrayList<Future> futureList = new ArrayList<Future>(subList.size());
        for (int index = 0; index < subList.size(); ++index) {
            List empList = (List)subList.get(index);
            SyncPersonDataTask task = new SyncPersonDataTask(way, empList, monitorNumber);
            Future future = SWCUnifiedThreadPoolFactory.SERVICE.submit((Callable)task, SWCUnifiedTaskTypeEnum.SWC_HSAS_PERSONSYNCTHREADPOOL.getKey(), RequestContext.get(), OperationContext.get());
            futureList.add(future);
        }
        try {
            for (Future future : futureList) {
                future.get();
            }
        }
        catch (ExecutionException e) {
            logger.error((Throwable)e);
        }
    }
}

