/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.personrule;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsbp.business.addperson.entity.CalPersonAddProgressInfo;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class AddPersonProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(AddPersonProgressPlugin.class);
    private static final String ADDPROGRESSBARAP = "addprogressbarap";
    private static final String KEY_BTNMIN = "btn_min";
    private static final String KEY_OK = "btn_ok";
    private static final String KEY_ONADDAP = "onaddap";
    private static final String KEY_AFTERADDAP = "afteraddap";
    private static final String KEY_FAILDETAILHYPER = "faildetailhyper";
    private static final String KEY_VIEW_CALPERSONLIST = "view_calpersonlist";
    private static final String KEY_SHOWADDCOUNTAP = "showaddcountap";
    private static final String KEY_ADDAP = "addap";
    private static final String KEY_NOPERSONAP = "nopersonap";

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{KEY_FAILDETAILHYPER, KEY_VIEW_CALPERSONLIST});
    }

    public void initialize() {
        ProgressBar progressBar = (ProgressBar)this.getControl(ADDPROGRESSBARAP);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_OK});
        ProgressBar progressBar = (ProgressBar)this.getControl(ADDPROGRESSBARAP);
        progressBar.start();
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_AFTERADDAP, KEY_VIEW_CALPERSONLIST, KEY_FAILDETAILHYPER, KEY_SHOWADDCOUNTAP, KEY_NOPERSONAP});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ONADDAP, KEY_ADDAP});
        Boolean isAuto = (Boolean)this.getView().getFormShowParameter().getCustomParam("isAuto");
        if (isAuto != null && isAuto.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"addcountap", "addinfoap"});
        }
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        CalPersonAddProgressInfo progress = (CalPersonAddProgressInfo)SWCAppCache.get((String)"hsas").get(String.format(Locale.ROOT, "cache_addperson_key_%s", taskId), CalPersonAddProgressInfo.class);
        this.setValueToProgressPage(null, progress);
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        if (StringUtils.equals((CharSequence)progressKey, (CharSequence)ADDPROGRESSBARAP)) {
            this.queryAndSetAddProgressDetails(progressEvent);
        }
    }

    private void queryAndSetAddProgressDetails(ProgressEvent progressEvent) {
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        CalPersonAddProgressInfo progress = (CalPersonAddProgressInfo)SWCAppCache.get((String)"hsas").get(String.format(Locale.ROOT, "cache_addperson_key_%s", taskId), CalPersonAddProgressInfo.class);
        if (progress == null) {
            this.stopProgress();
            return;
        }
        int status = progress.getStatus();
        this.setValueToProgressPage(progressEvent, progress);
        if (status == 2) {
            this.stopProgress();
        }
    }

    private void stopProgress() {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNMIN});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_OK});
        ProgressBar progressBar = (ProgressBar)this.getControl(ADDPROGRESSBARAP);
        progressBar.stop();
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_AFTERADDAP});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ONADDAP});
        this.getView().setVisible(Boolean.FALSE, new String[]{"remainap"});
        this.setLabelText("consumetimetitle", ResManager.loadKDString((String)"\u8017\u65f6", (String)"AddPersonProgressPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        Boolean isAuto = (Boolean)this.getView().getFormShowParameter().getCustomParam("isAuto");
        if (isAuto != null && isAuto.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_VIEW_CALPERSONLIST, KEY_SHOWADDCOUNTAP});
        }
    }

    private void setValueToProgressPage(ProgressEvent progressEvent, CalPersonAddProgressInfo progress) {
        int total = progress.getTotal();
        int finishCount = progress.getFinish();
        int percentage = 0;
        if (total > 0) {
            percentage = new BigDecimal(String.valueOf(finishCount)).divide(new BigDecimal(String.valueOf(total)), 2, 1).multiply(new BigDecimal("100")).intValue();
        } else if (progress.getStatus() == 2) {
            percentage = 100;
        }
        if (progressEvent != null) {
            progressEvent.setProgress(percentage);
        } else {
            ProgressBar progressBar = (ProgressBar)this.getControl(ADDPROGRESSBARAP);
            progressBar.setPercent(percentage);
        }
        if (percentage == 100 && progress.getTotal() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ADDAP});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_NOPERSONAP});
        }
        if (percentage == 100) {
            this.stopProgress();
            this.getView().setVisible(Boolean.valueOf(progress.getFail() > 0), new String[]{KEY_FAILDETAILHYPER});
        }
        this.setLabelText("totalcount", String.valueOf(total));
        this.setLabelText("progress", String.valueOf(percentage) + "%");
        this.setLabelText("successcount", String.valueOf(progress.getSuccess()));
        this.setLabelText("successcountshow", String.valueOf(progress.getSuccess()));
        this.setLabelText("failcount", String.valueOf(progress.getFail()));
        this.setLabelText("remaincount", String.valueOf(progress.getRemain()));
        this.setLabelText("addconsumetime", this.getCostTime(progress.getStartDate()));
        this.setLabelText("consumetime", this.getCostTime(progress.getStartDate()));
    }

    private void setLabelText(String key, String value) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(key, "text", (Object)value);
    }

    public void beforeClosed(BeforeClosedEvent event) {
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        String name = (String)this.getView().getFormShowParameter().getCustomParam("name");
        CalPersonAddProgressInfo progress = (CalPersonAddProgressInfo)SWCAppCache.get((String)"hsas").get(String.format(Locale.ROOT, "cache_addperson_key_%s", taskId), CalPersonAddProgressInfo.class);
        if (progress != null) {
            int status = progress.getStatus();
            String bgtaskId = (String)this.getView().getFormShowParameter().getCustomParam("sch_taskid");
            if (status != 2 && SWCObjectUtils.isEmpty((Object)bgtaskId)) {
                this.openProgressBall(taskId, name);
                return;
            }
            if (status == 2 && !SWCObjectUtils.isEmpty((Object)bgtaskId)) {
                HRBackgroundTaskHelper.getInstance().confirmEndTask(bgtaskId, "COMPLETED");
            }
            if (status == 2) {
                IFormView grandFatherView;
                IFormView parentView = this.getView().getParentView();
                String parentPageId = (String)this.getView().getFormShowParameter().getCustomParam("parentPageId");
                if (SWCStringUtils.isNotEmpty((String)parentPageId)) {
                    parentView = this.getView().getView(parentPageId);
                }
                if (parentView instanceof IListView) {
                    ((IListView)parentView).refresh();
                    this.getView().sendFormAction(parentView);
                }
                if (parentView != null && (grandFatherView = parentView.getParentView()) instanceof IListView) {
                    ((IListView)grandFatherView).refresh();
                    this.getView().sendFormAction(grandFatherView);
                }
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(taskId), (String)CalPersonOperationEnum.OP_ADDCALPERSON.getOperationKey());
            }
        }
    }

    private void openProgressBall(Long taskId, String name) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Boolean isAuto = (Boolean)formShowParameter.getCustomParam("isAuto");
        Boolean isExc = (Boolean)formShowParameter.getCustomParam("isExc");
        String ballName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6dfb\u52a0\u6838\u7b97\u4eba\u5458_%s", (String)"AddPersonProgressPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), name);
        if (isAuto != null && isAuto.booleanValue()) {
            ballName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u81ea\u52a8\u6dfb\u52a0\u6838\u7b97\u4eba\u5458\uff1a%s\u3002", (String)"AddPersonProgressPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), name);
        }
        if (isExc != null && isExc.booleanValue()) {
            ballName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6dfb\u52a0\u4f8b\u5916\u4eba\u5458_%s", (String)"AddPersonProgressPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]), name);
        }
        HashMap<String, Long> params = new HashMap<String, Long>(16);
        params.put("taskId", taskId);
        IFormView mainView = this.getView().getMainView();
        if (mainView != null) {
            HRBackgroundTaskHelper instance = HRBackgroundTaskHelper.getInstance();
            String bgTaskId = instance.createBaskgroundTask("swc_hsas_addcalperson", ballName, true, mainView.getPageId(), this.getView().getParentView().getPageId(), params);
            instance.showBaskgroundTask(bgTaskId);
        }
    }

    private String getCostTime(Date startDate) {
        Date endtime = new Date();
        long between = endtime.getTime() - startDate.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        String hms = formatter.format(between);
        return hms;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        if (SWCStringUtils.equals((String)key, (String)KEY_FAILDETAILHYPER)) {
            ListShowParameter show = ShowFormHelper.createShowListForm((String)"hsas_addfailcalperson", (boolean)true);
            show.setFormId("hsas_calpersonaddfaillist");
            show.setCustomParam("taskId", (Object)taskId);
            Boolean isExc = (Boolean)this.getView().getFormShowParameter().getCustomParam("isExc");
            show.setCustomParam("isExc", (Object)isExc);
            this.getView().getParentView().showForm((FormShowParameter)show);
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        } else if (SWCStringUtils.equals((String)key, (String)KEY_VIEW_CALPERSONLIST)) {
            ListShowParameter showParameter = CalPayrollTaskHelper.getCalTableListForm((String)this.getView().getParentView().getPageId(), (long)taskId);
            this.getView().getParentView().showForm((FormShowParameter)showParameter);
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }
}

