/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.personrule;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.swc.hsas.business.callistrule.CalListRuleHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.enums.RuleParamTypeEnum;
import kd.swc.hsbp.common.util.RuleTypeOperatorsUtils;
import kd.swc.hsbp.common.util.RuleValidateUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.ConditionInfo;
import kd.swc.hsbp.common.vo.RuleConditionInfo;
import kd.swc.hsbp.common.vo.RuleValidateInfo;

public class CalListRuleEdit
extends HRBaseDataCommonEdit {
    private static final String OPEN_F7_CALLBACK = "openConditionParamF7CallBack";
    private static final String UPDATE_CONDITION_EVENT_NAME = "setValue";
    private static final String OPEN_DYNAMIC_OBJECT_F7_EVENT_NAME = "openParamF7";
    private static final String INIT_CONTROL_DATA_EVENT_NAME = "initConditionControlDataEvent";
    private static final String OPEN_EXPRESS_VIEW_EVENT_NAME = "openExpressView";
    private static final String KEY_RULECONTENT = "rulecontent";
    private static final String OP_PRERUN = "donothing_prerun";

    public void afterBindData(EventObject eventObject) {
        this.addBtn();
        super.afterBindData(eventObject);
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"org", "number"});
        }
        this.initConditionControlDataEvent();
    }

    private void addBtn() {
        String traceId = RequestContext.get().getTraceId();
        String cache = this.getPageCache().get(traceId + "_addBtn");
        if (SWCStringUtils.isEmpty((String)cache)) {
            Container toolBar = (Container)this.getView().getControl("tbmain");
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblclosehis"});
            toolBar.deleteControls(new String[]{"tblclosehis", "prerun", "bar_close", "tblclosehisnew"});
            ArrayList<Map> items = new ArrayList<Map>(10);
            BarItemAp preBtn = new BarItemAp();
            preBtn.setKey("prerun");
            preBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u540d\u5355\u8bd5\u8fd0\u884c", (String)"CalListRuleEdit_25", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
            preBtn.setOperationKey(OP_PRERUN);
            items.add(preBtn.createControl());
            BarItemAp closeBtn = new BarItemAp();
            closeBtn.setKey("tblclosehisnew");
            closeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u9000\u51fa", (String)"CalListRuleEdit_24", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
            closeBtn.setOperationKey("close");
            items.add(closeBtn.createControl());
            toolBar.addControls(items);
            this.getPageCache().put(traceId + "_addBtn", "1");
        }
    }

    private Map<String, String> getCusControlLangMap() {
        HashMap<String, String> langMap = new HashMap<String, String>(16);
        langMap.put("conditionParamTh", ResManager.loadKDString((String)"\u5165\u53c2\u5b57\u6bb5", (String)"CalListRuleEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        langMap.put("comparisonOptTh", ResManager.loadKDString((String)"\u5224\u65ad\u6761\u4ef6", (String)"CalListRuleEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        langMap.put("valueTypeTh", ResManager.loadKDString((String)"\u6bd4\u8f83\u503c\u7c7b\u578b", (String)"CalListRuleEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        langMap.put("valueTh", ResManager.loadKDString((String)"\u6bd4\u8f83\u503c", (String)"CalListRuleEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        langMap.put("param", ResManager.loadKDString((String)"\u53c2\u6570", (String)"CalListRuleEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        langMap.put("value", ResManager.loadKDString((String)"\u503c", (String)"CalListRuleEdit_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        langMap.put("yes", ResManager.loadKDString((String)"\u662f", (String)"CalListRuleEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        langMap.put("no", ResManager.loadKDString((String)"\u5426", (String)"CalListRuleEdit_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        langMap.put("addCondition", ResManager.loadKDString((String)"\u6dfb\u52a0\u6761\u4ef6", (String)"CalListRuleEdit_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        langMap.put("expressTitle", ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\uff1a", (String)"CalListRuleEdit_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        langMap.put("and", ResManager.loadKDString((String)"\u5e76\u4e14", (String)"CalListRuleEdit_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        langMap.put("or", ResManager.loadKDString((String)"\u6216\u8005", (String)"CalListRuleEdit_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        langMap.put("FitAllCondition", ResManager.loadKDString((String)"\u6ee1\u8db3\u6240\u6709\u6761\u4ef6\uff08\u5e76\u4e14\uff09", (String)"CalListRuleEdit_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        langMap.put("JustFitOne", ResManager.loadKDString((String)"\u6ee1\u8db3\u4efb\u610f\u6761\u4ef6\uff08\u6216\u8005\uff09", (String)"CalListRuleEdit_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        langMap.put("CustomCondition", ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u903b\u8f91", (String)"CalListRuleEdit_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        langMap.put("noResults", ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u53c2\u6570", (String)"CalListRuleEdit_21", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        return langMap;
    }

    public void customEvent(CustomEventArgs args) {
        String event = args.getEventName();
        String eventArgs = args.getEventArgs();
        if (UPDATE_CONDITION_EVENT_NAME.equals(event)) {
            this.getModel().setValue(KEY_RULECONTENT, (Object)eventArgs);
        } else if (OPEN_DYNAMIC_OBJECT_F7_EVENT_NAME.equals(event)) {
            this.openParamF7((AbstractFormPlugin)this, eventArgs, OPEN_F7_CALLBACK);
        } else if (OPEN_EXPRESS_VIEW_EVENT_NAME.equals(event)) {
            this.openExpressView();
        } else if (INIT_CONTROL_DATA_EVENT_NAME.equals(event)) {
            this.initConditionControlDataEvent();
        }
    }

    public void openExpressView() {
        String value = (String)this.getModel().getValue(KEY_RULECONTENT);
        if (SWCStringUtils.isNotEmpty((String)value)) {
            RuleConditionInfo ruleConditionInfo = (RuleConditionInfo)JSON.parseObject((String)value, RuleConditionInfo.class);
            RuleValidateInfo ruleValidateInfo = new RuleValidateInfo();
            RuleValidateUtil.validExpression((RuleConditionInfo)ruleConditionInfo, (RuleValidateInfo)ruleValidateInfo);
            if (!ruleValidateInfo.isSuccess()) {
                this.showErrorMsg(ruleValidateInfo);
                return;
            }
        }
        FormShowParameter bill = new FormShowParameter();
        bill.setStatus(OperationStatus.VIEW);
        bill.setFormId("hsbp_ruleexpressview");
        bill.getOpenStyle().setShowType(ShowType.Modal);
        bill.setHasRight(true);
        bill.setCustomParam("data", this.getModel().getValue(KEY_RULECONTENT));
        bill.getCustomParams().put("isIgnoreLicense", Boolean.TRUE);
        this.getView().showForm(bill);
    }

    private void showErrorMsg(RuleValidateInfo ruleValidateInfo) {
        List msgList = ruleValidateInfo.getMsgList();
        if (msgList.size() == 1) {
            this.getView().showErrorNotification((String)msgList.get(0));
        } else {
            FormShowParameter resultParameter = SWCShowFormServiceHelper.getOperationResultParameter((String)ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"CalListRuleEdit_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"CalListRuleEdit_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (List)msgList);
            this.getView().showForm(resultParameter);
        }
    }

    protected Map<String, Object> getConditionExpress(String ruleContent) {
        HashMap<String, Object> conditionExpress = new HashMap<String, Object>();
        if (SWCStringUtils.isNotEmpty((String)ruleContent)) {
            conditionExpress.put("value", ((RuleConditionInfo)JSON.parseObject((String)ruleContent, RuleConditionInfo.class)).getConditionExpressStr());
        } else {
            conditionExpress.put("value", "");
        }
        return conditionExpress;
    }

    private void openParamF7(AbstractFormPlugin plugin, String argsJson, String actionId) {
        Map argsMap = (Map)SerializationUtils.fromJsonString((String)argsJson, Map.class);
        String entityNumber = argsMap.get("entityNumber").toString();
        String index = argsMap.get("index").toString();
        String[] entitys = entityNumber.split("\\.");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entitys[0]);
        BasedataProp property = (BasedataProp)type.getProperty(entitys[1]);
        String entityId = property.getBaseEntityId();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        DynamicProperty statusProperty = dataEntityType.getProperty("status");
        DynamicProperty enableProperty = dataEntityType.getProperty("enable");
        ListShowParameter fsp = ShowFormHelper.createShowListForm((String)entityId, (boolean)false, (int)0, (boolean)true);
        if (statusProperty != null) {
            fsp.getListFilterParameter().setFilter(new QFilter("status", "=", (Object)"C"));
        }
        if (enableProperty != null) {
            fsp.getListFilterParameter().setFilter(new QFilter("enable", "=", (Object)"1"));
        }
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId + index));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        boolean isMulti = Boolean.parseBoolean(argsMap.get("isMulti").toString());
        if (isMulti) {
            RuleConditionInfo ruleConditionInfo;
            List conditionList;
            ConditionInfo conditionInfo;
            String value;
            String ruleContent = this.getModel().getDataEntity().getString(KEY_RULECONTENT);
            if (SWCStringUtils.isNotEmpty((String)ruleContent) && SWCStringUtils.isNotEmpty((String)(value = (conditionInfo = (ConditionInfo)(conditionList = (ruleConditionInfo = (RuleConditionInfo)JSON.parseObject((String)ruleContent, RuleConditionInfo.class)).getConditionList()).get(Integer.parseInt(index) - 1)).getValue()))) {
                Object[] idsStr = value.split(",");
                fsp.setSelectedRows(idsStr);
            }
            fsp.setMultiSelect(true);
        }
        fsp.setShowTitle(false);
        if (property instanceof OrgProp) {
            Map showFormCustomParams = ((OrgProp)property).getShowFormCustomParams();
            fsp.setCustomParams(showFormCustomParams);
        }
        plugin.getView().showForm((FormShowParameter)fsp);
    }

    private void initConditionControlDataEvent() {
        BillShowParameter formShowParameter;
        BillOperationStatus billStatus;
        String pageState;
        String ruleContent = this.getModel().getDataEntity().getString(KEY_RULECONTENT);
        RuleConditionInfo ruleConditionInfo = (RuleConditionInfo)JSON.parseObject((String)ruleContent, RuleConditionInfo.class);
        if (ruleConditionInfo != null && SWCListUtils.isEmpty((List)ruleConditionInfo.getConditionList())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef", (String)"CalListRuleEdit_20", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("init", "true");
        data.put("value", ruleContent);
        data.put("comparisonOpt", this.getComparisonOperatorsMap());
        pageState = BaseDataHisHelper.isHisPage((IFormView)this.getView()) ? (SWCStringUtils.isEmpty((String)(pageState = this.getPageCache().get("pageStatus"))) || SWCStringUtils.equals((String)pageState, (String)"view") ? "VIEW" : pageState) : ((billStatus = (formShowParameter = (BillShowParameter)this.getView().getFormShowParameter()).getBillStatus()) == BillOperationStatus.VIEW || billStatus == BillOperationStatus.SUBMIT || billStatus == BillOperationStatus.AUDIT ? "VIEW" : "EDIT");
        data.put("pageState", pageState);
        data.put("conditionExpress", this.getConditionExpress(ruleContent));
        data.put("hideButton", Boolean.FALSE);
        data.put("defaultRows", 1);
        data.put("showDeleteOnlyOneRow", Boolean.FALSE);
        SWCDataServiceHelper fieldHelper = new SWCDataServiceHelper("hsbs_callistfieldcfg");
        QFilter filter = new QFilter("isusedbyrule", "=", (Object)Boolean.TRUE);
        if (SWCStringUtils.equals((String)"VIEW", (String)pageState)) {
            filter = new QFilter("1", "=", (Object)1);
        }
        DynamicObjectCollection configs = fieldHelper.queryOriginalCollection("name,number,type,isusedbyrule,perruleobj.number,perruleobj.name", new QFilter[]{filter});
        Map<String, List<DynamicObject>> configGrp = configs.stream().collect(Collectors.groupingBy(config -> config.getString("perruleobj.number")));
        for (Map.Entry<String, List<DynamicObject>> configEntry : configGrp.entrySet()) {
            String entityNumber = configEntry.getKey();
            List<DynamicObject> subConfigs = configEntry.getValue();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            for (DynamicObject subConfig : subConfigs) {
                String[] entitys;
                DynamicProperty property;
                String key = subConfig.getString("number");
                if (SWCStringUtils.equals((String)entityNumber, (String)"hsas_calpayrolltask") && (SWCStringUtils.equals((String)key, (String)"startdate") || SWCStringUtils.equals((String)key, (String)"enddate")) || (property = dataEntityType.getProperty((entitys = key.split("\\."))[0])) == null) continue;
                subConfig.set("name", (Object)property.getDisplayName());
            }
        }
        data.put("param", CalListRuleEdit.getConfigFiledParam(configs));
        data.put("valueParam", CalListRuleEdit.getConfigFiledValueParam(configs));
        data.put("text", this.getCusControlLangMap());
        this.updateConditionData(data);
    }

    private static List<Map<String, Object>> getConfigFiledParam(DynamicObjectCollection cfgs) {
        HashMap<String, MainEntityType> entityTypeMap = new HashMap<String, MainEntityType>(16);
        HashMap<String, List> groupList = new HashMap<String, List>(16);
        String personName = "";
        for (DynamicObject cfg : cfgs) {
            if (!SWCStringUtils.equals((String)cfg.getString("perruleobj.number"), (String)"hsas_personhr")) continue;
            personName = cfg.getString("perruleobj.name");
            break;
        }
        for (DynamicObject cfg : cfgs) {
            ComboProp comboProp;
            MainEntityType entityType;
            String type = cfg.getString("type");
            String objName = cfg.getString("perruleobj.name");
            String objNumber = cfg.getString("perruleobj.number");
            if (SWCStringUtils.equals((String)"hsas_employee", (String)objNumber) || SWCStringUtils.equals((String)"hsas_pernontsprop", (String)objNumber)) {
                objName = personName;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", objNumber + "." + cfg.getString("number"));
            map.put("number", objNumber + "." + cfg.getString("number"));
            map.put("text", objName + '.' + cfg.getString("name"));
            map.put("name", objName + '.' + cfg.getString("name"));
            map.put("type", type);
            if (SWCStringUtils.equals((String)type, (String)RuleParamTypeEnum.BOOLEAN.getValue())) {
                map.put("enumList", JSON.toJSONString(CalListRuleEdit.getBoolean()));
            } else if (SWCStringUtils.equals((String)type, (String)RuleParamTypeEnum.ENUM.getValue())) {
                entityType = (MainEntityType)entityTypeMap.get(objNumber);
                if (entityType == null) {
                    entityType = EntityMetadataCache.getDataEntityType((String)objNumber);
                    entityTypeMap.put(objNumber, entityType);
                }
                if ((comboProp = (ComboProp)entityType.getProperty(cfg.getString("number"))) == null) continue;
                map.put("enumList", JSON.toJSONString((Object)comboProp.getComboItems()));
            } else if (SWCStringUtils.equals((String)type, (String)RuleParamTypeEnum.DYNAMICOBJECT.getValue())) {
                entityType = (MainEntityType)entityTypeMap.get(objNumber);
                if (entityType == null) {
                    entityType = EntityMetadataCache.getDataEntityType((String)objNumber);
                    entityTypeMap.put(objNumber, entityType);
                }
                if ((comboProp = (BasedataProp)entityType.getProperty(cfg.getString("number"))) == null) continue;
                if (SWCStringUtils.equals((String)comboProp.getBaseEntityId(), (String)"haos_adminorghr")) {
                    map.put("isadminorg", "true");
                }
            }
            List fieldList = groupList.computeIfAbsent(objName, val -> new ArrayList(10));
            fieldList.add(map);
        }
        ArrayList<Map<String, Object>> rootList = new ArrayList<Map<String, Object>>(groupList.size());
        for (Map.Entry groupListEntry : groupList.entrySet()) {
            String name = (String)groupListEntry.getKey();
            List fields = (List)groupListEntry.getValue();
            HashMap<String, Object> filedDataMap = new HashMap<String, Object>();
            filedDataMap.put("text", name);
            filedDataMap.put("children", fields);
            rootList.add(filedDataMap);
        }
        return rootList;
    }

    private static List<Map<String, Object>> getBoolean() {
        ArrayList<Map<String, Object>> booleanList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> trueMap = new HashMap<String, Object>();
        LocaleString trueString = new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"CalListRuleEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        trueMap.put("name", trueString);
        trueMap.put("value", Boolean.TRUE);
        booleanList.add(trueMap);
        HashMap<String, Object> falseMap = new HashMap<String, Object>();
        LocaleString falseString = new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"CalListRuleEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        falseMap.put("name", falseString);
        falseMap.put("value", Boolean.FALSE);
        booleanList.add(falseMap);
        return booleanList;
    }

    private static Map<String, List<Map<String, Object>>> getConfigFiledValueParam(DynamicObjectCollection cfgs) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)100);
        for (DynamicObject cfg : cfgs) {
            String objName = cfg.getString("perruleobj.name");
            String type = cfg.getString("type");
            List list = paramMap.getOrDefault(type, new ArrayList(20));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", cfg.getString("perruleobj.number") + "." + cfg.get("number"));
            map.put("number", cfg.getString("perruleobj.number") + "." + cfg.get("number"));
            map.put("text", objName + '.' + cfg.getString("name"));
            map.put("name", objName + '.' + cfg.getString("name"));
            map.put("type", type);
            list.add(map);
            paramMap.put(type, list);
        }
        return paramMap;
    }

    private void updateConditionData(Map<String, Object> data) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData(data);
    }

    protected Map getComparisonOperatorsMap() {
        HashMap<String, List> comparisonOperatorsMap = new HashMap<String, List>();
        comparisonOperatorsMap.put(RuleParamTypeEnum.BOOLEAN.getValue(), RuleTypeOperatorsUtils.getBooleanComparisonOperators());
        comparisonOperatorsMap.put(RuleParamTypeEnum.DATE.getValue(), RuleTypeOperatorsUtils.getDateComparisonOperators());
        comparisonOperatorsMap.put(RuleParamTypeEnum.STRING.getValue(), RuleTypeOperatorsUtils.getStringComparisonOperators());
        comparisonOperatorsMap.put(RuleParamTypeEnum.NUMBER.getValue(), RuleTypeOperatorsUtils.getNumberComparisonOperators());
        comparisonOperatorsMap.put(RuleParamTypeEnum.DYNAMICOBJECT.getValue(), RuleTypeOperatorsUtils.getObjectComparisonOperators());
        comparisonOperatorsMap.put(RuleParamTypeEnum.ENUM.getValue(), RuleTypeOperatorsUtils.getEnumComparisonOperators());
        comparisonOperatorsMap.put(RuleParamTypeEnum.ADMINORG.getValue(), RuleTypeOperatorsUtils.getAdminOrgComparisonOperators());
        return comparisonOperatorsMap;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.startsWith(OPEN_F7_CALLBACK)) {
            String index = actionId.replace(OPEN_F7_CALLBACK, "");
            Map<String, Object> resultMap = this.getF7CallBack(index, closedCallBackEvent);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("paramValue", resultMap);
            data.put("timestamp", System.currentTimeMillis());
            this.updateConditionData(data);
        }
    }

    private Map<String, Object> getF7CallBack(String index, ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedCol = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (null == selectedCol) {
            return null;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)32);
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)32);
        ArrayList nameList = Lists.newArrayListWithExpectedSize((int)32);
        ArrayList numberList = Lists.newArrayListWithExpectedSize((int)32);
        for (ListSelectedRow select : selectedCol) {
            idList.add(select.getPrimaryKeyValue().toString());
            nameList.add(select.getName());
            numberList.add(select.getNumber());
        }
        resultMap.put("idList", idList);
        resultMap.put("nameList", nameList);
        resultMap.put("numberList", numberList);
        resultMap.put("index", index);
        return resultMap;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "ruledate": {
                Date newData = (Date)args.getChangeSet()[0].getNewValue();
                if (null == newData) {
                    return;
                }
                String data = HRDateTimeUtils.formatDate((Date)newData);
                HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                dataMap.put("date", data);
                dataMap.put("timestamp", System.currentTimeMillis());
                this.updateConditionData(dataMap);
                this.getModel().setValue("ruledate", null);
                break;
            }
            case "rulecontent": {
                this.getModel().setValue("rulecontentshow", (Object)CalListRuleHelper.getParamValues((String)this.getModel().getDataEntity().getString(KEY_RULECONTENT)));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "donothing_changehis": 
            case "confirmchange": 
            case "donothing_prerun": {
                String value;
                RuleValidateInfo ruleValidateInfo;
                if (args.isCancel() || (ruleValidateInfo = RuleValidateUtil.validCondition((String)(value = (String)this.getModel().getValue(KEY_RULECONTENT)))).isSuccess()) break;
                args.setCancel(true);
                this.showErrorMsg(ruleValidateInfo);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        this.addBtn();
        switch (operateKey) {
            case "submit": 
            case "audit": 
            case "confirmchange": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                HashMap<String, Object> dataMap = new HashMap<String, Object>(1);
                dataMap.put("pageState", "VIEW");
                this.updateConditionData(dataMap);
                break;
            }
            case "unsubmit": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                HashMap<String, Object> dataMap = new HashMap<String, Object>(1);
                dataMap.put("pageState", "EDIT");
                this.updateConditionData(dataMap);
                break;
            }
            case "donothing_prerun": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("hsas_previewpersoncfg");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCustomParam(KEY_RULECONTENT, (Object)this.getModel().getDataEntity().getString(KEY_RULECONTENT));
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    protected List<String> getUnCheckField() {
        List uncheckFieldList = super.getUnCheckField();
        uncheckFieldList.add("ruledate");
        return uncheckFieldList;
    }
}

