/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.bizdatatpl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.TipsSupport;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsas.formplugin.web.file.subpage.SalaryFileBaseDataEdit;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.tab.UpdateTabNameHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class BizDataBillEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener,
ClickListener {
    private static final String CHANGE_BIZ_ITEM = "changeBizItem";
    private static final String CHANGE_CURRENCY = "changeCurrency";
    private static final String BIZITEMPROP_FLEX = "bizpropflex";
    private static final String BIZITEMPROP_ENTRY = "recurbizpropentry";

    public void afterCreateNewData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"frequency"});
        String salaryfileId = (String)this.getView().getFormShowParameter().getCustomParam("salaryfile");
        if (SWCStringUtils.isNotEmpty((String)salaryfileId)) {
            this.getView().getModel().setValue("salaryfile", (Object)Long.valueOf(salaryfileId));
            this.getView().setEnable(Boolean.FALSE, new String[]{"salaryfile"});
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit bizItem = (BasedataEdit)this.getView().getControl("bizitem");
        bizItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currency = (BasedataEdit)this.getView().getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Container panelap = (Container)this.getView().getControl("fs_baseinfo");
        this.replaceBasedataEdit(panelap.getItems());
        this.getView().createControlIndex(panelap.getItems());
        BasedataEdit salaryFile = (BasedataEdit)this.getView().getControl("salaryfile");
        salaryFile.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void replaceBasedataEdit(List<Control> items) {
        for (int i = 0; i < items.size(); ++i) {
            Control lap2Item = items.get(i);
            if (!"salaryfile".equals(lap2Item.getKey())) continue;
            BasedataEdit basedataEdit = (BasedataEdit)lap2Item;
            SalaryFileBaseDataEdit fileBaseDataEdit = new SalaryFileBaseDataEdit();
            fileBaseDataEdit.setKey(basedataEdit.getKey());
            fileBaseDataEdit.setView(basedataEdit.getView());
            items.set(i, (Control)fileBaseDataEdit);
            return;
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
        this.setF7Filter(fieldKey, param, arg0);
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        Boolean isSalaryStd;
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        if (formShowParameter != null && OperationStatus.ADDNEW.equals((Object)formShowParameter.getStatus()) && (isSalaryStd = (Boolean)formShowParameter.getCustomParam("isSalaryStd")) != null && isSalaryStd.booleanValue()) {
            formShowParameter.getFormConfig().setCaption(ResManager.getLocaleString((String)"\u65b0\u589e\u85aa\u916c\u6807\u51c6", (String)"BizDataBillEdit_202", (String)"swc-hsas-formplugin"));
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Boolean isSalaryStd = (Boolean)this.getView().getFormShowParameter().getCustomParam("isSalaryStd");
        if (!OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            if (isSalaryStd != null && isSalaryStd.booleanValue()) {
                String title = ResManager.loadKDString((String)"\u85aa\u916c\u6807\u51c6", (String)"BizDataBillEdit_201", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                String name = this.getView().getModel().getDataEntity().getString("salaryfile.name");
                UpdateTabNameHelper.updateTabNameByWholeValue((IFormView)this.getView(), (String)(title + " - " + name));
            } else {
                UpdateTabNameHelper.updateTabName((IFormView)this.getView(), (String)"salaryfile.name");
            }
        }
    }

    public void afterBindData(EventObject event) {
        this.initBarAndFiledsStatus();
        this.initTips();
        DynamicObject bizItem = (DynamicObject)this.getModel().getValue("bizitem");
        if (bizItem == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"currency", "datevalue", "decimalvalue"});
            FieldEdit textValueEdit = (FieldEdit)this.getView().getControl("datavalue");
            textValueEdit.setMustInput(true);
            return;
        }
        long dataTypeId = bizItem.getLong("datatype.id");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        this.initFiledValue(bizItem, dataTypeId, currency);
        this.initFiledVisibleByDataType(dataTypeId);
        this.setMaxValueAndMinValue(bizItem);
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "save": 
            case "submit": {
                String entityName = this.getView().getEntityId();
                if (SWCStringUtils.equals((String)entityName, (String)"hsas_nonrecurbizdata")) {
                    this.writeRedundance();
                }
                source.getOption().setVariableValue("isImport", Boolean.FALSE.toString());
                source.getOption().setVariableValue("isListOp", Boolean.FALSE.toString());
                break;
            }
        }
    }

    private void writeRedundance() {
        DynamicObject salaryFileObj = this.getModel().getDataEntity().getDynamicObject("salaryfile");
        if (SWCObjectUtils.isEmpty((Object)salaryFileObj)) {
            return;
        }
        this.getModel().setValue("org", salaryFileObj.get("org"));
        this.getModel().setValue("payrollregion", salaryFileObj.get("payrollregion"));
        this.getModel().setValue("payrollgroup", salaryFileObj.get("payrollgroup"));
        this.getModel().setValue("adminorg", salaryFileObj.get("adminorg"));
        this.getModel().setValue("empgroup", salaryFileObj.get("empgroup"));
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "bizitem": {
                DynamicObject oldValue = (DynamicObject)event.getChangeSet()[0].getOldValue();
                DynamicObject newValue = (DynamicObject)event.getChangeSet()[0].getNewValue();
                if (newValue == null) break;
                this.changeBizItem(oldValue, newValue);
                break;
            }
            case "currency": {
                DynamicObject oldCurrencyValue = (DynamicObject)event.getChangeSet()[0].getOldValue();
                DynamicObject newCurrencyValue = (DynamicObject)event.getChangeSet()[0].getNewValue();
                this.changeCurrency(oldCurrencyValue, newCurrencyValue);
                break;
            }
            case "salaryfile": {
                DynamicObject bizItem;
                DynamicObject oldSalaryFileObj = (DynamicObject)event.getChangeSet()[0].getOldValue();
                DynamicObject newSalaryFileObj = (DynamicObject)event.getChangeSet()[0].getNewValue();
                if (oldSalaryFileObj != newSalaryFileObj) {
                    this.getModel().beginInit();
                    this.getModel().setValue("calperiodtype", null);
                    this.getModel().setValue("calperiod", null);
                    this.getModel().endInit();
                }
                if ((bizItem = (DynamicObject)this.getModel().getValue("bizitem")) != null && !SWCStringUtils.equals((String)bizItem.getString("ctrlstrategy"), (String)"5")) {
                    if (SWCObjectUtils.isEmpty((Object)newSalaryFileObj)) break;
                    this.checkBizItemPermission(newSalaryFileObj.getLong("org.id"), bizItem.getLong("id"));
                }
                this.getView().updateView();
                break;
            }
        }
    }

    private void checkBizItemPermission(Long orgId, Long bizItemId) {
        boolean isPass;
        QFilter usedFilter = BaseDataServiceHelper.getBaseDataFilter((String)"hsbs_bizitem", (Long)orgId);
        if (usedFilter == null) {
            isPass = false;
        } else {
            QFilter filter = new QFilter("id", "=", (Object)bizItemId);
            filter.and(usedFilter);
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
            boolean bl = isPass = helper.count(new QFilter[]{filter}) > 0;
        }
        if (!isPass) {
            this.getModel().setValue("bizitem", null);
            this.getModel().setValue("maxvalue", null);
            this.getModel().setValue("minvalue", null);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (SWCStringUtils.equals((String)callBackId, (String)CHANGE_BIZ_ITEM)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.clearFiledValue();
                DynamicObject bizItem = (DynamicObject)this.getModel().getValue("bizitem");
                if (bizItem != null) {
                    this.setDecimalFieldScale(bizItem);
                    this.setMaxValueAndMinValue(bizItem);
                }
            } else {
                String entityName;
                String oldBizItemIdStr = messageBoxClosedEvent.getCustomVaule();
                if (SWCStringUtils.isNotEmpty((String)oldBizItemIdStr)) {
                    Long oldBizItemId = Long.valueOf(oldBizItemIdStr);
                    this.getModel().beginInit();
                    this.getModel().setValue("bizitem", (Object)oldBizItemId);
                    this.getModel().endInit();
                    this.getView().updateView();
                }
                if (SWCStringUtils.equals((String)"hsas_recurbizdata", (String)(entityName = ((BillView)this.getView()).getFormId()))) {
                    this.bizItemChangeEvent(this.getModel().getDataEntity().getDynamicObject("bizitem"));
                }
            }
        } else if (SWCStringUtils.equals((String)callBackId, (String)CHANGE_CURRENCY)) {
            this.currencyChangeConfirmEvent(result, messageBoxClosedEvent);
        }
    }

    private void currencyChangeConfirmEvent(MessageBoxResult result, MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            DynamicObject bizItem = (DynamicObject)this.getModel().getValue("bizitem");
            DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("currency");
            if (!SWCObjectUtils.isEmpty((Object)bizItem)) {
                long dataTypeId = bizItem.getLong("datatype.id");
                this.initFiledValue(bizItem, dataTypeId, currencyObj);
            }
        } else {
            String oldCurrencyIdStr = messageBoxClosedEvent.getCustomVaule();
            Long oldCurrencuId = null;
            if (SWCStringUtils.isNotEmpty((String)oldCurrencyIdStr)) {
                oldCurrencuId = Long.valueOf(oldCurrencyIdStr);
            }
            this.getModel().beginInit();
            this.getModel().setValue("currency", (Object)oldCurrencuId);
            this.getModel().endInit();
            this.getView().updateView();
        }
    }

    private void bizItemChangeEvent(DynamicObject bizItemObj) {
        if (SWCObjectUtils.isEmpty((Object)bizItemObj)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BIZITEMPROP_FLEX});
            this.getModel().deleteEntryData(BIZITEMPROP_ENTRY);
            return;
        }
        boolean isExtProp = bizItemObj.getBoolean("isextprop");
        if (isExtProp) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BIZITEMPROP_FLEX});
            this.loadBizItemPropEntry(bizItemObj.getLong("id"));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BIZITEMPROP_FLEX});
            this.getModel().deleteEntryData(BIZITEMPROP_ENTRY);
        }
    }

    private void loadBizItemPropEntry(long bizItemId) {
        SWCPageCache cache = new SWCPageCache(this.getView());
        Map cachePropMap = (Map)cache.get("propValMap", Map.class);
        BizDataHelper helper = new BizDataHelper();
        DynamicObjectCollection bizItemEntryColl = helper.getBizItemPropInfo(bizItemId);
        if (SWCObjectUtils.isEmpty((Object)bizItemEntryColl)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("bizitemprop", new Object[0]);
        setter.addField("propdatavalue", new Object[0]);
        for (DynamicObject bizItemEntryObj : bizItemEntryColl) {
            DynamicObject bizItemPropObj = bizItemEntryObj.getDynamicObject("bizitemprop");
            if (SWCObjectUtils.isEmpty((Object)bizItemPropObj)) continue;
            long bizItemPropId = bizItemPropObj.getLong("id");
            if (cachePropMap != null) {
                String propVal = (String)cachePropMap.get(String.valueOf(bizItemPropId));
                if (SWCStringUtils.isEmpty((String)propVal)) {
                    String status = bizItemPropObj.getString("status");
                    String enable = bizItemPropObj.getString("enable");
                    if (!SWCStringUtils.equals((String)status, (String)"C") || !SWCStringUtils.equals((String)enable, (String)"1")) continue;
                }
                setter.addRow(new Object[]{bizItemPropId, propVal});
                continue;
            }
            setter.addRow(new Object[]{bizItemPropId, null});
        }
        model.deleteEntryData(BIZITEMPROP_ENTRY);
        model.batchCreateNewEntryRow(BIZITEMPROP_ENTRY, setter);
        this.getView().updateView(BIZITEMPROP_ENTRY);
        model.endInit();
    }

    private void changeBizItem(DynamicObject oldValue, DynamicObject newValue) {
        boolean isNeedClear = this.checkNeedClear();
        long dataTypeId = newValue.getLong("datatype.id");
        if (oldValue == null || !isNeedClear) {
            this.initFiledVisibleByDataType(dataTypeId);
            this.setDecimalFieldScale(newValue);
            this.setMaxValueAndMinValue(newValue);
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CHANGE_BIZ_ITEM, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5207\u6362\u540e\uff0c\u5c06\u6e05\u7a7a\u5df2\u586b\u5199\u7684\u503c\u3002\u662f\u5426\u5207\u6362\uff1f", (String)"BizDataBillEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, null, options, ConfirmTypes.Default, confirmCallBacks, null, String.valueOf(oldValue.getLong("id")));
    }

    private void changeCurrency(DynamicObject oldCurrencyValue, DynamicObject newCurrencyValue) {
        BigDecimal decimalVal = (BigDecimal)this.getModel().getValue("decimalvalue");
        if (decimalVal == null) {
            DynamicObject bizItem = (DynamicObject)this.getModel().getValue("bizitem");
            if (!SWCObjectUtils.isEmpty((Object)bizItem)) {
                long dataTypeId = bizItem.getLong("datatype.id");
                this.initFiledValue(bizItem, dataTypeId, newCurrencyValue);
            }
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CHANGE_CURRENCY, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5207\u6362\u5e01\u79cd\u540e\u5c06\u81ea\u52a8\u6839\u636e\u5e01\u79cd\u7cbe\u5ea6\u56db\u820d\u4e94\u5165\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizDataBillEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        if (!SWCObjectUtils.isEmpty((Object)oldCurrencyValue)) {
            this.getView().showConfirm(msg, null, options, ConfirmTypes.Default, confirmCallBacks, null, String.valueOf(oldCurrencyValue.getLong("id")));
        } else {
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks);
        }
    }

    private void initTips() {
        List promptString = (List)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptForString", (Object[])new Object[]{"hsas_bizdatatemplate", "islistgenerate", this.getModel().getDataEntity()});
        String tipsValue = "";
        Iterator iterator = promptString.iterator();
        while (iterator.hasNext()) {
            String entry;
            tipsValue = entry = (String)iterator.next();
        }
        Tips tips = new Tips();
        tips.setType("text");
        tips.setContent(new LocaleString(tipsValue));
        TipsSupport control = (TipsSupport)this.getControl("islistgenerate");
        control.addTips(tips);
    }

    private void setMaxValueAndMinValue(DynamicObject bizItem) {
        BigDecimal maxVal = bizItem.getBigDecimal("maxvalue");
        BigDecimal minVal = bizItem.getBigDecimal("minvalue");
        boolean isMaxValNull = bizItem.getBoolean("ismaxvalnull");
        boolean isMinValNull = bizItem.getBoolean("isminvalnull");
        if (!isMinValNull) {
            this.getModel().setValue("minvalue", (Object)minVal.toPlainString());
        } else {
            this.getModel().setValue("minvalue", null);
        }
        if (!isMaxValNull) {
            this.getModel().setValue("maxvalue", (Object)maxVal.toPlainString());
        } else {
            this.getModel().setValue("maxvalue", null);
        }
    }

    private boolean checkNeedClear() {
        return this.getModel().getValue("currency") != null || SWCStringUtils.isNotEmpty((String)((String)this.getModel().getValue("datavalue"))) || this.getModel().getValue("datevalue") != null || this.getModel().getValue("decimalvalue") != null;
    }

    private void clearFiledValue() {
        this.getModel().beginInit();
        this.getModel().setValue("datavalue", null);
        this.getModel().setValue("datevalue", null);
        this.getModel().setValue("decimalvalue", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("frequency", null);
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void setF7Filter(String fieldKey, ListShowParameter param, BeforeF7SelectEvent arg0) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        QFilter filter = null;
        switch (fieldKey) {
            case "currency": {
                DynamicObject bizItem = this.getModel().getDataEntity().getDynamicObject("bizitem");
                HashSet<Long> currencyIdSet = new HashSet<Long>(16);
                if (!SWCObjectUtils.isEmpty((Object)bizItem)) {
                    DynamicObjectCollection currencyColl = bizItem.getDynamicObjectCollection("currency");
                    for (DynamicObject currency : currencyColl) {
                        currencyIdSet.add(currency.getLong("fbasedataid_id"));
                    }
                }
                if (currencyIdSet.size() <= 0) break;
                filter = new QFilter("id", "in", currencyIdSet);
                break;
            }
            case "bizitem": {
                HasPermOrgResult permOrgResult;
                Boolean isSalaryStd;
                DynamicObject salaryFile = (DynamicObject)this.getModel().getValue("salaryfile");
                if (salaryFile != null) {
                    filter = BaseDataServiceHelper.getBaseDataFilter((String)"hsbs_bizitem", (Long)salaryFile.getLong("org.id"));
                }
                if ((isSalaryStd = (Boolean)this.getView().getFormShowParameter().getCustomParam("isSalaryStd")) != null && isSalaryStd.booleanValue()) {
                    arg0.addCustomQFilter(new QFilter("issalarystd", "=", (Object)"1"));
                }
                if (!(permOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"47150e89000000ac")).hasAllOrgPerm()) {
                    List allOrgList = permOrgResult.getHasPermOrgs();
                    QFilter orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_bizitem", (List)allOrgList, (boolean)true);
                    arg0.addCustomQFilter(orgFilter);
                }
                arg0.getFormShowParameter().setCustomParam("filterLeftTree", (Object)"1");
                arg0.addCustomQFilter(new QFilter("classification", "!=", (Object)"1"));
                break;
            }
            case "salaryfile": {
                this.salaryFileCheck(filterList);
                break;
            }
        }
        if (filter != null) {
            filterList.add(filter);
            if (!CollectionUtils.isEmpty((Collection)param.getListFilterParameter().getQFilters())) {
                filterList.addAll(param.getListFilterParameter().getQFilters());
            }
        }
        if (filterList != null && filterList.size() > 0) {
            param.getListFilterParameter().setQFilters(filterList);
        }
    }

    private void salaryFileCheck(List<QFilter> filterList) {
        HasPermOrgResult hasPermOrgResult;
        String formId = this.getView().getFormShowParameter().getFormId();
        if (!("hsas_recurbizdata".equals(formId) || "hsas_nonrecurbizdata".equals(formId) || "hsas_salarystd".equals(formId))) {
            filterList.add(new QFilter("1", "!=", (Object)1));
            return;
        }
        if ("hsas_recurbizdata".equals(formId) || "hsas_nonrecurbizdata".equals(formId)) {
            HasPermOrgResult hasPermOrgResult2 = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)formId, (String)"47150e89000000ac");
            if (hasPermOrgResult2 != null && !hasPermOrgResult2.hasAllOrgPerm()) {
                List orgIdList = hasPermOrgResult2.getHasPermOrgs();
                filterList.add(new QFilter("org.id", "in", (Object)orgIdList));
            }
        } else if ("hsas_salarystd".equals(formId) && (hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_recurbizdata", (String)"47150e89000000ac")) != null && !hasPermOrgResult.hasAllOrgPerm()) {
            List orgIdList = hasPermOrgResult.getHasPermOrgs();
            filterList.add(new QFilter("org.id", "in", (Object)orgIdList));
        }
    }

    private void initBarAndFiledsStatus() {
        String dataSources = (String)this.getModel().getValue("datasources");
        String auditstatus = (String)this.getModel().getValue("auditstatus");
        if ("2".equals(dataSources) || "3".equals(dataSources) || SWCStringUtils.equals((String)"E", (String)auditstatus) || SWCStringUtils.equals((String)"R", (String)auditstatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_del", "bar_save", "bar_submit", "bar_modify"});
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        }
    }

    private void initFiledValue(DynamicObject bizItem, long dataTypeId, DynamicObject currency) {
        String strValue = (String)this.getModel().getValue("datavalue");
        if (1050L == dataTypeId) {
            if (SWCStringUtils.isNotEmpty((String)strValue)) {
                BizDataHelper bizDataHelper = new BizDataHelper();
                Object dataValue = bizDataHelper.getDateValue(strValue);
                this.getModel().setValue("datevalue", dataValue);
            }
        } else if (1010L == dataTypeId) {
            int scale = this.getScale(bizItem);
            this.setClientFieldScale("decimalvalue", scale);
            if (SWCStringUtils.isNotEmpty((String)strValue)) {
                BigDecimal value = new BigDecimal(strValue).setScale(scale, RoundingMode.HALF_UP);
                this.getModel().setValue("decimalvalue", (Object)value);
            }
        } else if (1020L == dataTypeId) {
            if (SWCObjectUtils.isEmpty((Object)currency)) {
                return;
            }
            int scale = currency.getInt("amtprecision");
            this.setClientFieldScale("decimalvalue", scale);
            if (SWCStringUtils.isNotEmpty((String)strValue)) {
                BigDecimal value = new BigDecimal(strValue).setScale(scale, RoundingMode.HALF_UP);
                this.getModel().setValue("decimalvalue", (Object)value);
            }
        }
    }

    private int getScale(DynamicObject bizItem) {
        String scalelimit = bizItem.getString("scalelimit");
        int scale = 10;
        if (!SWCObjectUtils.isEmpty((Object)scalelimit)) {
            scale = Integer.parseInt(scalelimit);
        }
        return scale;
    }

    private void initFiledVisibleByDataType(long dataTypeId) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"currency", "datavalue", "datevalue", "decimalvalue", "datalength", "earliestdate", "lastdate", "maxvalue", "minvalue", "currency", "scalelimit", "bizitemgrpentcur", "frequency"});
        FieldEdit currencyEdit = (FieldEdit)this.getView().getControl("currency");
        currencyEdit.setMustInput(false);
        FieldEdit textValueEdit = (FieldEdit)this.getView().getControl("datavalue");
        textValueEdit.setMustInput(false);
        FieldEdit dateValueEdit = (FieldEdit)this.getView().getControl("datevalue");
        dateValueEdit.setMustInput(false);
        FieldEdit decimalValueEdit = (FieldEdit)this.getView().getControl("decimalvalue");
        decimalValueEdit.setMustInput(false);
        if (1030L == dataTypeId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"datavalue", "datalength"});
            textValueEdit.setMustInput(true);
        } else if (1050L == dataTypeId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"datevalue", "earliestdate", "lastdate"});
            dateValueEdit.setMustInput(true);
        } else if (1010L == dataTypeId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"decimalvalue", "maxvalue", "minvalue", "scalelimit", "frequency"});
            decimalValueEdit.setMustInput(true);
        } else if (1020L == dataTypeId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"decimalvalue", "currency", "bizitemgrpentcur", "frequency"});
            currencyEdit.setMustInput(true);
            decimalValueEdit.setMustInput(true);
        }
    }

    private void setClientFieldScale(String key, int scale) {
        HashMap<String, Integer> editorProps = new HashMap<String, Integer>();
        editorProps.put("sc", scale);
        HashMap<String, HashMap<String, Integer>> ctrlProps = new HashMap<String, HashMap<String, Integer>>();
        ctrlProps.put("item", editorProps);
        this.getView().updateControlMetadata(key, ctrlProps);
    }

    private void setServerFieldScale(String key, int scale) {
        BigDecimal oldValue = (BigDecimal)this.getModel().getValue(key);
        if (oldValue != null) {
            BigDecimal newValue = oldValue.setScale(scale, RoundingMode.HALF_UP);
            this.getModel().setValue(key, (Object)newValue);
        }
    }

    private void setDecimalFieldScale(DynamicObject bizItem) {
        long dataTypeId = bizItem.getLong("datatype.id");
        int scale = this.getScale(bizItem);
        if (1010L == dataTypeId || 1020L == dataTypeId) {
            this.setClientFieldScale("decimalvalue", scale);
            this.setServerFieldScale("decimalvalue", scale);
            this.getModel().setValue("decimalvalue", null);
        }
    }
}

