/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.bizdatatpl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataImportPlugin
extends BatchImportPlugin {
    public List<String> getDefaultLockUIs() {
        ArrayList<String> lockKeys = new ArrayList<String>();
        lockKeys.add("radiofield1");
        lockKeys.add("radiofield2");
        lockKeys.add("keyfields");
        return lockKeys;
    }

    protected void beforeSave(List<ImportBillData> billData, ImportLogger logger) {
        super.beforeSave(billData, logger);
        String billFormId = this.getBillFormId();
        if (SWCStringUtils.equals((String)billFormId, (String)"hsas_nonrecurbizdata")) {
            this.salaryFileRedundanceBuild(billData);
        }
        ArrayList<String> bizItemNumList = new ArrayList<String>(billData.size());
        for (ImportBillData importBillData : billData) {
            String bizDataNumber;
            JSONObject bizItemObj;
            JSONObject billDataObj = importBillData.getData();
            if (billDataObj == null || (bizItemObj = billDataObj.getJSONObject("bizitem")) == null || !SWCStringUtils.isNotEmpty((String)(bizDataNumber = bizItemObj.getString("number")))) continue;
            bizItemNumList.add(bizDataNumber);
        }
        Object[] bizItemNumbers = bizItemNumList.toArray();
        if (bizItemNumbers == null || bizItemNumbers.length == 0) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        QFilter filter = new QFilter("number", "in", (Object)bizItemNumbers);
        DynamicObject[] bizItemArray = helper.query("id,number,datatype.storagetype", new QFilter[]{filter});
        if (bizItemArray == null || bizItemArray.length == 0) {
            return;
        }
        HashMap<String, String> dataTypeMap = new HashMap<String, String>(bizItemArray.length);
        for (DynamicObject bizItemObj : bizItemArray) {
            String number = bizItemObj.getString("number");
            DynamicObject dataTypeObj = bizItemObj.getDynamicObject("datatype");
            String storagetype = dataTypeObj.getString("storagetype");
            dataTypeMap.put(number, storagetype);
        }
        Iterator<ImportBillData> it = billData.iterator();
        while (it.hasNext()) {
            JSONObject currencyObj;
            String storagetype;
            String bizItemNum;
            JSONObject bizItemObj;
            ImportBillData importData = it.next();
            if (importData.isEmpty() || (bizItemObj = importData.getData().getJSONObject("bizitem")) == null || SWCStringUtils.isEmpty((String)(bizItemNum = bizItemObj.getString("number"))) || SWCStringUtils.isEmpty((String)(storagetype = (String)dataTypeMap.get(bizItemNum))) || !SWCStringUtils.equals((String)storagetype, (String)"num") || (currencyObj = importData.getData().getJSONObject("currency")) == null) continue;
            String currencyNumber = importData.getData().getJSONObject("currency").getString("number");
            String currencyName = importData.getData().getJSONObject("currency").getString("name");
            if (!SWCStringUtils.isNotEmpty((String)currencyNumber) && !SWCStringUtils.isNotEmpty((String)currencyName)) continue;
            it.remove();
            this.log(importData.getStartIndex(), ResManager.loadKDString((String)"\u6570\u503c\u7c7b\u578b\u7684\u4e1a\u52a1\u9879\u76ee\u5e01\u79cd\u5fc5\u987b\u4e3a\u7a7a", (String)"BizDataImportPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), logger);
        }
    }

    private void salaryFileRedundanceBuild(List<ImportBillData> billData) {
        Object[] salaryFileNumbers = billData.stream().map(bill -> bill.getData().getJSONObject("salaryfile").getString("number")).toArray();
        String field = "number,org.id,payrollregion.id,payrollgroup.id,adminorg.id,empgroup.id";
        QFilter filter = new QFilter("number", "in", (Object)salaryFileNumbers);
        filter.and("iscurrentversion", "=", (Object)"1");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject[] queryDatas = helper.query(field, new QFilter[]{filter});
        if (queryDatas == null || queryDatas.length == 0) {
            return;
        }
        HashMap<String, HashMap<String, Long>> cacheDataMap = new HashMap<String, HashMap<String, Long>>(queryDatas.length);
        for (DynamicObject dataObj : queryDatas) {
            String number = dataObj.getString("number");
            HashMap<String, Long> redundanceMap = (HashMap<String, Long>)cacheDataMap.get(number);
            if (redundanceMap == null || redundanceMap.size() == 0) {
                redundanceMap = new HashMap<String, Long>(4);
            }
            redundanceMap.put("org", dataObj.getLong("org.id"));
            redundanceMap.put("payrollregion", dataObj.getLong("payrollregion.id"));
            redundanceMap.put("payrollgroup", dataObj.getLong("payrollgroup.id"));
            redundanceMap.put("adminorg", dataObj.getLong("adminorg.id"));
            redundanceMap.put("empgroup", dataObj.getLong("empgroup.id"));
            cacheDataMap.put(number, redundanceMap);
        }
        for (ImportBillData importBillData : billData) {
            Long empId;
            Long adminOrgId;
            Long groupId;
            Long regionId;
            String salaryFilenumber;
            Map otherMap;
            JSONObject billDataObj = importBillData.getData();
            JSONObject salaryFileObj = billDataObj.getJSONObject("salaryfile");
            if (salaryFileObj == null || salaryFileObj.size() == 0 || (otherMap = (Map)cacheDataMap.get(salaryFilenumber = salaryFileObj.getString("number"))) == null || otherMap.size() == 0) continue;
            Long orgId = (Long)otherMap.get("org");
            if (orgId != null && orgId != 0L) {
                JSONObject orgObj = new JSONObject();
                orgObj.put("importprop", (Object)"number");
                orgObj.put("id", (Object)orgId);
                billDataObj.put("org", (Object)orgObj);
            }
            if ((regionId = (Long)otherMap.get("payrollregion")) != null && regionId != 0L) {
                JSONObject regionObj = new JSONObject();
                regionObj.put("importprop", (Object)"number");
                regionObj.put("id", (Object)regionId);
                billDataObj.put("payrollregion", (Object)regionObj);
            }
            if ((groupId = (Long)otherMap.get("payrollgroup")) != null && groupId != 0L) {
                JSONObject groupObj = new JSONObject();
                groupObj.put("importprop", (Object)"number");
                groupObj.put("id", (Object)groupId);
                billDataObj.put("payrollgroup", (Object)groupObj);
            }
            if ((adminOrgId = (Long)otherMap.get("adminorg")) != null && adminOrgId != 0L) {
                JSONObject adminOrgObj = new JSONObject();
                adminOrgObj.put("importprop", (Object)"number");
                adminOrgObj.put("id", (Object)adminOrgId);
                billDataObj.put("adminorg", (Object)adminOrgObj);
            }
            if ((empId = (Long)otherMap.get("empgroup")) == null || empId == 0L) continue;
            JSONObject empObj = new JSONObject();
            empObj.put("importprop", (Object)"number");
            empObj.put("id", (Object)empId);
            billDataObj.put("empgroup", (Object)empObj);
        }
    }

    private void log(int rowIndex, String errorMsg, ImportLogger logger) {
        Map logCache = logger.getLogCache();
        if (logCache.get(rowIndex) != null) {
            ((List)logCache.get(rowIndex)).add(new ImportLogger.ImportLog(errorMsg));
            logger.setLogCache(logCache);
        } else {
            logger.log(Integer.valueOf(rowIndex), errorMsg).fail();
        }
    }
}

