/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.bizdatatpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Table;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.util.JSONUtils;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsas.business.bizdata.service.BizDataRecoverBsledService;
import kd.swc.hsas.common.utils.GlobalParam;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import org.apache.commons.collections.CollectionUtils;

public class RecurBizDataListPlugin
extends SWCDataBaseList {
    private static final String CALLBACK_INVOKE = "callback_invoke";
    private static final Log log = LogFactory.getLog(RecurBizDataListPlugin.class);
    private static final String HSAS_BIZDATA_CACHE_KEY = "hsas_bizdata_cache_key";
    private static final String CLOSE_CALBACK_AUDIT = "closecalbackaudit";
    private static final String CLOSE_CALBACK_UNAUDIT = "closecalbackunaudit";
    private static final String CLOSE_CALBACK_REJECT = "closecalbackreject";
    private static final int MAX_OP_COUNT = 5000;
    private static final int BATCH_TRANS_PAYROLLGRP_NUM = 500;

    public void initialize() {
        super.initialize();
        List filterIdList = (List)this.getView().getFormShowParameter().getCustomParam("filterIdList");
        if (filterIdList != null) {
            try {
                this.getPageCache().put("filterIdList", JSONUtils.toString((Object)filterIdList));
            }
            catch (IOException e) {
                log.error("filterIdList trans fail{}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.getView().getFormShowParameter().setCustomParam("filterIdList", null);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (source.getOption().tryGetVariableValue(CALLBACK_INVOKE, new RefObject())) {
            return;
        }
        switch (operateKey) {
            case "donothing_reject": {
                args.setCancel(true);
                this.doReject();
                break;
            }
            case "donothing_updatebsled": {
                args.setCancel(true);
                this.doUpdateBsled();
                break;
            }
            case "donothing_abandon": {
                args.setCancel(true);
                this.doAbandon();
                break;
            }
            case "submit": {
                source.getOption().setVariableValue("isImport", Boolean.FALSE.toString());
                break;
            }
            case "donothing_audit": {
                args.setCancel(true);
                this.doAudit(args);
                break;
            }
            case "donothing_unaudit": {
                args.setCancel(true);
                this.doUnAudit(args);
                break;
            }
            case "donothing_directtrans": 
            case "donothing_bsedtrans": {
                args.setCancel(true);
                this.doPayRollGrpTrans(operateKey);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        FormOperate op = (FormOperate)args.getSource();
        switch (operateKey) {
            case "donothing_abandon": 
            case "donothing_reject": 
            case "donothing_updatebsled": {
                ((IEntityOperate)op).setCancelRefresh(false);
                break;
            }
            case "donothing_viewmodifyrecord": {
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                List<Object> primaryKeyValues = Arrays.asList(selectedRows.getPrimaryKeyValues());
                this.viewBizDataModifyRecord(primaryKeyValues);
                break;
            }
            case "donothing_viewmodifyrecordcol": {
                ArrayList<Object> focusRows = new ArrayList<Object>(1);
                focusRows.add(this.getFocusRowPkId());
                this.viewBizDataModifyRecord(focusRows);
                break;
            }
            case "donothing_directtrans": 
            case "donothing_bsedtrans": {
                if (!args.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void viewBizDataModifyRecord(List<Object> primaryKeyValues) {
        QFilter filter = new QFilter("modeltype", "=", (Object)"1");
        filter.and("bizitem.cycle", "=", (Object)"1");
        if (!CollectionUtils.isEmpty(primaryKeyValues)) {
            filter.and("dataid", "in", primaryKeyValues);
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hsas_bizdatamodifyrecord");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("bos_list");
        if (!CollectionUtils.isEmpty(primaryKeyValues)) {
            showParameter.setCustomParam("dataids", primaryKeyValues);
        }
        ListFilterParameter filterParams = showParameter.getListFilterParameter();
        filterParams.setQFilters(Collections.singletonList(filter));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List filters = args.getQFilters();
        switch (fieldName) {
            case "salaryfile.payrollgroup.id": 
            case "salaryfile.payrollgroup.name": {
                this.setOrgAuthorFilter(filters);
                break;
            }
            case "salaryfile.org.name": {
                this.addOrgPermFilter(filters, "id", "/UHMBBGZQ65X", "hsas_recurbizdata");
                break;
            }
            case "salaryfile.empgroup.name": {
                QFilter empGroupFilter = new QFilter("id", "in", (Object)SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)"hsas"));
                filters.add(empGroupFilter);
                break;
            }
            case "salaryfile.name": 
            case "salaryfile.number": {
                this.addOrgPermFilter(filters, "org.id", "/UHMBBGZQ65X", "hsas_recurbizdata");
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "salaryfile.payrollgroup.id": 
            case "salaryfile.payrollgroup.name": {
                this.setOrgAuthorFilter(filters);
                break;
            }
            case "salaryfile.org.name": {
                this.addOrgPermFilter(filters, "id", "/UHMBBGZQ65X", "hsas_recurbizdata");
                break;
            }
            case "salaryfile.empgroup.name": {
                QFilter empGroupFilter = new QFilter("id", "in", (Object)SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)"hsas"));
                filters.add(empGroupFilter);
                break;
            }
            case "salaryfile.name": 
            case "salaryfile.number": {
                this.addOrgPermFilter(filters, "org.id", "/UHMBBGZQ65X", "hsas_recurbizdata");
                break;
            }
            case "bizitem.name": 
            case "bizitem.number": {
                filters.add(BizDataHelper.getClassificationFilter());
                break;
            }
        }
    }

    private void addOrgPermFilter(List<QFilter> filters, String propKey, String appId, String entityNum) {
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)appId, (String)entityNum, (String)"47150e89000000ac");
        if (permOrgs != null) {
            if (permOrgs.hasAllOrgPerm()) {
                return;
            }
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            QFilter permFilter = new QFilter(propKey, "in", (Object)hasPermOrgs);
            filters.add(permFilter);
        }
    }

    public void setOrgAuthorFilter(List<QFilter> qFilters) {
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_recurbizdata", (String)"47150e89000000ac");
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            log.info("RecurbizDataListPlugin.setOrgAuthorFilter: hasPermOrgs is {}", (Object)JSON.toJSONString((Object)hasPermOrgs));
            QFilter permFilter = new QFilter("org", "in", (Object)hasPermOrgs);
            qFilters.add(permFilter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData instanceof ListSelectedRowCollection) {
            if (SWCStringUtils.equals((String)actionId, (String)"donothing_directtrans")) {
                ListSelectedRowCollection selectColl = (ListSelectedRowCollection)returnData;
                if (selectColl == null || selectColl.size() == 0) {
                    return;
                }
                Long payRollGroupId = (Long)selectColl.get(0).getPrimaryKeyValue();
                OperateOption option = OperateOption.create();
                option.setVariableValue("payRollGroupId", String.valueOf(payRollGroupId));
                option.setVariableValue(CALLBACK_INVOKE, "true");
                option.setVariableValue("batchop_batchsize", String.valueOf(500));
                this.getView().invokeOperation("donothing_directtrans", option);
            }
        } else {
            Map rsMap = (Map)closedCallBackEvent.getReturnData();
            if (rsMap != null && "ok".equals(rsMap.get("operate"))) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("userId", String.valueOf(RequestContext.get().getCurrUserId()));
                option.setVariableValue("pageId", this.getView().getPageId());
                option.setVariableValue("isRecur", "Y");
                option.setVariableValue(CALLBACK_INVOKE, "true");
                if (SWCStringUtils.equals((String)actionId, (String)"donothing_reject")) {
                    this.rejectDonothigEvent(rsMap, option);
                } else if (SWCStringUtils.equals((String)actionId, (String)"donothing_abandon")) {
                    option.setVariableValue("opreason", (String)rsMap.get("opreason"));
                    this.getView().invokeOperation("donothing_abandon", option);
                } else if (SWCStringUtils.equals((String)actionId, (String)"donothing_updatebsled")) {
                    this.doUpdateBsledConfirm(rsMap);
                } else if (SWCStringUtils.equals((String)"updateBsledConfirm", (String)actionId)) {
                    ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATA_CACHE_KEY);
                    option.setVariableValue("descriptionbsled", (String)appCache.get("descriptionbsled", String.class));
                    option.setVariableValue("updatebsledStr", (String)appCache.get("updatebsledStr", String.class));
                    this.getView().invokeOperation("donothing_updatebsled", option);
                } else if (SWCStringUtils.equals((String)CLOSE_CALBACK_AUDIT, (String)actionId)) {
                    this.auditCloseCalBackEvent();
                } else if (SWCStringUtils.equals((String)CLOSE_CALBACK_UNAUDIT, (String)actionId)) {
                    this.unAuditCloseCalBackEvent();
                } else if (SWCStringUtils.equals((String)CLOSE_CALBACK_REJECT, (String)actionId)) {
                    this.rejectCloseCalbackEvent(rsMap, option);
                } else if (SWCStringUtils.equals((String)actionId, (String)"donothing_bsedtrans")) {
                    option.setVariableValue("payRollGroupId", (String)rsMap.get("payRollGroupId"));
                    option.setVariableValue("bsed", (String)rsMap.get("bsed"));
                    option.setVariableValue("bsled", (String)rsMap.get("bsled"));
                    option.setVariableValue(CALLBACK_INVOKE, "true");
                    option.setVariableValue("batchop_batchsize", String.valueOf(500));
                    this.getView().invokeOperation("donothing_bsedtrans", option);
                }
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        CommonBaseDataFilterColumn filterColumn;
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        if (commonFilterColumns != null && !commonFilterColumns.isEmpty() && (filterColumn = (CommonBaseDataFilterColumn)commonFilterColumns.get(0)).getFieldName().equals("salaryfile.org.name")) {
            filterColumn.setDefaultValue("");
        }
        this.setFastFilterDefautValue(args);
    }

    private void setFastFilterDefautValue(FilterContainerInitArgs args) {
        String filterIdListStr = this.getView().getPageCache().get("filterIdList");
        if (SWCStringUtils.isEmpty((String)filterIdListStr)) {
            return;
        }
        List filterIdList = null;
        try {
            filterIdList = (List)JSONUtils.cast((String)filterIdListStr, List.class);
        }
        catch (IOException ioException) {
            log.error("filterIdList\u53cd\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)ioException);
        }
        SWCDataServiceHelper dataHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        QFilter filter = new QFilter("id", "in", (Object)filterIdList);
        DynamicObjectCollection bizDataColl = dataHelper.queryOriginalCollection("identifynumber", new QFilter[]{filter});
        if (bizDataColl == null || bizDataColl.size() == 0) {
            return;
        }
        List fastFilterColumns = args.getFastFilterColumns();
        Set identifyNumSet = bizDataColl.stream().map(obj -> obj.getString("identifynumber")).collect(Collectors.toSet());
        for (FilterColumn filterColumn : fastFilterColumns) {
            if (!"identifynumber".equals(filterColumn.getFieldName())) continue;
            filterColumn.setDefaultValues(identifyNumSet.toArray());
        }
    }

    public void setFilter(SetFilterEvent event) {
        HasPermOrgResult hasPermOrgResult;
        String filterIdListStr = this.getView().getPageCache().get("filterIdList");
        if (SWCStringUtils.isNotEmpty((String)filterIdListStr)) {
            event.getQFilters().clear();
            this.getPageCache().put("filterIdList", null);
            List filterIdList = null;
            try {
                filterIdList = (List)JSONUtils.cast((String)filterIdListStr, List.class);
            }
            catch (IOException ioException) {
                log.error("filterIdList setFilter fail {}", (Object)ioException.getMessage(), (Object)ioException);
            }
            if (CollectionUtils.isNotEmpty((Collection)filterIdList)) {
                event.getQFilters().add(new QFilter("id", "in", (Object)filterIdList));
            }
            return;
        }
        List qFilterList = event.getQFilters();
        Iterator iterator = qFilterList.iterator();
        QFilter newFilter = null;
        BizDataHelper helper = new BizDataHelper();
        while (iterator.hasNext()) {
            QFilter filter = (QFilter)iterator.next();
            if (filter == null) continue;
            String propertyName = filter.getProperty();
            Boolean isRecur = Boolean.TRUE;
            if (!SWCStringUtils.equals((String)"monthandyearoption", (String)propertyName)) continue;
            newFilter = helper.buildMonthAndYearsFilter(filter.getValue(), isRecur);
            iterator.remove();
        }
        if (newFilter != null) {
            qFilterList.add(newFilter);
        }
        if (!(hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_recurbizdata", (String)"47150e89000000ac")).hasAllOrgPerm()) {
            qFilterList.add(new QFilter("salaryfile.org", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
    }

    private void rejectCloseCalbackEvent(Map<String, String> rsMap, OperateOption option) {
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATA_CACHE_KEY);
        String pageId = this.getView().getPageId();
        List rejectIdList = (List)appCache.get("rejectIdList_" + pageId, ArrayList.class);
        SWCDataServiceHelper recurHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        QFilter filter = new QFilter("id", "in", (Object)rejectIdList);
        DynamicObject[] recurBizDatas = recurHelper.query("id,identifynumber,auditstatus,datasources,usagecount", new QFilter[]{filter});
        ArrayList<String> rejectFailList = new ArrayList<String>(recurBizDatas.length);
        for (DynamicObject recurBizData : recurBizDatas) {
            String auditStatus = recurBizData.getString("auditstatus");
            String dataSources = recurBizData.getString("datasources");
            int usageCount = recurBizData.getInt("usagecount");
            if (SWCStringUtils.equals((String)auditStatus, (String)"C") && SWCStringUtils.equals((String)dataSources, (String)"3") && usageCount == 0) continue;
            String bizDataCode = recurBizData.getString("identifynumber");
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u8bf7\u9009\u62e9\u6570\u636e\u6765\u6e90\u4e3a\u201c\u524d\u7aef\u63d0\u62a5\u201d\u4e14\u4f7f\u7528\u6b21\u6570=0\uff0c\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u7684\u6570\u636e\u3002", (String)"RecurBizDataListPlugin_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]), bizDataCode);
            rejectFailList.add(errorMsg);
        }
        Set<String> recoverFailBizDataCodeSet = this.getUnCoverBizDataCode(rejectIdList);
        if (recoverFailBizDataCodeSet != null && recoverFailBizDataCodeSet.size() > 0) {
            appCache.put("recoverFailBizDataCodeSet_" + pageId, recoverFailBizDataCodeSet);
        }
        if (rejectFailList.size() == 0 && (recoverFailBizDataCodeSet == null || recoverFailBizDataCodeSet.size() == 0)) {
            option.setVariableValue("opreason", rsMap.get("opreason"));
            option.setVariableValue("pageId", pageId);
            this.getView().invokeOperation("donothing_reject", option);
            return;
        }
        int totalCount = rejectIdList.size();
        int failCount = rejectFailList.size();
        if (totalCount == 1 && failCount == 1) {
            option.setVariableValue("opreason", rsMap.get("opreason"));
            option.setVariableValue("pageId", pageId);
            this.getView().invokeOperation("donothing_reject", option);
            return;
        }
        String rejectInfo = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u9a73\u56de\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"RecurBizDataListPlugin_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]), totalCount, totalCount - failCount, failCount);
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("hsas_bizdatarejectfail");
        parameters.setShowTitle(false);
        parameters.setCustomParam("rejectInfo", (Object)rejectInfo);
        parameters.setCustomParam("pageId", (Object)pageId);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int len = rejectFailList.size();
        for (int index = 0; index < 5 && index < len; ++index) {
            buf.append((String)rejectFailList.get(index)).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)(rejectFailList.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        parameters.setCustomParam("failList", rejectFailList);
        parameters.setCustomParam("failCount", (Object)failCount);
        this.getView().showForm(parameters);
        option.setVariableValue("opreason", rsMap.get("opreason"));
        option.setVariableValue("pageId", pageId);
        this.getView().invokeOperation("donothing_reject", option);
    }

    private Set<String> getUnCoverBizDataCode(List<Long> rejectIdList) {
        HashSet<String> retSet = new HashSet<String>(rejectIdList.size());
        SWCDataServiceHelper recurBizHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        QFilter filter = new QFilter("id", "in", rejectIdList);
        DynamicObject[] queryDatas = recurBizHelper.query("identifynumber", new QFilter[]{filter});
        if (queryDatas == null || queryDatas.length == 0) {
            return retSet;
        }
        HashSet<String> bizDataCodeSet = new HashSet<String>(queryDatas.length);
        for (DynamicObject queryData : queryDatas) {
            bizDataCodeSet.add(queryData.getString("identifynumber"));
        }
        BizDataHelper helper = new BizDataHelper();
        QFilter effectFilter = new QFilter("opbizdatacode", "in", bizDataCodeSet);
        effectFilter.and("isabandon", "!=", (Object)"1");
        List effectBizDataList = helper.queryEffectOrAffectedBizDatas(effectFilter, true);
        if (effectBizDataList == null || effectBizDataList.size() == 0) {
            return retSet;
        }
        HashSet<String> allEffectCodeSet = new HashSet<String>(effectBizDataList.size());
        for (DynamicObject effectBizDataObj : effectBizDataList) {
            allEffectCodeSet.add(effectBizDataObj.getString("bizdatacode"));
        }
        QFilter affectedFilter = new QFilter("bizdatacode", "in", bizDataCodeSet);
        affectedFilter.and("isabandon", "!=", (Object)"1");
        List affectedBizDataList = helper.queryEffectOrAffectedBizDatas(affectedFilter, false);
        BizDataRecoverBsledService recoverService = new BizDataRecoverBsledService();
        Set recoverBizDataCodeSet = recoverService.filterUnCoverBizDatas(effectBizDataList, affectedBizDataList);
        if (recoverBizDataCodeSet == null || recoverBizDataCodeSet.size() == 0) {
            return allEffectCodeSet;
        }
        recoverService.filterLastBizDataByStatus(recoverBizDataCodeSet);
        if (recoverBizDataCodeSet == null || recoverBizDataCodeSet.size() == 0) {
            return allEffectCodeSet;
        }
        QFilter recurFilter = new QFilter("identifynumber", "in", (Object)recoverBizDataCodeSet);
        recurFilter.and("auditstatus", "=", (Object)"C");
        DynamicObject[] recurBizDatas = recurBizHelper.query("identifynumber", new QFilter[]{recurFilter});
        if (recurBizDatas == null || recurBizDatas.length == 0) {
            return allEffectCodeSet;
        }
        HashSet<String> passBizDataCodeSet = new HashSet<String>(recurBizDatas.length);
        for (DynamicObject recurBizData : recurBizDatas) {
            passBizDataCodeSet.add(recurBizData.getString("identifynumber"));
        }
        allEffectCodeSet.removeAll(passBizDataCodeSet);
        retSet = allEffectCodeSet;
        return retSet;
    }

    private void rejectDonothigEvent(Map<String, String> rsMap, OperateOption option) {
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATA_CACHE_KEY);
        String pageId = this.getView().getPageId();
        List rejectIdList = (List)appCache.get("rejectIdList_" + pageId, ArrayList.class);
        if (rejectIdList == null || rejectIdList.size() == 0) {
            return;
        }
        SWCDataServiceHelper recurBizHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        QFilter recurFilter = new QFilter("id", "in", (Object)rejectIdList);
        recurFilter.and("auditstatus", "=", (Object)"C");
        recurFilter.and("datasources", "in", (Object)new String[]{"3"});
        recurFilter.and("usagecount", "<=", (Object)0);
        DynamicObject[] recurBizDatas = recurBizHelper.query("identifynumber", new QFilter[]{recurFilter});
        if (recurBizDatas == null || recurBizDatas.length == 0) {
            return;
        }
        HashSet<String> rejectBizDataCodeSet = new HashSet<String>(recurBizDatas.length);
        for (DynamicObject recurBizData : recurBizDatas) {
            rejectBizDataCodeSet.add(recurBizData.getString("identifynumber"));
        }
        if (rejectBizDataCodeSet == null || rejectBizDataCodeSet.size() == 0) {
            return;
        }
        BizDataHelper bizDataHelper = new BizDataHelper();
        QFilter effectFilter = new QFilter("opbizdatacode", "in", rejectBizDataCodeSet);
        effectFilter.and("isabandon", "!=", (Object)"1");
        List effectBizDataList = bizDataHelper.queryEffectOrAffectedBizDatas(effectFilter, true);
        if (effectBizDataList == null || effectBizDataList.size() == 0) {
            option.setVariableValue("opreason", rsMap.get("opreason"));
            option.setVariableValue("pageId", pageId);
            this.getView().invokeOperation("donothing_reject", option);
            return;
        }
        HashSet<String> needUpdateBizDataCodeSet = new HashSet<String>(effectBizDataList.size());
        HashMap<String, String> effectMap = new HashMap<String, String>(effectBizDataList.size());
        for (DynamicObject effectBizDataObj : effectBizDataList) {
            String needUpdateBizDataCode = effectBizDataObj.getString("bizdatacode");
            effectMap.put(effectBizDataObj.getString("opbizdatacode"), needUpdateBizDataCode);
            needUpdateBizDataCodeSet.add(needUpdateBizDataCode);
        }
        QFilter affectedFilter = new QFilter("bizdatacode", "in", rejectBizDataCodeSet);
        affectedFilter.and("isabandon", "!=", (Object)"1");
        List affectedBizDataList = bizDataHelper.queryEffectOrAffectedBizDatas(affectedFilter, false);
        QFilter updateCheckFilter = new QFilter("bizdatacode", "in", needUpdateBizDataCodeSet);
        HashSet<String> opTypeSet = new HashSet<String>(3);
        opTypeSet.add(BizDataOperateEnum.OPERATE_UPDATE.getCode());
        opTypeSet.add(BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode());
        opTypeSet.add(BizDataOperateEnum.OPERATE_ITF_UPDATE.getCode());
        updateCheckFilter.and("optype", "in", opTypeSet);
        updateCheckFilter.and("isabandon", "!=", (Object)"1");
        List updateCheckBizDataList = bizDataHelper.queryEffectOrAffectedBizDatas(updateCheckFilter, false);
        ArrayList<Object> unCoverBizDataCodeList = new ArrayList<Object>(affectedBizDataList.size());
        for (DynamicObject affectedBizDataObj : affectedBizDataList) {
            String bizDataCode = affectedBizDataObj.getString("bizdatacode");
            DynamicObject[] unCoverBizDataCode = (DynamicObject[])effectMap.get(bizDataCode);
            if (!SWCStringUtils.isNotEmpty((String)unCoverBizDataCode)) continue;
            unCoverBizDataCodeList.add(unCoverBizDataCode);
        }
        if (updateCheckBizDataList != null && updateCheckBizDataList.size() > 0) {
            for (DynamicObject updateCheckBizData : updateCheckBizDataList) {
                unCoverBizDataCodeList.add(updateCheckBizData.getString("bizdatacode"));
            }
        }
        QFilter recurBizFilter = new QFilter("identifynumber", "in", unCoverBizDataCodeList);
        recurBizFilter.and("auditstatus", "=", (Object)"C");
        DynamicObject[] unCoverBizDatas = bizDataHelper.getBizDataColl(recurBizHelper, recurBizFilter);
        if (unCoverBizDatas == null || unCoverBizDatas.length == 0) {
            option.setVariableValue("opreason", rsMap.get("opreason"));
            option.setVariableValue("pageId", pageId);
            this.getView().invokeOperation("donothing_reject", option);
            return;
        }
        JSONArray rejectParamArray = new JSONArray();
        for (DynamicObject unCoverBizData : unCoverBizDatas) {
            Long salaryFileId = unCoverBizData.getLong("salaryfile.id");
            Long bizItemId = unCoverBizData.getLong("bizitem.id");
            String bizDataCode = unCoverBizData.getString("identifynumber");
            String dataValue = unCoverBizData.getString("datavalue");
            Long currencyId = unCoverBizData.getLong("currency.id");
            Date bsed = unCoverBizData.getDate("bsed");
            Date bsled = unCoverBizData.getDate("bsled");
            Long frequencyId = unCoverBizData.getLong("frequency.id");
            String description = unCoverBizData.getString("description");
            String auditStatus = unCoverBizData.getString("auditstatus");
            JSONObject auditParamObj = new JSONObject();
            auditParamObj.put("salaryFileId", (Object)salaryFileId);
            auditParamObj.put("bizItemId", (Object)bizItemId);
            auditParamObj.put("bizDataCode", (Object)bizDataCode);
            auditParamObj.put("dataValue", (Object)dataValue);
            auditParamObj.put("currencyId", (Object)currencyId);
            auditParamObj.put("bsed", (Object)bsed);
            auditParamObj.put("beforeBsled", (Object)bsled);
            auditParamObj.put("frequencyId", (Object)frequencyId);
            auditParamObj.put("description", (Object)description);
            auditParamObj.put("auditStatus", (Object)auditStatus);
            rejectParamArray.add((Object)auditParamObj);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_bizdataauditconfirm");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"RecurBizDataListPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALBACK_REJECT));
        showParameter.setCustomParam("rejectParamArray", (Object)rejectParamArray);
        showParameter.setCustomParam("auditType", (Object)"reject");
        showParameter.setCustomParam("opreason", (Object)rsMap.get("opreason"));
        this.getView().showForm(showParameter);
    }

    private void auditCloseCalBackEvent() {
        SWCPageCache cache = new SWCPageCache(this.getView());
        List auditBizDataIdList = (List)cache.get("auditBizDataIdList", ArrayList.class);
        if (auditBizDataIdList == null || auditBizDataIdList.size() == 0) {
            return;
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        BizDataHelper helper = new BizDataHelper();
        Map bizDataIdAndBizDataCodeRel = (Map)cache.get("bizDataIdAndBizDataCodeRel", Map.class);
        if (bizDataIdAndBizDataCodeRel == null || bizDataIdAndBizDataCodeRel.size() == 0) {
            return;
        }
        HashSet bizDataCodeSet = new HashSet(bizDataIdAndBizDataCodeRel.size());
        for (Map.Entry entry : bizDataIdAndBizDataCodeRel.entrySet()) {
            bizDataCodeSet.add(entry.getValue());
        }
        QFilter bizDataCodeFilter = new QFilter("identifynumber", "in", bizDataCodeSet);
        DynamicObject[] bizDataCodeColl = helper.getBizDataColl(serviceHelper, bizDataCodeFilter);
        if (bizDataCodeColl == null || bizDataCodeColl.length == 0) {
            ArrayList<String> failList = new ArrayList<String>(bizDataCodeSet.size());
            for (String bizDataCode : bizDataCodeSet) {
                String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u6570\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)"RecurBizDataListPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]), bizDataCode);
                failList.add(msg);
            }
            if (failList.size() == 1) {
                this.getView().showTipNotification((String)failList.get(0));
            } else {
                FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter(null, null, failList);
                this.getView().showForm(parameters);
            }
            return;
        }
        if (bizDataCodeColl.length != bizDataCodeSet.size()) {
            HashSet<String> queryBizDataCode = new HashSet<String>(bizDataCodeColl.length);
            for (DynamicObject bizDataCodeObj : bizDataCodeColl) {
                String bizDataCode = bizDataCodeObj.getString("identifynumber");
                queryBizDataCode.add(bizDataCode);
            }
            ArrayList<String> failList = new ArrayList<String>(bizDataCodeSet.size());
            for (String bizDataCode : bizDataCodeSet) {
                if (queryBizDataCode.contains(bizDataCode)) continue;
                String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u6570\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)"RecurBizDataListPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]), bizDataCode);
                failList.add(msg);
            }
            if (failList.size() == 1) {
                this.getView().showTipNotification((String)failList.get(0));
            } else {
                FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter(null, null, failList);
                this.getView().showForm(parameters);
            }
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)auditBizDataIdList);
        DynamicObject[] bizDataColl = helper.getBizDataColl(serviceHelper, filter);
        ArrayList<String> cacheBizDataList = new ArrayList<String>(10);
        for (DynamicObject bizDataObj : bizDataColl) {
            String bizDataCode = bizDataObj.getString("identifynumber");
            String auditStatus = bizDataObj.getString("auditstatus");
            if (SWCStringUtils.equals((String)auditStatus, (String)"B")) continue;
            cacheBizDataList.add(bizDataCode);
        }
        if (cacheBizDataList.size() == 1) {
            String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u6570\u636e\u72b6\u6001\u4e0d\u662f\u201c\u5df2\u63d0\u4ea4\u201d\uff0c\u5bf9\u5e94\u5173\u8054\u6570\u636e\u7684\u5931\u6548\u65e5\u671f\u4e0d\u505a\u66f4\u65b0\u3002", (String)"RecurBizDataListPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), cacheBizDataList.get(0));
            this.getView().showTipNotification(msg);
            return;
        }
        if (cacheBizDataList.size() > 1) {
            ArrayList<String> errorMsg = new ArrayList<String>(10);
            for (String bizDataCode : cacheBizDataList) {
                String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u6570\u636e\u72b6\u6001\u4e0d\u662f\u201c\u5df2\u63d0\u4ea4\u201d\uff0c\u5bf9\u5e94\u5173\u8054\u6570\u636e\u7684\u5931\u6548\u65e5\u671f\u4e0d\u505a\u66f4\u65b0\u3002", (String)"RecurBizDataListPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), bizDataCode);
                errorMsg.add(msg);
            }
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter(null, null, errorMsg);
            this.getView().showForm(parameters);
            return;
        }
        List<DynamicObject> auditBizDataList = Arrays.asList(bizDataColl);
        helper.sortListData(auditBizDataList);
        List samePersonSameItemBizList = helper.getSamePersonSameItemBizDatas(auditBizDataList);
        if (samePersonSameItemBizList.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5ba1\u6838\u65f6\uff0c\u540c\u4e00\u85aa\u8d44\u6863\u6848\u540c\u4e00\u5faa\u73af\u9879\u76ee\u8bf7\u6bcf\u6b21\u53ea\u9009\u62e9\u4e00\u6761\u6570\u636e\uff0c\u6839\u636e\u751f\u6548\u65e5\u671f\u7531\u65e9\u5230\u665a\u4f9d\u6b21\u8fdb\u884c\u5ba1\u6838\u3002", (String)"RecurBizDataListPlugin_01", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().invokeOperation("audit");
    }

    private void unAuditCloseCalBackEvent() {
        SWCPageCache cache = new SWCPageCache(this.getView());
        List unAuditBizDataIdList = (List)cache.get("unAuditBizDataIdList", ArrayList.class);
        if (unAuditBizDataIdList == null || unAuditBizDataIdList.size() == 0) {
            return;
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        BizDataHelper helper = new BizDataHelper();
        Map bizDataIdAndBizDataCodeRel = (Map)cache.get("bizDataIdAndBizDataCodeRel", Map.class);
        if (bizDataIdAndBizDataCodeRel == null || bizDataIdAndBizDataCodeRel.size() == 0) {
            return;
        }
        HashSet bizDataCodeSet = new HashSet(bizDataIdAndBizDataCodeRel.size());
        for (Map.Entry entry : bizDataIdAndBizDataCodeRel.entrySet()) {
            bizDataCodeSet.add(entry.getValue());
        }
        QFilter bizDataCodeFilter = new QFilter("identifynumber", "in", bizDataCodeSet);
        DynamicObject[] bizDataCodeColl = helper.getBizDataColl(serviceHelper, bizDataCodeFilter);
        if (bizDataCodeColl == null || bizDataCodeColl.length == 0) {
            ArrayList<String> failList = new ArrayList<String>(bizDataCodeSet.size());
            for (String bizDataCode : bizDataCodeSet) {
                String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u6570\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)"RecurBizDataListPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]), bizDataCode);
                failList.add(msg);
            }
            if (failList.size() == 1) {
                this.getView().showTipNotification((String)failList.get(0));
            } else {
                FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter(null, null, failList);
                this.getView().showForm(parameters);
            }
            return;
        }
        if (bizDataCodeColl.length != bizDataCodeSet.size()) {
            HashSet<String> queryBizDataCode = new HashSet<String>(bizDataCodeColl.length);
            for (DynamicObject bizDataCodeObj : bizDataCodeColl) {
                String bizDataCode = bizDataCodeObj.getString("identifynumber");
                queryBizDataCode.add(bizDataCode);
            }
            ArrayList<String> failList = new ArrayList<String>(bizDataCodeSet.size());
            for (String bizDataCode : bizDataCodeSet) {
                if (queryBizDataCode.contains(bizDataCode)) continue;
                String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u6570\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)"RecurBizDataListPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]), bizDataCode);
                failList.add(msg);
            }
            if (failList.size() == 1) {
                this.getView().showTipNotification((String)failList.get(0));
            } else {
                FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter(null, null, failList);
                this.getView().showForm(parameters);
            }
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)unAuditBizDataIdList);
        DynamicObject[] bizDataColl = helper.getBizDataColl(serviceHelper, filter);
        ArrayList<String> cacheBizDataList = new ArrayList<String>(10);
        for (DynamicObject bizDataObj : bizDataColl) {
            String bizDataCode = bizDataObj.getString("identifynumber");
            String auditStatus = bizDataObj.getString("auditstatus");
            String dataSources = bizDataObj.getString("datasources");
            if (SWCStringUtils.equals((String)auditStatus, (String)"C") && SWCStringUtils.equals((String)dataSources, (String)"1")) continue;
            cacheBizDataList.add(bizDataCode);
        }
        if (cacheBizDataList.size() == 1) {
            String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u6570\u636e\u72b6\u6001\u9700\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u4e14\u6570\u636e\u6765\u6e90\u9700\u4e3a\u201c\u624b\u5de5\u65b0\u589e\u201d\u3002", (String)"RecurBizDataListPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]), cacheBizDataList.get(0));
            this.getView().showTipNotification(msg);
            return;
        }
        if (cacheBizDataList.size() > 1) {
            ArrayList<String> errorMsg = new ArrayList<String>(10);
            for (String bizDataCode : cacheBizDataList) {
                String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u6570\u636e\u72b6\u6001\u9700\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u4e14\u6570\u636e\u6765\u6e90\u9700\u4e3a\u201c\u624b\u5de5\u65b0\u589e\u201d\u3002", (String)"RecurBizDataListPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]), bizDataCode);
                errorMsg.add(msg);
            }
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter(null, null, errorMsg);
            this.getView().showForm(parameters);
            return;
        }
        this.getView().invokeOperation("unaudit");
    }

    private void doReject() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows.size() > 5000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u64cd\u4f5c\u7684\u6570\u636e\u91cf\u8bf7\u52ff\u8d85\u8fc75000\u6761\u3002", (String)"RecurBizDataListPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        BizDataHelper bizDataHelper = new BizDataHelper();
        SWCDataServiceHelper recurHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        List rejectIdList = bizDataHelper.filterRejectIdList(selectedRows, recurHelper);
        if (rejectIdList.size() == 0 || rejectIdList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u6765\u6e90\u4e3a\u201c\u524d\u7aef\u63d0\u62a5\u201d\uff0c\u4f7f\u7528\u6b21\u6570\u4e3a0\uff0c\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u7684\u6570\u636e\u3002", (String)"BizDataTplListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATA_CACHE_KEY);
        appCache.put("rejectIdList_" + this.getView().getPageId(), (Object)rejectIdList);
        int rejectCount = rejectIdList.size();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_bizdataopconfirm");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("rejectCount", (Object)rejectCount);
        showParameter.setCustomParam("totalCount", (Object)selectedRows.size());
        showParameter.setCustomParam("operate", (Object)"reject");
        StyleCss css = new StyleCss();
        css.setWidth("870px");
        css.setHeight("534px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"RecurBizDataListPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "donothing_reject"));
        this.getView().showForm(showParameter);
    }

    private void doUpdateBsled() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        ArrayList<Long> bizDataIdList = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            bizDataIdList.add((Long)row.getPrimaryKeyValue());
        }
        SWCDataServiceHelper recurHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        QFilter filter = new QFilter("id", "in", bizDataIdList);
        DynamicObject[] dynamicObjects = this.filterUpdateBsledStatus(recurHelper, filter);
        if (dynamicObjects.length != selectedRows.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u7684\u6570\u636e\u66f4\u65b0\u5931\u6548\u65e5\u671f\u3002", (String)"BizDataTplListPlugin_06", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_bizdataopconfirm");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("460px");
        css.setHeight("310px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCustomParam("operate", (Object)"updatebsled");
        showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5931\u6548\u65e5\u671f", (String)"BizDataTplListPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "donothing_updatebsled"));
        this.getView().showForm(showParameter);
    }

    private void doAudit(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        ArrayList<Long> auditBizDataIdList = new ArrayList<Long>(listSelectedData.size());
        for (ListSelectedRow row : listSelectedData) {
            auditBizDataIdList.add((Long)row.getPrimaryKeyValue());
        }
        BizDataHelper helper = new BizDataHelper();
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        QFilter delFilter = new QFilter("id", "in", auditBizDataIdList);
        DynamicObject[] delBizDataColl = helper.getBizDataColl(serviceHelper, delFilter);
        if (delBizDataColl.length != auditBizDataIdList.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"RecurBizDataListPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        SWCPageCache cache = new SWCPageCache(this.getView());
        cache.put("auditBizDataIdList", auditBizDataIdList);
        QFilter filter = new QFilter("id", "in", auditBizDataIdList);
        filter.and("auditstatus", "=", (Object)"B");
        DynamicObject[] bizDataColl = helper.getBizDataColl(serviceHelper, filter);
        if (bizDataColl.length != auditBizDataIdList.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5df2\u63d0\u4ea4\u201d\u72b6\u6001\u7684\u6570\u636e\u3002", (String)"RecurBizDataListPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<Long, String> bizDataIdAndBizDataCodeRel = new HashMap<Long, String>(auditBizDataIdList.size());
        for (DynamicObject bizDataObj : bizDataColl) {
            Long bizDataId = bizDataObj.getLong("id");
            String bizDataCode = bizDataObj.getString("identifynumber");
            bizDataIdAndBizDataCodeRel.put(bizDataId, bizDataCode);
        }
        cache.put("bizDataIdAndBizDataCodeRel", bizDataIdAndBizDataCodeRel);
        List<DynamicObject> auditBizDataList = Arrays.asList(bizDataColl);
        helper.sortListData(auditBizDataList);
        List samePersonSameItemBizList = helper.getSamePersonSameItemBizDatas(auditBizDataList);
        if (samePersonSameItemBizList.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5ba1\u6838\u65f6\uff0c\u540c\u4e00\u85aa\u8d44\u6863\u6848\u540c\u4e00\u5faa\u73af\u9879\u76ee\u8bf7\u6bcf\u6b21\u53ea\u9009\u62e9\u4e00\u6761\u6570\u636e\uff0c\u6839\u636e\u751f\u6548\u65e5\u671f\u7531\u65e9\u5230\u665a\u4f9d\u6b21\u8fdb\u884c\u5ba1\u6838\u3002", (String)"RecurBizDataListPlugin_01", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        int size = auditBizDataList.size();
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(size);
        HashSet<Object> bizItemIdSet = new HashSet<Object>(size);
        for (DynamicObject obj : auditBizDataList) {
            Long salaryFileId = obj.getLong("salaryfile.id");
            salaryFileIdSet.add(salaryFileId);
            Long bizItemId = obj.getLong("bizitem.id");
            bizItemIdSet.add(bizItemId);
        }
        BizDataHelper bizDataHelper = new BizDataHelper();
        Table oldRecurBizData = bizDataHelper.getRecurBizData(salaryFileIdSet, bizItemIdSet);
        ArrayList<String> errorMsgList = new ArrayList<String>(auditBizDataList.size());
        for (DynamicObject dynamicObject : auditBizDataList) {
            this.checkRecurbizUpdateBsled(errorMsgList, dynamicObject, (Table<Long, Long, List<DynamicObject>>)oldRecurBizData);
        }
        if (errorMsgList.size() > 0) {
            if (errorMsgList.size() == 1) {
                this.getView().showErrorNotification((String)errorMsgList.get(0));
            } else {
                FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter(null, null, errorMsgList);
                this.getView().showForm(parameters);
            }
            return;
        }
        HashMap<String, Date> bizDataBsledDateMap = new HashMap<String, Date>(16);
        if (oldRecurBizData != null && oldRecurBizData.size() > 0) {
            for (Object salaryFileId : oldRecurBizData.rowKeySet()) {
                for (Long bizItemId : oldRecurBizData.columnKeySet()) {
                    List oldBizDataList = (List)oldRecurBizData.get(salaryFileId, (Object)bizItemId);
                    if (oldBizDataList == null || oldBizDataList.size() == 0) continue;
                    for (DynamicObject oldBizDataObj : oldBizDataList) {
                        String oldBizDataCode = oldBizDataObj.getString("identifynumber");
                        Long oldBizItemId = oldBizDataObj.getLong("bizitem.id");
                        Date oldBsled = oldBizDataObj.getDate("bsled");
                        if (oldBsled == null) continue;
                        bizDataBsledDateMap.put(oldBizDataCode + '#' + oldBizItemId, oldBsled);
                    }
                }
            }
        }
        ArrayList arrayList = new ArrayList(10);
        for (DynamicObject dynamicObject : auditBizDataList) {
            List updateList = bizDataHelper.dealNeedUpdateBsledData(oldRecurBizData, dynamicObject);
            if (updateList == null || updateList.size() <= 0) continue;
            arrayList.addAll(updateList);
        }
        if (arrayList != null && arrayList.size() > 0) {
            JSONArray auditParamArray = new JSONArray();
            for (DynamicObject needUpdateObj : arrayList) {
                Long salaryFileId = needUpdateObj.getLong("salaryfile.id");
                Long bizItemId = needUpdateObj.getLong("bizitem.id");
                String bizDataCode = needUpdateObj.getString("identifynumber");
                String dataValue = needUpdateObj.getString("datavalue");
                Long currencyId = needUpdateObj.getLong("currency.id");
                Date bsed = needUpdateObj.getDate("bsed");
                Date beforeBsled = (Date)bizDataBsledDateMap.get(bizDataCode + '#' + bizItemId);
                Date afterBsled = needUpdateObj.getDate("bsled");
                Long frequencyId = needUpdateObj.getLong("frequency.id");
                String description = needUpdateObj.getString("description");
                String auditStatus = needUpdateObj.getString("auditstatus");
                JSONObject auditParamObj = new JSONObject();
                auditParamObj.put("salaryFileId", (Object)salaryFileId);
                auditParamObj.put("bizItemId", (Object)bizItemId);
                auditParamObj.put("bizDataCode", (Object)bizDataCode);
                auditParamObj.put("dataValue", (Object)dataValue);
                auditParamObj.put("currencyId", (Object)currencyId);
                auditParamObj.put("bsed", (Object)bsed);
                auditParamObj.put("beforeBsled", (Object)beforeBsled);
                auditParamObj.put("afterBsled", (Object)afterBsled);
                auditParamObj.put("frequencyId", (Object)frequencyId);
                auditParamObj.put("description", (Object)description);
                auditParamObj.put("auditStatus", (Object)auditStatus);
                auditParamArray.add((Object)auditParamObj);
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("hsas_bizdataauditconfirm");
            SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)formShowParameter);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"RecurBizDataListPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALBACK_AUDIT));
            formShowParameter.setCustomParam("auditParamArray", (Object)auditParamArray);
            formShowParameter.setCustomParam("auditType", (Object)"audit");
            this.getView().showForm(formShowParameter);
        } else {
            this.getView().invokeOperation("audit");
        }
    }

    private void doUnAudit(BeforeDoOperationEventArgs args) {
        DynamicObject[] bizDataCode;
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        ArrayList<Long> auditBizDataIdList = new ArrayList<Long>(listSelectedData.size());
        for (ListSelectedRow row : listSelectedData) {
            auditBizDataIdList.add((Long)row.getPrimaryKeyValue());
        }
        BizDataHelper helper = new BizDataHelper();
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        QFilter delFilter = new QFilter("id", "in", auditBizDataIdList);
        DynamicObject[] delBizDataColl = helper.getBizDataColl(serviceHelper, delFilter);
        if (delBizDataColl.length != auditBizDataIdList.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"RecurBizDataListPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        SWCPageCache cache = new SWCPageCache(this.getView());
        cache.put("unAuditBizDataIdList", auditBizDataIdList);
        QFilter filter = new QFilter("id", "in", auditBizDataIdList);
        filter.and("auditstatus", "=", (Object)"C");
        filter.and("datasources", "=", (Object)"1");
        DynamicObject[] bizDataColl = helper.getBizDataColl(serviceHelper, filter);
        if (bizDataColl.length != auditBizDataIdList.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u6570\u636e\u6765\u6e90\u4e3a\u201c\u624b\u5de5\u65b0\u589e\u201d\u7684\u6570\u636e\u3002", (String)"RecurBizDataListPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<Long, DynamicObject[]> bizDataIdAndBizDataCodeRel = new HashMap<Long, DynamicObject[]>(auditBizDataIdList.size());
        for (DynamicObject bizDataObj : bizDataColl) {
            Long bizDataId = bizDataObj.getLong("id");
            bizDataCode = bizDataObj.getString("identifynumber");
            bizDataIdAndBizDataCodeRel.put(bizDataId, bizDataCode);
        }
        cache.put("bizDataIdAndBizDataCodeRel", bizDataIdAndBizDataCodeRel);
        ArrayList<DynamicObject[]> bizDataCodeList = new ArrayList<DynamicObject[]>(auditBizDataIdList.size());
        for (DynamicObject bizDataObj : bizDataColl) {
            bizDataCode = bizDataObj.getString("identifynumber");
            bizDataCodeList.add(bizDataCode);
        }
        SWCDataServiceHelper bsledHelper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");
        QFilter bsledFilter = new QFilter("opbizdatacode", "in", bizDataCodeList);
        bsledFilter.and("isabandon", "!=", (Object)"1");
        bsledFilter.and(QFilter.sqlExpress((String)"opbizdatacode", (String)"!=", (String)"fbizdatacode"));
        DynamicObject[] bsledDatas = bsledHelper.query("bizdatacode", new QFilter[]{bsledFilter});
        if (bsledDatas == null || bsledDatas.length == 0) {
            this.getView().invokeOperation("unaudit");
            return;
        }
        ArrayList<String> bsledDataCodeList = new ArrayList<String>(bsledDatas.length);
        for (DynamicObject bizDataObj : bsledDatas) {
            bsledDataCodeList.add(bizDataObj.getString("bizdatacode"));
        }
        SWCDataServiceHelper recurBizHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        QFilter recurBizFilter = new QFilter("identifynumber", "in", bsledDataCodeList);
        recurBizFilter.and("auditstatus", "=", (Object)"C");
        DynamicObject[] recurBizDatas = helper.getBizDataColl(recurBizHelper, recurBizFilter);
        if (recurBizDatas == null || recurBizDatas.length == 0) {
            this.getView().invokeOperation("unaudit");
            return;
        }
        JSONArray unAuditParamArray = new JSONArray();
        for (DynamicObject recurBizObj : recurBizDatas) {
            Long salaryFileId = recurBizObj.getLong("salaryfile.id");
            Long bizItemId = recurBizObj.getLong("bizitem.id");
            String bizDataCode2 = recurBizObj.getString("identifynumber");
            String dataValue = recurBizObj.getString("datavalue");
            Long currencyId = recurBizObj.getLong("currency.id");
            Date bsed = recurBizObj.getDate("bsed");
            Date bsled = recurBizObj.getDate("bsled");
            Long frequencyId = recurBizObj.getLong("frequency.id");
            String description = recurBizObj.getString("description");
            String auditStatus = recurBizObj.getString("auditstatus");
            JSONObject auditParamObj = new JSONObject();
            auditParamObj.put("salaryFileId", (Object)salaryFileId);
            auditParamObj.put("bizItemId", (Object)bizItemId);
            auditParamObj.put("bizDataCode", (Object)bizDataCode2);
            auditParamObj.put("dataValue", (Object)dataValue);
            auditParamObj.put("currencyId", (Object)currencyId);
            auditParamObj.put("bsed", (Object)bsed);
            auditParamObj.put("beforeBsled", (Object)bsled);
            auditParamObj.put("frequencyId", (Object)frequencyId);
            auditParamObj.put("description", (Object)description);
            auditParamObj.put("auditStatus", (Object)auditStatus);
            unAuditParamArray.add((Object)auditParamObj);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_bizdataauditconfirm");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"RecurBizDataListPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALBACK_UNAUDIT));
        showParameter.setCustomParam("unAuditParamArray", (Object)unAuditParamArray);
        showParameter.setCustomParam("auditType", (Object)"unaudit");
        this.getView().showForm(showParameter);
    }

    private void doAbandon() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List<Long> abandonIdList = this.filterAbandonIdList(selectedRows);
        if (abandonIdList.size() == 0 || abandonIdList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u7684\u6570\u636e\u3002", (String)"BizDataTplListPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATA_CACHE_KEY);
        appCache.put("abandonIdList", abandonIdList);
        int abandonCount = abandonIdList.size();
        QFilter filter = new QFilter("id", "in", abandonIdList);
        filter.and("datasources", "=", (Object)"3");
        SWCDataServiceHelper recurBizHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        DynamicObject[] recurbizDatas = recurBizHelper.query("id", new QFilter[]{filter});
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_bizdataopconfirm");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("abandonCount", (Object)abandonCount);
        showParameter.setCustomParam("totalCount", (Object)selectedRows.size());
        showParameter.setCustomParam("hpdiCount", (Object)recurbizDatas.length);
        showParameter.setCustomParam("operate", (Object)"abandon");
        StyleCss css = new StyleCss();
        css.setWidth("870px");
        css.setHeight("534px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"RecurBizDataListPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "donothing_abandon"));
        this.getView().showForm(showParameter);
    }

    private List<Long> filterAbandonIdList(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> bizDataIdList = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            bizDataIdList.add((Long)row.getPrimaryKeyValue());
        }
        QFilter filter = new QFilter("id", "in", bizDataIdList);
        filter.and("auditstatus", "=", (Object)"C");
        SWCDataServiceHelper recurHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        BizDataHelper bizDataHelper = new BizDataHelper();
        List abandonIdList = bizDataHelper.getBizDataIdList(recurHelper, filter);
        return abandonIdList;
    }

    private void doUpdateBsledConfirm(Map<String, String> rsMap) {
        String updateBsled = rsMap.get("updatebsled");
        String descriptionbsled = rsMap.get("descriptionbsled");
        Date updateBsledDate = null;
        try {
            updateBsledDate = SWCDateTimeUtils.parseDate((String)updateBsled);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Set<Long> updateBsledIdList = this.filterUpdateBsledIdList(selectedRows, updateBsledDate);
        if (updateBsledIdList.size() == 0 || updateBsledIdList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5747\u4e0d\u53ef\u66f4\u65b0\uff1a\u5931\u6548\u65e5\u671f\u65e9\u4e8e\u751f\u6548\u65e5\u671f\u6216\u66f4\u65b0\u540e\u4e0e\u5df2\u6709\u6570\u636e\u91cd\u53e0\u3002", (String)"BizDataTplListPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATA_CACHE_KEY);
        appCache.put("updateBsledIdList", updateBsledIdList);
        appCache.put("descriptionbsled", (Object)descriptionbsled);
        appCache.put("updatebsledStr", (Object)updateBsled);
        appCache.put("updatebsled", (Object)updateBsledDate);
        int updateCount = updateBsledIdList.size();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_bizdataopconfirm");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("operate", (Object)"updateBsledConfirm");
        showParameter.setCustomParam("updateCount", (Object)updateCount);
        showParameter.setCustomParam("totalCount", (Object)selectedRows.size());
        StyleCss css = new StyleCss();
        css.setWidth("460px");
        css.setHeight("310px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"BizDataTplListPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "updateBsledConfirm"));
        this.getView().showForm(showParameter);
    }

    private DynamicObject[] filterUpdateBsledStatus(SWCDataServiceHelper recurHelper, QFilter filter) {
        filter.and("auditstatus", "=", (Object)"C");
        DynamicObject[] dynamicObjects = recurHelper.query("id", new QFilter[]{filter});
        return dynamicObjects;
    }

    private Set<Long> filterUpdateBsledIdList(ListSelectedRowCollection selectedRows, Date updateBsledDate) {
        ArrayList<Long> bizDataIdList = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            bizDataIdList.add((Long)row.getPrimaryKeyValue());
        }
        QFilter filter = new QFilter("id", "in", bizDataIdList);
        SWCDataServiceHelper recurHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        BizDataHelper bizDataHelper = new BizDataHelper();
        DynamicObject[] updateBsledColl = bizDataHelper.getBizDataColl(recurHelper, filter);
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(16);
        HashSet<Long> bizItemIdSet = new HashSet<Long>(16);
        ArrayList<DynamicObject> updateBsledList = new ArrayList<DynamicObject>(10);
        for (DynamicObject updateBsledObj : updateBsledColl) {
            Date bsed = updateBsledObj.getDate("bsed");
            if (bsed.compareTo(updateBsledDate) > 0) continue;
            Long salaryFileId = updateBsledObj.getLong("salaryfile.id");
            salaryFileIdSet.add(salaryFileId);
            Long bizItemId = updateBsledObj.getLong("bizitem.id");
            bizItemIdSet.add(bizItemId);
            updateBsledList.add(updateBsledObj);
        }
        BizDataHelper helper = new BizDataHelper();
        Table failMap = helper.checkBizDateUpdateBsledFailTable(recurHelper, salaryFileIdSet, bizItemIdSet, null);
        HashSet<Long> updateSuccSet = new HashSet<Long>(16);
        for (DynamicObject updateBsledObj : updateBsledList) {
            long updateId = updateBsledObj.getLong("id");
            Long salaryFileId = updateBsledObj.getLong("salaryfile.id");
            Long bizItemId = updateBsledObj.getLong("bizitem.id");
            Date updateDataBsed = updateBsledObj.getDate("bsed");
            Set bizDataIdSet = (Set)failMap.get((Object)salaryFileId, (Object)bizItemId);
            if (updateDataBsed.compareTo(updateBsledDate) > 0 || !helper.checkUpdateBsledIsOverlap(updateId, updateBsledDate, updateDataBsed, bizDataIdSet)) continue;
            updateSuccSet.add(updateBsledObj.getLong("id"));
        }
        return updateSuccSet;
    }

    private void checkRecurbizUpdateBsled(List<String> errorMsgList, DynamicObject data, Table<Long, Long, List<DynamicObject>> recurBizData) {
        BizDataHelper bizDataHelper;
        List errorIdentifyNumList;
        String identifyNumber = data.getString("identifynumber");
        Long salaryFileId = data.getLong("salaryfile.id");
        Long bizItemId = data.getLong("bizitem.id");
        Date newBsled = data.getDate("bsled");
        Date newBsed = data.getDate("bsed");
        List dynamicObjects = (List)recurBizData.get((Object)salaryFileId, (Object)bizItemId);
        String errorMsg = null;
        if (dynamicObjects != null && dynamicObjects.size() > 0 && (errorIdentifyNumList = (bizDataHelper = new BizDataHelper()).getUpdateBsledErrorList(newBsed, newBsled, dynamicObjects, identifyNumber)).size() > 0) {
            errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5faa\u73af\u9879\u4e1a\u52a1\u6570\u636e\u751f\u5931\u6548\u65e5\u671f\u4e0e\u8be5\u6863\u6848\u5df2\u6709\u6570\u636e{0}\u91cd\u53e0\u4e14\u4e0d\u652f\u6301\u81ea\u52a8\u5904\u7406\uff08\u4ec5\u652f\u6301\u65b0\u589e\u4e1a\u52a1\u6570\u636e\u751f\u6548\u65e5\u671f\uff1e\u6700\u65b0\u6570\u636e\u751f\u6548\u65e5\u671f\uff0c\u4e14\u5931\u6548\u65e5\u671f\u2265\u6700\u65b0\u6570\u636e\u7684\u5931\u6548\u65e5\u671f\u7684\u6570\u636e\uff09\u3002", (String)"RecurBizDataListPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, errorIdentifyNumList.toString());
            errorMsgList.add(errorMsg);
        }
    }

    private void doPayRollGrpTrans(String operateKey) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List<Long> payRollGrpTransIdList = this.filterPayRollGrpTransIdList(selectedRows);
        if (payRollGrpTransIdList.size() != selectedRows.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u7684\u6570\u636e\u6309\u85aa\u8d44\u6838\u7b97\u7ec4\u8f6c\u79fb\u3002", (String)"RecurBizDataListPlugin_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> bizDataIdList = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            bizDataIdList.add((Long)row.getPrimaryKeyValue());
        }
        if (SWCStringUtils.equals((String)operateKey, (String)"donothing_directtrans")) {
            this.directTrans(bizDataIdList);
        } else {
            this.bsedTrans(bizDataIdList);
        }
    }

    private void directTrans(List<Long> bizDataIdList) {
        int len;
        SWCDataServiceHelper recurBizHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        String queryField = "salaryfile.id,salaryfile.person.id,salaryfile.employee.empnumber,bizitem.id,bizitem.name";
        QFilter filter = new QFilter("id", "in", bizDataIdList);
        DynamicObject[] bizDataColl = recurBizHelper.query(queryField, new QFilter[]{filter});
        HashSet<String> checkPersonSet = new HashSet<String>(16);
        HashSet<String> checkFailSet = new HashSet<String>(16);
        ArrayList checkFailList = new ArrayList(10);
        for (DynamicObject bizDataObj : bizDataColl) {
            Long personId = bizDataObj.getLong("salaryfile.person.id");
            Long bizItemId = bizDataObj.getLong("bizitem.id");
            String string = personId + "##" + bizItemId;
            if (checkPersonSet.contains(string)) {
                if (checkFailSet.add(string)) {
                    HashMap<String, String> checkFailMap = new HashMap<String, String>(2);
                    checkFailMap.put(bizDataObj.getString("salaryfile.employee.empnumber"), bizDataObj.getString("bizitem.name"));
                    checkFailList.add(checkFailMap);
                }
            } else {
                checkPersonSet.add(string);
            }
            if (checkFailList.size() > 3) break;
        }
        if ((len = checkFailList.size()) > 0) {
            StringBuilder sb = new StringBuilder();
            String mainErrorMsg = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8f6c\u79fb\u540c\u4e00\u4e2a\u4eba\u540c\u4e00\u9879\u76ee\u7684\u591a\u6761\u5faa\u73af\u9879\u4e1a\u52a1\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RecurBizDataListPlugin_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            sb.append(mainErrorMsg).append("\r\n");
            for (int index = 0; index < len; ++index) {
                Map errorMap = (Map)checkFailList.get(index);
                for (Map.Entry entry : errorMap.entrySet()) {
                    String errorMsg = ResManager.loadKDString((String)"\u5de5\u53f7\uff08{0}\uff09\uff0c\u4e1a\u52a1\u9879\u76ee\uff08{1}\uff09", (String)"RecurBizDataListPlugin_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    sb.append(MessageFormat.format(errorMsg, entry.getKey(), entry.getValue()));
                    if (index != len - 1) {
                        sb.append('\uff1b').append("\r\n");
                    } else {
                        sb.append('\u3002');
                    }
                    if (index != 2 || len <= 3) continue;
                    sb.append(ResManager.loadKDString((String)"\u2026\u2026\u7b49", (String)"RecurBizDataListPlugin_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    this.getView().showErrorNotification(sb.toString());
                    return;
                }
            }
            this.getView().showErrorNotification(sb.toString());
            return;
        }
        QFilter permFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_transpayrollgrp", (String)"payrollgroup");
        HasPermOrgResult hasBuResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_transpayrollgrp", (String)"47150e89000000ac");
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsas_payrollgrp", (boolean)false);
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "donothing_directtrans"));
        if (permFilter != null) {
            showParameter.getListFilterParameter().getQFilters().add(permFilter);
            log.info("query getDataRuleForBdProp is:{}", (Object)permFilter.toString());
        }
        if (!hasBuResult.hasAllOrgPerm()) {
            List orgList = hasBuResult.getHasPermOrgs();
            QFilter orgFilter = new QFilter("org", "in", (Object)orgList);
            showParameter.getListFilterParameter().getQFilters().add(orgFilter);
        }
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void bsedTrans(List<Long> bizDataIdList) {
        int len;
        SWCDataServiceHelper recurBizHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        String queryField = "salaryfile.id,salaryfile.person.id,salaryfile.employee.empnumber,bizitem.id,bizitem.name";
        QFilter filter = new QFilter("id", "in", bizDataIdList);
        DynamicObject[] bizDataColl = recurBizHelper.query(queryField, new QFilter[]{filter});
        HashSet<String> checkPersonSet = new HashSet<String>(16);
        HashSet<String> checkFailSet = new HashSet<String>(16);
        ArrayList checkFailList = new ArrayList(10);
        for (DynamicObject bizDataObj : bizDataColl) {
            Long personId = bizDataObj.getLong("salaryfile.person.id");
            Long bizItemId = bizDataObj.getLong("bizitem.id");
            String checkKey = personId + "##" + bizItemId;
            if (checkPersonSet.contains(checkKey)) {
                if (checkFailSet.add(checkKey)) {
                    HashMap<String, String> checkFailMap = new HashMap<String, String>(2);
                    checkFailMap.put(bizDataObj.getString("salaryfile.employee.empnumber"), bizDataObj.getString("bizitem.name"));
                    checkFailList.add(checkFailMap);
                }
            } else {
                checkPersonSet.add(checkKey);
            }
            if (checkFailList.size() > 3) break;
        }
        if ((len = checkFailList.size()) > 0) {
            StringBuilder sb = new StringBuilder();
            String mainErrorMsg = ResManager.loadKDString((String)"\u65e0\u6cd5\u6309\u751f\u6548\u65e5\u671f\u8f6c\u79fb\u540c\u4e00\u4eba\u540c\u4e00\u9879\u76ee\u7684\u591a\u6761\u5faa\u73af\u9879\u4e1a\u52a1\u6570\u636e\u3002\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RecurBizDataListPlugin_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            sb.append(mainErrorMsg).append("\r\n");
            for (int index = 0; index < len; ++index) {
                Map errorMap = (Map)checkFailList.get(index);
                for (Map.Entry entry : errorMap.entrySet()) {
                    String errorMsg = ResManager.loadKDString((String)"\u5de5\u53f7\uff08{0}\uff09\uff0c\u4e1a\u52a1\u9879\u76ee\uff08{1}\uff09", (String)"RecurBizDataListPlugin_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    sb.append(MessageFormat.format(errorMsg, entry.getKey(), entry.getValue()));
                    if (index != len - 1) {
                        sb.append('\uff1b').append("\r\n");
                    } else {
                        sb.append('\u3002');
                    }
                    if (index != 2 || len <= 3) continue;
                    sb.append(ResManager.loadKDString((String)"\u2026\u2026\u7b49", (String)"RecurBizDataListPlugin_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    this.getView().showErrorNotification(sb.toString());
                    return;
                }
            }
            this.getView().showErrorNotification(sb.toString());
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_transpayrollgrp");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "donothing_bsedtrans"));
        this.getView().showForm(showParameter);
    }

    private List<Long> filterPayRollGrpTransIdList(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> bizDataIdList = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            bizDataIdList.add((Long)row.getPrimaryKeyValue());
        }
        QFilter filter = new QFilter("id", "in", bizDataIdList);
        filter.and("auditstatus", "=", (Object)"C");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_recurbizdata");
        BizDataHelper bizDataHelper = new BizDataHelper();
        List transIdList = bizDataHelper.getBizDataIdList(helper, filter);
        return transIdList;
    }

    public void destory() {
        super.destory();
        GlobalParam.remove();
    }
}

