/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.cal.itemresult.AccDataResultFactory;
import kd.swc.hsas.business.cal.itemresult.BcDataResultFactory;
import kd.swc.hsas.business.cal.itemresult.BsItemResultFactory;
import kd.swc.hsas.business.cal.itemresult.SlItemResultFactory;
import kd.swc.hsas.business.cal.itemresult.SpItemResultFactory;
import kd.swc.hsas.common.dto.calitem.AccItemResultDTO;
import kd.swc.hsas.common.dto.calitem.BaseItemResultDTO;
import kd.swc.hsas.common.dto.calitem.BsItemResultDTO;
import kd.swc.hsas.common.dto.calitem.OtherItemResultDTO;
import kd.swc.hsas.common.dto.calitem.StItemResultDTO;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.tab.UpdateTabNameHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCCoreBaseBillEdit;

public class CalItemDetailResultPlugin
extends SWCCoreBaseBillEdit {
    private static final String CALMESSAGEENTRY = "calmessageentry";
    private static Log log = LogFactory.getLog(CalItemDetailResultPlugin.class);
    private static final String HSAS_CALTABLEENTRY = "hsas_caltableentry";
    private static final String HSAS_CALACCENTRY = "hsas_calaccentry";
    private static final String HSAS_CALBSENTRY = "hsas_calbsentry";
    private static final String HSAS_CALOHTERENTRY = "hsas_calohterentry";
    private static final Set<String> CALING_STATUS = new HashSet<String>(4);
    private static final Set<String> FAIL_STATUS = new HashSet<String>(6);
    public static final String ATTITEMTYPE_SUMMARY = "1";
    public static final String ATTITEMTYPE_DETAIL = "0";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        DynamicObject calPerson = this.initData();
        if (calPerson == null) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CalItemDetailResultPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
            }
            this.getView().close();
            return;
        }
        Long senceId = calPerson.getLong("caltask.payrollscenev.id");
        DynamicObject schemeAfterCalObj = this.getSceneSchemeAfterCalObj(senceId);
        if (schemeAfterCalObj != null) {
            this.getView().getPageCache().put("isNoCountBizData", schemeAfterCalObj.getBoolean("nocountbizdata") ? ATTITEMTYPE_SUMMARY : ATTITEMTYPE_DETAIL);
            this.getView().getPageCache().put("isNoCountAtt", schemeAfterCalObj.getBoolean("nocountatt") ? ATTITEMTYPE_SUMMARY : ATTITEMTYPE_DETAIL);
        }
        long taskId = calPerson.getLong("caltask.id");
        this.getView().getPageCache().put("calTaskId", String.valueOf(taskId));
        this.getView().getPageCache().put("calPersonId", String.valueOf(calPerson.getLong("id")));
        this.getView().getPageCache().put("salaryFileId", String.valueOf(calPerson.getLong("salaryfile.id")));
        this.getView().getPageCache().put("isCalResult", calPerson.getBoolean("iscalresult") ? ATTITEMTYPE_SUMMARY : ATTITEMTYPE_DETAIL);
        DynamicObject calTable = this.initCalTable(calPerson);
        DynamicObject payrollgrpv = this.initPayrollgrpv(calPerson);
        this.initTab(calPerson);
        DynamicObject calRule = this.initBaseInfo(calPerson, calTable, payrollgrpv);
        this.initOutputMessageEntry(calPerson);
        this.initEntry(calPerson, calTable, payrollgrpv, calRule);
    }

    private void initOutputMessageEntry(DynamicObject calPerson) {
        Long calPersonId = calPerson.getLong("id");
        Long calTaskId = calPerson.getLong("caltask.id");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrecord");
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        filter.and("optype", "=", (Object)ATTITEMTYPE_SUMMARY);
        DynamicObjectCollection calRecordList = helper.queryOriginalCollection("id", new QFilter[]{filter});
        if (calRecordList.size() == 0) {
            this.hideMessageEntry();
            return;
        }
        Set calRecordIdSet = calRecordList.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        helper.setEntityName("hsas_caldetail");
        filter = new QFilter("record.id", "in", calRecordIdSet);
        filter.and("calpersonid", "=", (Object)calPersonId);
        DynamicObjectCollection calDetailList = helper.queryOriginalCollection("id,record.id", new QFilter[]{filter}, "modifytime desc");
        if (calDetailList.size() == 0) {
            this.hideMessageEntry();
            return;
        }
        DynamicObject newDetail = (DynamicObject)calDetailList.get(0);
        helper.setEntityName("hsas_calmessage");
        filter = new QFilter("record.id", "=", (Object)newDetail.getLong("record.id"));
        filter.and("calpersonid", "=", (Object)calPersonId);
        DynamicObjectCollection messageList = helper.queryOriginalCollection("id", new QFilter[]{filter}, "index asc");
        if (messageList.size() == 0) {
            this.hideMessageEntry();
            return;
        }
        this.buildMessageEntry(messageList);
    }

    private void buildMessageEntry(DynamicObjectCollection messageList) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("calmessage", new Object[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        for (DynamicObject message : messageList) {
            setter.addRow(new Object[]{message.getLong("id")});
        }
        model.deleteEntryData(CALMESSAGEENTRY);
        model.batchCreateNewEntryRow(CALMESSAGEENTRY, setter);
        model.endInit();
        this.getView().updateView(CALMESSAGEENTRY);
    }

    private void hideMessageEntry() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.setOperationColumnByPerm();
    }

    private void setOperationColumnByPerm() {
        String targetCycle;
        String isCalResult = this.getView().getPageCache().get("isCalResult");
        if (SWCStringUtils.equals((String)isCalResult, (String)ATTITEMTYPE_DETAIL)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"accoperation"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bizdataoperation"});
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        boolean accPermFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_accresult", (String)"47150e89000000ac");
        if (!accPermFlag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"accoperation"});
        }
        boolean recurBizDataPermFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_recurbizdata", (String)"47150e89000000ac");
        boolean nonRecurBizDataPermFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_nonrecurbizdata", (String)"47150e89000000ac");
        if (recurBizDataPermFlag && nonRecurBizDataPermFlag) {
            return;
        }
        if (recurBizDataPermFlag) {
            targetCycle = ATTITEMTYPE_SUMMARY;
        } else if (nonRecurBizDataPermFlag) {
            targetCycle = ATTITEMTYPE_DETAIL;
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bizdataoperation"});
            return;
        }
        EntryGrid bizDataGrid = (EntryGrid)this.getView().getControl(HSAS_CALBSENTRY);
        ArrayList<String> operationKeys = new ArrayList<String>(1);
        operationKeys.add("viewbizdata");
        DynamicObject[] datas = bizDataGrid.getEntryData().getDataEntitys();
        for (int index = 0; index < datas.length; ++index) {
            DynamicObject data = datas[index];
            if (SWCStringUtils.equals((String)targetCycle, (String)data.getString("bizitem.cycle"))) continue;
            bizDataGrid.hideOperateItems("bizdataoperation", index, operationKeys);
        }
        this.getView().updateView(HSAS_CALBSENTRY);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        int index = 0;
        DynamicObject entry = null;
        DynamicObject obj = null;
        switch (args.getOperateKey()) {
            case "viewaccdetail": {
                index = this.getModel().getEntryCurrentRowIndex(HSAS_CALACCENTRY);
                entry = this.getModel().getEntryRowEntity(HSAS_CALACCENTRY, index);
                obj = entry.getDynamicObject("accdata");
                if (obj == null) break;
                this.openAccResultDetailPage(obj.getLong("id"));
                break;
            }
            case "viewbizdata": {
                index = this.getModel().getEntryCurrentRowIndex(HSAS_CALBSENTRY);
                entry = this.getModel().getEntryRowEntity(HSAS_CALBSENTRY, index);
                obj = entry.getDynamicObject("bizitem");
                String bizItemType = entry.getString("bizitemtype");
                Date startDate = entry.getDate("bsstartdate");
                Date endDate = entry.getDate("bsenddate");
                if (obj == null) break;
                this.openBizDataListPage(obj.getLong("id"), bizItemType, startDate, endDate);
                break;
            }
        }
    }

    private void openAccResultDetailPage(long accId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accdetails");
        QFilter accDetailFilter = new QFilter("caltask.id", "=", (Object)Long.valueOf(this.getView().getPageCache().get("calTaskId")));
        accDetailFilter.and(new QFilter("calPersonId", "=", (Object)Long.valueOf(this.getView().getPageCache().get("calPersonId"))));
        DynamicObjectCollection accDetails = helper.queryOriginalCollection("caltask.id,calpersonid,accresult.id", new QFilter[]{accDetailFilter});
        List accResultIdList = accDetails.stream().map(accDetail -> accDetail.getLong("accresult.id")).collect(Collectors.toList());
        helper.setEntityName("hsas_accresult");
        QFilter accResultFilter = new QFilter("id", "in", accResultIdList);
        accResultFilter.and(new QFilter("acc.id", "=", (Object)accId));
        DynamicObject accResult = helper.queryOriginalOne("id", new QFilter[]{accResultFilter});
        if (accResult == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CalItemDetailResultPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_accresultdetailinfo");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("accResultId", (Object)accResult.getLong("id"));
        showParameter.setCustomParam("pageType", (Object)"view");
        this.getView().showForm(showParameter);
    }

    private void openBizDataListPage(long bizItemId, String bizItemType, Date startDate, Date endDate) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        DynamicObject bizItem = helper.queryOriginalOne("cycle, attitemtype", new QFilter[]{new QFilter("id", "=", (Object)bizItemId)});
        if (bizItem == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CalItemDetailResultPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("bos_list");
        if ("hsbs_bizitem".equals(bizItemType)) {
            DynamicObjectCollection allBizDataRels = this.getBsCalRelData(bizItemId, bizItem, showParameter);
            if (allBizDataRels == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CalItemDetailResultPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            List allBizDataIdList = allBizDataRels.stream().map(allBizDataRel -> allBizDataRel.getLong("bizdataid")).collect(Collectors.toList());
            QFilter bizDataFilter = new QFilter("id", "in", allBizDataIdList);
            bizDataFilter.and(new QFilter("bizitem.id", "=", (Object)bizItemId));
            if (SWCStringUtils.equals((String)bizItem.getString("cycle"), (String)ATTITEMTYPE_SUMMARY)) {
                SWCDataServiceHelper bsDataHelper = new SWCDataServiceHelper("hsas_recurbizdata");
                showParameter.setBillFormId("hsas_recurbizdata");
                DynamicObjectCollection bizDatas = bsDataHelper.queryOriginalCollection("id,bizitem.id", new QFilter[]{bizDataFilter});
                if (CollectionUtils.isEmpty((Collection)bizDatas)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5173\u8054\u7684\u524d\u7aef\u4e1a\u52a1\u6570\u636e\u3002", (String)"CalItemDetailResultPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                List bizDataIdList = bizDatas.stream().map(bizData -> bizData.getLong("id")).collect(Collectors.toList());
                showParameter.setCustomParam("filterIdList", bizDataIdList);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                SWCDataServiceHelper nonRecurBsDataHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
                showParameter.setBillFormId("hsas_nonrecurbizdata");
                DynamicObjectCollection bizDatas = nonRecurBsDataHelper.queryOriginalCollection("id,bizitem.id,bizdatarecord", new QFilter[]{bizDataFilter});
                if (CollectionUtils.isEmpty((Collection)bizDatas)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5173\u8054\u7684\u524d\u7aef\u4e1a\u52a1\u6570\u636e\u3002", (String)"CalItemDetailResultPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashSet<Long> bizDataRecordIdSet = new HashSet<Long>(16);
                for (DynamicObject bizDataObj : bizDatas) {
                    Long bizDataRecordId = bizDataObj.getLong("bizdatarecord");
                    if (bizDataRecordId == null || bizDataRecordId <= 0L) continue;
                    bizDataRecordIdSet.add(bizDataRecordId);
                }
                log.info("calItemDetailResultPlugin bizDataRecordIdSet is:{}", bizDataRecordIdSet);
                if (bizDataRecordIdSet.size() == 0) {
                    List bizDataIdList = bizDatas.stream().map(bizData -> bizData.getLong("id")).collect(Collectors.toList());
                    showParameter.setCustomParam("filterIdList", bizDataIdList);
                    if (startDate != null && endDate != null) {
                        showParameter.setCustomParam("startDate", (Object)SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"));
                        showParameter.setCustomParam("endDate", (Object)SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd"));
                    }
                    this.getView().showForm((FormShowParameter)showParameter);
                    return;
                }
                SWCDataServiceHelper bizDataRecordHelper = new SWCDataServiceHelper("hsas_bizdatarecord");
                Long salaryFileId = Long.valueOf(this.getView().getPageCache().get("salaryFileId"));
                log.info("calItemDetailResultPlugin new salaryFileId is:{}", (Object)salaryFileId);
                QFilter bizDataRecordFilter = new QFilter("id", "in", bizDataRecordIdSet);
                bizDataRecordFilter.and("salaryfile.id", "=", (Object)salaryFileId);
                DynamicObject[] bizDataRecordArray = bizDataRecordHelper.query("bizdataaccesstpl", new QFilter[]{bizDataRecordFilter});
                long bizItemGroupId = 0L;
                if (bizDataRecordArray != null && bizDataRecordArray.length > 0) {
                    bizItemGroupId = bizDataRecordArray[0].getLong("bizdataaccesstpl.id");
                }
                log.info("calItemDetailResultPlugin bizItemGroupId is:{}", (Object)bizItemGroupId);
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("hsas_bizdatarecordlist");
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                if (bizItemGroupId != 0L) {
                    formShowParameter.setCustomParam("bizitemgroup", (Object)bizItemGroupId);
                }
                if (salaryFileId != null && salaryFileId != 0L) {
                    formShowParameter.setCustomParam("salaryFileId", (Object)salaryFileId);
                }
                formShowParameter.setCustomParam("bizDataRecordIds", (Object)((Object)bizDataRecordIdSet).toString());
                this.getView().showForm(formShowParameter);
            }
        } else {
            this.openAttBizDataList(bizItemId, startDate, endDate, bizItem, showParameter);
        }
    }

    private DynamicObjectCollection getBsCalRelData(long bizItemId, DynamicObject bizItem, ListShowParameter showParameter) {
        SWCDataServiceHelper bsDataRelHelper = null;
        showParameter.setCustomParam("bizItemId", (Object)bizItemId);
        String isNoCountBizData = this.getView().getPageCache().get("isNoCountBizData");
        if (SWCStringUtils.isEmpty((String)isNoCountBizData)) {
            return null;
        }
        bsDataRelHelper = SWCStringUtils.equals((String)bizItem.getString("cycle"), (String)ATTITEMTYPE_SUMMARY) ? (ATTITEMTYPE_SUMMARY.equals(isNoCountBizData) ? new SWCDataServiceHelper("hsas_calbsnocntrel") : new SWCDataServiceHelper("hsas_calbizdatarel")) : (ATTITEMTYPE_SUMMARY.equals(isNoCountBizData) ? new SWCDataServiceHelper("hsas_noncalbsnocntrel") : new SWCDataServiceHelper("hsas_calnonbizdatarel"));
        QFilter calBizRelFilter = new QFilter("caltask.id", "=", (Object)Long.valueOf(this.getView().getPageCache().get("calTaskId")));
        Long calPersonId = Long.valueOf(this.getView().getPageCache().get("calPersonId"));
        calBizRelFilter.and(new QFilter("calpersonid", "=", (Object)calPersonId));
        return bsDataRelHelper.queryOriginalCollection("bizdataid,caltask.id,calpersonid", new QFilter[]{calBizRelFilter});
    }

    private void openAttBizDataList(long bizItemId, Date startDate, Date endDate, DynamicObject bizItem, ListShowParameter showParameter) {
        String attItemType = bizItem.getString("attitemtype");
        String isNoCountAtt = this.getView().getPageCache().get("isNoCountAtt");
        if (SWCStringUtils.isEmpty((String)isNoCountAtt)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CalItemDetailResultPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        SWCDataServiceHelper attBsHelper = null;
        if (ATTITEMTYPE_SUMMARY.equals(attItemType)) {
            attBsHelper = ATTITEMTYPE_SUMMARY.equals(isNoCountAtt) ? new SWCDataServiceHelper("hsas_calattnocntrel") : new SWCDataServiceHelper("hsas_calattbizdatarel");
            showParameter.setBillFormId("hsas_attbssumresult");
            showParameter.setCustomParam("formId", (Object)"hsas_attbizdatasummary");
        } else {
            attBsHelper = ATTITEMTYPE_SUMMARY.equals(isNoCountAtt) ? new SWCDataServiceHelper("hsas_calattdetnocntrel") : new SWCDataServiceHelper("hsas_calattbsdetailrel");
            showParameter.setBillFormId("hsas_attbsdetailresult");
            showParameter.setCustomParam("formId", (Object)"hsas_attbizdatadetail");
        }
        DynamicObjectCollection allBizDataRels = this.queryAttCalRelData(bizItemId, attBsHelper);
        Set attBizDataIdSet = allBizDataRels.stream().map(allBizDataRel -> allBizDataRel.getLong("attbizdataid")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(attBizDataIdSet)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5173\u8054\u7684\u8003\u52e4\u4e1a\u52a1\u6570\u636e\u3002", (String)"CalItemDetailResultPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        showParameter.setCustomParam("attBizDataIds", (Object)SerializationUtils.serializeToBase64(attBizDataIdSet));
        showParameter.setCustomParam("startDate", (Object)SerializationUtils.serializeToBase64((Object)startDate));
        showParameter.setCustomParam("endDate", (Object)SerializationUtils.serializeToBase64((Object)endDate));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private DynamicObjectCollection queryAttCalRelData(long bizItemId, SWCDataServiceHelper attBsHelper) {
        QFilter calBizRelFilter = new QFilter("caltask.id", "=", (Object)Long.valueOf(this.getView().getPageCache().get("calTaskId")));
        Long calPersonId = Long.valueOf(this.getView().getPageCache().get("calPersonId"));
        calBizRelFilter.and("calpersonid", "=", (Object)calPersonId);
        calBizRelFilter.and("attbizitem.id", "=", (Object)bizItemId);
        return attBsHelper.queryOriginalCollection("attbizdataid", new QFilter[]{calBizRelFilter});
    }

    public DynamicObject getSceneSchemeAfterCalObj(Long sceneId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
        QFilter filter = new QFilter("id", "=", (Object)sceneId);
        DynamicObject sceneObj = helper.queryOne("schemeaftercal.id", new QFilter[]{filter});
        if (sceneObj == null) {
            return null;
        }
        long schemeAfterCalId = sceneObj.getLong("schemeaftercal.id");
        helper = new SWCDataServiceHelper("hsas_schemeaftercal");
        filter = new QFilter("id", "=", (Object)schemeAfterCalId);
        String fields = "nocountbizdata,nocountsinsur,nocountatt";
        DynamicObjectCollection schemeAfterCalObjs = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)schemeAfterCalObjs)) {
            return null;
        }
        return (DynamicObject)schemeAfterCalObjs.get(0);
    }

    private DynamicObject initData() {
        Long calTableId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("pkId"));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        String selectField = "id,name,caltask,salaryfile,calresultid,calstatus,iscalresult,isproration,caltask.payrollscenev.id";
        return helper.queryOne(selectField, (Object)calTableId);
    }

    private DynamicObject initCalTable(DynamicObject calPerson) {
        Long calTableId = calPerson.getLong("calresultid");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        return helper.queryOne("salaryitem,datasource,isnull,numvalue,datevalue,textvalue,calamountvalue,resultcover,slprorationindex,slstartdate,slenddate,proportion", (Object)calTableId);
    }

    private DynamicObject initPayrollgrpv(DynamicObject calPerson) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        return helper.loadSingle((Object)calPerson.getLong("caltask.payrollgroupv.id"));
    }

    private void initTab(DynamicObject calPerson) {
        String tabPrefix = ResManager.loadKDString((String)"\u6838\u7b97\u7ed3\u679c", (String)"CalItemDetailResultPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String salaryFileName = calPerson.getString("name");
        String showName = tabPrefix + " - " + salaryFileName;
        UpdateTabNameHelper.updateTabNameByWholeValue((IFormView)this.getView(), (String)showName);
    }

    private DynamicObject initBaseInfo(DynamicObject calPerson, DynamicObject calTable, DynamicObject payrollgrpv) {
        Label calStatusLabel;
        Long salaryFileId = calPerson.getLong("salaryfile.id");
        String personName = calPerson.getString("name");
        String calState = calPerson.getString("calstatus");
        this.getModel().setValue("salaryfile", (Object)salaryFileId);
        this.getModel().setValue("personname", (Object)personName);
        this.getModel().setValue("calstatus", (Object)calState);
        this.getModel().setValue("filenumber", (Object)calPerson.getString("salaryfile.number"));
        if (FAIL_STATUS.contains(calState)) {
            calStatusLabel = (Label)this.getControl("failstatuslabel");
            this.getView().setVisible(Boolean.FALSE, new String[]{"calingstatuslabel", "calstatuslabel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"failstatuslabel"});
        } else if (CALING_STATUS.contains(calState)) {
            calStatusLabel = (Label)this.getControl("calingstatuslabel");
            this.getView().setVisible(Boolean.FALSE, new String[]{"failstatuslabel", "calstatuslabel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"calingstatuslabel"});
        } else {
            calStatusLabel = (Label)this.getControl("calstatuslabel");
            this.getView().setVisible(Boolean.FALSE, new String[]{"calingstatuslabel", "failstatuslabel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"calstatuslabel"});
        }
        calStatusLabel.setText(CalStateEnum.getDesc((String)calState));
        Long calRuleId = calPerson.getLong("caltask.calrulev.id");
        if (payrollgrpv == null) {
            return null;
        }
        DynamicObject calCurrency = payrollgrpv.getDynamicObject("currency");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrule");
        DynamicObject calRule = helper.queryOne("totalsalary,netsalary,salaryitem.id,datasource,isconvert,customprorationrule.dataprecision.id", (Object)calRuleId);
        if (calRule == null) {
            return null;
        }
        Long totalSalaryId = calRule.getLong("totalsalary.id");
        Long netSalaryId = calRule.getLong("netsalary.id");
        if (calTable == null) {
            return calRule;
        }
        DynamicObjectCollection salaryItemResults = calTable.getDynamicObjectCollection(HSAS_CALTABLEENTRY);
        for (DynamicObject entry : salaryItemResults) {
            BigDecimal calAmount;
            BigDecimal calamountvalue;
            Long dataroundId;
            if (entry.getInt("slprorationindex") != 0) continue;
            Long salaryItemId = entry.getLong("salaryitem.id");
            if (totalSalaryId.equals(salaryItemId)) {
                dataroundId = entry.getLong("salaryitem.dataround.id");
                calamountvalue = entry.getBigDecimal("calamountvalue");
                calAmount = calamountvalue.setScale(calCurrency.getInt("amtprecision"), this.getRoundingMode(dataroundId));
                this.getModel().setValue("totalsalary", (Object)calAmount);
            }
            if (!netSalaryId.equals(salaryItemId)) continue;
            dataroundId = entry.getLong("salaryitem.dataround.id");
            calamountvalue = entry.getBigDecimal("calamountvalue");
            calAmount = calamountvalue.setScale(calCurrency.getInt("amtprecision"), this.getRoundingMode(dataroundId));
            this.getModel().setValue("netsalary", (Object)calAmount);
        }
        this.getView().updateView("totalsalary");
        return calRule;
    }

    public RoundingMode getRoundingMode(long dataRoundId) {
        if (dataRoundId == 1010L) {
            return RoundingMode.HALF_UP;
        }
        if (dataRoundId == 1020L) {
            return RoundingMode.DOWN;
        }
        if (dataRoundId == 1030L) {
            return RoundingMode.UP;
        }
        return RoundingMode.HALF_UP;
    }

    private void initEntry(DynamicObject calPerson, DynamicObject calTable, DynamicObject payrollgrpv, DynamicObject calRule) {
        HashMap<Long, Integer> proportionScaleMap;
        if (calTable == null) {
            return;
        }
        Map<Long, String> dataTypeMap = this.getDataTypeMap();
        Map<Long, Integer> dataPrecisionMap = this.instanceDataPrecisionMap();
        Long mainId = calPerson.getLong("id");
        Long calTableId = calTable.getLong("id");
        Boolean isProration = calPerson.getBoolean("isproration");
        this.getView().setVisible(isProration, new String[]{"prorationindex", "bsprorationindex", "otherprorationindex", "proportion"});
        DynamicObject calCurrency = payrollgrpv.getDynamicObject("currency");
        DynamicObjectCollection salaryItemResults = calTable.getDynamicObjectCollection(HSAS_CALTABLEENTRY);
        Date calTableStartDate = calPerson.getDate("caltask.startdate");
        Date calTableEndDate = calPerson.getDate("caltask.enddate");
        String isCalResult = calPerson.getString("iscalresult");
        if (isProration.booleanValue()) {
            DynamicObjectCollection calRuleEntrys = calRule.getDynamicObjectCollection("calruleitementry");
            proportionScaleMap = new HashMap(calRuleEntrys.size());
            for (DynamicObject entry : calRuleEntrys) {
                if (!SWCStringUtils.equals((String)"2", (String)entry.getString("isconvert"))) continue;
                proportionScaleMap.put(entry.getLong("salaryitem.id"), dataPrecisionMap.get(entry.getLong("customprorationrule.dataprecision.id")));
            }
        } else {
            proportionScaleMap = new HashMap<Long, Integer>(0);
        }
        SlItemResultFactory slItemResultFactory = new SlItemResultFactory(calTableId, isProration, calCurrency, salaryItemResults, calRule, dataPrecisionMap, calTableStartDate, calTableEndDate, proportionScaleMap);
        slItemResultFactory.setIsCalResult(isCalResult);
        List stItemResultDTOS = slItemResultFactory.createItemResultDTOList(dataTypeMap);
        this.initSalaryItemResult(mainId, stItemResultDTOS);
        AccDataResultFactory accDataResultFactory = new AccDataResultFactory(calTableId, isProration, calCurrency, mainId, calPerson);
        List accDataResultDTOS = accDataResultFactory.createItemResultDTOList(dataTypeMap);
        this.initAccDataResult(accDataResultDTOS);
        BsItemResultFactory bsItemResultFactory = new BsItemResultFactory(calTableId, isProration, calCurrency);
        List bsItemResultDTOS = bsItemResultFactory.createItemResultDTOList(dataTypeMap);
        this.initBsDataResult(bsItemResultDTOS);
        BcDataResultFactory bcDataResultFactory = new BcDataResultFactory(calTableId, isProration, calCurrency);
        List bcItemResultDTOS = bcDataResultFactory.createItemResultDTOList(dataTypeMap);
        SpItemResultFactory spItemResultFactory = new SpItemResultFactory(calTableId, isProration, dataPrecisionMap, calCurrency, calTableStartDate, calTableEndDate);
        List spItemResultDTOS = spItemResultFactory.createItemResultDTOList(dataTypeMap);
        this.initOtherItemResult(bcItemResultDTOS, spItemResultDTOS);
    }

    private Map<Long, String> getDataTypeMap() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_datatype");
        QFilter filter = new QFilter("enable", "=", (Object)ATTITEMTYPE_SUMMARY);
        filter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject[] query = helper.query("id,showtype", new QFilter[]{filter});
        HashMap<Long, String> dataMap = new HashMap<Long, String>(16);
        for (DynamicObject data : query) {
            Long id = data.getLong("id");
            String showType = data.getString("showtype");
            dataMap.put(id, showType);
        }
        return dataMap;
    }

    private Map<Long, Integer> instanceDataPrecisionMap() {
        DynamicObject[] objects;
        HashMap<Long, Integer> dataprecisionMap = new HashMap<Long, Integer>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_dataprecision");
        QFilter filter = new QFilter("enable", "=", (Object)ATTITEMTYPE_SUMMARY);
        for (DynamicObject dynamicObject : objects = helper.query("id,scale", new QFilter[]{filter})) {
            dataprecisionMap.put(dynamicObject.getLong("id"), dynamicObject.getInt("scale"));
        }
        return dataprecisionMap;
    }

    private void initSalaryItemResult(Long mainId, List<BaseItemResultDTO> stItemResultDTOS) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("id", new Object[0]);
        setter.addField("pid", new Object[0]);
        setter.addField("salaryitem", new Object[0]);
        setter.addField("stseq", new Object[0]);
        setter.addField("stdatatype", new Object[0]);
        setter.addField("stresult", new Object[0]);
        setter.addField("proportion", new Object[0]);
        setter.addField("prorationindex", new Object[0]);
        setter.addField("ststartdate", new Object[0]);
        setter.addField("stenddate", new Object[0]);
        setter.addField("datasource", new Object[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List<Long> itemIdList = stItemResultDTOS.stream().map(BaseItemResultDTO::getItemId).collect(Collectors.toList());
        List<Long> hasCoverDataItemList = this.assembleItemCoverDataList(mainId, itemIdList);
        model.beginInit();
        for (int index = 0; index < stItemResultDTOS.size(); ++index) {
            StItemResultDTO resultDTO = (StItemResultDTO)stItemResultDTOS.get(index);
            boolean hasCover = hasCoverDataItemList.contains(resultDTO.getItemId());
            String dataSource = hasCover ? "4" : resultDTO.getDataSource();
            setter.addRow(new Object[]{resultDTO.getEntryId(), 0, resultDTO.getItemId(), index + 1, resultDTO.getDataType(), resultDTO.getItemResult(), null, resultDTO.getProrationIndex(), resultDTO.getStartDate(), resultDTO.getEndDate(), dataSource});
            if (hasCover) continue;
            List childItemResultDTOList = resultDTO.getChildItemResultList();
            for (StItemResultDTO childItemResultDTO : childItemResultDTOList) {
                setter.addRow(new Object[]{childItemResultDTO.getEntryId(), resultDTO.getEntryId(), childItemResultDTO.getItemId(), index + 1, childItemResultDTO.getDataType(), childItemResultDTO.getItemResult(), childItemResultDTO.getProportion(), childItemResultDTO.getProrationIndex(), childItemResultDTO.getStartDate(), childItemResultDTO.getEndDate(), childItemResultDTO.getDataSource()});
            }
        }
        model.deleteEntryData(HSAS_CALTABLEENTRY);
        model.batchCreateNewEntryRow(HSAS_CALTABLEENTRY, setter);
        model.endInit();
        this.getView().updateView(HSAS_CALTABLEENTRY);
    }

    private List<Long> assembleItemCoverDataList(Long mainId, List<Long> itemIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresultcoverdata");
        QFilter filter = new QFilter("calperson", "=", (Object)mainId);
        filter.and("salaryitem", "in", itemIdList);
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("salaryitem.id", new QFilter[]{filter});
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return new ArrayList<Long>(0);
        }
        return dynamicObjects.stream().map(single -> single.getLong("salaryitem.id")).collect(Collectors.toList());
    }

    private void initAccDataResult(List<BaseItemResultDTO> accDataResultDTOS) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("accdata", new Object[0]);
        setter.addField("accresult", new Object[0]);
        setter.addField("acstartdate", new Object[0]);
        setter.addField("acenddate", new Object[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        for (int index = 0; index < accDataResultDTOS.size(); ++index) {
            AccItemResultDTO resultDTO = (AccItemResultDTO)accDataResultDTOS.get(index);
            setter.addRow(new Object[]{resultDTO.getItemId(), resultDTO.getItemResult(), resultDTO.getStartDate(), resultDTO.getEndDate()});
        }
        model.deleteEntryData(HSAS_CALACCENTRY);
        model.batchCreateNewEntryRow(HSAS_CALACCENTRY, setter);
        model.endInit();
        this.getView().updateView(HSAS_CALACCENTRY);
    }

    private void initBsDataResult(List<BaseItemResultDTO> bsDataResultDTOS) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("bizitemtype", new Object[0]);
        setter.addField("bizitem", new Object[0]);
        setter.addField("bizitemhide", new Object[0]);
        setter.addField("bsresult", new Object[0]);
        setter.addField("bsprorationindex", new Object[0]);
        setter.addField("bsstartdate", new Object[0]);
        setter.addField("bsenddate", new Object[0]);
        setter.addField("bscalblock", new Object[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        for (int index = 0; index < bsDataResultDTOS.size(); ++index) {
            BsItemResultDTO resultDTO = (BsItemResultDTO)bsDataResultDTOS.get(index);
            setter.addRow(new Object[]{resultDTO.getBizItemType(), resultDTO.getItemId(), resultDTO.getItemId(), resultDTO.getItemResult(), resultDTO.getProrationIndex(), resultDTO.getStartDate(), resultDTO.getEndDate(), resultDTO.getCalBlock()});
        }
        model.deleteEntryData(HSAS_CALBSENTRY);
        model.batchCreateNewEntryRow(HSAS_CALBSENTRY, setter);
        model.endInit();
        this.getView().updateView(HSAS_CALBSENTRY);
    }

    private void initOtherItemResult(List<BaseItemResultDTO> bcItemResultDTOS, List<BaseItemResultDTO> spItemResultDTOS) {
        OtherItemResultDTO resultDTO;
        int index;
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("itemtype", new Object[0]);
        setter.addField("itemnumber", new Object[0]);
        setter.addField("itemname", new Object[0]);
        setter.addField("datatype", new Object[0]);
        setter.addField("result", new Object[0]);
        setter.addField("otherprorationindex", new Object[0]);
        setter.addField("startdate", new Object[0]);
        setter.addField("enddate", new Object[0]);
        setter.addField("othercalblock", new Object[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        boolean isHaveError = false;
        for (index = 0; index < bcItemResultDTOS.size(); ++index) {
            resultDTO = (OtherItemResultDTO)bcItemResultDTOS.get(index);
            if (resultDTO.getError().booleanValue()) {
                isHaveError = true;
                continue;
            }
            setter.addRow(new Object[]{resultDTO.getItemEnum().getCode(), resultDTO.getItemNumber(), resultDTO.getItemName(), resultDTO.getDataType(), resultDTO.getItemResult(), resultDTO.getProrationIndex(), resultDTO.getStartDate(), resultDTO.getEndDate(), resultDTO.getCalBlock()});
        }
        if (isHaveError) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u916c\u57fa\u7840\u6570\u636e\u5df2\u88ab\u4fee\u6539\u6216\u5220\u9664\uff0c\u65e0\u6cd5\u63d0\u4f9b\u8be6\u7ec6\u67e5\u8be2\u7ed3\u679c\u3002", (String)"CalItemDetailResultPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        for (index = 0; index < spItemResultDTOS.size(); ++index) {
            resultDTO = (OtherItemResultDTO)spItemResultDTOS.get(index);
            setter.addRow(new Object[]{resultDTO.getItemEnum().getCode(), resultDTO.getItemNumber(), resultDTO.getItemName(), resultDTO.getDataType(), resultDTO.getItemResult(), resultDTO.getProrationIndex(), resultDTO.getStartDate(), resultDTO.getEndDate(), resultDTO.getCalBlock()});
        }
        model.deleteEntryData(HSAS_CALOHTERENTRY);
        model.batchCreateNewEntryRow(HSAS_CALOHTERENTRY, setter);
        model.endInit();
        this.getView().updateView(HSAS_CALOHTERENTRY);
    }

    static {
        CALING_STATUS.add(CalStateEnum.PRECAL_CALED.getCode());
        CALING_STATUS.add(CalStateEnum.TAX_CALED.getCode());
        CALING_STATUS.add(CalStateEnum.APPROVALING.getCode());
        CALING_STATUS.add(CalStateEnum.WAIT_APPROVALED.getCode());
        FAIL_STATUS.add(CalStateEnum.PUSHTAX_ERROR.getCode());
        FAIL_STATUS.add(CalStateEnum.PULLTAX_ERROR.getCode());
        FAIL_STATUS.add(CalStateEnum.AFTERCAL_ERROR.getCode());
        FAIL_STATUS.add(CalStateEnum.CANCELCAL_ERROR.getCode());
        FAIL_STATUS.add(CalStateEnum.TAXCAL_ERROR.getCode());
        FAIL_STATUS.add(CalStateEnum.APPROVALED_NOT_PASS.getCode());
    }
}

