/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal;

import java.io.IOException;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.JSONUtils;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsbp.business.addperson.entity.CalGetCouldAddPersonProgressInfo;
import kd.swc.hsbp.business.addperson.entity.CalPersonAddProgressInfo;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.CalPersonLockEnum;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalPersonF7List
extends AbstractListPlugin
implements ItemClickListener {
    private static final Log logger = LogFactory.getLog(CalPersonF7List.class);
    private static final String ADDCALPERSON = "addcalperson";

    public void beforeBindData(EventObject e) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"isshowdisabled"});
    }

    public void setFilter(SetFilterEvent e) {
        ISWCAppCache appCache = SWCAppCache.get((String)"cache_getperson_key_%s");
        Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        CalGetCouldAddPersonProgressInfo progressInfo = (CalGetCouldAddPersonProgressInfo)appCache.get(String.format(Locale.ROOT, "cache_getperson_key_%s", payrolltaskId), CalGetCouldAddPersonProgressInfo.class);
        List list = e.getQFilters();
        QFilter dateRangeFilter = new QFilter("id", "in", (Object)progressInfo.getFileIds());
        list.add(dateRangeFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate fo = (FormOperate)args.getSource();
        String operateKey = fo.getOperateKey();
        if (ADDCALPERSON.equals(operateKey)) {
            args.setCancel(true);
            if (!SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"hsas_calperson", (String)"0=KX5+RHU1BC")) {
                this.getView().showErrorNotification(SWCPermissionServiceHelper.getNoPermTips((String)ResManager.loadKDString((String)"\u6838\u7b97\u540d\u5355", (String)"CalPersonF7List_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6dfb\u52a0\u6838\u7b97\u4eba\u5458", (String)"CalPersonF7List_10", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
                return;
            }
            Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
            DynamicObject taskDy = CalPayrollTaskHelper.queryTaskInfoById((Long)payrolltaskId);
            if (taskDy == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u53ef\u80fd\u88ab\u5220\u9664,\u8bf7\u68c0\u67e5\u3002", (String)"CalPersonF7List_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (CalPayrollTaskStateEnum.APPROVALED.getCode().equals(taskDy.getString("taskstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u5df2\u5ba1\u6279\u901a\u8fc7\uff0c\u65e0\u6cd5\u6dfb\u52a0\u6838\u7b97\u4eba\u5458\u3002", (String)"CalPersonF7List_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getView().getParentView().getPageCache().put("invokeOperation", "true");
            logger.info("\u6dfb\u52a0\u6838\u7b97\u4eba\u5458\u5f00\u59cb\u65f6\u95f4:{}", (Object)SWCDateTimeUtils.format((Date)new Date()));
            ListSelectedRowCollection rows = this.getSelectedRows();
            List ids = rows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            try {
                this.getPageCache().put("selectRowIds", JSONUtils.toString(ids));
            }
            catch (IOException e) {
                logger.error("\u6240\u9009\u884cID\u7f13\u5b58\u5931\u8d25");
            }
            CalPersonAddProgressInfo progress = new CalPersonAddProgressInfo();
            progress.setTotal(ids.size());
            progress.setStartDate(new Date());
            progress.setRemain(ids.size());
            progress.setStatus(0);
            SWCAppCache.get((String)"hsas").put(String.format(Locale.ROOT, "cache_addperson_key_%s", payrolltaskId), (Object)progress);
            String errorCode = (String)SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"ICalPersonService", (String)"addCalPerson", (Object[])new Object[]{payrolltaskId, ids, Boolean.FALSE});
            if (SWCStringUtils.isNotEmpty((String)errorCode)) {
                this.getView().showErrorNotification(CalPersonLockEnum.getDesc((String)errorCode));
                return;
            }
            CalPersonHelper.showAddPersonProgress((Long)payrolltaskId, (String)taskDy.getString("name"), (IFormView)this.getView().getParentView(), (boolean)false, (boolean)false);
            this.getPageCache().put("isAdd", Boolean.TRUE.toString());
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    public void pageRelease(EventObject e) {
        if (SWCStringUtils.isEmpty((String)this.getPageCache().get("isAdd"))) {
            Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(payrolltaskId), (String)CalPersonOperationEnum.OP_ADDCALPERSON.getOperationKey());
        }
        super.pageRelease(e);
    }

    public void beforeExportFile(BeforeExportFileEvent e) {
        String dateStr = SWCDateTimeUtils.format((Date)new Date(), (String)"MMdd");
        e.setFileName(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6dfb\u52a0\u6838\u7b97\u4eba\u5458\u5217\u8868_%s", (String)"CalPersonF7List_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), dateStr));
    }
}

