/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.form.JobFormInfo;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.bankoffer.vo.BaseDataConverter;
import kd.swc.hsas.business.cal.helper.CalProcessHandler;
import kd.swc.hsas.business.cal.helper.HSASCalListHelper;
import kd.swc.hsas.business.cal.service.CalTableCalService;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultListHelper;
import kd.swc.hsbp.business.formula.utils.FormulaCacheUtils;
import kd.swc.hsbp.business.record.TaskRecordHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(CalProgressPlugin.class);
    private static final String CANCELCAL = "cancelcal";
    private static final String AFTERTAXCALPROGRESS = "aftertaxcalprogress";
    private static final String PRETAXCALPROGRESS = "pretaxcalprogress";
    private static final String TAXCALPROGRESS = "taxcalprogress";
    private static final String KEY_ONCALAP = "oncalap";
    private static final String KEY_AFTERCALAP = "aftercalap";
    private static final String KEY_SOTPREMINDAP = "sotpremindap";
    private static final String KEY_BUTTONCLOSE = "buttonclose";
    private static final String VIEWHIS = "donothing_viewhis";
    private static final String OK = "donothing_ok";
    private static final String MINISIZE = "donothing_minisize";
    private static final String PERMITEMID = "0SWBXI04K+PJ";
    private static final String CALSTATE_CALING = "5";
    private static final String TASK_RECORD = "task_record_%s";
    private static final String CAL_INFO = "calInfo_%s";
    private static final String VIEW_CAL_RESULT = "viewcalresult";
    private static final String DO_NOTHING_VIEW_CAL_RESULT = "donothing_viewcalresult";
    private static final String DO_NOTHING_VIEW_CAL_REQUEST = "donothing_viewcalrequestlist";
    public static final String KEY_REMINDAP = "remindap";
    public static final String KEY_VIEWCALREQUEST = "viewcalrequest";
    public static final String KEY_BTNOK = "btnok";
    public static final String KEY_PROGRESSAP = "progressap";
    public static final String KEY_CONSUMETIMELABE = "consumetimelabe";
    public static final String BTN_CANCELCAL = "btn_cancelcal";

    public void preOpenForm(PreOpenFormEventArgs e) {
        StyleCss css;
        super.preOpenForm(e);
        FormShowParameter parameter = e.getFormShowParameter();
        Object openTaxCal = parameter.getCustomParam("openTaxCal");
        Long calTaskId = (Long)parameter.getCustomParam("calTaskId");
        boolean isOnlyPreCal = this.isOnlyPreCal(parameter);
        boolean enableTax = openTaxCal != null ? ((Boolean)BaseDataConverter.convert((Object)openTaxCal, Boolean.class)).booleanValue() : TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)calTaskId).booleanValue();
        if (!enableTax) {
            css = new StyleCss();
            css.setWidth("600px");
            css.setHeight("410px");
            parameter.getOpenStyle().setInlineStyleCss(css);
        }
        if (!enableTax && isOnlyPreCal) {
            css = new StyleCss();
            css.setWidth("600px");
            css.setHeight("350px");
            parameter.getOpenStyle().setInlineStyleCss(css);
        }
    }

    private boolean isOnlyPreCal(FormShowParameter parameter) {
        boolean isOnlyPreCal = false;
        Long calRecordId = (Long)parameter.getCustomParam("calRecordId");
        ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", calRecordId));
        Map typeCountMap = (Map)calProgressAppCache.get(String.format(Locale.ROOT, "cal_type_count_progress_%s", calRecordId), Map.class);
        if (typeCountMap != null) {
            Integer calCount = (Integer)parameter.getCustomParam("calCount");
            Integer onlyPreCalCount = (Integer)typeCountMap.get("onlyPreCalCount");
            isOnlyPreCal = calCount.equals(onlyPreCalCount);
        }
        return isOnlyPreCal;
    }

    public void initialize() {
        super.initialize();
        ProgressBar afterTaxCal = (ProgressBar)this.getControl(AFTERTAXCALPROGRESS);
        ProgressBar preTaxCal = (ProgressBar)this.getControl(PRETAXCALPROGRESS);
        ProgressBar taxCal = (ProgressBar)this.getControl(TAXCALPROGRESS);
        afterTaxCal.addProgressListener((ProgresssListener)this);
        preTaxCal.addProgressListener((ProgresssListener)this);
        taxCal.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.getView().setVisible(Boolean.FALSE, new String[]{"calprogressflex", "saveprogressflex"});
        ProgressBar afterTaxCalProgress = (ProgressBar)this.getControl(AFTERTAXCALPROGRESS);
        ProgressBar preTaxCalProgress = (ProgressBar)this.getControl(PRETAXCALPROGRESS);
        preTaxCalProgress.start();
        afterTaxCalProgress.start();
        Long calTaskId = (Long)parameter.getCustomParam("calTaskId");
        Object openTaxCal = parameter.getCustomParam("openTaxCal");
        boolean enableTax = openTaxCal != null ? ((Boolean)BaseDataConverter.convert((Object)openTaxCal, Boolean.class)).booleanValue() : TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)calTaskId).booleanValue();
        if (enableTax) {
            ProgressBar taxCalProgress = (ProgressBar)this.getControl(TAXCALPROGRESS);
            taxCalProgress.start();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"taxcalprogressflex", KEY_REMINDAP});
        }
        boolean isOnlyPreCal = this.isOnlyPreCal(parameter);
        if (!enableTax && isOnlyPreCal) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"aftercalflex"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{VIEW_CAL_RESULT, KEY_AFTERCALAP, KEY_BUTTONCLOSE, KEY_SOTPREMINDAP});
        int calCount = (Integer)parameter.getCustomParam("calCount");
        int calTimes = this.countCalTimes(calTaskId);
        this.getView().getFormShowParameter().setCustomParam("calTimes", (Object)calTimes);
        this.setCalInfo(calCount, calTimes);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (SWCStringUtils.equals((String)args.getOperateKey(), (String)CANCELCAL)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CANCELCAL, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMap = new HashMap<Integer, String>();
            btnNameMap.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"CalProgressPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            btnNameMap.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed", (String)"CalProgressPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u672a\u8ba1\u7b97\u6210\u529f\u7684\u6838\u7b97\u8bb0\u5f55\u5c06\u7ec8\u6b62\u8ba1\u7b97\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CalProgressPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMap);
        } else if (SWCStringUtils.equals((String)args.getOperateKey(), (String)OK)) {
            Button btnRefresh;
            this.getView().close();
            if (this.getView().getParentView() != null && (btnRefresh = (Button)this.getView().getParentView().getControl("refresh")) != null) {
                btnRefresh.click();
                this.getView().sendFormAction(this.getView().getParentView());
            }
        } else if (SWCStringUtils.equals((String)args.getOperateKey(), (String)MINISIZE)) {
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        String callBackId = event.getCallBackId();
        if (SWCStringUtils.equals((String)CANCELCAL, (String)callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Long calRecordId = (Long)parameter.getCustomParam("calRecordId");
            Long calTaskId = (Long)parameter.getCustomParam("calTaskId");
            CalTableCalService calService = new CalTableCalService();
            try {
                Map resultMap = calService.cancelCal(calRecordId, calTaskId);
                if (resultMap != null && resultMap.size() > 0) {
                    this.getView().showErrorNotification((String)resultMap.get("msg"));
                    return;
                }
            }
            catch (Exception e) {
                logger.error("cancelCal error", (Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
            this.getPageCache().put("cachekey_startpropgress", "false");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (SWCStringUtils.equals((String)operate.getOperateKey(), (String)VIEWHIS)) {
            Button btnRefresh;
            if (!this.checkIsHasButtonPerssion(operate)) {
                this.getView().showErrorNotification(SWCPermissionServiceHelper.getNoPermTips((String)operate.getOperateName().getLocaleValue()));
                args.setCancel(true);
                return;
            }
            this.getView().close();
            if (this.getView().getParentView() != null && (btnRefresh = (Button)this.getView().getParentView().getControl("refresh")) != null) {
                btnRefresh.click();
                this.getView().sendFormAction(this.getView().getParentView());
            }
            this.openCalReportDetail();
        } else if (SWCStringUtils.equals((String)operate.getOperateKey(), (String)DO_NOTHING_VIEW_CAL_RESULT)) {
            Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
            DynamicObjectCollection calResultTplInfos = SalaryDetailResultListHelper.getCalResultTplInfo((Long)calTaskId);
            if (calResultTplInfos.size() == 1) {
                DynamicObject firstObj = (DynamicObject)calResultTplInfos.get(0);
                if (SWCObjectUtils.isEmpty((Object)firstObj)) {
                    return;
                }
                Long calResultTplId = firstObj.getLong("id");
                this.openCalResultPage(calResultTplId, calTaskId);
                return;
            }
            ListShowParameter listShowParameter = SalaryDetailResultListHelper.openCalResultTplPage((Long)calTaskId, (DynamicObjectCollection)calResultTplInfos);
            if (listShowParameter == null) {
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u8d44\u6838\u7b97\u7ec4\u672a\u8bbe\u7f6e\u85aa\u8d44\u660e\u7ec6\u7ed3\u679c\u6a21\u677f\u3002", (String)"HSASCalResultDetailPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                args.setCancel(true);
                return;
            }
            ListView parentListView = (ListView)this.getView().getParentView();
            String parentBillFormId = parentListView.getBillFormId();
            this.setCloseCallBack(calTaskId, listShowParameter, parentBillFormId, (IFormView)parentListView);
            this.getView().getParentView().showForm((FormShowParameter)listShowParameter);
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        } else if (SWCStringUtils.equals((String)operate.getOperateKey(), (String)DO_NOTHING_VIEW_CAL_REQUEST)) {
            CalProcessHandler.openRequestList((IFormView)this.getView());
        }
    }

    private void setCloseCallBack(Long calTaskId, ListShowParameter listShowParameter, String parentBillFormId, IFormView view) {
        if (SWCStringUtils.equals((String)parentBillFormId, (String)"hsas_calperson")) {
            listShowParameter.setCloseCallBack(new CloseCallBack("kd.swc.hsas.formplugin.web.calpersonlist.CalPersonCalOperateList", "closecaldetailpage"));
        } else if (SWCStringUtils.equals((String)parentBillFormId, (String)"hsas_calpayrolltask")) {
            SWCPageCache parentPageCache = new SWCPageCache(view);
            parentPageCache.put(view.getPageId() + "_cacheCalTaskId", (Object)calTaskId);
            listShowParameter.setCloseCallBack(new CloseCallBack("kd.swc.hsas.formplugin.web.guide.CalPayrollTaskCalList", "closecaldetailpage"));
        } else if (SWCStringUtils.equals((String)parentBillFormId, (String)"hsas_calrequest")) {
            SWCPageCache parentPageCache = new SWCPageCache(view);
            parentPageCache.put(view.getPageId() + "_cacheCalTaskId", (Object)calTaskId);
            listShowParameter.setCloseCallBack(new CloseCallBack("kd.swc.hsas.formplugin.web.cal.calrequest.CalRequestList", "closecaldetailpage"));
        }
    }

    private void openCalResultPage(Long calResultTplId, Long calTaskId) {
        FormShowParameter formShowParameter = SalaryDetailResultListHelper.openCalResultDetailPage((Long)calResultTplId, (Long)calTaskId, (String)this.getView().getPageId());
        if (formShowParameter == null) {
            return;
        }
        if (CalProcessHandler.isParentRequestList((IFormView)this.getView())) {
            CalProcessHandler.grandfatherShow((IFormView)this.getView(), (FormShowParameter)formShowParameter);
            return;
        }
        this.getView().getParentView().showForm(formShowParameter);
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }

    private void openCalReportDetail() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long calRecordId = (Long)parameter.getCustomParam("calRecordId");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calreport");
        showParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a", (String)"CalRecordListPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("calReportId", (Object)calRecordId);
        if (CalProcessHandler.isParentRequestList((IFormView)this.getView())) {
            CalProcessHandler.grandfatherShow((IFormView)this.getView(), (FormShowParameter)showParameter);
            return;
        }
        this.getView().getParentView().showForm(showParameter);
        this.getView().sendFormAction(this.getView().getParentView());
        this.toBackground();
    }

    private String getCalTime(String startTime) {
        Date date;
        try {
            date = SWCDateTimeUtils.parseDate((String)startTime, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            logger.error("parse date error");
            date = new Date();
        }
        return SWCDateTimeUtils.getConsumeTime((Date)date);
    }

    public void onProgress(ProgressEvent evt) {
        String progressKey;
        String startProgress = this.getPageCache().get("cachekey_startpropgress");
        Control control = (Control)evt.getSource();
        switch (progressKey = control.getKey()) {
            case "pretaxcalprogress": 
            case "taxcalprogress": 
            case "aftertaxcalprogress": {
                this.queryAndSetProgressDetails(evt, startProgress, progressKey);
                break;
            }
        }
    }

    private void queryAndSetProgressDetails(ProgressEvent evt, String startProgress, String progressKey) {
        String cacheKey;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String startTiem = (String)parameter.getCustomParam("starttime");
        Long calRecordId = (Long)parameter.getCustomParam("calRecordId");
        Long calTaskId = (Long)parameter.getCustomParam("calTaskId");
        Integer calCount = (Integer)parameter.getCustomParam("calCount");
        String calTaskName = (String)parameter.getCustomParam("calTaskName");
        ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", calRecordId));
        Map progressMap = (Map)calProgressAppCache.get(cacheKey = this.getProgressCacheKey(progressKey, calRecordId), Map.class);
        if (progressMap == null) {
            progressMap = FormulaCacheUtils.getCalProgerssFromPage((long)calRecordId, (String)cacheKey);
        }
        Integer sucessCount = 0;
        Integer failCount = 0;
        Integer onlyPreCalCount = 0;
        if (null != progressMap && progressMap.size() > 0) {
            sucessCount = (Integer)progressMap.get("sucesscount");
            failCount = (Integer)progressMap.get("failcount");
            onlyPreCalCount = (Integer)progressMap.get("onlyPreCalCount");
        }
        Integer pendingCount = calCount - sucessCount - failCount;
        Integer caledCount = sucessCount + failCount + onlyPreCalCount;
        String consumerTime = this.getCalTime(startTiem);
        this.setText(KEY_CONSUMETIMELABE, ResManager.loadKDString((String)"\uff08\u8017\u65f6\uff1a{0}\uff09", (String)"CalProgressPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[]{consumerTime}));
        this.setCount(progressKey, sucessCount.toString(), failCount.toString(), pendingCount.toString(), startTiem);
        Label percentLabel = this.getPercentLabel(progressKey);
        int progressPercent = this.setProgress(evt, new BigDecimal(calCount.toString()), new BigDecimal(caledCount.toString()), percentLabel);
        if (progressPercent == 100) {
            CalProcessHandler.changeGreenProgressColor((IFormView)this.getView(), (String)progressKey);
        }
        if (StringUtils.equals((CharSequence)"false", (CharSequence)startProgress)) {
            ProgressBar saveprogress = (ProgressBar)this.getControl(progressKey);
            saveprogress.stop();
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CANCELCAL, KEY_ONCALAP, KEY_VIEWCALREQUEST, KEY_BTNOK, KEY_PROGRESSAP});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_SOTPREMINDAP, KEY_BUTTONCLOSE});
        } else if (progressPercent == 100 && SWCStringUtils.equals((String)progressKey, (String)AFTERTAXCALPROGRESS)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CANCELCAL, KEY_ONCALAP, KEY_REMINDAP, KEY_VIEWCALREQUEST, KEY_BTNOK});
            this.getView().setVisible(Boolean.TRUE, new String[]{VIEW_CAL_RESULT, KEY_AFTERCALAP, KEY_BUTTONCLOSE});
            sucessCount = sucessCount + onlyPreCalCount;
            this.setCalResultDetail(calTaskId, calCount, calTaskName, sucessCount, failCount, progressPercent);
            ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "hscs_salarycalcache_%d", calRecordId));
            appCache.clear();
        }
    }

    private String getProgressCacheKey(String progressKey, Long recordId) {
        String cacheKey = null;
        switch (progressKey) {
            case "aftertaxcalprogress": {
                cacheKey = String.format(Locale.ROOT, "calrecord_progress_%s", recordId);
                break;
            }
            case "pretaxcalprogress": {
                cacheKey = String.format(Locale.ROOT, "pretax_cal_progress_%s", recordId);
                break;
            }
            case "taxcalprogress": {
                cacheKey = String.format(Locale.ROOT, "tax_cal_progress_%s", recordId);
                break;
            }
        }
        return cacheKey;
    }

    private void setCount(String progressKey, String successCount, String failCount, String pendingCount, String startTiem) {
        switch (progressKey) {
            case "pretaxcalprogress": {
                this.setPreCalCount(successCount, failCount, pendingCount);
                break;
            }
            case "taxcalprogress": {
                this.setTaxCalCount(successCount, failCount, pendingCount);
                break;
            }
            case "aftertaxcalprogress": {
                this.setAfterCalCount(successCount, failCount, pendingCount);
                break;
            }
        }
    }

    private void setPreCalCount(String successCount, String failCount, String pendingCount) {
        Label saveSuccLabel = (Label)this.getView().getControl("precalsucccount");
        Label saveFailLabel = (Label)this.getView().getControl("precalfailcount");
        Label savePendingLabel = (Label)this.getView().getControl("precaltodocount");
        saveSuccLabel.setText(successCount);
        saveFailLabel.setText(failCount);
        savePendingLabel.setText(pendingCount);
    }

    private void setTaxCalCount(String successCount, String failCount, String pendingCount) {
        Label saveSuccLabel = (Label)this.getView().getControl("taxcalsucccount");
        Label saveFailLabel = (Label)this.getView().getControl("taxcalfailcount");
        Label savePendingLabel = (Label)this.getView().getControl("taxcaltodocount");
        saveSuccLabel.setText(successCount);
        saveFailLabel.setText(failCount);
        savePendingLabel.setText(pendingCount);
    }

    private void setAfterCalCount(String successCount, String failCount, String pendingCount) {
        Label saveSuccLabel = (Label)this.getView().getControl("aftercalsucccount");
        Label saveFailLabel = (Label)this.getView().getControl("aftercalfailcount");
        Label savePendingLabel = (Label)this.getView().getControl("aftercaltodocount");
        saveSuccLabel.setText(successCount);
        saveFailLabel.setText(failCount);
        savePendingLabel.setText(pendingCount);
    }

    private Label getPercentLabel(String progressKey) {
        Label percentLabel = null;
        switch (progressKey) {
            case "pretaxcalprogress": {
                percentLabel = (Label)this.getControl("precalpercent");
                break;
            }
            case "taxcalprogress": {
                percentLabel = (Label)this.getControl("taxcalpercent");
                break;
            }
            case "aftertaxcalprogress": {
                percentLabel = (Label)this.getControl("aftercalpercent");
                break;
            }
        }
        return percentLabel;
    }

    private void setCalResultDetail(Long calTaskId, Integer tatolCount, String calTaskName, int saveSucesscount, int saveFailcount, int calProgressPercent) {
        HSASCalListHelper calListHelper = new HSASCalListHelper();
        DynamicObject taskInfo = calListHelper.getTaskInfo(calTaskId);
        Date payRollDate = taskInfo.getDate("payrolldate");
        String payRollDateStr = SWCDateTimeUtils.formatDate((Date)payRollDate);
        String year = payRollDateStr.split("-")[0];
        String month = payRollDateStr.split("-")[1];
        int calCount = taskInfo.getInt("calcount");
    }

    private Integer setProgress(ProgressEvent evt, BigDecimal calCount, BigDecimal caledCount, Label percentLabel) {
        StringBuilder calText = new StringBuilder();
        Integer calProgressPercent = this.calProgress(caledCount, calCount);
        evt.setProgress(calProgressPercent.intValue());
        calText.append(calProgressPercent).append('%');
        percentLabel.setText(calText.toString());
        return calProgressPercent;
    }

    private void setCalInfo(int calCount, int calTimes) {
        this.setText("caltaskname", (String)this.getView().getFormShowParameter().getCustomParam("calTaskName"));
        this.setText("countlabel", ResManager.loadKDString((String)"\u5171{0}\u6761\u6838\u7b97\u8bb0\u5f55", (String)"CalProgressPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[]{calCount}));
        this.setText("caltimeslabel", ResManager.loadKDString((String)"\uff08\u7b2c{0}\u6b21\u8ba1\u7b97\uff09", (String)"CalProgressPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[]{calTimes}));
    }

    private void setText(String key, String text) {
        Label control = (Label)this.getControl(key);
        if (control != null) {
            control.setText(text);
        }
    }

    private int calProgress(BigDecimal caledCount, BigDecimal calCount) {
        if (caledCount.compareTo(calCount) == 0) {
            return 100;
        }
        if (BigDecimal.ZERO.compareTo(caledCount) == 0) {
            return 0;
        }
        BigDecimal progress = caledCount.divide(calCount, 2, 4).multiply(new BigDecimal("100"));
        if (progress.intValue() == 100 && caledCount.compareTo(calCount) != 0) {
            return 99;
        }
        return progress.intValue();
    }

    private int countCalTimes(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrecord");
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        filter.and("optype", "=", (Object)"1");
        int count = helper.count(new QFilter[]{filter});
        return count;
    }

    private boolean checkIsHasButtonPerssion(FormOperate operate) {
        boolean isHasPerssion = true;
        switch (operate.getOperateKey()) {
            case "donothing_viewhis": {
                isHasPerssion = SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)PERMITEMID);
                break;
            }
        }
        return isHasPerssion;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.toBackground();
    }

    private void toBackground() {
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        Long calRecordId = (Long)this.getView().getFormShowParameter().getCustomParam("calRecordId");
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calTaskIdCondition = new QFilter("caltask", "=", (Object)calTaskId);
        QFilter stateCondition = new QFilter("calstatus", "=", (Object)CALSTATE_CALING);
        int count = calPersonHelper.count(new QFilter[]{calTaskIdCondition, stateCondition});
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", calRecordId));
        JobFormInfo jobFormInfo = (JobFormInfo)appCache.get(String.format(Locale.ROOT, "platformTaskInfo_%s", calRecordId), JobFormInfo.class);
        Object openTaxCal = this.getView().getFormShowParameter().getCustomParam("openTaxCal");
        boolean enableTax = openTaxCal != null ? ((Boolean)BaseDataConverter.convert((Object)openTaxCal, Boolean.class)).booleanValue() : TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)calTaskId).booleanValue();
        Integer pendingCount = this.getPendingCount(calRecordId);
        Boolean isCancel = (Boolean)appCache.get(String.format(Locale.ROOT, "isCancel_%s", String.valueOf(calRecordId)), Boolean.class);
        if (count <= 0 && enableTax || pendingCount <= 0 || isCancel != null && isCancel.booleanValue()) {
            if (jobFormInfo != null) {
                appCache.remove(String.format(Locale.ROOT, "platformTaskInfo_%s", calRecordId));
                TaskRecordHelper.delTask((String)jobFormInfo.getJobInfo().getTaskId(), (JobFormInfo)jobFormInfo, null);
            }
        } else if (jobFormInfo == null) {
            this.dispatchTask(this.getView().getFormShowParameter().getCustomParams());
        }
    }

    private Integer getPendingCount(Long calRecordId) {
        Integer calCount = (Integer)this.getView().getFormShowParameter().getCustomParam("calCount");
        ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", calRecordId));
        Map progressMap = (Map)calProgressAppCache.get(String.format(Locale.ROOT, "calrecord_progress_%s", calRecordId), Map.class);
        Integer sucessCount = 0;
        Integer failCount = 0;
        Integer onlyPreCalCount = 0;
        if (null != progressMap && progressMap.size() > 0) {
            sucessCount = (Integer)progressMap.get("sucesscount");
            failCount = (Integer)progressMap.get("failcount");
            onlyPreCalCount = (Integer)progressMap.get("onlyPreCalCount");
        }
        Integer pendingCount = calCount - sucessCount - failCount - onlyPreCalCount;
        return pendingCount;
    }

    private JobFormInfo dispatchTask(Map<String, Object> data) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.putAll(data);
        params.put("calRecordId", data.get("calRecordId"));
        params.put("calCount", data.get("calCount"));
        params.put("parentpageid", this.getView().getFormShowParameter().getParentPageId());
        HRBackgroundTaskHelper instance = HRBackgroundTaskHelper.getInstance();
        String taskName = (String)this.getView().getFormShowParameter().getCustomParam("calTaskName");
        String bgTaskId = instance.createBaskgroundTask("swc_hsas_cal", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97(%s)", (String)"HSASCalTableListCalPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]), taskName), true, this.getView().getMainView().getPageId(), this.getView().getParentView().getPageId(), params);
        instance.showBaskgroundTask(bgTaskId);
        JobFormInfo jobFormInfo = instance.getJobFormInfoByTaskId(bgTaskId);
        Long calRecordId = (Long)data.get("calRecordId");
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", calRecordId));
        params.put("calTimes", this.getView().getFormShowParameter().getCustomParam("calTimes"));
        params.put("calTaskName", this.getView().getFormShowParameter().getCustomParam("calTaskName"));
        appCache.put(String.format(Locale.ROOT, CAL_INFO, bgTaskId), params);
        appCache.put(String.format(Locale.ROOT, "platformTaskInfo_%s", calRecordId), (Object)jobFormInfo);
        return jobFormInfo;
    }
}

