/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsbp.business.addperson.entity.CalPersonAddProgressInfo;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.proration.HandleProrationHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.CalPersonLockEnum;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ExcCalPersonF7List
extends AbstractListPlugin
implements ItemClickListener {
    private static final Log logger = LogFactory.getLog(ExcCalPersonF7List.class);
    private static final String ADDCALPERSON = "addcalperson";
    private static final String BILLLISTAP = "billlistap";
    private static final String EMPTYAP = "emptyap";

    public void setFilter(SetFilterEvent e) {
        Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        List list = e.getQFilters();
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject task = taskHelper.queryOriginalOne("id,islimitadd,tasktype,payrollgroup.id", (Object)payrolltaskId);
        List fileIdsByTask = CalPersonHelper.getFileIdsByTask((Long)payrolltaskId);
        QFilter fileIdsByTaskFilter = new QFilter("boid", "not in", (Object)fileIdsByTask);
        QFilter dateRangeFilter = new QFilter("payrollgroup", "=", (Object)task.getLong("payrollgroup.id"));
        if (task.getBoolean("islimitadd")) {
            dateRangeFilter.and("boid", "in", (Object)CalPersonHelper.getSamePeriodFileIdsByTask((Long)task.getLong("id")));
        }
        BaseDataHisHelper.addHisCurrFilter((QFilter)dateRangeFilter);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"47150e89000000ac");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (authorizedDataRuleQFilter == null) {
            list.add(new QFilter("1", "=", (Object)2));
        } else if (!authorizedDataRuleQFilter.isEmpty()) {
            list.addAll(authorizedDataRuleQFilter);
        }
        list.add(dateRangeFilter);
        list.add(fileIdsByTaskFilter);
        list.add(statusFilter);
        FilterContainer filtercontainerap = (FilterContainer)this.getControl("filtercontainerap");
        FilterKeyValueCollections fastFilterValues = filtercontainerap.getCachedFilterValues().getFastFilterValues();
        List filterValuesList = fastFilterValues.createFilterValuesList();
        if (CollectionUtils.isEmpty((Collection)filterValuesList)) {
            list.add(new QFilter("1", "=", (Object)2));
            this.getView().setVisible(Boolean.FALSE, new String[]{BILLLISTAP});
            this.getView().setVisible(Boolean.TRUE, new String[]{EMPTYAP});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BILLLISTAP});
            this.getView().setVisible(Boolean.FALSE, new String[]{EMPTYAP});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        args.setCancel(true);
        FormOperate fo = (FormOperate)args.getSource();
        String operateKey = fo.getOperateKey();
        if (ADDCALPERSON.equals(operateKey)) {
            if (!SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"hsas_calperson", (String)"2ITLQ+70M1IZ")) {
                this.getView().showErrorNotification(SWCPermissionServiceHelper.getNoPermTips((String)ResManager.loadKDString((String)"\u6838\u7b97\u540d\u5355", (String)"ExcCalPersonF7List_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6dfb\u52a0\u6838\u7b97\u4eba\u5458", (String)"ExcCalPersonF7List_5", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
                return;
            }
            Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
            DynamicObject taskDy = CalPayrollTaskHelper.queryTaskInfoById((Long)payrolltaskId);
            if (taskDy == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u53ef\u80fd\u88ab\u5220\u9664,\u8bf7\u68c0\u67e5\u3002", (String)"CalPersonF7List_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (CalPayrollTaskStateEnum.APPROVALED.getCode().equals(taskDy.getString("taskstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u5df2\u5ba1\u6279\u901a\u8fc7\uff0c\u65e0\u6cd5\u6dfb\u52a0\u6838\u7b97\u4eba\u5458\u3002", (String)"CalPersonF7List_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            logger.info("\u6dfb\u52a0\u6838\u7b97\u4eba\u5458\u5f00\u59cb\u65f6\u95f4:{}", (Object)SWCDateTimeUtils.format((Date)new Date()));
            String errorCode = CalPersonHelper.checkLock((Long)payrolltaskId);
            if (SWCStringUtils.isNotEmpty((String)errorCode)) {
                this.getView().showErrorNotification(CalPersonLockEnum.getDesc((String)errorCode));
                return;
            }
            ListSelectedRowCollection rows = this.getSelectedRows();
            List<Long> ids = rows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            CalPersonAddProgressInfo progress = new CalPersonAddProgressInfo();
            progress.setTotal(ids.size());
            progress.setRemain(ids.size());
            progress.setStartDate(new Date());
            progress.setStatus(0);
            progress.setFileIds(ids);
            if ("0".equals(taskDy.getString("tasktype"))) {
                this.filterAlreadyAddPerson(payrolltaskId, ids, progress);
            } else if ("1".equals(taskDy.getString("tasktype")) && taskDy.getBoolean("islimitadd")) {
                this.filterCommonNotAddPerson(payrolltaskId, ids, progress);
            }
            ids = this.filterOnHold(taskDy.getDate("startdate"), taskDy.getDate("enddate"), ids, progress);
            List<Long> fileVids = this.getEXCFileVids(taskDy, ids, progress);
            SWCAppCache.get((String)"hsas").put(String.format(Locale.ROOT, "cache_addperson_key_%s", payrolltaskId), (Object)progress);
            errorCode = (String)SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"ICalPersonService", (String)"addCalPerson", (Object[])new Object[]{payrolltaskId, fileVids, Boolean.TRUE});
            if (SWCStringUtils.isNotEmpty((String)errorCode)) {
                this.getView().showErrorNotification(CalPersonLockEnum.getDesc((String)errorCode));
                return;
            }
            CalPersonHelper.showAddPersonProgress((Long)payrolltaskId, (String)taskDy.getString("name"), (IFormView)this.getView().getParentView(), (boolean)false, (boolean)true);
            this.getPageCache().put("isAdd", Boolean.TRUE.toString());
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    private void filterAlreadyAddPerson(Long payrolltaskId, List<Long> ids, CalPersonAddProgressInfo progress) {
        List fileIdsByTask = CalPersonHelper.getSamePeriodFileIdsByTask((Long)payrolltaskId);
        List existList = ids.stream().filter(fileIdsByTask::contains).collect(Collectors.toList());
        ids.removeAll(existList);
        for (Long fileId : existList) {
            progress.getFailMap().put(fileId, ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u7c7b\u578b\u4e0d\u53ef\u6dfb\u52a0\u6b64\u6863\u6848\u3002", (String)"ExcCalPersonF7List_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    private void filterCommonNotAddPerson(Long payrolltaskId, List<Long> ids, CalPersonAddProgressInfo progress) {
        List fileIdsByTask = CalPersonHelper.getSamePeriodFileIdsByTask((Long)payrolltaskId);
        List notExistList = ids.stream().filter(o -> !fileIdsByTask.contains(o)).collect(Collectors.toList());
        ids.removeAll(notExistList);
        for (Long fileId : notExistList) {
            progress.getFailMap().put(fileId, ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u7c7b\u578b\u4e0d\u53ef\u6dfb\u52a0\u6b64\u6863\u6848\u3002", (String)"ExcCalPersonF7List_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Long> filterOnHold(Date taskStartDate, Date taskEndDate, List<Long> fileIds, CalPersonAddProgressInfo progress) {
        HashSet<Long> retSalaryFileIdSet = new HashSet<Long>(fileIds.size());
        SWCDataServiceHelper onHoldFileHelper = new SWCDataServiceHelper("hsas_onholdfile");
        QFilter filter = new QFilter("salaryfile.id", "in", fileIds);
        DynamicObjectCollection onHoldFileDyArr = onHoldFileHelper.queryOriginalCollection("salaryfile.id,status,startdate,isallowcal", filter.toArray(), "createtime asc");
        if (onHoldFileDyArr == null || onHoldFileDyArr.size() == 0) {
            return fileIds;
        }
        HashMap<Long, ArrayList<DynamicObject>> onHoldMap = new HashMap<Long, ArrayList<DynamicObject>>(16);
        for (DynamicObject onHoldFileObj : onHoldFileDyArr) {
            Long salaryFileId = onHoldFileObj.getLong("salaryfile.id");
            ArrayList<DynamicObject> onHoldFileList = (ArrayList<DynamicObject>)onHoldMap.get(salaryFileId);
            if (onHoldFileList == null) {
                onHoldFileList = new ArrayList<DynamicObject>(10);
            }
            onHoldFileList.add(onHoldFileObj);
            onHoldMap.put(salaryFileId, onHoldFileList);
        }
        for (Long salaryFileId : fileIds) {
            List onHoldFileList = (List)onHoldMap.get(salaryFileId);
            if (onHoldFileList == null || onHoldFileList.size() == 0) {
                retSalaryFileIdSet.add(salaryFileId);
                continue;
            }
            for (DynamicObject onHoldFileObj : onHoldFileList) {
                Date startDate;
                String isAllowCal = onHoldFileObj.getString("isallowcal");
                if (SWCStringUtils.equals((String)isAllowCal, (String)"1")) {
                    retSalaryFileIdSet.add(salaryFileId);
                    continue;
                }
                String status = onHoldFileObj.getString("status");
                if (SWCStringUtils.equals((String)status, (String)" ") || SWCStringUtils.equals((String)status, (String)String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()))) {
                    retSalaryFileIdSet.add(salaryFileId);
                    continue;
                }
                if (!SWCStringUtils.equals((String)status, (String)String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode())) && !SWCStringUtils.equals((String)status, (String)String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode())) && !SWCStringUtils.equals((String)status, (String)String.valueOf(OnHoldStatusEnum.STATUS_TOPAY.getCode())) || (startDate = onHoldFileObj.getDate("startdate")) == null) continue;
                startDate = HandleProrationHelper.replaceDateTime((Date)startDate, (String)"23:59:59");
                taskEndDate = HandleProrationHelper.replaceDateTime((Date)taskEndDate, (String)"23:59:59");
                if (startDate.getTime() > taskEndDate.getTime()) {
                    retSalaryFileIdSet.add(salaryFileId);
                    continue;
                }
                retSalaryFileIdSet.remove(salaryFileId);
            }
        }
        for (Long salaryFileId : fileIds) {
            if (retSalaryFileIdSet.contains(salaryFileId)) continue;
            progress.getFailMap().put(salaryFileId, ResManager.loadKDString((String)"\u6863\u6848\u5df2\u88ab\u505c\u7f13\u53d1\u3002", (String)"ExcCalPersonF7List_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        progress.setFail(progress.getFailMap().size());
        progress.setFinish(progress.getFailMap().size());
        progress.setRemain(progress.getTotal() - progress.getSuccess() - progress.getFail());
        return new ArrayList<Long>(retSalaryFileIdSet);
    }

    private List<Long> getEXCFileVids(DynamicObject taskDy, List<Long> ids, CalPersonAddProgressInfo progress) {
        SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("boid", "in", ids);
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        filter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        filter.and("paystatus", "=", (Object)"1");
        filter.and("salaryfile.status", "=", (Object)"C");
        filter.and(ExcCalPersonF7List.getDateFilter(taskDy.getDate("startdate"), taskDy.getDate("enddate")));
        HashSet<Long> fileIds = new HashSet<Long>(ids.size());
        ArrayList<Long> fileVids = new ArrayList<Long>(ids.size());
        DataSet dataSet = fileHelper.queryDataSet("getSalaryFileVid", "id,boid,bsed", filter.toArray(), "boid asc,bsed desc");
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (!fileIds.add(row.getLong("boid"))) continue;
            fileVids.add(row.getLong("id"));
        }
        ids.removeAll(fileIds);
        for (Long id : ids) {
            progress.getFailMap().put(id, ResManager.loadKDString((String)"\u65e0\u7b26\u5408\u6dfb\u52a0\u6761\u4ef6\u7684\u6863\u6848\u7248\u672c\u3002", (String)"ExcCalPersonF7List_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        progress.setFail(progress.getFailMap().size());
        progress.setFinish(progress.getFailMap().size());
        progress.setRemain(progress.getTotal() - progress.getSuccess() - progress.getFail());
        return fileVids;
    }

    private static QFilter getDateFilter(Date startDate, Date endDate) {
        QFilter brledFilter = new QFilter("bsled", ">=", (Object)startDate);
        QFilter filter = new QFilter("bsed", "<=", (Object)endDate);
        brledFilter.or(QFilter.isNull((String)"bsled"));
        filter.and(brledFilter);
        return filter;
    }

    public void pageRelease(EventObject e) {
        if (SWCStringUtils.isEmpty((String)this.getPageCache().get("isAdd"))) {
            Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(payrolltaskId), (String)CalPersonOperationEnum.OP_ADDEXCCALPERSON.getOperationKey());
        }
        super.pageRelease(e);
    }
}

