/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsas.formplugin.web.guide.AbstractCalPersonList;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class HSASCalTableListApproveBillPlugin
extends AbstractCalPersonList {
    private static final Log LOGGER = LogFactory.getLog(HSASCalTableListApproveBillPlugin.class);

    @Override
    protected List<CalPersonOperationEnum> operationKey() {
        ArrayList<CalPersonOperationEnum> calPersonOperationEnums = new ArrayList<CalPersonOperationEnum>();
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_CREATEAPPROVE);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_SHOWAPPROVEDETAIL);
        return calPersonOperationEnums;
    }

    @Override
    protected boolean isSelectData() {
        switch (this.calPersonOperationEnum) {
            case OP_SHOWAPPROVEDETAIL: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        FormOperate formOperate = (FormOperate)args.getSource();
        Long taskId = calPayRollTask.getCalPayRollTaskId();
        if (taskId != null && taskId > 0L) {
            switch (this.calPersonOperationEnum) {
                case OP_SHOWAPPROVEDETAIL: 
                case OP_CREATEAPPROVE: {
                    boolean calapprove;
                    SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
                    DynamicObject schemeAfterCalObj = sceneService.getAfterCalObjByTask(taskId);
                    if (schemeAfterCalObj == null || (calapprove = schemeAfterCalObj.getBoolean("calapprove"))) break;
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u7684\u6838\u7b97\u540e\u5904\u7406\u65b9\u6848{0}\u4e2d\u672a\u542f\u7528\u85aa\u8d44\u5ba1\u6279\u4e1a\u52a1\u3002", (String)"CalPayRollTaskApproveBillList_4", (String)"swc-hsas-formplugin", (Object[])new Object[]{schemeAfterCalObj.getString("number")}));
                    return;
                }
            }
        }
        switch (this.calPersonOperationEnum) {
            case OP_CREATEAPPROVE: {
                OperateOption option = formOperate.getOption();
                if (option.tryGetVariableValue("CallBackInvoke", new RefObject())) break;
                this.dealCreateApproveInfo(calPayRollTask);
                break;
            }
            case OP_SHOWAPPROVEDETAIL: {
                this.showApproveDetail(calPayRollTask);
                break;
            }
        }
    }

    private void dealCreateApproveInfo(CalPayRollTask calPayRollTask) {
        HashSet<String> calPersonOnHoldSet = new HashSet<String>(16);
        Map<String, String> calPersonCalTableMap = this.isHaveValidData(calPayRollTask, calPersonOnHoldSet);
        if (calPersonCalTableMap.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u53ef\u5bf9\u6838\u7b97\u72b6\u6001\u4e3a\u201c\u5ba1\u6279\u4e0d\u901a\u8fc7\u201d\u6216\u201c\u5df2\u5ba1\u6838\u201d\u3001\u505c\u7f13\u53d1\u72b6\u6001\u4e3a\u7a7a\u6216\u201c\u5df2\u89e3\u85aa\u201d\u3001\u4e14\u6863\u6848\u672a\u5e9f\u5f03\u7684\u6838\u7b97\u8bb0\u5f55\u64cd\u4f5c\u751f\u6210\u5ba1\u6279\u5355\u3002", (String)"HSASCalTableListApproveBillPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return;
        }
        calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
        this.openApproveView(calPayRollTask, calPersonCalTableMap, calPersonOnHoldSet);
    }

    private Map<String, String> isHaveValidData(CalPayRollTask calPayRollTask, Set<String> calPersonOnHoldSet) {
        List calPersons = calPayRollTask.getCalPersons();
        QFilter filter = new QFilter("id", "in", (Object)calPersons);
        filter.and("salaryfile.status", "!=", (Object)"E");
        QFilter filterStatus = new QFilter("calstatus", "in", Arrays.asList(CalStateEnum.AUDIT.getCode(), CalStateEnum.APPROVALED_NOT_PASS.getCode()));
        filterStatus.and("onholdstatus", "not in", Collections.singletonList(String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode())));
        filter.and(filterStatus);
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObjectCollection calPersonCol = calPersonHelper.queryOriginalCollection("id,calresultid,onholdstatus", new QFilter[]{filter});
        HashMap<String, String> calPersonCalTableMap = new HashMap<String, String>(calPersonCol.size());
        for (DynamicObject calPerson : calPersonCol) {
            calPersonCalTableMap.put(calPerson.getString("id"), calPerson.getString("calresultid"));
            if (!SWCStringUtils.equals((String)String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode()), (String)calPerson.getString("onholdstatus"))) continue;
            calPersonOnHoldSet.add(calPerson.getString("id"));
        }
        return calPersonCalTableMap;
    }

    private void openApproveView(CalPayRollTask calPayRollTask, Map<String, String> calPersonCalTableMap, Set<String> calPersonOnHoldSet) {
        FormShowParameter show = new FormShowParameter();
        show.setFormId("hsas_calviewapprovebill");
        show.getOpenStyle().setShowType(ShowType.Modal);
        show.setShowTitle(false);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("totalSize", (Object)calPayRollTask.getCalPersons().size());
        show.setCustomParam("calPersonCalTableMap", calPersonCalTableMap);
        show.setCustomParam("calPersonOnHoldSet", (Object)JSON.toJSONString(calPersonOnHoldSet));
        show.setCustomParam("calTaskId", (Object)calPayRollTask.getCalPayRollTaskId().toString());
        DynamicObject calTaskInfo = this.getCalTaskInfo(calPayRollTask.getCalPayRollTaskId(), "org.id,org.name,payrollgroup,calrulev.id");
        show.setCustomParam("payrollgroupId", (Object)calTaskInfo.getLong("payrollgroup.id"));
        show.setCustomParam("orgName", (Object)calTaskInfo.getString("org.name"));
        show.setCustomParam("orgId", (Object)calTaskInfo.getLong("org.id"));
        show.setCustomParam("calRuleVid", (Object)calTaskInfo.getString("calrulev.id"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "calapproveviewclose");
        show.setCloseCallBack(closeCallBack);
        this.getView().showForm(show);
        Map operationParam = calPayRollTask.getOperationParam();
        operationParam.put("orgId", String.valueOf(calTaskInfo.getLong("org.id")));
        operationParam.put("payrollgroupId", String.valueOf(calTaskInfo.getLong("payrollgroup.id")));
        operationParam.put("orgName", calTaskInfo.getString("org.name"));
        operationParam.put("pageId", show.getPageId());
        operationParam.put("taskId", String.valueOf(calPayRollTask.getCalPayRollTaskId()));
    }

    private void showApproveDetail(CalPayRollTask calPayRollTask) {
        if (!SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_approvebill", (String)"47150e89000000ac")) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u85aa\u8d44\u5ba1\u6279\u5355\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"CalPayRollTaskApproveBillList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        Long calTaskId = calPayRollTask.getCalPayRollTaskId();
        ListShowParameter show = new ListShowParameter();
        show.setBillFormId("hsas_approvebill");
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        List calPersons = calPayRollTask.getCalPersons();
        if (calPersons == null || calPersons.size() < 1) {
            SWCDataServiceHelper approveHelper = new SWCDataServiceHelper("hsas_approvebill");
            QFilter filter = new QFilter("caltasks.fbasedataid_id", "=", (Object)calTaskId);
            if (approveHelper.count(new QFilter[]{filter}) == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u672a\u751f\u6210\u5ba1\u6279\u5355\uff0c\u65e0\u53ef\u67e5\u8be2\u6570\u636e\u3002", (String)"HSASCalTableListApproveBillPlugin_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            show.setCustomParam("calTaskId", (Object)calTaskId);
            show.setCustomParam("defaultTaskNumbers", Collections.singletonList(calPayRollTask.getNumber()));
            this.getView().showForm((FormShowParameter)show);
            return;
        }
        Set<Long> calApproveIdSet = this.getApproveIdSet(calPersons);
        if (calApproveIdSet.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u8bb0\u5f55\u672a\u751f\u6210\u5ba1\u6279\u5355\uff0c\u65e0\u53ef\u67e5\u8be2\u6570\u636e\u3002", (String)"HSASCalTableListApproveBillPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter calApproveIdFilter = new QFilter("id", "in", calApproveIdSet);
        show.getListFilterParameter().setFilter(calApproveIdFilter);
        this.getView().showForm((FormShowParameter)show);
    }

    private Set<Long> getApproveIdSet(List<Long> calPersons) {
        SWCDataServiceHelper approveHelper = new SWCDataServiceHelper("hsas_approvebill");
        QFilter filter = new QFilter("calentryentity.calpersonid", "in", calPersons);
        DynamicObjectCollection approveCol = approveHelper.queryOriginalCollection("id", new QFilter[]{filter});
        return approveCol.stream().map(data -> data.getLong("id")).collect(Collectors.toSet());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actId;
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        switch (actId = closedCallBackEvent.getActionId()) {
            case "calapproveviewclose": {
                if (returnData == null) {
                    this.releaseDistributedLock();
                    return;
                }
                this.createApproveBill(returnData);
                break;
            }
            case "createapproveresultclose": {
                if (returnData == null) {
                    return;
                }
                this.jumpApproveBillDetail();
                break;
            }
        }
    }

    private void jumpApproveBillDetail() {
        CalPayRollTaskContext calPayRollTaskContext = (CalPayRollTaskContext)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("calPayRollTaskContext"), CalPayRollTaskContext.class);
        List validDatas = calPayRollTaskContext.getValidDatas();
        ArrayList<Object> approveBillNos = new ArrayList<Object>(validDatas.size());
        for (CalPayRollTask validData : validDatas) {
            ISWCAppCache appCache = SWCAppCache.get((String)((String)validData.getOperationParam().get("pageId")));
            approveBillNos.add(appCache.get(validData.getCalPayRollTaskId() + "approveBillNo", String.class));
            appCache.remove(validData.getCalPayRollTaskId() + "approveBillNo");
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("hsas_approvebill");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("defaultApproveBillNo", approveBillNos);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void createApproveBill(Map<String, Object> returnData) {
        IAppCache appCache = AppCache.get((String)this.getView().getPageId());
        appCache.remove("approveBillNo");
        appCache.remove("allCalTableIdList");
        Long approveBillTplId = (Long)returnData.get("approveBillTplId");
        Boolean isAll = (Boolean)returnData.getOrDefault("isAll", Boolean.FALSE);
        Boolean isOnHold = (Boolean)returnData.getOrDefault("isOnHold", Boolean.FALSE);
        String calPersons = (String)returnData.getOrDefault("calPersons", "");
        String errorCustomMsg = (String)returnData.getOrDefault("errorCustomMsg", "");
        SWCDataServiceHelper approveBillTplHisHelper = new SWCDataServiceHelper("hsas_approvebilltpl");
        QFilter approveBillTplHisFilter = new QFilter("boid", "=", (Object)approveBillTplId);
        approveBillTplHisFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        BaseDataHisHelper.addHisVerFilter((QFilter)approveBillTplHisFilter);
        DynamicObject approveBillTplHisDy = approveBillTplHisHelper.queryOne("id", new QFilter[]{approveBillTplHisFilter});
        Long approveBillTplHisId = approveBillTplHisDy.getLong("id");
        CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
        for (CalPayRollTask validData : calPayRollTaskContext.getValidDatas()) {
            Map operationParam = validData.getOperationParam();
            operationParam.put("approveBillTplId", String.valueOf(approveBillTplId));
            operationParam.put("approveBillTplHisId", String.valueOf(approveBillTplHisId));
            operationParam.put("isAll", String.valueOf(isAll));
            operationParam.put("isOnHold", String.valueOf(isOnHold));
            operationParam.put("calPersons", calPersons);
            operationParam.put("errorCustomMsg", errorCustomMsg);
            OperateOption option = OperateOption.create();
            option.setVariableValue("CallBackInvoke", "true");
            operationParam.forEach((arg_0, arg_1) -> ((OperateOption)option).setVariableValue(arg_0, arg_1));
            this.getView().invokeOperation(CalPersonOperationEnum.OP_CREATEAPPROVE.getOperationKey(), option);
        }
        this.getView().getPageCache().put("calPayRollTaskContext", SerializationUtils.toJsonString((Object)calPayRollTaskContext));
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        if (CalPersonOperationEnum.OP_CREATEAPPROVE.getOperationKey().equals(opKey)) {
            operationResult.setShowMessage(false);
            String operateName = ResManager.loadKDString((String)"\u751f\u6210\u5ba1\u6279\u5355", (String)"HSASCalTableListApproveBillPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.showCreatePayDetailResult(operationResult, operateName);
        }
    }

    private void showCreatePayDetailResult(OperationResult operationResult, String operateName) {
        int successSize;
        int total = operationResult.getBillCount();
        int fail = total - (successSize = operationResult.getSuccessPkIds().size());
        String format = fail == 0 ? ResManager.loadKDString((String)"\u5171{0}\u6761\u6838\u7b97\u8bb0\u5f55\uff0c\u6210\u529f\u751f\u6210\u5ba1\u6279\u5355{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"HSASCalTableListApproveBillPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5171{0}\u6761\u6838\u7b97\u8bb0\u5f55\uff0c\u6210\u529f\u751f\u6210\u5ba1\u6279\u5355{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"HSASCalTableListApproveBillPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String title = MessageFormat.format(format, total, successSize, fail);
        this.showOperationResult(operationResult, operateName, title, successSize);
    }

    private void showOperationResult(OperationResult operationResult, String operateName, String title, int successSize) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        List<String> failList = errorInfos.stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
        FormShowParameter parameters = this.getCreateApproveOperationResult(operateName, title, failList, successSize);
        parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "createapproveresultclose"));
        this.getView().showForm(parameters);
    }

    private FormShowParameter getCreateApproveOperationResult(String operateName, String title, List<String> failList, int successSize) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("hsas_creatapproveresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)operateName);
        parameters.setCustomParam("title", (Object)title);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int len = failList.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(failList.get(i)).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)(failList.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        parameters.setCustomParam("failList", failList);
        parameters.setCustomParam("successSize", (Object)successSize);
        return parameters;
    }

    @Override
    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        ISWCAppCache appCache = SWCAppCache.get((String)this.getView().getPageId());
        appCache.remove("approveBillNo");
        appCache.remove("allCalTableIdList");
    }
}

