/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.helper.CalDetailHelper;
import kd.swc.hsas.business.cal.helper.CalPayRollTaskCalHelper;
import kd.swc.hsas.business.cal.service.HSASCalListService;
import kd.swc.hsas.business.cal.service.calperson.DefaultProcessHandler;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsas.business.mq.BatchPayDetailPublisher;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsas.formplugin.web.guide.AbstractCalPersonList;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CreatePayDetailType;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class HSASCalTableListPayPlugin
extends AbstractCalPersonList {
    @Override
    protected List<CalPersonOperationEnum> operationKey() {
        ArrayList<CalPersonOperationEnum> calPersonOperationEnums = new ArrayList<CalPersonOperationEnum>();
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_CREATEPAY);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_VIEWPAYDETAIL);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_DELDETAIL);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_APPROVE);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_DISAPPROVE);
        return calPersonOperationEnums;
    }

    @Override
    protected boolean operationMutex() {
        switch (this.calPersonOperationEnum) {
            case OP_VIEWPAYDETAIL: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void execute() {
        switch (this.calPersonOperationEnum) {
            case OP_VIEWPAYDETAIL: {
                this.openPayDetailList((CalPayRollTask)this.calPayRollTaskContext.getValidDatas().get(0));
                break;
            }
            case OP_DELDETAIL: {
                this.getPageCache().put("invokeOperation", "true");
                break;
            }
            case OP_CREATEPAY: {
                this.doOperation();
                break;
            }
        }
    }

    @Override
    protected boolean isSelectData() {
        switch (this.calPersonOperationEnum) {
            case OP_VIEWPAYDETAIL: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        FormOperate formOperate = (FormOperate)args.getSource();
        Long taskId = calPayRollTask.getCalPayRollTaskId();
        if (taskId != null && taskId > 0L) {
            SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
            DynamicObject schemeAfterCalObj = sceneService.getAfterCalObjByTask(taskId);
            switch (this.calPersonOperationEnum) {
                case OP_APPROVE: 
                case OP_DISAPPROVE: {
                    boolean calapprove;
                    if (schemeAfterCalObj == null || (calapprove = schemeAfterCalObj.getBoolean("calapprove"))) break;
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u7684\u6838\u7b97\u540e\u5904\u7406\u65b9\u6848{0}\u4e2d\u672a\u542f\u7528\u85aa\u8d44\u5ba1\u6279\u4e1a\u52a1\u3002", (String)"CalPayRollTaskApproveBillList_4", (String)"swc-hsas-formplugin", (Object[])new Object[]{schemeAfterCalObj.getString("number")}));
                    return;
                }
                case OP_VIEWPAYDETAIL: 
                case OP_DELDETAIL: 
                case OP_CREATEPAY: {
                    String schemeAfterCalNumber;
                    if (schemeAfterCalObj == null || SWCStringUtils.equals((String)"1010_S", (String)(schemeAfterCalNumber = schemeAfterCalObj.getString("number")))) break;
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u7684\u6838\u7b97\u540e\u5904\u7406\u7c7b\u578b\u4e3a\u975e\u85aa\u8d44\u53d1\u653e\uff0c\u4e0d\u652f\u6301\u8fdb\u884c\u53d1\u653e\u53ca\u5de5\u8d44\u6761\u76f8\u5173\u64cd\u4f5c\u3002", (String)"CalPayrollTaskSalarySlipList_9", (String)"swc-hsas-formplugin", (Object[])new Object[]{schemeAfterCalObj.getString("number")}));
                    return;
                }
            }
        }
        switch (this.calPersonOperationEnum) {
            case OP_DISAPPROVE: {
                if (formOperate.getOption().tryGetVariableValue("CallBackInvoke", new RefObject())) break;
                this.disapproveValidator(calPayRollTask);
                break;
            }
            case OP_CREATEPAY: {
                Long calTaskId = calPayRollTask.getCalPayRollTaskId();
                if (!this.hasPayOutItem(calTaskId)) {
                    calPayRollTask.setValidatorResult(false);
                    calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u89c4\u5219\u4e0b\u65e0\u5b9e\u53d1\u9879\u76ee\uff0c\u65e0\u6cd5\u751f\u6210\u660e\u7ec6\u3002", (String)"HSASCalTableListPayPlugin_25", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    return;
                }
                calPayRollTask.getOperationParam().put("caltaskid", calTaskId.toString());
                calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
                this.doOperation();
                break;
            }
        }
    }

    @Override
    protected void afterDoOperation(AfterDoOperationEventArgs args, CalPayRollTaskContext calPayRollTaskContext) {
        switch (this.calPersonOperationEnum) {
            case OP_APPROVE: 
            case OP_DISAPPROVE: {
                for (CalPayRollTask validData : calPayRollTaskContext.getValidDatas()) {
                    PayrollTaskHelper.updateCalPayRollTaskStatus((Long)validData.getCalPayRollTaskId());
                }
                break;
            }
        }
    }

    public void doOperation() {
        CalPayRollTask calPayRollTask = (CalPayRollTask)this.calPayRollTaskContext.getValidDatas().get(0);
        DefaultProcessHandler processHandler = new DefaultProcessHandler();
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("calPersonList", calPayRollTask.getCalPersons());
        param.put("calPayRollTaskId", calPayRollTask.getCalPayRollTaskId());
        param.put("batchId", this.calPayRollTaskContext.getTraceId());
        param.put("createPayDetailType", CreatePayDetailType.NORMAL);
        param.put("entityName", "hsas_calperson");
        BatchPayDetailPublisher.publishBatchPayDetailMsg(param);
        HashMap<String, Object> processHandlerParam = new HashMap<String, Object>(2);
        processHandlerParam.put("closeCallBack", new CloseCallBack((IFormPlugin)this, "processCloseCallBack"));
        processHandlerParam.put("calPayRollTaskContext", SerializationUtils.toJsonString((Object)this.calPayRollTaskContext));
        processHandler.open(this.getView(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97%s\u770b\u677f", (String)"AbstractCalPayRollTaskList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), this.calPersonOperationEnum.getOperationName()), processHandlerParam);
    }

    private void disapproveValidator(CalPayRollTask calPayRollTask) {
        boolean flag = CalDetailHelper.hasOnHoldReleaseAgencyBill((List)calPayRollTask.getCalPersons());
        if (flag) {
            String msg = ResManager.loadKDString((String)"\u53cd\u5ba1\u6279\u65f6\uff0c\u4f1a\u5c06\u5df2\u89e3\u85aa\u7684\u4ee3\u53d1\u5355\u5bf9\u5e94\u6570\u636e\u5e9f\u5f03\uff0c\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"HSASCalTableListPayPlugin_27", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CalPersonOperationEnum.OP_DISAPPROVE.getOperationKey()));
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        switch (e.getCallBackId()) {
            case "disapprove": {
                if (MessageBoxResult.OK.equals((Object)e.getResult()) || MessageBoxResult.Yes.equals((Object)e.getResult())) {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("CallBackInvoke", "true");
                    this.getView().invokeOperation(CalPersonOperationEnum.OP_DISAPPROVE.getOperationKey(), operateOption);
                    break;
                }
                this.releaseDistributedLock();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object data = event.getReturnData();
        switch (actionId) {
            case "processCloseCallBack": {
                if (data == null) break;
                FormShowParameter calOperationResultForm = CalPayRollTaskCalHelper.getModalFormShowParameter((String)"hsas_caloperationresult");
                calOperationResultForm.setCustomParam("calPayRollTaskContext", data);
                calOperationResultForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_caloperationresult"));
                this.getView().showForm(calOperationResultForm);
                break;
            }
            case "hsas_caloperationresult": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void openPayDetailList(CalPayRollTask calPayRollTask) {
        String defaultTaskNumber = calPayRollTask.getNumber();
        List calPersons = calPayRollTask.getCalPersons();
        HashMap<String, Date> payrollDateMap = new HashMap<String, Date>(16);
        ArrayList<String> defaultTaskNumbers = new ArrayList<String>();
        if (calPersons == null || calPersons.isEmpty()) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
            QFilter filter = new QFilter("id", "=", (Object)calPayRollTask.getCalPayRollTaskId());
            String selectProperties = "id,payrolldate,startDate,enddate";
            DynamicObject calTask = helper.queryOne(selectProperties, new QFilter[]{filter});
            Date payrolldate = calTask.getDate("payrolldate");
            ListShowParameter show = new ListShowParameter();
            show.setBillFormId("hsas_paydetail");
            show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            show.setCustomParam("defaultTaskNumber", (Object)defaultTaskNumber);
            String taskNumber = calTask.getString("number");
            if (!defaultTaskNumbers.contains(taskNumber)) {
                defaultTaskNumbers.add(taskNumber);
            }
            show.setCustomParam("defaultTaskDate", (Object)SWCDateTimeUtils.format((Date)payrolldate));
            Date startDate = calTask.getDate("startDate");
            Date enddate = calTask.getDate("enddate");
            payrollDateMap.put("beginDate", startDate);
            payrollDateMap.put("endDate", enddate);
            show.setCustomParam("defaultTaskNumbers", defaultTaskNumbers);
            show.setCustomParam("defaultDateMap", payrollDateMap);
            show.setCustomParam("abandonedstatus", (Object)"0");
            this.getView().showForm((FormShowParameter)show);
            return;
        }
        ListShowParameter show = new ListShowParameter();
        show.setBillFormId("hsas_paydetail");
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter filter = new QFilter("id", "in", (Object)calPersons);
        HSASCalListService service = new HSASCalListService();
        DynamicObject[] dyObjs = service.queryCalTableForShowDetail(new QFilter[]{filter});
        ArrayList<String> defaultEmpNumbers = new ArrayList<String>();
        HashMap<Long, String> onHoldDatasMap = new HashMap<Long, String>(dyObjs.length);
        boolean isCreateDetail = false;
        Date belongperiod = null;
        for (DynamicObject dyObj : dyObjs) {
            String onholdstatus;
            String paystatus = dyObj.getString("paystatus");
            belongperiod = dyObj.getDate("belongperiod");
            if (SWCStringUtils.equals((String)PayStateEnum.UNPAY.getCode(), (String)paystatus) || SWCStringUtils.equals((String)PayStateEnum.PAYING.getCode(), (String)paystatus) || SWCStringUtils.equals((String)PayStateEnum.PAID.getCode(), (String)paystatus) || SWCStringUtils.equals((String)PayStateEnum.PREPAREPAY.getCode(), (String)paystatus) || SWCStringUtils.equals((String)PayStateEnum.PAYFAIL.getCode(), (String)paystatus)) {
                isCreateDetail = true;
                String empNumber = dyObj.getString("salaryfile.employee.empnumber");
                String taskNumber = dyObj.getString("caltask.number");
                if (!defaultEmpNumbers.contains(empNumber)) {
                    defaultEmpNumbers.add(empNumber);
                }
                if (!defaultTaskNumbers.contains(taskNumber)) {
                    defaultTaskNumbers.add(taskNumber);
                }
                Date startDate = dyObj.getDate("caltask.startDate");
                Date enddate = dyObj.getDate("caltask.enddate");
                payrollDateMap.put("beginDate", startDate);
                payrollDateMap.put("endDate", enddate);
            }
            if (!SWCStringUtils.isNotEmpty((String)(onholdstatus = dyObj.getString("onholdstatus"))) || !SWCStringUtils.equals((String)PayStateEnum.UNCREATE.getCode(), (String)paystatus)) continue;
            onHoldDatasMap.put(dyObj.getLong("id"), dyObj.getString("salaryfile.employee.empnumber"));
        }
        if (this.confirmAbandonPayDetails(defaultEmpNumbers, onHoldDatasMap)) {
            isCreateDetail = true;
        }
        if (isCreateDetail) {
            show.setCustomParam("defaultTaskNumber", (Object)defaultTaskNumber);
            show.setCustomParam("defaultEmpNumbers", defaultEmpNumbers);
            show.setCustomParam("defaultTaskNumbers", defaultTaskNumbers);
            show.setCustomParam("defaultTaskDate", (Object)SWCDateTimeUtils.format((Date)belongperiod));
            show.setCustomParam("defaultDateMap", payrollDateMap);
            show.setCustomParam("abandonedstatus", (Object)"0");
            this.getView().showForm((FormShowParameter)show);
        } else {
            String msg = ResManager.loadKDString((String)"\u6240\u9009\u8bb0\u5f55\u672a\u751f\u6210\u660e\u7ec6\uff0c\u65e0\u53ef\u67e5\u8be2\u6570\u636e\u3002", (String)"HSASCalTableListPayPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        }
    }

    private boolean confirmAbandonPayDetails(List<String> defaultEmpNumbers, Map<Long, String> onHoldDatasMap) {
        boolean isHavingAbanPayDetails = false;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter qFilter = new QFilter("caltableid", "in", onHoldDatasMap.keySet());
        DynamicObject[] payDetailsObjs = helper.query("id,caltableid", new QFilter[]{qFilter});
        if (null != payDetailsObjs && payDetailsObjs.length > 0) {
            isHavingAbanPayDetails = true;
            for (DynamicObject payDetailsObj : payDetailsObjs) {
                Long id = payDetailsObj.getLong("caltableid");
                String empNumber = onHoldDatasMap.get(id);
                if (defaultEmpNumbers.contains(empNumber)) continue;
                defaultEmpNumbers.add(empNumber);
            }
        }
        return isHavingAbanPayDetails;
    }

    private boolean hasPayOutItem(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String selectProperties = "calrulev.calruleitementry.ispayoutitem";
        DynamicObject taskInfo = helper.queryOne(selectProperties, (Object)calTaskId);
        DynamicObjectCollection ent = taskInfo.getDynamicObjectCollection("calrulev.calruleitementry");
        if (ent != null) {
            for (DynamicObject dynamicObject : ent) {
                boolean ispayoutitem = dynamicObject.getBoolean("ispayoutitem");
                if (!ispayoutitem) continue;
                return true;
            }
        }
        return false;
    }
}

