/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.helper.PaySalarySlipHelper;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsas.common.enums.ReleaseSalarySlipEnum;
import kd.swc.hsas.formplugin.web.guide.AbstractCalPersonList;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipViewDTO;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.ReleaseStateEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class HSASCalTableListSalaryPlugin
extends AbstractCalPersonList {
    private Log log = LogFactory.getLog(HSASCalTableListSalaryPlugin.class);

    @Override
    protected List<CalPersonOperationEnum> operationKey() {
        ArrayList<CalPersonOperationEnum> calPersonOperationEnums = new ArrayList<CalPersonOperationEnum>();
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_CREATESALARY);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_RECOVERSALARY);
        return calPersonOperationEnums;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        Long taskId = calPayRollTask.getCalPayRollTaskId();
        if (taskId != null && taskId > 0L) {
            switch (this.calPersonOperationEnum) {
                case OP_CREATESALARY: 
                case OP_RECOVERSALARY: {
                    String schemeAfterCalNumber;
                    SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
                    DynamicObject schemeAfterCalObj = sceneService.getAfterCalObjByTask(taskId);
                    if (schemeAfterCalObj == null || SWCStringUtils.equals((String)"1010_S", (String)(schemeAfterCalNumber = schemeAfterCalObj.getString("number")))) break;
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u7684\u6838\u7b97\u540e\u5904\u7406\u7c7b\u578b\u4e3a\u975e\u85aa\u8d44\u53d1\u653e\uff0c\u4e0d\u652f\u6301\u8fdb\u884c\u53d1\u653e\u53ca\u5de5\u8d44\u6761\u76f8\u5173\u64cd\u4f5c\u3002", (String)"CalPayrollTaskSalarySlipList_9", (String)"swc-hsas-formplugin", (Object[])new Object[]{schemeAfterCalObj.getString("number")}));
                    return;
                }
            }
        }
        switch (this.calPersonOperationEnum) {
            case OP_CREATESALARY: {
                if (PaySalarySlipHelper.checkSalarySlipParameterLock((IFormView)this.getView()).booleanValue()) {
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    return;
                }
                if (PaySalarySlipHelper.checkEncrypt((IFormView)this.getView())) {
                    this.toCreateSalary(calPayRollTask);
                    break;
                }
                calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                break;
            }
            case OP_RECOVERSALARY: {
                this.toRecoverSalary(calPayRollTask);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Map returnData = (Map)event.getReturnData();
        if (returnData != null) {
            if (((Boolean)returnData.get("isOk")).booleanValue()) {
                IListView view = (IListView)this.getView();
                CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
                ArrayList<Long> calPersons = new ArrayList(10);
                if (calPayRollTaskContext != null) {
                    calPersons = ((CalPayRollTask)calPayRollTaskContext.getValidDatas().get(0)).getCalPersons();
                }
                switch (actionId) {
                    case "createsalary": {
                        this.showReleaseSalaryViewForm();
                        break;
                    }
                    case "recoverSalarySlip": {
                        this.recoverSalarySlip(calPersons);
                        String msgRecover = ResManager.loadKDString((String)"\u540e\u53f0\u5df2\u5f00\u59cb\u8fdb\u884c\u5de5\u8d44\u6761\u56de\u6536\u5904\u7406\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019\u3002", (String)"CalPayrollTaskList_33", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                        this.getView().showSuccessNotification(msgRecover);
                        view.refresh();
                        break;
                    }
                    case "releaseSalaryFormCloseCallBack": {
                        if (!this.releaseSalarySlip(returnData, calPersons)) break;
                        String msg = ResManager.loadKDString((String)"\u540e\u53f0\u5df2\u5f00\u59cb\u8fdb\u884c\u53d1\u5e03\u5de5\u8d44\u6761\u5904\u7406\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019\u3002", (String)"CalPayrollTaskList_32", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                        this.getView().showSuccessNotification(msg);
                        break;
                    }
                }
            } else {
                this.releaseDistributedLock();
            }
        } else {
            ((IListView)this.getView()).refresh();
        }
    }

    private boolean releaseSalarySlip(Map<String, Object> returnData, List<Long> calPersons) {
        CalSalarySlipViewDTO dto = (CalSalarySlipViewDTO)returnData.get("calSalarySlipView");
        Boolean isUseOldView = returnData.get("useview") == null ? Boolean.FALSE : (Boolean)returnData.get("useview");
        List<Long> taskIdList = Collections.singletonList(this.getCalTaskId());
        return PaySalarySlipHelper.releaseSalarySlip((IFormView)this.getView(), (CalSalarySlipViewDTO)dto, taskIdList, calPersons, (Boolean)isUseOldView, (Boolean)Boolean.FALSE, (Boolean)Boolean.FALSE);
    }

    private void showReleaseSalaryViewForm() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter qFilter = new QFilter("id", "=", (Object)this.getCalTaskId());
        DynamicObject task = helper.queryOriginalOne("id,country.id,org.id", new QFilter[]{qFilter});
        String countryId = task.getString("country.id");
        IPageCache pageCache = this.getPageCache();
        String unPayCount = pageCache.get("unPayCount");
        String payedCount = pageCache.get("payedCount");
        FormShowParameter releaseSalaryViewForm = PaySalarySlipHelper.getReleaseSalaryViewForm((int)Integer.parseInt(unPayCount), (int)Integer.parseInt(payedCount));
        releaseSalaryViewForm.setCustomParam("orgIdList", (Object)JSON.toJSONString(Collections.singletonList(task.getLong("org.id"))));
        releaseSalaryViewForm.setCustomParam("countryId", (Object)countryId);
        releaseSalaryViewForm.setCustomParam("salaryViewId", (Object)PaySalarySlipHelper.getDefaultSalarySlipView((Long)this.getCalTaskId(), Collections.singletonList(task.getLong("org.id"))));
        releaseSalaryViewForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "releaseSalaryFormCloseCallBack"));
        this.getView().showForm(releaseSalaryViewForm);
    }

    private void toCreateSalary(CalPayRollTask calPayRollTask) {
        List calPersonIds = calPayRollTask.getCalPersons();
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        ArrayList<Long> calPayRollTaskIds = new ArrayList<Long>();
        calPayRollTaskIds.add(this.getCalTaskId());
        Map releaseSalarySlip = PaySalarySlipHelper.getReleaseSalarySlip(calPayRollTaskIds);
        ReleaseSalarySlipEnum releaseSalarySlipEnum = (ReleaseSalarySlipEnum)releaseSalarySlip.get(this.getCalTaskId());
        int unPayNum = 0;
        int payedNum = 0;
        if (releaseSalarySlipEnum != null) {
            QFilter calStatusFilter = PaySalarySlipHelper.getCanReleaseSalaryCalPersonFilter((ReleaseSalarySlipEnum)releaseSalarySlipEnum);
            QFilter calTaskIdFilter = new QFilter("caltask", "=", (Object)this.getCalTaskId());
            calTaskIdFilter.and(new QFilter("calmainid", "=", (Object)0));
            QFilter salaryUnPayFilter = PaySalarySlipHelper.getCanReleaseSalaryCalPersonSalaryStatusUnPayFilter();
            QFilter salaryPayedFilter = PaySalarySlipHelper.getCanReleaseSalaryCalPersonSalaryStatusPayedFilter();
            QFilter calPersonIdFilter = new QFilter("id", "in", (Object)calPersonIds);
            unPayNum = calTableHelper.count(new QFilter[]{calPersonIdFilter, calStatusFilter, salaryUnPayFilter});
            payedNum = calTableHelper.count(new QFilter[]{calPersonIdFilter, calStatusFilter, salaryPayedFilter});
            this.getView().getPageCache().put("unPayCount", String.valueOf(unPayNum));
            this.getView().getPageCache().put("payedCount", String.valueOf(payedNum));
        }
        if (unPayNum + payedNum == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u8fdb\u884c\u5de5\u8d44\u6761\u53d1\u5e03\uff1a\u6240\u9009\u6570\u636e\u5df2\u53d1\u5e03\u6216\u4e0d\u53d1\u5e03\u5de5\u8d44\u6761\u3001\u672a\u8fbe\u5230\u6216\u672a\u8bbe\u7f6e\u53d1\u5e03\u65f6\u70b9\u3002", (String)"HSASCalTableListSalaryPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return;
        }
        calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
        if (unPayNum + payedNum == calPersonIds.size()) {
            this.showReleaseSalaryViewForm();
            return;
        }
        FormShowParameter parameters = PaySalarySlipHelper.getPaySalConfirm((int)unPayNum, (int)payedNum, (int)calPersonIds.size(), (String)"calPerson", (int)1);
        parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.calPayRollTaskContext.getCalPersonOperationEnum().getOperationKey()));
        this.getView().showForm(parameters);
    }

    private void toRecoverSalary(CalPayRollTask calPayRollTask) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("name", "recoversalaryall");
        option.setVariableValue("pageId", this.getView().getPageId());
        option.setVariableValue("taskId", String.valueOf(calPayRollTask.getCalPayRollTaskId()));
        option.setVariableValue("confirm", "true");
        List idsCollect = null;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        idsCollect = calPayRollTask.getCalPersons();
        if (idsCollect.size() == 1 && !this.checkRecoverStatusByOne((Long)idsCollect.get(0))) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return;
        }
        QFilter idsFilter = new QFilter("id", "in", (Object)idsCollect);
        filters.add(idsFilter);
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter salaryFilter = new QFilter("salarystatus", "=", (Object)ReleaseStateEnum.RELEASED.getCode());
        QFilter calTableFilter = new QFilter("id", "in", (Object)idsCollect);
        filters.add(salaryFilter);
        filters.add(calTableFilter);
        QFilter[] newFilters = new QFilter[filters.size()];
        newFilters = filters.toArray(newFilters);
        int recoverNum = calTableHelper.count(newFilters);
        this.getPageCache().put("recoverNum", String.valueOf(recoverNum));
        this.showRecoverConfirm(false, calPayRollTask);
    }

    private void showRecoverConfirm(boolean isAll, CalPayRollTask calPayRollTask) {
        int recoverNum = 0;
        List ids = calPayRollTask.getCalPersons();
        int totalNum = ids.size();
        String recoverNumString = this.getPageCache().get("recoverNum");
        if (StringUtils.isNotEmpty((CharSequence)recoverNumString)) {
            recoverNum = Integer.parseInt(recoverNumString);
        }
        if (!isAll && totalNum == 1 && recoverNum == 1) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540e\u53f0\u5df2\u5f00\u59cb\u8fdb\u884c\u5de5\u8d44\u6761\u56de\u6536\u5904\u7406\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019\u3002", (String)"HSASCalTableListSalaryPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            this.recoverSalarySlip(ids);
            ((IListView)this.getView()).refresh();
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
            return;
        }
        if (recoverNum == 0) {
            String msg = ResManager.loadKDString((String)"\u56de\u6536\u5931\u8d25\uff0c\u6240\u9009\u6838\u7b97\u4efb\u52a1\u4e2d\u6838\u7b97\u8bb0\u5f55\u672a\u53d1\u5e03\u5de5\u8d44\u6761\uff0c\u6216\u53d1\u5e03\u7684\u5de5\u8d44\u6761\u5df2\u56de\u6536\u6216\u5df2\u5931\u6548\u3002", (String)"HSASCalTableListSalaryPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
        } else {
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "recoverSalarySlip"));
            parameters.setCustomParam("totalNum", (Object)totalNum);
            parameters.setCustomParam("calTableNum", (Object)1);
            parameters.setCustomParam("enable", (Object)recoverNum);
            parameters.setCustomParam("disenable", (Object)(totalNum - recoverNum));
            parameters.setFormId("hsas_recoverconfirm");
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
            this.getView().showForm(parameters);
        }
    }

    private void recoverSalarySlip(List<Long> calList) {
        List<Long> taskIds = Collections.singletonList(this.getCalTaskId());
        PaySalarySlipHelper.recoverSalarySlip(taskIds, calList);
    }

    private boolean checkRecoverStatusByOne(Long calPersonId) {
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObject dynamicObject = calTableHelper.queryOne("calstatus,salarystatus,salaryfile", (Object)calPersonId);
        String salaryStatus = dynamicObject.getString("salarystatus");
        if (ReleaseStateEnum.NORELEASE.getCode().equals(salaryStatus) || ReleaseStateEnum.UNRELEASE.getCode().equals(salaryStatus) || ReleaseStateEnum.RELEASEING.getCode().equals(salaryStatus)) {
            String fileNumber = dynamicObject.getString("salaryfile.number");
            String failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\u4e3a%s\u7684\u6838\u7b97\u8bb0\u5f55\u672a\u53d1\u5e03\u5de5\u8d44\u6761\uff0c\u65e0\u6cd5\u56de\u6536\u3002", (String)"CalTableRecoverPaySalaryValidator_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), fileNumber);
            this.getView().showErrorNotification(failMessage);
            return false;
        }
        if (ReleaseStateEnum.RECOVERED.getCode().equals(salaryStatus) || ReleaseStateEnum.RECOVEREING.getCode().equals(salaryStatus)) {
            String fileNumber = dynamicObject.getString("salaryfile.number");
            String failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\u4e3a%s\u7684\u6838\u7b97\u8bb0\u5f55\u53d1\u5e03\u7684\u5de5\u8d44\u6761\u5df2\u56de\u6536\uff0c\u65e0\u9700\u518d\u6b21\u56de\u6536\u3002", (String)"CalTableRecoverPaySalaryValidator_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), fileNumber);
            this.getView().showErrorNotification(failMessage);
            return false;
        }
        if (ReleaseStateEnum.INVALID.getCode().equals(salaryStatus)) {
            String fileNumber = dynamicObject.getString("salaryfile.number");
            String failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\u4e3a%s\u7684\u6838\u7b97\u8bb0\u5f55\u53d1\u5e03\u7684\u5de5\u8d44\u6761\u5df2\u5931\u6548\uff0c\u65e0\u6cd5\u56de\u6536\u3002", (String)"CalTableRecoverPaySalaryValidator_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), fileNumber);
            this.getView().showErrorNotification(failMessage);
            return false;
        }
        return true;
    }
}

