/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.calreport;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.calreport.CalRecordViewHelper;
import kd.swc.hsas.business.cal.calreport.dto.CalDetailExportDto;
import kd.swc.hsas.business.cal.calreport.helper.CalDetailExportHelper;
import kd.swc.hsas.business.cal.calreport.utils.CalReportDateUtil;
import kd.swc.hsas.business.calresulttpl.helper.CalResultTplAddItemServiceHelper;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultListHelper;
import kd.swc.hsas.business.salaryresultlist.helper.HSASCalResultListHelper;
import kd.swc.hsas.common.utils.TaskUtil;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.CalStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.collections.MapUtils;

public class CalReportViewPlugin
extends SWCDataBaseEdit {
    private static final String CAL_TASK_NUMBER_LABEL = "caltasknumber";
    private static final String OPERATE_TYPE_LABEL = "operatetype";
    private static final String TOTAL_COUNT_LABEL = "totalcount";
    private static final String SUCCESS_COUNT_LABEL = "successcount";
    private static final String FAIL_COUNT_LABEL = "failcount";
    private static final String CAL_TASK_NAME_LABEL = "caltaskname";
    private static final String SALARY_ITEM_COUNT = "itemcount";
    private static final String ROLL_BACK_LABEL = "rollbacklabel";
    private static final String CAL_TOOL_VERSION = "caltoolversion";
    private static final String CREATOR_NAME_LABEL = "createname";
    private static final String CAL_USE_TIME = "calusetime";
    private static final String CAL_START_TIME = "calstarttime";
    private static final String CAL_END_TIME = "calendtime";
    private static final String CAL_FAIL_ENTRY_ENTITY = "entryentity";
    private static final String PAYROLL_GROUP_VID = "payRollGroupVid";
    private static final String ENTRY_EXPORT_DATA = "donothing_exportdata";
    public static final Integer PAGE_SIZE = 100;
    private static final String PROGRESS = "progress";
    private static final String COMPLETE = "complete";
    private static final String MODULE_NAME = "swc-hsas-formplugin";
    private static final String MESSAGECOUNT = "messagecount";
    private static final String MESSAGEENTRY = "messageentry";
    private static final String DONOTHING_EXPORTMESSAGEDATA = "donothing_exportmessagedata";
    private static final String DONOTHING_VIEWSALARYDETAIL = "donothing_viewsalarydetail";
    private static final String DONOTHING_VIEWMESSAGEPERSON = "donothing_viewmessageperson";
    private static final String DONOTHING_VIEWPERSON = "donothing_viewperson";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Label textEdit = (Label)this.getView().getControl(CAL_TOOL_VERSION);
        textEdit.addClickListener((ClickListener)this);
        Label totalLabel = (Label)this.getView().getControl(TOTAL_COUNT_LABEL);
        totalLabel.addClickListener((ClickListener)this);
        Label successLabel = (Label)this.getView().getControl(SUCCESS_COUNT_LABEL);
        successLabel.addClickListener((ClickListener)this);
        Label failLabel = (Label)this.getView().getControl(FAIL_COUNT_LABEL);
        failLabel.addClickListener((ClickListener)this);
        Label messageCountLabel = (Label)this.getView().getControl(MESSAGECOUNT);
        messageCountLabel.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject evt) {
        this.loadBaseData();
    }

    private void loadBaseData() {
        DynamicObject calReportInfo = this.getCalReportInfo();
        if (calReportInfo == null) {
            return;
        }
        String calTaskNumber = calReportInfo.getString("caltask.number");
        this.modifyLabelValue(CAL_TASK_NUMBER_LABEL, calTaskNumber);
        String optType = calReportInfo.getString("optype");
        String optName = "";
        optName = SWCStringUtils.equals((String)optType, (String)"1") ? ResManager.loadKDString((String)"\u8ba1\u7b97", (String)"CalReportViewPlugin_0", (String)MODULE_NAME, (Object[])new Object[0]) : (SWCStringUtils.equals((String)optType, (String)"2") ? ResManager.loadKDString((String)"\u8ba1\u7b97\u56de\u6eda", (String)"CalReportViewPlugin_1", (String)MODULE_NAME, (Object[])new Object[0]) : (SWCStringUtils.equals((String)optType, (String)"3") ? ResManager.loadKDString((String)"\u8ba1\u7b97\u7a0e\u524d", (String)"CalReportViewPlugin_2", (String)MODULE_NAME, (Object[])new Object[0]) : (SWCStringUtils.equals((String)optType, (String)"4") ? ResManager.loadKDString((String)"\u8ba1\u7b97\u7a0e\u540e", (String)"CalReportViewPlugin_3", (String)MODULE_NAME, (Object[])new Object[0]) : optType)));
        this.getModel().setValue(OPERATE_TYPE_LABEL, (Object)optName);
        String calStatus = calReportInfo.getString("calstatus");
        if (SWCStringUtils.equals((String)optType, (String)"1") && SWCStringUtils.equals((String)calStatus, (String)"3")) {
            String msg = ResManager.loadKDString((String)"\u8ba1\u7b97\u88ab\u7ec8\u6b62\uff0c\u5df2\u8fdb\u884c\u56de\u6eda\uff0c\u5171\u56de\u6eda", (String)"CalReportViewPlugin_19", (String)MODULE_NAME, (Object[])new Object[0]);
            this.modifyLabelValue(ROLL_BACK_LABEL, msg);
        }
        int totalCount = calReportInfo.getInt(TOTAL_COUNT_LABEL);
        this.modifyLabelValue(TOTAL_COUNT_LABEL, String.valueOf(totalCount));
        int successCount = calReportInfo.getInt("sucesscount");
        this.modifyLabelValue(SUCCESS_COUNT_LABEL, String.valueOf(successCount));
        int failCount = calReportInfo.getInt(FAIL_COUNT_LABEL);
        this.modifyLabelValue(FAIL_COUNT_LABEL, String.valueOf(failCount));
        Container flexContainer = (Container)this.getView().getControl("flexpanelap211");
        if (failCount == 0) {
            flexContainer.setCollapse(true);
        } else {
            flexContainer.setCollapse(false);
        }
        OrmLocaleValue localName = (OrmLocaleValue)calReportInfo.get("caltask.name");
        this.modifyLabelValue(CAL_TASK_NAME_LABEL, localName.getLocaleValue());
        int salaryItemCount = calReportInfo.getInt("salaryitemcount");
        this.modifyLabelValue(SALARY_ITEM_COUNT, String.valueOf(salaryItemCount));
        String calVersionNo = calReportInfo.getString("calversionno");
        this.modifyLabelValue(CAL_TOOL_VERSION, calVersionNo);
        this.getModel().setValue("calversionno", (Object)calVersionNo);
        OrmLocaleValue creatorName = (OrmLocaleValue)calReportInfo.get("creator.name");
        if (creatorName != null) {
            this.modifyLabelValue(CREATOR_NAME_LABEL, creatorName.getLocaleValue());
        }
        Date calStartTime = calReportInfo.getDate("starttime");
        Date calEndTime = calReportInfo.getDate("endtime");
        String timeStr = CalReportDateUtil.getTimeStr((Date)calStartTime, (Date)calEndTime);
        this.modifyLabelValue(CAL_USE_TIME, timeStr);
        String calStartStr = SWCInteDateTimeUtil.formatTimeWithUserZone((Date)calStartTime);
        String calEndStr = SWCInteDateTimeUtil.formatTimeWithUserZone((Date)calEndTime);
        this.modifyLabelValue(CAL_START_TIME, calStartStr);
        this.modifyLabelValue(CAL_END_TIME, calEndStr);
        long recordId = calReportInfo.getLong("id");
        this.loadCalFailInfo(recordId);
        this.loadCalMessageData(recordId, calVersionNo);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        String calVersionNo = (String)this.getModel().getValue("calversionno");
        if (SWCStringUtils.equals((String)CAL_TOOL_VERSION, (String)key)) {
            FormShowParameter show = new FormShowParameter();
            show.setFormId("hsas_calversionlist");
            show.setCaption(ResManager.loadKDString((String)"\u6838\u7b97\u5de5\u5177\u7248\u672c", (String)"CalReportViewPlugin_4", (String)MODULE_NAME, (Object[])new Object[0]));
            show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            show.setCustomParam("calversionno", (Object)calVersionNo);
            this.getView().showForm(show);
        } else if (SWCStringUtils.equals((String)TOTAL_COUNT_LABEL, (String)key)) {
            this.clickCalTotalCount("total");
        } else if (SWCStringUtils.equals((String)SUCCESS_COUNT_LABEL, (String)key)) {
            this.clickCalSuccessCount("success");
        } else if (SWCStringUtils.equals((String)FAIL_COUNT_LABEL, (String)key)) {
            this.clickCalFailCount("fail");
        } else if (MESSAGECOUNT.equals(key)) {
            this.clickMessageCount();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        long userId;
        boolean permFlag;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String optKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)optKey, (String)DONOTHING_VIEWSALARYDETAIL)) {
            this.openCalResultDetailPage(args);
        } else if ((SWCStringUtils.equals((String)optKey, (String)ENTRY_EXPORT_DATA) || DONOTHING_EXPORTMESSAGEDATA.equals(optKey)) && !(permFlag = SWCPermissionServiceHelper.hasPerm((long)(userId = RequestContext.get().getCurrUserId()), (String)"/UHMBBGZQ65X", (String)this.getView().getEntityId(), (String)"4730fc9f000004ae"))) {
            String msg = ResManager.loadKDString((String)"\u65e0\u5bfc\u51fa\u6743\u9650\uff01", (String)"CalReportViewPlugin_20", (String)MODULE_NAME, (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String optKey = args.getOperateKey();
        if (SWCStringUtils.equals((String)optKey, (String)DONOTHING_VIEWPERSON)) {
            this.viewPerson();
        } else if (SWCStringUtils.equals((String)optKey, (String)ENTRY_EXPORT_DATA)) {
            this.entryDataExport();
        } else if (DONOTHING_VIEWMESSAGEPERSON.equals(optKey)) {
            this.viewCalMessageDetail();
        } else if (DONOTHING_EXPORTMESSAGEDATA.equals(optKey)) {
            this.exportCalMessage();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actId = closedCallBackEvent.getActionId();
        if (SWCStringUtils.equals((String)actId, (String)"closecaldetailpage")) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (SWCObjectUtils.isEmpty((Object)returnData)) {
                return;
            }
            ListSelectedRow selectRow = returnData.get(0);
            Long calResultTplId = (Long)selectRow.getPrimaryKeyValue();
            this.openCalResultDetailPage(calResultTplId);
        }
    }

    private void openCalResultDetailPage(Long calResultTplId) {
        DynamicObject calReportInfo = this.getCalReportInfo();
        if (calReportInfo == null) {
            return;
        }
        Long calTaskId = calReportInfo.getLong("caltask.id");
        SalaryDetailResultListHelper helper = new SalaryDetailResultListHelper();
        ListShowParameter showParameter = helper.getCalTableListForm(this.getView().getPageId(), calTaskId.longValue(), calResultTplId);
        if (showParameter == null) {
            return;
        }
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas_calresulttpl_appcache");
        String pageId = showParameter.getPageId();
        appCache.put(pageId + "_calResultTplCache", (Object)calResultTplId);
        showParameter.setCaption(ResManager.loadKDString((String)"\u85aa\u8d44\u660e\u7ec6\u7ed3\u679c", (String)"CalReportViewPlugin_15", (String)MODULE_NAME, (Object[])new Object[0]));
        showParameter.setCustomParam("pageType", (Object)"salaryDetailResultPage");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openCalResultDetailPage(BeforeDoOperationEventArgs args) {
        DynamicObject calReportInfo = this.getCalReportInfo();
        if (calReportInfo == null) {
            return;
        }
        CalResultTplAddItemServiceHelper helper = new CalResultTplAddItemServiceHelper();
        Long calTaskId = calReportInfo.getLong("caltask.id");
        Map<String, Object> calMessage = this.getCalMessage(calTaskId);
        long payRollGroupVid = MapUtils.getLong(calMessage, (Object)PAYROLL_GROUP_VID);
        long payRollGroupId = HSASCalResultListHelper.getPayGroupIdByVid((long)payRollGroupVid);
        DynamicObjectCollection calResultTpls = helper.getCalResultTpl(Long.valueOf(payRollGroupId));
        if (calResultTpls == null || calResultTpls.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u8d44\u6838\u7b97\u7ec4\u672a\u8bbe\u7f6e\u85aa\u8d44\u660e\u7ec6\u7ed3\u679c\u6a21\u677f\u3002", (String)"CalReportViewPlugin_13", (String)MODULE_NAME, (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            args.setCancel(true);
            return;
        }
        if (calResultTpls.size() == 1) {
            DynamicObject firstObj = (DynamicObject)calResultTpls.get(0);
            if (SWCObjectUtils.isEmpty((Object)firstObj)) {
                return;
            }
            Long calResultTplId = firstObj.getLong("id");
            this.openCalResultPage(calResultTplId, calTaskId);
        } else {
            Set calResultTplIds = calResultTpls.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
            QFilter filter = new QFilter("payrollgroups.fbasedataid_id", "=", (Object)payRollGroupId);
            filter.and("bsed", "<=", (Object)SWCDateTimeUtils.getDateWithoutMinTs((Date)new Date()));
            filter.and("status", "=", (Object)"C");
            filter.and("enable", "=", (Object)"1");
            filter.and("id", "in", calResultTplIds);
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(filter);
            ListShowParameter showParameter = new ListShowParameter();
            long defaultTplId = CalReportViewPlugin.getDefaultTplId(calResultTpls);
            if (defaultTplId > 0L) {
                showParameter.setSelectedRow((Object)defaultTplId);
            }
            showParameter.setBillFormId("hsas_calresulttpl");
            showParameter.setFormId("bos_listf7");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u6a21\u677f", (String)"CalReportViewPlugin_14", (String)MODULE_NAME, (Object[])new Object[0]));
            showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("960px");
            styleCss.setHeight("580px");
            showParameter.getOpenStyle().setInlineStyleCss(styleCss);
            showParameter.setLookUp(true);
            showParameter.setMultiSelect(false);
            showParameter.setShowTitle(false);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closecaldetailpage"));
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private static long getDefaultTplId(DynamicObjectCollection calResultTpls) {
        for (DynamicObject dataObj : calResultTpls) {
            String isDefault = dataObj.getString("isdefault");
            if (!SWCStringUtils.isNotEmpty((String)isDefault)) continue;
            return dataObj.getLong("id");
        }
        return 0L;
    }

    private void openCalResultPage(Long calResultTplId, Long calTaskId) {
        FormShowParameter formShowParameter = SalaryDetailResultListHelper.openCalResultDetailPage((Long)calResultTplId, (Long)calTaskId, (String)this.getView().getPageId());
        if (formShowParameter == null) {
            return;
        }
        this.getView().showForm(formShowParameter);
    }

    public Map<String, Object> getCalMessage(Long calTaskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject taskInfo = this.getTaskInfoObj(calTaskId);
        if (taskInfo == null) {
            return map;
        }
        String taskName = taskInfo.getString("name");
        String payRollGroupName = taskInfo.getString("payrollgroupv.name");
        Date groupbred = taskInfo.getDate("payrollgroupv.bsed");
        String groupbredStr = SWCDateTimeUtils.format((Date)groupbred, (String)"yyyyMMdd");
        String calRuleName = taskInfo.getString("calrulev.name");
        Date rulebred = taskInfo.getDate("calrulev.bsed");
        String rulebredStr = SWCDateTimeUtils.format((Date)rulebred, (String)"yyyyMMdd");
        Date payRollDate = taskInfo.getDate("payrolldate");
        String payRollDateStr = SWCDateTimeUtils.formatDate((Date)payRollDate);
        payRollGroupName = String.format("%s %s", payRollGroupName, groupbredStr);
        calRuleName = String.format("%s %s", calRuleName, rulebredStr);
        String periodInfo = "";
        map.put("taskName", taskName);
        map.put("payRollGroupName", payRollGroupName);
        map.put(PAYROLL_GROUP_VID, taskInfo.getLong("payrollgroupv.id"));
        map.put("calRuleName", calRuleName);
        map.put("calRuleVid", taskInfo.getLong("calrulev.id"));
        map.put("periodInfo", periodInfo);
        map.put("payRollDateStr", payRollDateStr);
        Long orgId = taskInfo.getLong("org.id");
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        return map;
    }

    private DynamicObject getTaskInfoObj(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String field = "name,payrollgroup.name,payrollgroupv.name,payrollgroupv.bsed,payrollgroupv.bsled,calrule.name,calrulev,calrulev.name,calrulev.bsed,calrulev.bsle,payrolldate,calcount,period.name,org.id";
        QFilter taskFilter = new QFilter("id", "=", (Object)calTaskId);
        QFilter[] filters = new QFilter[]{taskFilter};
        DynamicObject taskInfo = helper.queryOne(field, filters);
        return taskInfo;
    }

    private void entryDataExport() {
        int index = this.getModel().getEntryCurrentRowIndex(CAL_FAIL_ENTRY_ENTITY);
        DynamicObject viewObj = this.getModel().getEntryRowEntity(CAL_FAIL_ENTRY_ENTITY, index);
        if (viewObj == null) {
            return;
        }
        DynamicObject calReportInfo = this.getCalReportInfo();
        if (calReportInfo == null) {
            return;
        }
        long recordId = calReportInfo.getLong("id");
        String failType = viewObj.getString("failtype");
        String errorElement = viewObj.getString("failelement");
        String failReason = viewObj.getString("failreason");
        this.doExport(recordId, failType, errorElement, failReason);
    }

    private void doExport(long recordId, String failType, String errorElement, String failReason) {
        QFilter[] filters = this.getQueryFilters(recordId, failType, errorElement, failReason);
        CalDetailExportHelper helper = new CalDetailExportHelper();
        Map headers = helper.getExportHeaders();
        CalDetailExportDto.Builder builder = new CalDetailExportDto.Builder();
        builder.setFilters(filters).setHeaders(headers);
        String downLoadTaskId = TaskUtil.getExportTaskID();
        this.startExport(builder, downLoadTaskId, helper);
    }

    private void startExport(CalDetailExportDto.Builder builder, String downLoadTaskId, CalDetailExportHelper helper) {
        CalDetailExportDto dto = builder.build();
        QFilter[] filters = dto.getFilters();
        int totalElements = ORM.create().count("BusinessDataServiceHelper.load", "hsas_caldetail", filters);
        int totalPages = (int)Math.ceil((double)totalElements * 1.0 / (double)PAGE_SIZE.intValue());
        CountDownLatch countDownLatch = new CountDownLatch(totalPages);
        this.openExportProgressBar(totalElements, totalPages, countDownLatch, downLoadTaskId);
        Map headers = dto.getHeaders();
        LocalDate now = LocalDate.now();
        String date = String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
        String fileName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6838\u7b97\u8bb0\u5f55\u8be6\u7ec6\u8868\u5bfc\u51fa_%s", (String)"CalReportViewPlugin_16", (String)MODULE_NAME, (Object[])new Object[0]), date);
        RequestContext ctx = RequestContext.get();
        helper.mutiThreadExport(ctx, fileName, headers, totalPages, filters, countDownLatch, this.getView(), totalElements, downLoadTaskId);
    }

    private void openExportProgressBar(int totalCount, int totalPages, CountDownLatch countDownLatch, String downLoadTaskId) {
        String pageId = this.getView().getPageId();
        FormShowParameter para = new FormShowParameter();
        para.setFormId("hsas_caltableexportprog");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("pageId", (Object)pageId);
        para.setCustomParam("totalCount", (Object)totalCount);
        para.setCustomParam("status", (Object)0);
        para.setCustomParam("downLoadTaskId", (Object)downLoadTaskId);
        para.setCustomParam("exportMsg", (Object)ResManager.loadKDString((String)"\u5171\u9009\u4e2d%s\u6761\u6570\u636e", (String)"CalReportViewPlugin_18", (String)MODULE_NAME, (Object[])new Object[0]));
        para.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u8fdb\u5ea6", (String)"CalReportViewPlugin_17", (String)MODULE_NAME, (Object[])new Object[0]));
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        if (totalPages <= 0) {
            pageCache.put(PROGRESS + downLoadTaskId, (Object)100);
            para.setCustomParam(PROGRESS, (Object)100);
        } else {
            pageCache.put(PROGRESS + downLoadTaskId, (Object)(((long)totalPages - countDownLatch.getCount()) / (long)totalPages));
            pageCache.put(COMPLETE + downLoadTaskId, (Object)(((long)totalPages - countDownLatch.getCount()) * 100L));
        }
        pageCache.saveChanges();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "openExportProgressBar");
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private QFilter[] getQueryFilters(long recordId, String failType, String errorElement, String failReason) {
        QFilter filter = new QFilter("record.id", "=", (Object)recordId);
        if (SWCStringUtils.isNotEmpty((String)failType)) {
            QFilter failTypeFilter = new QFilter("failtype", "=", (Object)failType);
            filter.and(failTypeFilter);
        }
        if (SWCStringUtils.isNotEmpty((String)errorElement)) {
            QFilter errorElementFilter = new QFilter("errorelement", "=", (Object)errorElement);
            filter.and(errorElementFilter);
        }
        if (SWCStringUtils.isNotEmpty((String)failReason)) {
            QFilter failReasonFilter = new QFilter("failmsg", "=", (Object)failReason);
            filter.and(failReasonFilter);
        }
        QFilter[] filters = new QFilter[]{filter};
        return filters;
    }

    private void viewPerson() {
        int index = this.getModel().getEntryCurrentRowIndex(CAL_FAIL_ENTRY_ENTITY);
        DynamicObject viewObj = this.getModel().getEntryRowEntity(CAL_FAIL_ENTRY_ENTITY, index);
        if (viewObj == null) {
            return;
        }
        ListShowParameter showParameter = this.getListShowParameter();
        showParameter.setCustomParam("pageType", (Object)"viewPerson");
        String failType = viewObj.getString("failtype");
        showParameter.setCustomParam("failType", (Object)failType);
        String errorElement = viewObj.getString("failelement");
        showParameter.setCustomParam("errorElement", (Object)errorElement);
        String failReason = viewObj.getString("failreason");
        showParameter.setCustomParam("failReason", (Object)failReason);
        DynamicObject calReportInfo = this.getCalReportInfo();
        if (calReportInfo != null) {
            long recordId = calReportInfo.getLong("id");
            showParameter.setCustomParam("recordId", (Object)recordId);
        }
        String failCode = viewObj.getString("classcode");
        StringBuilder sb = new StringBuilder();
        String failStr = ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25\u4eba\u5458\u5217\u8868", (String)"CalReportViewPlugin_12", (String)MODULE_NAME, (Object[])new Object[0]);
        sb.append(failStr);
        sb.append('-').append(failCode);
        showParameter.setCaption(sb.toString());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void viewCalMessageDetail() {
        int index = this.getModel().getEntryCurrentRowIndex(MESSAGEENTRY);
        DynamicObject viewObj = this.getModel().getEntryRowEntity(MESSAGEENTRY, index);
        if (viewObj == null) {
            return;
        }
        ListShowParameter showParameter = this.getCalMessageParameter();
        Long formulaId = viewObj.getLong("formulaid");
        String message = viewObj.getString("message");
        String number = viewObj.getString("messagenumber");
        showParameter.setCustomParam("formulaId", (Object)formulaId);
        showParameter.setCustomParam("message", (Object)message);
        showParameter.setCustomParam("pageType", (Object)"viewDetail");
        StringBuilder sb = new StringBuilder();
        String failStr = ResManager.loadKDString((String)"\u516c\u5f0f\u8f93\u51fa\u6d88\u606f\u4eba\u5458\u5217\u8868", (String)"CalReportViewPlugin_21", (String)MODULE_NAME, (Object[])new Object[0]);
        sb.append(failStr);
        sb.append('-').append(number);
        showParameter.setCaption(sb.toString());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private ListShowParameter getCalMessageParameter() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("hsas_calmessage");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        FormShowParameter pageParameter = this.getView().getFormShowParameter();
        Long recordId = (Long)pageParameter.getCustomParam("calReportId");
        showParameter.setCustomParam("calRecordId", (Object)recordId);
        return showParameter;
    }

    private ListShowParameter getListShowParameter() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("hsas_caldetaillist");
        showParameter.setBillFormId("hsas_caldetail");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return showParameter;
    }

    private void clickCalSuccessCount(String pageType) {
        ListShowParameter showParameter = this.getListShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a\u4eba\u5458\u5217\u8868-\u6210\u529f", (String)"CalReportViewPlugin_10", (String)MODULE_NAME, (Object[])new Object[0]));
        showParameter.setCustomParam("pageType", (Object)pageType);
        DynamicObject calReportInfo = this.getCalReportInfo();
        if (calReportInfo != null) {
            long recordId = calReportInfo.getLong("id");
            showParameter.setCustomParam("recordId", (Object)recordId);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void clickMessageCount() {
        ListShowParameter showParameter = this.getCalMessageParameter();
        showParameter.setCustomParam("pageType", (Object)"allCount");
        showParameter.setCaption(ResManager.loadKDString((String)"\u516c\u5f0f\u8f93\u51fa\u6d88\u606f\u4eba\u5458\u5217\u8868", (String)"CalReportViewPlugin_21", (String)MODULE_NAME, (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void clickCalFailCount(String pageType) {
        ListShowParameter showParameter = this.getListShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a\u4eba\u5458\u5217\u8868-\u5931\u8d25", (String)"CalReportViewPlugin_11", (String)MODULE_NAME, (Object[])new Object[0]));
        showParameter.setCustomParam("pageType", (Object)pageType);
        DynamicObject calReportInfo = this.getCalReportInfo();
        if (calReportInfo != null) {
            long recordId = calReportInfo.getLong("id");
            showParameter.setCustomParam("recordId", (Object)recordId);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void clickCalTotalCount(String pageType) {
        ListShowParameter showParameter = this.getListShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a\u4eba\u5458\u5217\u8868-\u603b", (String)"CalReportViewPlugin_9", (String)MODULE_NAME, (Object[])new Object[0]));
        showParameter.setCustomParam("pageType", (Object)pageType);
        DynamicObject calReportInfo = this.getCalReportInfo();
        if (calReportInfo != null) {
            long recordId = calReportInfo.getLong("id");
            showParameter.setCustomParam("recordId", (Object)recordId);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private DynamicObject getCalReportInfo() {
        Long calReportId = (Long)this.getView().getFormShowParameter().getCustomParam("calReportId");
        if (calReportId == null) {
            return null;
        }
        CalRecordViewHelper helper = new CalRecordViewHelper();
        DynamicObject calReportInfo = helper.getCalReportInfoById(calReportId);
        return calReportInfo;
    }

    private void loadCalFailInfo(long recordId) {
        CalRecordViewHelper helper = new CalRecordViewHelper();
        List failInfoList = helper.getCalFailGroupInfo(recordId, CalStatusEnum.FAIL.getCode());
        if (failInfoList == null || failInfoList.size() == 0) {
            return;
        }
        IDataModel model = this.getModel();
        for (Map failInfoMap : failInfoList) {
            int detailIndex = model.createNewEntryRow(CAL_FAIL_ENTRY_ENTITY);
            String failClassCode = this.getFailClassCode(detailIndex + 1, "F");
            model.setValue("classcode", (Object)failClassCode, detailIndex);
            model.setValue("failtype", failInfoMap.get("failType"), detailIndex);
            model.setValue("failelement", failInfoMap.get("errorElement"), detailIndex);
            model.setValue("failreason", failInfoMap.get("failMsg"), detailIndex);
            model.setValue("personcount", failInfoMap.get("count"), detailIndex);
        }
        this.getView().updateView(CAL_FAIL_ENTRY_ENTITY);
    }

    private String getFailClassCode(int index, String startNumber) {
        StringBuilder sb = new StringBuilder();
        sb.append(startNumber);
        if (index >= 1 && index <= 9) {
            sb.append("00").append(index);
        } else if (index >= 10 && index <= 99) {
            sb.append('0').append(index);
        } else if (index >= 100 && index <= 999) {
            sb.append(index);
        }
        return sb.toString();
    }

    private void modifyLabelValue(String labelName, String modifyStr) {
        Label lable = (Label)this.getControl(labelName);
        lable.setText(modifyStr);
    }

    private void loadCalMessageData(Long recordId, String calVersionNo) {
        QFilter filter = new QFilter("record.id", "=", (Object)recordId);
        int count = this.getMessageCount(filter);
        Label countLabel = (Label)this.getView().getControl(MESSAGECOUNT);
        countLabel.setText(String.valueOf(count));
        Container flexContainer = (Container)this.getView().getControl("flexpanelap4");
        if (count < 1) {
            flexContainer.setCollapse(true);
            return;
        }
        flexContainer.setCollapse(false);
        CalRecordViewHelper recordViewHelper = new CalRecordViewHelper();
        List resultList = recordViewHelper.getCalMessageGroupData(recordId.longValue());
        if (resultList.size() == 0) {
            return;
        }
        Map<Long, List<Map>> resultMap = resultList.stream().collect(Collectors.groupingBy(obj -> (Long)obj.get("fformulaid")));
        Map formulaMap = recordViewHelper.getFormulaMap(resultMap.keySet(), calVersionNo);
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("messagenumber", new Object[0]);
        setter.addField("formula", new Object[0]);
        setter.addField("message", new Object[0]);
        setter.addField("filecount", new Object[0]);
        setter.addField("formulaid", new Object[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        int index = 1;
        List<Map> tempList = null;
        String number = null;
        for (Map.Entry formuaEntry : formulaMap.entrySet()) {
            tempList = resultMap.get(formuaEntry.getKey());
            if (SWCListUtils.isEmpty(tempList)) continue;
            for (Map tempMap : tempList) {
                number = this.getFailClassCode(index, "M");
                setter.addRow(new Object[]{number, formuaEntry.getValue(), tempMap.get("fmessage"), tempMap.get("count"), tempMap.get("fformulaid")});
                ++index;
            }
        }
        model.deleteEntryData(MESSAGEENTRY);
        model.batchCreateNewEntryRow(MESSAGEENTRY, setter);
        model.endInit();
        this.getView().updateView(MESSAGEENTRY);
    }

    private int getMessageCount(QFilter filter) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calmessage");
        int count = helper.count(new QFilter[]{filter});
        return count;
    }

    private void exportCalMessage() {
        int index = this.getModel().getEntryCurrentRowIndex(MESSAGEENTRY);
        DynamicObject viewObj = this.getModel().getEntryRowEntity(MESSAGEENTRY, index);
        if (viewObj == null) {
            return;
        }
        Long recordId = (Long)this.getView().getFormShowParameter().getCustomParam("calReportId");
        if (recordId == null) {
            return;
        }
        Long formulaId = viewObj.getLong("formulaid");
        String message = viewObj.getString("message");
        QFilter filter = new QFilter("record.id", "=", (Object)recordId);
        filter.and("formula.id", "=", (Object)formulaId);
        filter.and("message", "=", (Object)message);
        CalDetailExportHelper helper = new CalDetailExportHelper();
        Map headers = helper.getCalMessageExportHeaders();
        CalDetailExportDto.Builder builder = new CalDetailExportDto.Builder();
        QFilter[] filters = new QFilter[]{filter};
        builder.setFilters(filters).setHeaders(headers);
        String downLoadTaskId = TaskUtil.getExportTaskID();
        int count = this.getMessageCount(filter);
        CalDetailExportDto dto = builder.build();
        int totalPages = (int)Math.ceil((double)count * 1.0 / (double)PAGE_SIZE.intValue());
        CountDownLatch countDownLatch = new CountDownLatch(totalPages);
        this.openExportProgressBar(count, totalPages, countDownLatch, downLoadTaskId);
        String fileName = ResManager.loadKDString((String)"\u516c\u5f0f\u8f93\u51fa\u6d88\u606f", (String)"CalMessageList_0", (String)MODULE_NAME, (Object[])new Object[0]);
        String dateTimeStr = SWCDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
        fileName = fileName + '_' + dateTimeStr;
        helper.exportCalMessageData(fileName, dto, totalPages, countDownLatch, this.getView(), count, downLoadTaskId);
    }
}

