/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.genbizdata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.IBaseDataService;
import kd.swc.hsas.business.genbizdata.GenBizDataService;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class GenBizDataEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String FIELD_ITEMNAME = "itemname";
    private static final String FIELD_ITEMTYPE = "itemtype";
    private static final String FIELD_AREATYPE = "areatype";
    private static final String FIELD_AREATYPE_GENERAL = "1";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_ITEMID = "itemid";
    private static final String FIELD_REFBIZITEM = "refbizitem";
    private static final String FIELD_DATATYPE = "datatype";
    private static final String CHANGE_AREA_TYPE = "changeAreaType";
    private static final String CHANGE_COUNTRY = "changeCountry";
    private static final String FIELD_AUTOGEN = "isautogenbsed";
    private static final String FIELD_BASEDATETYPE = "basedatetype";
    private static final String FIELD_MONTH = "month";
    private static final String FIELD_DATETYPE = "datetype";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit refBizItem = (BasedataEdit)this.getView().getControl(FIELD_REFBIZITEM);
        refBizItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{FIELD_ITEMNAME});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        switch (key) {
            case "itemname": {
                if (selectedRows == null || selectedRows.length <= 0) break;
                this.openItemMatchSelectF7(selectedRows[0]);
                break;
            }
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.fillEntryItemName();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name;
        switch (name = beforeF7SelectEvent.getProperty().getName()) {
            case "refbizitem": {
                this.addBizItemF7Filter(beforeF7SelectEvent);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "enable": {
                Boolean hasData = this.checkEntryHasData();
                if (hasData.booleanValue()) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u63a8\u9001\u914d\u7f6e\u4e2d\u8981\u5305\u542b\u81f3\u5c11\u4e00\u6761\u6570\u636e\u3002", (String)"GenBizDataEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        switch (fieldKey) {
            case "itemtype": {
                this.cleanOtherData(rowIndex, FIELD_ITEMNAME, FIELD_ITEMID, FIELD_DATATYPE, FIELD_REFBIZITEM);
                break;
            }
            case "itemname": {
                String newValue = (String)args.getChangeSet()[0].getNewValue();
                if (!SWCStringUtils.isEmpty((String)newValue)) break;
                this.cleanOtherData(rowIndex, FIELD_ITEMID, FIELD_DATATYPE, FIELD_REFBIZITEM);
                break;
            }
            case "areatype": {
                if (this.checkEntryHasData().booleanValue()) {
                    this.openAreaTypeChangeConfirm((String)args.getChangeSet()[0].getOldValue());
                    break;
                }
                this.checkAreaType();
                break;
            }
            case "country": {
                DynamicObject oldCountry = (DynamicObject)args.getChangeSet()[0].getOldValue();
                if (oldCountry == null) {
                    return;
                }
                if (!this.checkEntryHasData().booleanValue()) break;
                this.openCountryChangeConfirm(oldCountry.getString("id"));
                break;
            }
            case "isautogenbsed": {
                Boolean autoGen = (Boolean)args.getChangeSet()[0].getNewValue();
                this.changeFieldView(autoGen);
                break;
            }
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.checkAreaType();
        boolean autoGen = this.getModel().getDataEntity().getBoolean(FIELD_AUTOGEN);
        this.changeFieldView(autoGen);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        String customVaule = messageBoxClosedEvent.getCustomVaule();
        switch (callBackId) {
            case "changeAreaType": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.cleanConfigData(result, customVaule, callBackId);
                    break;
                }
                String oldAreaTypeValue = messageBoxClosedEvent.getCustomVaule();
                this.getModel().beginInit();
                this.getModel().setValue(FIELD_AREATYPE, (Object)oldAreaTypeValue);
                this.getModel().endInit();
                this.getView().updateView();
                break;
            }
            case "changeCountry": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.cleanConfigData(result, customVaule, callBackId);
                    break;
                }
                String oldCountryValue = messageBoxClosedEvent.getCustomVaule();
                this.getModel().beginInit();
                this.getModel().setValue(FIELD_COUNTRY, (Object)Long.valueOf(oldCountryValue));
                this.getModel().endInit();
                this.getView().updateView();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (SWCStringUtils.isEmpty((String)actionId)) {
            return;
        }
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (CollectionUtils.isEmpty((Collection)returnData)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        Long itemId = (Long)returnData.get(0).getPrimaryKeyValue();
        switch (actionId) {
            case "hsbs_supportitem": {
                this.setObjItemSelect(selectedRows[0], itemId, "hsbs_supportitem");
                break;
            }
            case "hsbs_salaryitem": {
                this.setObjItemSelect(selectedRows[0], itemId, "hsbs_salaryitem");
                break;
            }
            case "hsbs_bizitem": {
                this.setObjItemSelect(selectedRows[0], itemId, "hsbs_bizitem");
                break;
            }
            case "hsbs_fetchitem": {
                this.setObjItemSelect(selectedRows[0], itemId, "hsbs_fetchitem");
                break;
            }
        }
    }

    private void changeFieldView(Boolean autoGen) {
        FieldEdit typeField = (FieldEdit)this.getControl(FIELD_BASEDATETYPE);
        FieldEdit monthField = (FieldEdit)this.getControl(FIELD_MONTH);
        FieldEdit dateField = (FieldEdit)this.getControl(FIELD_DATETYPE);
        if (autoGen.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_BASEDATETYPE, FIELD_MONTH, FIELD_DATETYPE});
            this.setFieldMustInput(true, typeField, monthField, dateField);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_BASEDATETYPE, FIELD_MONTH, FIELD_DATETYPE});
            this.setFieldMustInput(false, typeField, monthField, dateField);
        }
    }

    private void setFieldMustInput(boolean must, FieldEdit ... field) {
        for (FieldEdit fieldEdit : field) {
            fieldEdit.setMustInput(must);
        }
    }

    private void cleanConfigData(MessageBoxResult result, String customVaule, String type) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.getModel().deleteEntryData("entryentity");
            this.checkAreaType();
        } else {
            this.getModel().beginInit();
            if (SWCStringUtils.equals((String)CHANGE_AREA_TYPE, (String)type)) {
                this.getModel().setValue(FIELD_AREATYPE, (Object)customVaule);
            }
            if (SWCStringUtils.equals((String)CHANGE_COUNTRY, (String)type)) {
                this.getModel().setValue(FIELD_COUNTRY, (Object)Long.valueOf(customVaule));
            }
            this.getModel().endInit();
            this.getView().updateView();
        }
    }

    private void openAreaTypeChangeConfirm(String oldValue) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CHANGE_AREA_TYPE, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u66f4\u6539\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\uff0c\u4e1a\u52a1\u6570\u636e\u63a8\u9001\u914d\u7f6e\u5185\u5bb9\u5c06\u4f1a\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"GenBizDataEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, null, options, ConfirmTypes.Default, confirmCallBacks, null, oldValue);
    }

    private void openCountryChangeConfirm(String oldValue) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CHANGE_COUNTRY, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u66f4\u6539\u56fd\u5bb6/\u5730\u533a\uff0c\u4e1a\u52a1\u6570\u636e\u63a8\u9001\u914d\u7f6e\u5185\u5bb9\u5c06\u4f1a\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"GenBizDataEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, null, options, ConfirmTypes.Default, confirmCallBacks, null, oldValue);
    }

    private void checkAreaType() {
        String areaType = this.getModel().getDataEntity().getString(FIELD_AREATYPE);
        FieldEdit countryField = (FieldEdit)this.getControl(FIELD_COUNTRY);
        if (FIELD_AREATYPE_GENERAL.equals(areaType)) {
            DynamicObject country = (DynamicObject)this.getModel().getValue(FIELD_COUNTRY);
            if (country != null) {
                this.getModel().beginInit();
                this.getModel().setValue(FIELD_COUNTRY, null);
                this.getModel().endInit();
                this.getView().updateView(FIELD_COUNTRY);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_COUNTRY});
            countryField.setMustInput(false);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_COUNTRY});
            countryField.setMustInput(true);
        }
    }

    private Boolean checkEntryHasData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null || entryEntity.size() == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void cleanOtherData(int rowIndex, String ... field) {
        for (String single : field) {
            this.getModel().beginInit();
            this.getModel().setValue(single, null, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(single, rowIndex);
        }
    }

    private void fillEntryItemName() {
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("entryentity");
        if (SWCListUtils.isEmpty((List)itemEntry)) {
            return;
        }
        Map itemTypeIdMap = itemEntry.stream().filter(single -> SWCStringUtils.isNotEmpty((String)single.getString(FIELD_ITEMTYPE))).collect(Collectors.groupingBy(single -> single.getString(FIELD_ITEMTYPE), Collectors.mapping(obj -> obj.getLong(FIELD_ITEMID), Collectors.toList())));
        GenBizDataService genBizDataService = new GenBizDataService();
        Map itemNameMap = genBizDataService.getItemNameByTypeAndId(itemTypeIdMap);
        for (DynamicObject entry : itemEntry) {
            entry.set(FIELD_ITEMNAME, itemNameMap.get(entry.getString(FIELD_ITEMTYPE) + "-" + entry.getString(FIELD_ITEMID)));
        }
        this.getView().updateView("entryentity");
    }

    private void addBizItemF7Filter(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter listFilterParameter = param.getListFilterParameter();
        List filterList = listFilterParameter.getQFilters();
        if (!this.setCountryFilter(filterList)) {
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        if (selectedRows != null && selectedRows.length > 0) {
            DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("entryentity");
            DynamicObject row = (DynamicObject)itemEntry.get(selectedRows[0]);
            Long dataTypeId = row.getLong("datatype.id");
            String itemName = row.getString(FIELD_ITEMNAME);
            String itemType = row.getString(FIELD_ITEMTYPE);
            if (SWCStringUtils.isEmpty((String)itemType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u9009\u62e9\u6620\u5c04\u4e1a\u52a1\u9879\u76ee\u4e4b\u524d\uff0c\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u7c7b\u578b\u3002", (String)"GenBizDataEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            if (SWCStringUtils.isEmpty((String)itemName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u9009\u62e9\u6620\u5c04\u4e1a\u52a1\u9879\u76ee\u4e4b\u524d\uff0c\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u540d\u79f0\u3002", (String)"GenBizDataEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            if (dataTypeId != null && dataTypeId > 0L) {
                filterList.add(new QFilter(FIELD_DATATYPE, "=", (Object)dataTypeId));
            }
        }
        QFilter validFilter = new QFilter("status", "=", (Object)"C");
        validFilter.and("enable", "=", (Object)FIELD_AREATYPE_GENERAL);
        filterList.add(new QFilter("cycle", "=", (Object)"0"));
        filterList.add(validFilter);
    }

    private List<Long> assembleSelectedItemId(String field) {
        ArrayList<Long> itemIdList = new ArrayList<Long>(10);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null || entryEntity.size() == 0) {
            return itemIdList;
        }
        for (DynamicObject obj : entryEntity) {
            itemIdList.add(obj.getLong(field));
        }
        return itemIdList;
    }

    private void setObjItemSelect(int selectIndex, Long itemId, String entity) {
        Long refDataType;
        GenBizDataService genBizDataService = new GenBizDataService();
        DynamicObject itemObj = genBizDataService.getItemObjByTypeAndId(entity, itemId);
        this.getModel().beginInit();
        this.getModel().setValue(FIELD_ITEMID, (Object)itemId, selectIndex);
        this.getModel().setValue(FIELD_ITEMNAME, (Object)itemObj.getString("name"), selectIndex);
        Long dataType = itemObj.getLong("datatype.id");
        this.getModel().setValue(FIELD_DATATYPE, (Object)dataType, selectIndex);
        DynamicObject refBizItem = (DynamicObject)this.getModel().getValue(FIELD_REFBIZITEM, selectIndex);
        if (null != refBizItem && dataType.compareTo(refDataType = Long.valueOf(refBizItem.getLong("datatype.id"))) != 0) {
            this.getModel().setValue(FIELD_REFBIZITEM, null, selectIndex);
        }
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void openItemMatchSelectF7(int rowIndex) {
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("entryentity");
        DynamicObject row = (DynamicObject)itemEntry.get(rowIndex);
        String itemType = row.getString(FIELD_ITEMTYPE);
        if (SWCStringUtils.isEmpty((String)itemType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u7c7b\u578b\u3002", (String)"GenBizDataEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (itemType) {
            case "1": {
                this.openSourceFieldF7("hsbs_salaryitem");
                break;
            }
            case "2": {
                this.openSourceFieldF7("hsbs_supportitem");
                break;
            }
            case "3": {
                this.openSourceFieldF7("hsbs_bizitem");
                break;
            }
            case "4": {
                this.openSourceFieldF7("hsbs_fetchitem");
                break;
            }
        }
    }

    private void openSourceFieldF7(String entity) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        if (!this.setCountryFilter(filterList)) {
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entity, (boolean)false);
        showParameter.setFormId("bos_listf7");
        showParameter.setBillFormId(entity);
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        long orgID = this.getModel().getDataEntity().getLong("createorg.id");
        IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
        QFilter qFilter = baseDataService.getBaseDataFilter(entity, Long.valueOf(orgID));
        qFilters.add(qFilter);
        if (SWCStringUtils.equals((String)entity, (String)"hsbs_fetchitem")) {
            GenBizDataService genBizDataService = new GenBizDataService();
            List itemCodeList = genBizDataService.selectRelatedFetchItem();
            if (CollectionUtils.isEmpty((Collection)itemCodeList)) {
                qFilters.add(new QFilter("enable", "=", (Object)"-1"));
            } else {
                qFilters.add(new QFilter("uniquecode", "in", (Object)itemCodeList));
            }
        }
        qFilters.add(new QFilter("enable", "=", (Object)FIELD_AREATYPE_GENERAL));
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        List<Long> selectedItemId = this.assembleSelectedItemId(FIELD_ITEMID);
        if (!CollectionUtils.isEmpty(selectedItemId)) {
            filterList.add(new QFilter("id", "not in", selectedItemId));
        }
        qFilters.addAll(filterList);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entity);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean setCountryFilter(List<QFilter> filterList) {
        String areaType = (String)this.getModel().getValue(FIELD_AREATYPE);
        if (SWCStringUtils.equals((String)areaType, (String)FIELD_AREATYPE_GENERAL)) {
            filterList.add(new QFilter(FIELD_AREATYPE, "=", (Object)areaType));
            return true;
        }
        DynamicObject country = (DynamicObject)this.getModel().getValue(FIELD_COUNTRY);
        if (country == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u56fd\u5bb6/\u5730\u533a\u3002", (String)"GenBizDataEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter filter = new QFilter(FIELD_COUNTRY, "=", (Object)country.getLong("id"));
        filter.or(new QFilter(FIELD_AREATYPE, "=", (Object)FIELD_AREATYPE_GENERAL));
        filterList.add(filter);
        return true;
    }
}

