/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.genbizdata;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.genbizdata.GenBizDataService;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class GenBizDataProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static Log log = LogFactory.getLog(GenBizDataProgressPlugin.class);
    private static final String KEY_BTN_BG = "btncancel";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTN_BG});
        ProgressBar progress = (ProgressBar)this.getControl("progress");
        progress.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject object) {
        super.afterBindData(object);
        this.getView().setVisible(Boolean.FALSE, new String[]{"finishap"});
        this.setText("totalcnt", this.getView().getFormShowParameter().getCustomParam("totalcnt") + "");
        this.setText("todocnt", this.getView().getFormShowParameter().getCustomParam("totalcnt") + "");
        ProgressBar progress = (ProgressBar)this.getControl("progress");
        progress.start();
    }

    public void onProgress(ProgressEvent progressEvent) {
        int progress = progressEvent.getProgress();
        log.info("onProgress:{}", (Object)progress);
        progress = this.updateProgressAndRetLabel();
        progressEvent.setProgress(progress);
    }

    private void checkFailMsg() {
        GenBizDataService service = new GenBizDataService();
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        List cacheFailMsg = service.getCacheFailMsg(taskId);
        if (!SWCListUtils.isEmpty((List)cacheFailMsg)) {
            Map progressMap = service.getGenBizDataProgressCache(taskId);
            log.info("progressMap:{}", (Object)progressMap.toString());
            Integer totalCnt = (Integer)progressMap.get("total");
            Integer successCnt = (Integer)progressMap.get("success");
            Integer failCnt = (Integer)progressMap.get("fail");
            String msg = ResManager.loadKDString((String)"\u5171{0}\u85aa\u8d44\u6863\u6848\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"GenBizDataProgressPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[]{totalCnt, successCnt, failCnt});
            FormShowParameter resultParameter = SWCShowFormServiceHelper.getOperationResultParameter((String)CalPersonOperationEnum.OP_GENBIZDATA.getOperationName(), (String)msg, (List)cacheFailMsg);
            this.getView().showForm(resultParameter);
        }
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if (KEY_BTN_BG.equals(controlKey)) {
            String finished = this.getView().getPageCache().get("finished");
            Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
            if (!SWCStringUtils.equals((String)"1", (String)finished)) {
                ISWCAppCache bgAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "genbizdata_bggroud_taskid_%s", taskId));
                String bgTaskId = (String)bgAppCache.get("bgTaskId", String.class);
                if (SWCStringUtils.isNotEmpty((String)bgTaskId)) {
                    HRBackgroundTaskHelper.getInstance().showBaskgroundTask(bgTaskId);
                }
                this.updateProgressAndRetLabel();
            } else {
                this.saveOpLog(true, CalPersonOperationEnum.OP_GENBIZDATA.getOperationName());
            }
            this.getView().close();
        }
    }

    public void pageRelease(EventObject e) {
        GenBizDataService service = new GenBizDataService();
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        service.removeCacheFailMsg(taskId);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (SWCStringUtils.equals((String)"failMsgConfirm", (String)callBackId)) {
            GenBizDataService service = new GenBizDataService();
            Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
            service.removeCacheFailMsg(taskId);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String finished = this.getView().getPageCache().get("finished");
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        if (!SWCStringUtils.equals((String)"1", (String)finished)) {
            ISWCAppCache bgAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "genbizdata_bggroud_taskid_%s", taskId));
            String bgTaskId = (String)bgAppCache.get("bgTaskId", String.class);
            if (SWCStringUtils.isNotEmpty((String)bgTaskId)) {
                HRBackgroundTaskHelper.getInstance().showBaskgroundTask(bgTaskId);
            }
        } else {
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(taskId), (String)CalPersonOperationEnum.OP_GENBIZDATA.getOperationKey());
        }
    }

    public void saveOpLog(boolean success, String opName) {
        MultiLangEnumBridge opDescBridge = success ? new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f\u3002", "CalPersonGenBizDataPlugin_9", "swc-hsas-formplugin") : new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25\u3002", "CalPersonGenBizDataPlugin_10", "swc-hsas-formplugin");
        try {
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u751f\u6210\u4e1a\u52a1\u6570\u636e", "CalPersonOperationEnum_40", "swc-hsbp-common");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)opName, (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
        }
        catch (Exception exception) {
            log.info("addLog error");
        }
    }

    private int updateProgressAndRetLabel() {
        int percentage;
        GenBizDataService service = new GenBizDataService();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long taskId = (Long)formShowParameter.getCustomParam("taskId");
        Map progressMap = service.getGenBizDataProgressCache(taskId);
        if (progressMap == null) {
            return 0;
        }
        log.info("progressMap:{}", (Object)progressMap.toString());
        Integer totalCnt = (Integer)progressMap.get("total");
        Integer successCnt = (Integer)progressMap.get("success");
        Integer failCnt = (Integer)progressMap.get("fail");
        this.setText("successcnt", successCnt + "");
        this.setText("failcnt", failCnt + "");
        this.setText("todocnt", totalCnt - successCnt - failCnt + "");
        if (totalCnt == successCnt + failCnt) {
            percentage = 100;
            this.getView().setVisible(Boolean.FALSE, new String[]{"ongenap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"finishap"});
            this.getView().getPageCache().put("finished", "1");
            this.checkFailMsg();
        } else {
            percentage = new BigDecimal(String.valueOf(successCnt + failCnt)).divide(new BigDecimal(String.valueOf(totalCnt)), 2, 1).multiply(new BigDecimal("100")).intValue();
        }
        this.setText("percent", percentage + "%");
        String startTiem = (String)formShowParameter.getCustomParam("starttime");
        String consumerTime = this.getCalTime(startTiem);
        this.setText("consumetimelabe", ResManager.loadKDString((String)"\u5df2\u8017\u65f6\uff1a{0}\u3002", (String)"GenBizDataProgressPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[]{consumerTime}));
        service.updateGenBizDataProcess(percentage, taskId);
        return percentage;
    }

    private String getCalTime(String startTime) {
        Date date;
        try {
            date = SWCDateTimeUtils.parseDate((String)startTime, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            date = new Date();
        }
        return SWCDateTimeUtils.getConsumeTime((Date)date);
    }

    private void setText(String key, String text) {
        Label control = (Label)this.getControl(key);
        if (control != null) {
            control.setText(text);
        }
    }
}

