/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.paynode;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.swc.hsas.business.paynode.PayNodeCacheHelper;
import kd.swc.hsas.business.paynode.PayNodeHelper;
import kd.swc.hsas.common.dto.PayNodeScmEntity;
import kd.swc.hsas.formplugin.web.cal.paynode.imports.IDataPort;
import kd.swc.hsas.formplugin.web.cal.paynode.imports.ImportConfig;
import kd.swc.hsas.formplugin.web.cal.paynode.imports.ListExporter;
import kd.swc.hsas.formplugin.web.cal.paynode.imports.ListTemplateExporter;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.imports.ValidateResults;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.entity.EntryColumnContainer;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.formplugin.imports.ProgressHandler;
import kd.swc.hsbp.formplugin.imports.event.DataImportEvent;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.openxml4j.util.ZipSecureFile;

public class PayNodeDynamicEntryImportEdit
extends SWCDataBaseEdit
implements IDataPort {
    private static final Log LOGGER = LogFactory.getLog(PayNodeDynamicEntryImportEdit.class);
    private static final char[] ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final String COMBOFIELD = "combofield";
    private static final String CALPERIODNUMBER = "calperiodnumber";
    private static final String PERIODNUMBER = "periodnumber";

    public void registerListener(EventObject e) {
        SWCPermissionServiceHelper.checkCancelDataAndFunctionRightWithException((IFormView)this.getView().getParentView(), (boolean)false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((String)"donothing_import", (String)operateKey)) {
            this.checkPermission("4715a0df000000ac", ResManager.loadKDString((String)"\u4fee\u6539", (String)"PayNodeDynamicEntryPlugin_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            ValidateResult result = new ValidateResult();
            result.setSuccess(true);
            if (result.isSuccess()) {
                IDataPort.openImportWindow(this.getView(), (IFormPlugin)this, ResManager.loadKDString((String)"\u65f6\u95f4\u7a97\u53e3\u5bfc\u5165\u8d77\u59cb\u9875", (String)"PayNodeDynamicEntryImportEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), "hsas_importstart");
            } else {
                IFormView pareView = this.getView().getParentView();
                for (OperateErrorInfo errorInfo : result.getAllErrorInfo()) {
                    pareView.showErrorNotification(errorInfo.getMessage());
                    this.getView().sendFormAction(pareView);
                }
            }
        }
        if (StringUtils.equals((String)"donothing_export", (String)operateKey)) {
            this.checkPermission("4715a0df000000ac", ResManager.loadKDString((String)"\u4fee\u6539", (String)"PayNodeDynamicEntryPlugin_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.doExport();
        }
    }

    private void checkPermission(String permItemId, String opName) {
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_paynodescm", (String)permItemId);
        if (!hasPerm) {
            throw new KDBizException(SWCPermissionServiceHelper.getNoPermTips((String)opName));
        }
    }

    private void doExport() {
        ZipSecureFile.setMinInflateRatio((double)-1.0);
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)this.getView(), (String)"entryentity");
        EntityType entityType = (EntityType)this.getView().getModel().getDataEntityType().getAllEntities().get("entryentity");
        ImportConfig importConfig = this.getExportConfig();
        ArrayList colWidths = Lists.newArrayList((Object[])new Integer[]{1, 1, 1, 5});
        ArrayList mustInput = Lists.newArrayList((Object[])new Integer[]{0, 0, 0, 0});
        if (this.isHis()) {
            colWidths.add(1);
            mustInput.add(0);
        }
        ListExporter exporter = this.getListExporter(wrapper, entityType, importConfig, colWidths, mustInput);
        exporter.writeTemplate();
        List<EntryColumnContainer> containers = PayNodeDynamicEntryImportEdit.getEntryColumnContainers(PayNodeDynamicEntryImportEdit.geEntryColumns(this.getView()), Sets.newHashSet());
        Map captions = SWCExportEntryHelper.getEntryFieldCaptions(containers);
        int index = SWCExportEntryHelper.calcSheetHeadHeight(containers) + 3;
        if (importConfig.getImportType() == ImportConfig.ImportType.Complete) {
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = grid.getSelectRows();
            DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity("entryentity");
            DynamicObjectCollection entryEntityExport = (DynamicObjectCollection)PayNodeHelper.deserialize((byte[])((byte[])PayNodeHelper.serialize((Serializable)entryEntity)));
            if (selectRows.length > 0) {
                entryEntityExport.clear();
            }
            for (int selectRow : selectRows) {
                entryEntityExport.add(entryEntity.get(selectRow));
            }
            entryEntityExport.forEach(dy -> dy.set(COMBOFIELD, (Object)("1".equals(dy.getString(COMBOFIELD)) ? ResManager.loadKDString((String)"\u662f", (String)"PayNodeDynamicEntryPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"PayNodeDynamicEntryPlugin_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]))));
            exporter.exportEntryTemplate(this.getView().getModel(), entryEntityExport, captions, index, importConfig);
        }
        String url = exporter.flush(this.getView().getModel().getDataEntityType(), importConfig.getTemplateFileName());
        this.getView().download(UrlService.getAttachmentFullUrl((String)url));
        this.getView().sendFormAction(this.getView());
    }

    private ImportConfig getExportConfig() {
        ImportConfig importConfig = this.getImportConfig();
        String templateFileName = ResManager.loadKDString((String)"\u65f6\u95f4\u7a97\u53e3\u5bfc\u51fa\u7ed3\u679c_", (String)"PayNodeDynamicEntryImportEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        importConfig.setTemplateFileName(templateFileName + this.getSuffix());
        importConfig.setTemplateWarningInfo(templateFileName + this.getSuffix());
        Set<String> ignoreSet = PayNodeDynamicEntryImportEdit.getIgnoreColumns(PayNodeDynamicEntryImportEdit.geEntryColumns(this.getView()));
        ImportConfig config = new ImportConfig();
        config.setImportType(ImportConfig.ImportType.Complete);
        config.setIgnoreColumns(ignoreSet);
        return importConfig;
    }

    @Override
    public ImportConfig getImportConfig() {
        List<Map<String, Object>> columns = PayNodeDynamicEntryImportEdit.geEntryColumns(this.getView());
        Set<String> ignoreSet = PayNodeDynamicEntryImportEdit.getIgnoreColumns(columns);
        ImportConfig config = new ImportConfig();
        config.setImportType(ImportConfig.ImportType.Complete);
        config.setMaxRowCount(10000);
        config.setClearColumns(Sets.newHashSet());
        config.setIgnoreColumns(ignoreSet);
        config.setTemplateCaption("");
        config.setTemplateWarningInfo(ResManager.loadKDString((String)"\u8bf7\u76f4\u63a5\u586b\u5199\u84dd\u8272\u533a\u57df\uff0c\u4e0d\u8981\u4fee\u6539\u672c\u6b21\u5bfc\u5165\u7684\u6a21\u677f\u3002\u65f6\u95f4\u5355\u5143\u683c\u7684\u586b\u5199\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss\u3002", (String)"PayNodeDynamicEntryImportEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        config.setModelName(ResManager.loadKDString((String)"\u65f6\u95f4\u7a97\u53e3", (String)"PayNodeDynamicEntryImportEdit_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        HashMap fieldAnnotation = Maps.newHashMap();
        fieldAnnotation.put("calperiodname", "cal_period_name");
        config.setFieldAnnotation(fieldAnnotation);
        String str = ResManager.loadKDString((String)"\u65f6\u95f4\u7a97\u53e3\u5bfc\u5165\u6a21\u677f_", (String)"PayNodeDynamicEntryImportEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        config.setTemplateFileName(str + this.getSuffix());
        return config;
    }

    private String getSuffix() {
        LocalDate now = LocalDate.now();
        return String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
    }

    @Override
    public DynamicObjectCollection getRowData() {
        List<DynamicObject> periods = this.getPeriods(this.isHis());
        IDataModel thisModel = this.getView().getModel();
        DynamicObjectCollection entryEntity = thisModel.getEntryEntity("entryentity");
        Map periodMap = entryEntity.stream().collect(Collectors.toMap(entry -> entry.getString(CALPERIODNUMBER), Function.identity()));
        DynamicObjectCollection dyColl = new DynamicObjectCollection(entryEntity.getDynamicObjectType(), null);
        ArrayList captions = Lists.newArrayList(this.getCaptions().keySet());
        Map<String, DynamicObject> payNode = this.getPayNodeHisEntry();
        int seq = 1;
        for (DynamicObject period : periods) {
            String combo = Optional.ofNullable(periodMap.get(period.get(PERIODNUMBER))).map(per -> per.getString(COMBOFIELD)).orElse("");
            if ("0".equals(combo)) continue;
            DynamicObject dy = dyColl.addNew();
            dy.set("seq", (Object)seq++);
            dy.set("calperiod", (Object)period);
            dy.set(CALPERIODNUMBER, period.get(PERIODNUMBER));
            dy.set("calperiodname", period.get("periodname"));
            Date startDate = period.getDate("startdate");
            Date endDate = period.getDate("enddate");
            String dateRange = SWCDateTimeUtils.formatDate((Date)startDate) + " ~ " + SWCDateTimeUtils.formatDate((Date)endDate);
            dy.set("daterange", (Object)dateRange);
            for (int j = 3; j < captions.size(); ++j) {
                String caption = (String)captions.get(j);
                String[] fieldIds = caption.split("_");
                DynamicObject payNodeDy = payNode.get(fieldIds[1]);
                boolean enable = payNodeDy.getBoolean("starttimebox");
                if (enable || !fieldIds[0].startsWith("start")) continue;
                dy.set(caption, (Object)ResManager.loadKDString((String)"\u4e0d\u9650\u5236", (String)"PayNodeDynamicEntryPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
        }
        return dyColl;
    }

    @Override
    public ListExporter getExporterConfig(EntryColumnWrapper wrapper, EntityType entryType, ImportConfig importConfig) {
        SWCExportEntryHelper.removeIgnoreColumn((List)wrapper.getContainers(), importConfig.getIgnoreColumns());
        ArrayList colWidths = Lists.newArrayList((Object[])new Integer[]{1, 1, 1, 5});
        ArrayList mustInput = Lists.newArrayList((Object[])new Integer[]{0, 0, 0, 0});
        return this.getListExporter(wrapper, entryType, importConfig, colWidths, mustInput);
    }

    private ListExporter getListExporter(EntryColumnWrapper wrapper, EntityType entryType, ImportConfig importConfig, List<Integer> colWidths, List<Integer> mustInput) {
        Map<String, DynamicObject> payNode = this.getPayNodeHisEntry();
        ListTemplateExporter exporter = new ListTemplateExporter(wrapper, entryType, importConfig);
        ArrayList captions = Lists.newArrayList(this.getCaptions().keySet());
        for (int i = 3; i < captions.size(); ++i) {
            colWidths.add(2);
            String caption = (String)captions.get(i);
            String[] fieldIds = caption.split("_");
            DynamicObject payNodeDy = payNode.get(fieldIds[1]);
            boolean enable = payNodeDy.getBoolean("starttimebox");
            if (!enable && fieldIds[0].startsWith("start")) {
                mustInput.add(0);
                continue;
            }
            mustInput.add(1);
        }
        exporter.setColWidths(colWidths.toArray(new Integer[0]));
        exporter.setMustInput(mustInput.toArray(new Integer[0]));
        return exporter;
    }

    private List<DynamicObject> getPeriods(boolean isHis) {
        IDataModel model = this.getView().getParentView().getModel();
        return PayNodeHelper.getPeriods((IFormView)this.getView(), (IDataModel)model, (boolean)isHis);
    }

    private boolean isHis() {
        IFormView parentView = this.getView().getParentView();
        return BaseDataHisHelper.isHisPage((IFormView)parentView);
    }

    @Override
    public ValidateResults onValidateTemplate(DataImportEvent evt) {
        List dataHead = evt.getDataHead();
        ((Map)dataHead.get(0)).remove(0);
        ((Map)dataHead.get(1)).remove(0);
        List dataRow = evt.getDataRow();
        AbstractFormPlugin source = (AbstractFormPlugin)evt.getSource();
        List<Map<String, Object>> columns = PayNodeDynamicEntryImportEdit.geEntryColumns(this.getView());
        List<EntryColumnContainer> containers = PayNodeDynamicEntryImportEdit.getEntryColumnContainers(columns, PayNodeDynamicEntryImportEdit.getIgnoreColumns(columns));
        int headHeight = SWCExportEntryHelper.calcSheetHeadHeight(containers);
        List<Map<Integer, String>> dataHeadSource = PayNodeDynamicEntryImportEdit.getSourceHeadData(containers, headHeight, this.getModel());
        ValidateResults validateResult = new ValidateResults(ErrorLevel.Error);
        if (CollectionUtils.isEmpty((Collection)dataHead) || CollectionUtils.isEmpty(dataHeadSource) || dataHead.size() != dataHeadSource.size()) {
            return this.getValidateFailResult(source, validateResult);
        }
        for (int i = 0; i < dataHead.size(); ++i) {
            Map<Integer, String> headSourceMap;
            Map headMap = (Map)dataHead.get(i);
            if (!this.colNotMatch(headMap, headSourceMap = dataHeadSource.get(i))) continue;
            return this.getValidateFailResult(source, validateResult);
        }
        if (CollectionUtils.isEmpty((Collection)dataRow)) {
            return this.getValidateFailResult(source, validateResult);
        }
        List<DynamicObject> periods = this.getPeriods(this.isHis());
        Map<String, DynamicObject> periodMap = periods.stream().collect(Collectors.toMap(dy -> dy.getString(PERIODNUMBER), Function.identity()));
        HashSet nums = Sets.newHashSetWithExpectedSize((int)dataRow.size());
        for (Map map : dataRow) {
            String periodNumber = (String)map.get(1);
            String calPeriodName = (String)map.get(2);
            nums.add(periodNumber);
            if (!this.periodNotMatch(periodMap, periodNumber, calPeriodName)) continue;
            LOGGER.warn("paynode row periodNumber is {}, periodName is {}", (Object)periodNumber, (Object)calPeriodName);
            return this.getValidateFailResult(source, validateResult);
        }
        if (dataRow.size() > nums.size()) {
            return this.getValidateFailResult(source, validateResult);
        }
        return validateResult;
    }

    private boolean colNotMatch(Map<Integer, String> headMap, Map<Integer, String> headSourceMap) {
        Collection<String> values = headMap.values();
        Collection<String> valuesSource = headSourceMap.values();
        LOGGER.info("targetJson is {},sourceJson is {}", (Object)JSON.toJSONString(values), (Object)JSON.toJSONString(valuesSource));
        if (values.size() != valuesSource.size()) {
            return true;
        }
        for (String next : values) {
            if (valuesSource.contains(next)) continue;
            return true;
        }
        return false;
    }

    private ValidateResults getValidateFailResult(AbstractFormPlugin source, ValidateResults validateResult) {
        validateResult.failed();
        source.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"PayNodeDynamicEntryImportEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        return validateResult;
    }

    private boolean checkForbid(String fieldId, boolean enable, String val) {
        return !enable && fieldId.startsWith("start") && StringUtils.isNotEmpty((String)val) && !ResManager.loadKDString((String)"\u4e0d\u9650\u5236", (String)"PayNodeDynamicEntryPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]).equals(val);
    }

    @Override
    public int getEffectiveDataRow(DataImportEvent evt) {
        return evt == null ? 0 : evt.getDataRow().size();
    }

    @Override
    public void dataImport(DataImportEvent evt) {
        Map<String, KeyValue> captions = this.getCaptions();
        List dataHead = evt.getDataHead();
        Map colMap = (Map)dataHead.get(0);
        List dataRow = evt.getDataRow();
        ProgressHandler processHandler = evt.getProcessHandler();
        DynamicObjectCollection payNodeScmEntries = this.getPayNodeScmEntries();
        List<DynamicObject> periods = this.getPeriods(true);
        Map<String, DynamicObject> periodMap = periods.stream().collect(Collectors.toMap(dy -> dy.getString(PERIODNUMBER), Function.identity()));
        ArrayList dataList = Lists.newArrayList();
        for (int i = 0; i < dataRow.size(); ++i) {
            String calPeriodName;
            Map rowMap = (Map)dataRow.get(i);
            boolean checkSuccess = true;
            String calPeriodNumber = (String)rowMap.get(1);
            if (this.periodNotMatch(periodMap, calPeriodNumber, calPeriodName = (String)rowMap.get(2))) {
                processHandler.putRowError(Integer.valueOf(i), ResManager.loadKDString((String)"\u6dfb\u52a0\u5931\u8d25\uff0c\u671f\u95f4\u622a\u6b62\u65e5\u671f\u9700\u665a\u4e8e\u7b49\u4e8e\u5355\u636e\u751f\u6548\u65e5\u671f\u3002", (String)"PayNodeDynamicEntryImportEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                continue;
            }
            for (int j = 4; j < ((Map)dataHead.get(0)).size(); ++j) {
                String field = (String)((Map)dataHead.get(0)).get(j);
                String[] fieldIds = field.split("_");
                Map<String, DynamicObject> payNode = this.getPayNodeHisEntry();
                DynamicObject payNodeDy = payNode.get(fieldIds[1]);
                boolean enable = payNodeDy.getBoolean("starttimebox");
                if (Objects.isNull(rowMap.get(j)) && (enable || fieldIds[0].startsWith("end"))) {
                    processHandler.putRowError(Integer.valueOf(i), ResManager.loadKDString((String)"\u5fc5\u586b\u6570\u636e\u5b58\u5728\u7a7a\u503c\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"PayNodeDynamicEntryImportEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    checkSuccess = false;
                    break;
                }
                String val = (String)rowMap.get(j);
                if (!this.checkForbid(fieldIds[0], enable, val)) continue;
                processHandler.putRowError(Integer.valueOf(i), ResManager.loadKDString((String)"\u3010%s\u3011\u672a\u542f\u7528\u5f00\u59cb\u65f6\u95f4\u9650\u5236\uff0c\u8bf7\u52ff\u586b\u5165\u6570\u636e", (String)"PayNodeDynamicEntryImportEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[]{payNodeDy.getString("nodename")}));
                checkSuccess = false;
                break;
            }
            if (!checkSuccess) continue;
            PayNodeScmEntity scmEntity = new PayNodeScmEntity();
            scmEntity.setCalPeriodId((Long)periodMap.get(calPeriodNumber).getPkValue());
            scmEntity.setPeriodNumber(calPeriodNumber);
            scmEntity.setPeriodName(calPeriodName);
            ArrayList subEntities = Lists.newArrayList();
            scmEntity.setPayNodes((List)subEntities);
            for (int col = 3; col < captions.size(); ++col) {
                PayNodeScmEntity.SubEntity subEntity;
                boolean isAfter;
                String val = (String)rowMap.get(col + 1);
                String colId = (String)colMap.get(col + 1);
                if (!this.checkTime(val)) {
                    processHandler.putRowError(Integer.valueOf(i), ResManager.loadKDString((String)"%s\u5217\u586b\u5165\u683c\u5f0f\u9519\u8bef\u3002", (String)"PayNodeDynamicEntryImportEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[]{Character.valueOf(ALPHABET[col + 1])}));
                    checkSuccess = false;
                    break;
                }
                if (colId.startsWith("start")) {
                    PayNodeScmEntity.SubEntity subEntity2 = new PayNodeScmEntity.SubEntity();
                    subEntities.add(subEntity2);
                    this.setSubEntity(subEntity2, val, colId, true);
                    continue;
                }
                if (!colId.startsWith("end") || (isAfter = this.setSubEntity(subEntity = (PayNodeScmEntity.SubEntity)subEntities.get(subEntities.size() - 1), val, colId, false))) continue;
                processHandler.putRowError(Integer.valueOf(i), ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u9700\u5c0f\u4e8e\u7b49\u4e8e\u622a\u6b62\u65f6\u95f4\u3002", (String)"PayNodeDynamicEntryImportEdit_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                checkSuccess = false;
            }
            if (!checkSuccess) continue;
            dataList.add(scmEntity);
        }
        List<PayNodeScmEntity> oldDataList = this.getOldDataList(payNodeScmEntries);
        List<PayNodeScmEntity> finalDataList = this.mergeDataList(oldDataList, dataList);
        int failSize = processHandler.getLogCache().size();
        processHandler.updateProgress(evt.getDataRow().size() - failSize, failSize);
        if (CollectionUtils.isNotEmpty(finalDataList)) {
            PayNodeCacheHelper.putPayNodeScmToCache((IFormView)this.getView(), finalDataList);
        }
    }

    private boolean periodNotMatch(Map<String, DynamicObject> periodMap, String calPeriodNumber, String calPeriodName) {
        return Objects.isNull(periodMap.get(calPeriodNumber)) || StringUtils.isNotEmpty((String)calPeriodName) && !calPeriodName.equals(periodMap.get(calPeriodNumber).getString("periodname"));
    }

    private Map<String, KeyValue> getCaptions() {
        List<Map<String, Object>> columns = PayNodeDynamicEntryImportEdit.geEntryColumns(this.getView());
        List<EntryColumnContainer> containers = PayNodeDynamicEntryImportEdit.getEntryColumnContainers(PayNodeDynamicEntryImportEdit.geEntryColumns(this.getView()), PayNodeDynamicEntryImportEdit.getIgnoreColumns(columns));
        return SWCExportEntryHelper.getEntryFieldCaptions(containers);
    }

    private DynamicObjectCollection getPayNodeScmEntries() {
        Map parentPageData = PayNodeCacheHelper.parseParentPageData((String)this.getView().getFormShowParameter().getParentPageId());
        return (DynamicObjectCollection)parentPageData.get("payNodeScmEntries");
    }

    private Map<String, DynamicObject> getPayNodeHisEntry() {
        Map parentPageData = PayNodeCacheHelper.parseParentPageData((String)this.getView().getFormShowParameter().getParentPageId());
        DynamicObjectCollection payNodeHisEntries = (DynamicObjectCollection)parentPageData.get("payNodeGrpHisEntries");
        return payNodeHisEntries.stream().collect(Collectors.toMap(ent -> ent.getString("id"), Function.identity()));
    }

    private List<PayNodeScmEntity> getOldDataList(DynamicObjectCollection payNodeScmEntries) {
        ArrayList oldDataList = Lists.newArrayList();
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity("entryentity");
        Map periodMap = entryEntity.stream().collect(Collectors.toMap(entry -> entry.getString(CALPERIODNUMBER), Function.identity()));
        payNodeScmEntries.forEach(entry -> {
            PayNodeScmEntity scmEntity = new PayNodeScmEntity();
            oldDataList.add(scmEntity);
            DynamicObject calPeriod = entry.getDynamicObject("calperiod");
            scmEntity.setCalPeriodId((Long)calPeriod.getPkValue());
            scmEntity.setPeriodNumber(calPeriod.getString("number"));
            scmEntity.setPeriodName(calPeriod.getString("name"));
            DynamicObject dyEnt = (DynamicObject)periodMap.get(scmEntity.getPeriodNumber());
            String combo = dyEnt.getString(COMBOFIELD);
            List properties = dyEnt.getDataEntityType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
            scmEntity.setChange("1".equals(combo));
            DynamicObjectCollection subEntryEntity = entry.getDynamicObjectCollection("subentryentity");
            ArrayList subEntities = Lists.newArrayList();
            scmEntity.setPayNodes((List)subEntities);
            subEntryEntity.forEach(sub -> {
                PayNodeScmEntity.SubEntity subEntity = new PayNodeScmEntity.SubEntity();
                subEntities.add(subEntity);
                subEntity.setPayNodeId((Long)sub.getDynamicObject("paynode").getPkValue());
                String endNodeTime = "endtime_".concat(sub.getString("paynode.id"));
                String startNodeTime = "starttime_".concat(sub.getString("paynode.id"));
                if (properties.contains(startNodeTime)) {
                    subEntity.setStartTime(dyEnt.getDate(startNodeTime));
                }
                if (properties.contains(endNodeTime)) {
                    subEntity.setEndTime(dyEnt.getDate(endNodeTime));
                }
            });
        });
        return oldDataList;
    }

    private List<PayNodeScmEntity> mergeDataList(List<PayNodeScmEntity> oldDataList, List<PayNodeScmEntity> dataList) {
        Map oldCollMap = oldDataList.stream().collect(Collectors.toMap(PayNodeScmEntity::getCalPeriodId, Function.identity()));
        Map newCollMap = dataList.stream().collect(Collectors.toMap(PayNodeScmEntity::getCalPeriodId, Function.identity()));
        oldCollMap.forEach((key, val) -> {
            if (val.isChange()) {
                newCollMap.putIfAbsent((Long)key, val);
            } else {
                newCollMap.put((Long)key, val);
            }
        });
        return new ArrayList<PayNodeScmEntity>(newCollMap.values());
    }

    private boolean setSubEntity(PayNodeScmEntity.SubEntity subEntity, String val, String col, boolean isStart) {
        if (Objects.isNull(subEntity)) {
            LOGGER.error("col must contain start");
            return false;
        }
        String payNodeId = col.substring(col.indexOf(95) + 1);
        subEntity.setPayNodeId(Long.valueOf(payNodeId));
        Date dateTime = null;
        try {
            dateTime = StringUtils.isEmpty((String)val) || ResManager.loadKDString((String)"\u4e0d\u9650\u5236", (String)"PayNodeDynamicEntryPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]).equals(val) ? null : SWCDateTimeUtils.parseDate((String)val);
        }
        catch (ParseException e) {
            LOGGER.error((Throwable)e);
        }
        if (isStart) {
            subEntity.setStartTime(dateTime);
            return true;
        }
        subEntity.setEndTime(dateTime);
        return Objects.isNull(subEntity.getStartTime()) || !subEntity.getStartTime().after(dateTime);
    }

    private boolean checkTime(String dateTime) {
        if (StringUtils.isEmpty((String)dateTime) || ResManager.loadKDString((String)"\u4e0d\u9650\u5236", (String)"PayNodeDynamicEntryPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]).equals(dateTime)) {
            return true;
        }
        try {
            SWCDateTimeUtils.parseDate((String)dateTime);
            return true;
        }
        catch (ParseException e) {
            LOGGER.error((Throwable)e);
            return false;
        }
    }

    @Override
    public void afterImport(DataImportEvent evt) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"ImportStartCloseCallBack")) {
            this.getView().updateView();
            List payNodeScmFromCache = PayNodeCacheHelper.getPayNodeScmFromCache((IFormView)this.getView());
            if (Objects.nonNull(payNodeScmFromCache)) {
                this.getView().returnDataToParent((Object)payNodeScmFromCache);
                this.getView().close();
            }
        }
    }

    private Set<String> getClearColumns(List<EntryColumnContainer> containers) {
        Map captions = SWCExportEntryHelper.getEntryFieldCaptions(containers);
        return captions.keySet().stream().filter(key -> key.startsWith("start") || key.startsWith("end")).collect(Collectors.toSet());
    }

    public static List<Map<String, Object>> geEntryColumns(IFormView entryView) {
        Map map = SWCExportEntryHelper.invokeLoadCustomControlMetas((IFormView)entryView);
        return SWCExportEntryHelper.getEntryColumnsFromMeta((Map)((Map)map.get("metas")), (String)"entryentity");
    }

    public static Set<String> getIgnoreColumns(List<Map<String, Object>> columns) {
        HashSet ignoreSet = Sets.newHashSet();
        SWCExportEntryHelper.getIgnoreColumn(columns);
        ignoreSet.add(COMBOFIELD);
        return ignoreSet;
    }

    public static List<EntryColumnContainer> getEntryColumnContainers(List<Map<String, Object>> columns, Set<String> ignoreSet) {
        EntryColumnWrapper wrapper = SWCExportEntryHelper.convertToEntryColumnInfo(columns);
        List containers = wrapper.getContainers();
        SWCExportEntryHelper.removeIgnoreColumn((List)containers, ignoreSet);
        return containers;
    }

    public static List<Map<Integer, String>> getSourceHeadData(List<EntryColumnContainer> containers, int headHeight, IDataModel model) {
        Map captions = SWCExportEntryHelper.getEntryFieldCaptions(containers);
        Map<Integer, String> entryColId = PayNodeDynamicEntryImportEdit.getEntryFiledId(captions);
        String[][] headArray = new String[headHeight][captions.size()];
        SWCExportEntryHelper.fillSheetHeadArray(containers, (String[][])headArray, (int)0, (int)0);
        List<Map<Integer, String>> headList = PayNodeDynamicEntryImportEdit.getEntryHeadStructs(headArray);
        ArrayList dataHeadSource = Lists.newArrayListWithCapacity((int)(headHeight + 1));
        dataHeadSource.add(entryColId);
        dataHeadSource.addAll(headList);
        return dataHeadSource;
    }

    public static Map<Integer, String> getEntryFiledId(Map<String, KeyValue> captions) {
        HashMap<Integer, String> result = new HashMap<Integer, String>(16);
        int i = 0;
        for (String key : captions.keySet()) {
            result.put(i, key);
            ++i;
        }
        return result;
    }

    public static List<Map<Integer, String>> getEntryHeadStructs(String[][] strArray) {
        ArrayList<Map<Integer, String>> resultList = new ArrayList<Map<Integer, String>>(strArray.length);
        for (int i = 0; i < strArray.length; ++i) {
            HashMap<Integer, String> map = new HashMap<Integer, String>(strArray[i].length);
            for (int j = 0; j < strArray[i].length; ++j) {
                if (null == strArray[i][j]) continue;
                map.put(j, strArray[i][j]);
            }
            resultList.add(map);
        }
        return resultList;
    }
}

