/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.paynode;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsas.business.cal.helper.CreateDynamicEntryHelper;
import kd.swc.hsas.business.paynode.PayNodeCacheHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class PayNodeDynamicEntryPlugin
extends SWCDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(PayNodeDynamicEntryPlugin.class);
    private static final String PAY_NODE = "paynode";
    public static final String START_TIME_FIELD = "starttime_";
    private static final String START_TEXT_FIELD = "starttext_";
    public static final String END_TIME_FIELD = "endtime_";
    private static final String END_TEXT_FIELD = "endtext_";
    private static final String IS_CHANGE = "combofield";
    private static final String IMAGE_KEY = "/icons/pc/state/already_processed.png";
    public static final String PARENT_STATUS = "parentStatus";
    private OperationStatus parentStatus = OperationStatus.ADDNEW;

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        Map parentPageData = PayNodeCacheHelper.parseParentPageData((String)formShowParameter.getParentPageId());
        DynamicObjectCollection payNodeGrpHisEntries = (DynamicObjectCollection)parentPageData.get("payNodeGrpHisEntries");
        this.setOperationStatus((Integer)parentPageData.get(PARENT_STATUS));
        EntryAp entryAp = this.createEntryAp();
        this.createComboField(formShowParameter, entryAp);
        this.createEntryDynamicField(payNodeGrpHisEntries, entryAp.getItems(), (Map)parentPageData.get("startFieldTypeMap"), (Map)parentPageData.get("endFieldTypeMap"));
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        Map parentPageData = PayNodeCacheHelper.parseParentPageData((String)this.getView().getFormShowParameter().getParentPageId());
        DynamicObjectCollection payNodeGrpHisEntries = (DynamicObjectCollection)parentPageData.get("payNodeGrpHisEntries");
        this.registerProperty(newMainType, payNodeGrpHisEntries, (Map)parentPageData.get("startFieldTypeMap"), (Map)parentPageData.get("endFieldTypeMap"));
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity");
        DataEntityPropertyCollection entityProperties = rows.getDynamicObjectType().getProperties();
        Map parentPageData = PayNodeCacheHelper.parseParentPageData((String)this.getView().getFormShowParameter().getParentPageId());
        DynamicObjectCollection payNodeScmEntries = (DynamicObjectCollection)parentPageData.get("payNodeScmEntries");
        String textFieldValue = ResManager.loadKDString((String)"\u4e0d\u9650\u5236", (String)"PayNodeDynamicEntryPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        for (DynamicObject payNodeScmEntry : payNodeScmEntries) {
            DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
            Map<String, DynamicObject> map = this.buildPayNodeScmSubMap(payNodeScmEntry);
            DynamicObject calPeriod = payNodeScmEntry.getDynamicObject("calperiod");
            this.setBaseDataFieldValue(newRow, calPeriod);
            if (map.size() > 0) {
                for (IDataEntityProperty tempProperty : entityProperties) {
                    String tempPropertyName = tempProperty.getName();
                    if (tempPropertyName.startsWith(START_TEXT_FIELD)) {
                        newRow.set(tempPropertyName, (Object)textFieldValue);
                        continue;
                    }
                    if (tempPropertyName.startsWith(START_TIME_FIELD)) {
                        newRow.set(tempPropertyName, (Object)map.get(tempPropertyName.substring(START_TIME_FIELD.length())).getDate("starttime"));
                        continue;
                    }
                    if (tempPropertyName.startsWith(END_TEXT_FIELD)) {
                        newRow.set(tempPropertyName, (Object)textFieldValue);
                        continue;
                    }
                    if (tempPropertyName.startsWith(END_TIME_FIELD)) {
                        newRow.set(tempPropertyName, (Object)map.get(tempPropertyName.substring(END_TIME_FIELD.length())).getDate("endtime"));
                        continue;
                    }
                    if (!tempPropertyName.startsWith(IS_CHANGE)) continue;
                    this.setChangeStatus(payNodeScmEntry, newRow, tempPropertyName);
                }
            }
            rows.add((Object)newRow);
        }
        e.setDataEntity((Object)dataEntity);
    }

    private void setChangeStatus(DynamicObject payNodeScmEntry, DynamicObject newRow, String tempPropertyName) {
        Date bredTime;
        boolean flag = false;
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView().getParentView())) {
            flag = true;
        }
        if ((bredTime = this.getView().getParentView().getModel().getDataEntity().getDate("bsed")) == null) {
            return;
        }
        Date calPeriodEndDate = payNodeScmEntry.getDynamicObject("calperiod").getDate("enddate");
        if (calPeriodEndDate.getTime() < bredTime.getTime() && flag) {
            newRow.set(tempPropertyName, (Object)"0");
        } else {
            newRow.set(tempPropertyName, (Object)"1");
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().getParentView().getPageCache().put("subPageId", this.getView().getPageId());
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map parentPageData = PayNodeCacheHelper.parseParentPageData((String)formShowParameter.getParentPageId());
        DynamicObjectCollection payNodeGrpHisEntries = (DynamicObjectCollection)parentPageData.get("payNodeGrpHisEntries");
        this.setOperationStatus((Integer)parentPageData.get(PARENT_STATUS));
        EntryAp entryAp = this.createEntryAp();
        this.createComboField(formShowParameter, entryAp);
        this.createEntryDynamicField(payNodeGrpHisEntries, entryAp.getItems(), (Map)parentPageData.get("startFieldTypeMap"), (Map)parentPageData.get("endFieldTypeMap"));
        this.buildRuntimeControl(entryAp);
        if (OperationStatus.VIEW.equals((Object)this.parentStatus) && !formShowParameter.getParentFormId().endsWith("his")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"clearselect", "moveentryup", "moveentrydown"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setStatus(this.parentStatus);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
        String[] fields = new String[properties.size()];
        for (int i = 0; i < properties.size(); ++i) {
            fields[i] = ((IDataEntityProperty)properties.get(i)).getName();
        }
        for (int index = 0; index < entryEntity.size(); ++index) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
            if (!SWCStringUtils.equals((String)"0", (String)dynamicObject.getString(IS_CHANGE))) continue;
            this.getView().setEnable(Boolean.FALSE, index, fields);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.startsWith(END_TEXT_FIELD) || key.startsWith(START_TEXT_FIELD)) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(key);
            textEdit.setEntryKey("entryentity");
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        } else if (key.startsWith(END_TIME_FIELD) || key.startsWith(START_TIME_FIELD)) {
            DateTimeEdit dateTimeEdit = new DateTimeEdit();
            dateTimeEdit.setKey(key);
            dateTimeEdit.setEntryKey("entryentity");
            dateTimeEdit.setView(this.getView());
            e.setControl((Control)dateTimeEdit);
        } else if (SWCStringUtils.equals((String)key, (String)IS_CHANGE)) {
            ComboEdit comboEdit = new ComboEdit();
            comboEdit.setKey(key);
            comboEdit.setEntryKey("entryentity");
            comboEdit.setView(this.getView());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "donothing_clear": {
                int[] rowIndexs = this.validateSelectIndexs(args);
                if (rowIndexs == null) {
                    return;
                }
                this.clearSelectValue(rowIndexs);
                break;
            }
            case "donothing_delentry": {
                int[] selectIndexs = this.validateSelectIndexs(args);
                if (selectIndexs == null) {
                    return;
                }
                this.delEntry(selectIndexs);
                break;
            }
        }
    }

    private int[] validateSelectIndexs(BeforeDoOperationEventArgs args) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndex = proxy.getEntryState("entryentity").getSelectedRows();
        if (rowIndex.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"PayNodeDynamicEntryPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return null;
        }
        return rowIndex;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndex);
        String propertyName = property.getName();
        if (propertyName.startsWith(START_TIME_FIELD)) {
            Date startTime = (Date)changeSet[0].getNewValue();
            if (this.validateStartTime(dynamicObject, propertyName, startTime)) {
                startTime = null;
                this.getModel().setValue(propertyName, null, rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u9700\u5c0f\u4e8e\u7b49\u4e8e\u622a\u6b62\u65f6\u95f4\u3002", (String)"PayNodeDynamicEntryPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
            IFormView parentView = this.getView().getParentView();
            IDataModel parentModel = parentView.getModel();
            this.updateParentFieldValue(parentModel, "starttime", startTime, dynamicObject, Long.valueOf(propertyName.substring(START_TIME_FIELD.length())));
            parentView.updateView("entryentity");
            this.getView().sendFormAction(parentView);
        } else if (propertyName.startsWith(END_TIME_FIELD)) {
            Date endTime = (Date)changeSet[0].getNewValue();
            if (this.validateEndTime(dynamicObject, propertyName, endTime)) {
                endTime = null;
                this.getModel().setValue(propertyName, null, rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u65f6\u95f4\u9700\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"PayNodeDynamicEntryPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
            IFormView parentView = this.getView().getParentView();
            IDataModel parentModel = parentView.getModel();
            this.updateParentFieldValue(parentModel, "endtime", endTime, dynamicObject, Long.valueOf(propertyName.substring(END_TIME_FIELD.length())));
            parentView.updateView("entryentity");
            this.getView().sendFormAction(parentView);
        }
    }

    private boolean validateEndTime(DynamicObject dynamicObject, String propertyName, Date endTime) {
        if (endTime == null) {
            return false;
        }
        Date startTime = null;
        String payNodePk = propertyName.substring(END_TIME_FIELD.length());
        Map parentPageData = PayNodeCacheHelper.parseParentPageData((String)this.getView().getFormShowParameter().getParentPageId());
        Map startFieldTypeMap = (Map)parentPageData.get("startFieldTypeMap");
        if (((Boolean)startFieldTypeMap.get(payNodePk)).booleanValue()) {
            startTime = dynamicObject.getDate(START_TIME_FIELD + payNodePk);
        }
        if (startTime != null) {
            return startTime.getTime() > endTime.getTime();
        }
        return false;
    }

    private boolean validateStartTime(DynamicObject dynamicObject, String propertyName, Date startTime) {
        if (startTime == null) {
            return false;
        }
        Date endTime = null;
        String payNodePk = propertyName.substring(START_TIME_FIELD.length());
        Map parentPageData = PayNodeCacheHelper.parseParentPageData((String)this.getView().getFormShowParameter().getParentPageId());
        Map endFieldTypeMap = (Map)parentPageData.get("endFieldTypeMap");
        if (((Boolean)endFieldTypeMap.get(payNodePk)).booleanValue()) {
            endTime = dynamicObject.getDate(END_TIME_FIELD + payNodePk);
        }
        if (endTime != null) {
            return startTime.getTime() > endTime.getTime();
        }
        return false;
    }

    private void clearSelectValue(int[] rowIndex) {
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        HashMap<Integer, DynamicObject> notEnableRows = new HashMap<Integer, DynamicObject>(16);
        for (int index : rowIndex) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", index);
            if (SWCStringUtils.equals((String)"0", (String)entryRowEntity.getString(IS_CHANGE))) {
                notEnableRows.put(index, entryRowEntity);
                continue;
            }
            DataEntityPropertyCollection properties = entryRowEntity.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String propertyName = property.getName();
                if (propertyName.startsWith(START_TIME_FIELD)) {
                    entryRowEntity.set(propertyName, null);
                    this.updateParentFieldValue(parentModel, "starttime", null, entryRowEntity, Long.valueOf(propertyName.substring(START_TIME_FIELD.length())));
                    continue;
                }
                if (!propertyName.startsWith(END_TIME_FIELD)) continue;
                entryRowEntity.set(propertyName, null);
                this.updateParentFieldValue(parentModel, "endtime", null, entryRowEntity, Long.valueOf(propertyName.substring(END_TIME_FIELD.length())));
            }
        }
        if (notEnableRows.size() < rowIndex.length) {
            parentView.updateView("entryentity");
            this.getView().sendFormAction(parentView);
            this.getView().updateView();
        }
        this.showInfo(notEnableRows, ResManager.loadKDString((String)"\u671f\u95f4\u201c%s\u201d\u4e0d\u5141\u8bb8\u53d8\u66f4\uff0c\u65e0\u6cd5\u6e05\u9664\u3002", (String)"PayNodeDynamicEntryPlugin_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
    }

    private void delEntry(int[] rowIndexs) {
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        HashMap<Integer, DynamicObject> notEnableRows = new HashMap<Integer, DynamicObject>(16);
        ArrayList<Integer> delIndexs = new ArrayList<Integer>(rowIndexs.length);
        ArrayList<Integer> delparentIndexs = new ArrayList<Integer>(rowIndexs.length);
        for (int index : rowIndexs) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", index);
            if (SWCStringUtils.equals((String)"0", (String)entryRowEntity.getString(IS_CHANGE))) {
                notEnableRows.put(index, entryRowEntity);
                continue;
            }
            DynamicObjectCollection payNodeScmEntries = parentModel.getEntryEntity("entryentity");
            int parentIndex = this.findParentPageEntryIndex(payNodeScmEntries, "calperiod", entryRowEntity.getLong("calperiod.id"));
            delparentIndexs.add(parentIndex);
            delIndexs.add(index);
        }
        this.getModel().deleteEntryRows("entryentity", delIndexs.stream().mapToInt(Integer::intValue).toArray());
        parentModel.deleteEntryRows("entryentity", delparentIndexs.stream().mapToInt(Integer::intValue).toArray());
        if (notEnableRows.size() < rowIndexs.length) {
            this.getView().sendFormAction(parentView);
            this.getView().updateView();
        }
        this.showInfo(notEnableRows, ResManager.loadKDString((String)"\u671f\u95f4\u201c%s\u201d\u4e0d\u5141\u8bb8\u53d8\u66f4\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"PayNodeDynamicEntryPlugin_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
    }

    private void showInfo(Map<Integer, DynamicObject> notEnableRows, String errMsg) {
        if (notEnableRows.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<Integer, DynamicObject> entry : notEnableRows.entrySet()) {
                DynamicObject value = entry.getValue();
                stringBuilder.append(value.getString("calperiodnumber"));
                stringBuilder.append('\u3001');
            }
            this.getView().showTipNotification(String.format(Locale.ROOT, errMsg, stringBuilder.substring(0, stringBuilder.length() - 1)));
        }
    }

    private void updateParentFieldValue(IDataModel parentModel, String fieldName, Object value, DynamicObject dynamicObject, Long payNodePk) {
        DynamicObjectCollection payNodeScmEntries = parentModel.getEntryEntity("entryentity");
        int entryIndex = this.findParentPageEntryIndex(payNodeScmEntries, "calperiod", dynamicObject.getLong("calperiod.id"));
        parentModel.setEntryCurrentRowIndex("entryentity", entryIndex);
        DynamicObject payNodeScmEntry = (DynamicObject)payNodeScmEntries.get(entryIndex);
        DynamicObjectCollection subEntryEntities = payNodeScmEntry.getDynamicObjectCollection("subentryentity");
        int subIndex = this.findParentPageEntryIndex(subEntryEntities, PAY_NODE, payNodePk);
        parentModel.setValue(fieldName, value, subIndex);
    }

    private int findParentPageEntryIndex(DynamicObjectCollection dynamicObjectCollection, String source, Long targetPk) {
        for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(index);
            DynamicObject sourceDynamicObject = dynamicObject.getDynamicObject(source);
            if (!targetPk.equals(sourceDynamicObject.getPkValue())) continue;
            return index;
        }
        return 0;
    }

    private void setOperationStatus(int parentStatusCustom) {
        this.parentStatus = OperationStatus.forValue((int)parentStatusCustom);
    }

    private EntryAp createEntryAp() {
        EntryAp entryAp = CreateDynamicEntryHelper.createEntryAp((String)"entryentity");
        List entryApItems = entryAp.getItems();
        entryApItems.add(CreateDynamicEntryHelper.createTextFieldAp((LocaleString)new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4\u7f16\u7801", (String)"PayNodeDynamicEntryPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0])), (String)"calperiodnumber"));
        entryApItems.add(CreateDynamicEntryHelper.createTextFieldAp((LocaleString)new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4\u540d\u79f0", (String)"PayNodeDynamicEntryPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0])), (String)"calperiodname"));
        entryApItems.add(CreateDynamicEntryHelper.createDateRangeField((LocaleString)new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4", (String)"PayNodeDynamicEntryPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0])), (String)"daterange"));
        return entryAp;
    }

    private void createEntryDynamicField(DynamicObjectCollection payNodeGrpHisEntries, List<ControlAp<?>> entryApItems, Map<String, Boolean> startFieldTypeMap, Map<String, Boolean> endFieldTypeMap) {
        for (DynamicObject payNodeGrpHisEnt : payNodeGrpHisEntries) {
            EntryFieldGroupAp entryFieldGroupAp = CreateDynamicEntryHelper.createEntryFieldGroupAp((String)payNodeGrpHisEnt.getString("nodename"));
            LocaleString startFieldName = new LocaleString(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4", (String)"PayNodeDynamicEntryPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            entryFieldGroupAp.getItems().add(this.createEntryTimeFieldAp(startFieldTypeMap, (Long)payNodeGrpHisEnt.getPkValue(), startFieldName, START_TIME_FIELD, START_TEXT_FIELD));
            LocaleString endFieldName = new LocaleString(ResManager.loadKDString((String)"\u622a\u6b62\u65f6\u95f4", (String)"PayNodeDynamicEntryPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            entryFieldGroupAp.getItems().add(this.createEntryTimeFieldAp(endFieldTypeMap, (Long)payNodeGrpHisEnt.getPkValue(), endFieldName, END_TIME_FIELD, END_TEXT_FIELD));
            entryApItems.add((ControlAp<?>)entryFieldGroupAp);
        }
    }

    private void registerProperty(MainEntityType newMainType, DynamicObjectCollection payNodeGrpHisEntries, Map<String, Boolean> startFieldTypeMap, Map<String, Boolean> endFieldTypeMap) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity");
        entryType.registerSimpleProperty((DynamicSimpleProperty)CreateDynamicEntryHelper.createTextProp((String)"calperiodnumber", (LocaleString)new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4\u7f16\u7801", (String)"PayNodeDynamicEntryPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]))));
        entryType.registerSimpleProperty((DynamicSimpleProperty)CreateDynamicEntryHelper.createTextProp((String)"calperiodname", (LocaleString)new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4\u540d\u79f0", (String)"PayNodeDynamicEntryPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]))));
        entryType.registerSimpleProperty((DynamicSimpleProperty)CreateDynamicEntryHelper.createTextProp((String)"daterange", (LocaleString)new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4", (String)"PayNodeDynamicEntryPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]))));
        entryType.registerSimpleProperty((DynamicSimpleProperty)CreateDynamicEntryHelper.createDateTimeProp((String)"calperiodenddate", (LocaleString)new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4\u7ed3\u675f\u65f6\u95f4", (String)"PayNodeDynamicEntryPlugin_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]))));
        entryType.registerSimpleProperty((DynamicSimpleProperty)CreateDynamicEntryHelper.createDateTimeProp((String)"calperiodstartdate", (LocaleString)new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4\u5f00\u59cb\u65f6\u95f4", (String)"PayNodeDynamicEntryPlugin_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]))));
        LocaleString startFieldName = new LocaleString(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4", (String)"PayNodeDynamicEntryPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        LocaleString endFieldName = new LocaleString(ResManager.loadKDString((String)"\u622a\u6b62\u65f6\u95f4", (String)"PayNodeDynamicEntryPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        for (DynamicObject payNodeGrpEnt : payNodeGrpHisEntries) {
            Long pkValue = (Long)payNodeGrpEnt.getPkValue();
            entryType.registerSimpleProperty((DynamicSimpleProperty)this.createTimeFieldProp(startFieldTypeMap.get(String.valueOf(pkValue)), START_TIME_FIELD + pkValue, START_TEXT_FIELD + pkValue, startFieldName));
            entryType.registerSimpleProperty((DynamicSimpleProperty)this.createTimeFieldProp(endFieldTypeMap.get(String.valueOf(pkValue)), END_TIME_FIELD + pkValue, END_TEXT_FIELD + pkValue, endFieldName));
        }
        entryType.registerSimpleProperty((DynamicSimpleProperty)CreateDynamicEntryHelper.createComboProp((String)IS_CHANGE, (LocaleString)new LocaleString(ResManager.loadKDString((String)"\u5141\u8bb8\u53d8\u66f4", (String)"PayNodeDynamicEntryPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]))));
    }

    private void buildRuntimeControl(EntryAp entryAp) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            if (fieldEdit instanceof Container) {
                List items = ((Container)fieldEdit).getItems();
                items.forEach(item -> {
                    item.setView(this.getView());
                    entryGrid.getItems().add(item);
                });
                continue;
            }
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
    }

    private void createComboField(FormShowParameter formShowParameter, EntryAp entryAp) {
        boolean isCurrPage = (Boolean)formShowParameter.getCustomParam("isCurrPage");
        EntryFieldAp comboFieldAp = CreateDynamicEntryHelper.createComFieldAp((String)IS_CHANGE, (LocaleString)new LocaleString(ResManager.loadKDString((String)"\u5141\u8bb8\u53d8\u66f4", (String)"PayNodeDynamicEntryPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        ComboField comboField = new ComboField();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"PayNodeDynamicEntryPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        comboItem.setImageKey(IMAGE_KEY);
        comboItem.setValue("1");
        comboItems.add(comboItem);
        comboField.setItems(comboItems);
        comboField.setId(IS_CHANGE);
        comboField.setKey(IS_CHANGE);
        comboFieldAp.setField((Field)comboField);
        if (isCurrPage) {
            comboFieldAp.setHidden(true);
        }
        Tips tips = new Tips();
        tips.setType("text");
        tips.setTriggerType("hover");
        tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u53ef\u53d8\u66f4\u7684\u671f\u95f4\u622a\u6b62\u65e5\u671f\u9700\u665a\u4e8e\u7b49\u4e8e\u8be5\u5355\u636e\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"PayNodeDynamicEntryPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        comboFieldAp.setCtlTips(tips);
        entryAp.getItems().add(comboFieldAp);
    }

    private EntryFieldAp createEntryTimeFieldAp(Map<String, Boolean> endDateMap, Long payNodePkValue, LocaleString fieldName, String timeField, String textField) {
        EntryFieldAp endDateTimeAp;
        if (endDateMap.get(payNodePkValue.toString()).booleanValue()) {
            endDateTimeAp = CreateDynamicEntryHelper.createDateTimeAp((LocaleString)fieldName, (String)(timeField + payNodePkValue));
            if (OperationStatus.VIEW.equals((Object)this.parentStatus)) {
                endDateTimeAp.setLock("new,edit,view,submit,audit");
            }
        } else {
            endDateTimeAp = CreateDynamicEntryHelper.createTextFieldAp((LocaleString)fieldName, (String)(textField + payNodePkValue));
        }
        endDateTimeAp.setWidth(new LocaleString("230px"));
        return endDateTimeAp;
    }

    private FieldProp createTimeFieldProp(Boolean fieldFlag, String timeField, String textField, LocaleString displayName) {
        Object startDateFieldProp = fieldFlag != false ? CreateDynamicEntryHelper.createDateTimeProp((String)timeField, (LocaleString)displayName) : CreateDynamicEntryHelper.createTextProp((String)textField, (LocaleString)displayName);
        return startDateFieldProp;
    }

    private void setBaseDataFieldValue(DynamicObject newRow, DynamicObject calPeriod) {
        newRow.set("calperiod", (Object)calPeriod);
        newRow.set("calperiodname", (Object)calPeriod.getString("name"));
        newRow.set("calperiodnumber", (Object)calPeriod.getString("number"));
        newRow.set("calperiodstartdate", (Object)calPeriod.getDate("startdate"));
        newRow.set("calperiodenddate", (Object)calPeriod.getDate("enddate"));
        String begin = HRInteDateTimeUtil.formatDate((String)"hsbs_calperiod", (String)"startdate", (Date)calPeriod.getDate("startdate"));
        String end = HRInteDateTimeUtil.formatDate((String)"hsbs_calperiod", (String)"enddate", (Date)calPeriod.getDate("enddate"));
        newRow.set("daterange", (Object)begin.concat(" ~ ").concat(end));
    }

    private Map<String, DynamicObject> buildPayNodeScmSubMap(DynamicObject payNodeScmEnt) {
        DynamicObjectCollection payNodeScmSub = payNodeScmEnt.getDynamicObjectCollection("subentryentity");
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        for (DynamicObject payNodeScmDtl : payNodeScmSub) {
            DynamicObject payNode = payNodeScmDtl.getDynamicObject(PAY_NODE);
            map.put(payNode.getString("id"), payNodeScmDtl);
        }
        return map;
    }
}

