/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.paynode;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.swc.hsas.business.paynode.PayNodeHelper;
import kd.swc.hsas.common.vo.PayNodeTimeConfig;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import org.apache.commons.lang3.StringUtils;

public class PayNodeGrpEntHisList
extends SWCDataBaseList {
    private static final String START_TIME_OPERATION = "starttimeoperation";
    public static final String START_TIME_CFG = "starttimecfg";
    private static final String END_TIME_OPERATION = "endtimeoperate";
    public static final String END_TIME_CFG = "endtimecfg";
    private static final String FIELD_START_TIME = "starttimeoperation";
    public static final String TIME_TYPE = "timetype";
    public static final String RULE_DESC = "ruledesc";
    public static final String DATA = "data";
    public static final String BEGIN_TIME = "begintime";
    public static final String END_TIME = "endtime";

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        String fieldKey = ((ColumnDesc)e.getSource()).getFieldKey();
        if ("starttimeoperation".equals(fieldKey) && e.getRowData().getBoolean("starttimebox")) {
            this.setReadCfg(e);
        }
        if (END_TIME_OPERATION.equals(fieldKey)) {
            this.setReadCfg(e);
        }
    }

    private void setReadCfg(PackageDataEvent e) {
        e.setFormatValue((Object)ResManager.loadKDString((String)"\u67e5\u770b\u89c4\u5219", (String)"PayNodeGrpEdit_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        FormShowParameter parameters = this.getFormShowParameter(args);
        this.getView().showForm(parameters);
    }

    private FormShowParameter getFormShowParameter(HyperLinkClickArgs args) {
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsas_paynodegrpenthis");
        Object pkVal = this.getCurrentListAllRowCollection().get(args.getRowIndex()).getPrimaryKeyValue();
        DynamicObject dyCfg = swcDataServiceHelper.queryOne("vid,starttimecfg,endtimecfg", pkVal);
        String startTimeCfg = dyCfg.getString(START_TIME_CFG);
        String endTimeCfg = dyCfg.getString(END_TIME_CFG);
        Long payNodeGrpHisId = dyCfg.getLong("vid");
        SWCDataServiceHelper payNodeServiceHelper = new SWCDataServiceHelper("hsas_paynodegrp");
        DynamicObject dyPayNodeGrpHis = payNodeServiceHelper.queryOne("calperiodtype,paynoderule", (Object)payNodeGrpHisId);
        SWCDataServiceHelper calPeriodServiceHelper = new SWCDataServiceHelper("hsbs_calperiodtype");
        DynamicObject calPeriodType = calPeriodServiceHelper.queryOne(dyPayNodeGrpHis.getDynamicObject("calperiodtype").getPkValue());
        String fieldName = args.getFieldName();
        String cfg = StringUtils.equals((CharSequence)"starttimeoperation", (CharSequence)fieldName) ? startTimeCfg : endTimeCfg;
        PayNodeTimeConfig payNodeTimeConfig = (PayNodeTimeConfig)JSONObject.parseObject((String)cfg, PayNodeTimeConfig.class);
        String ruleDesc = PayNodeHelper.buildRuleDesc((PayNodeTimeConfig)payNodeTimeConfig);
        Object workPlanId = this.getView().getFormShowParameter().getCustomParam("workPlanId");
        Long resultWorkPlanId = workPlanId instanceof Integer ? Long.valueOf(((Integer)workPlanId).longValue()) : (Long)workPlanId;
        JSONArray payNodePeriods = this.selectCalPeriods(calPeriodType, payNodeTimeConfig, resultWorkPlanId);
        int size = payNodePeriods.size();
        JSONArray rs = new JSONArray();
        for (int i = size; i > Math.max(size - 6, 0); --i) {
            rs.add((Object)payNodePeriods.getJSONObject(i - 1));
        }
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("hsas_paynodereadcfg");
        parameters.setShowTitle(false);
        parameters.setStatus(OperationStatus.VIEW);
        parameters.setCustomParam(TIME_TYPE, (Object)(StringUtils.equals((CharSequence)"starttimeoperation", (CharSequence)fieldName) ? BEGIN_TIME : END_TIME));
        parameters.setCustomParam(RULE_DESC, (Object)ruleDesc);
        parameters.setCustomParam(DATA, (Object)rs);
        return parameters;
    }

    private JSONArray selectCalPeriods(DynamicObject calPeriodType, PayNodeTimeConfig payNodeTimeConfig, Long workPlanId) {
        JSONArray payNodePeriods = new JSONArray();
        DynamicObjectCollection calPeriods = calPeriodType.getDynamicObjectCollection("entryentity");
        PayNodeHelper.buildTimeByTimeRule(noParam -> {
            for (int i = 0; i < calPeriods.size(); ++i) {
                DynamicObject calPeriod = (DynamicObject)calPeriods.get(i);
                Date startDate = calPeriod.getDate("startdate");
                Date endDate = calPeriod.getDate("enddate");
                String periodName = calPeriod.getString("periodname");
                String period = SWCDateTimeUtils.formatUseUserFormat((Date)startDate) + " ~ " + SWCDateTimeUtils.formatUseUserFormat((Date)endDate);
                Date time = PayNodeHelper.buildTimeByTimeRule((Long)workPlanId, (PayNodeTimeConfig)payNodeTimeConfig, (List)calPeriods, (int)i);
                JSONObject jo = new JSONObject();
                payNodePeriods.add((Object)jo);
                jo.put("periodName", (Object)periodName);
                jo.put("period", (Object)period);
                jo.put("time", (Object)time);
            }
        });
        return payNodePeriods;
    }
}

