/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.paynode;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.paynode.PayNodeHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import org.apache.commons.collections.CollectionUtils;

public class PayNodeList
extends SWCDataBaseList {
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "paynodegrp.calperiodtype.name": {
                QFilter baseDataFilter;
                HasPermOrgResult calPeriodTypePermOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_paynode", (String)"47150e89000000ac");
                if (calPeriodTypePermOrgs == null || calPeriodTypePermOrgs.hasAllOrgPerm() || (baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_calperiodtype", (List)calPeriodTypePermOrgs.getHasPermOrgs(), (boolean)true)) == null) break;
                filters.add(baseDataFilter);
                break;
            }
            case "paynodegrp.number": {
                QFilter baseDataFilter;
                HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_paynode", (String)"47150e89000000ac");
                if (permOrgs == null || permOrgs.hasAllOrgPerm() || (baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_paynodegrp", (List)permOrgs.getHasPermOrgs(), (boolean)true)) == null) break;
                filters.add(baseDataFilter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("enable".equals(operate.getOperateKey()) || "audit".equals(operate.getOperateKey())) {
            Object[] primaryKeyValues = args.getListSelectedData().getPrimaryKeyValues();
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paynode");
            DynamicObject[] payNodes = helper.query(primaryKeyValues);
            HashMap payNodeMap = Maps.newHashMap();
            for (DynamicObject payNode : payNodes) {
                String combineKey = this.getCombineKey(payNode);
                List dys = (List)payNodeMap.get(combineKey);
                if (CollectionUtils.isEmpty((Collection)dys)) {
                    payNodeMap.put(combineKey, Lists.newArrayList((Object[])new DynamicObject[]{payNode}));
                } else {
                    dys.add(payNode);
                }
                DynamicObject dy = PayNodeHelper.getSameCons((DynamicObject)payNode);
                if (!Objects.nonNull(dy)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c%s\u201d\u4e2d\u5df2\u5b58\u5728\u542f\u7528\u4e86\u5168\u90e8\u4e1a\u52a1\u9879\u76ee\u7684\u7ea6\u675f\u8bbe\u7f6e\uff0c\u8bf7\u5148\u7981\u7528\u540e\u518d\u6dfb\u52a0\u3002", (String)"PayNodeEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[]{dy.getString("name")}));
                args.setCancel(true);
                return;
            }
            AtomicBoolean showTip = new AtomicBoolean(false);
            StringBuilder msg = new StringBuilder();
            payNodeMap.forEach((key, val) -> {
                StringBuilder var = new StringBuilder();
                int allNum = 0;
                for (DynamicObject dy : val) {
                    if (!dy.getBoolean("bizallcfg")) continue;
                    String name = dy.getString("name");
                    var.append("\u3010".concat(name).concat("\u3011"));
                    ++allNum;
                }
                if (allNum < 2) {
                    return;
                }
                showTip.set(true);
                msg.append(ResManager.loadKDString((String)"%s\u4e2d\u5df2\u5b58\u5728\u542f\u7528\u4e86\u5168\u90e8\u4e1a\u52a1\u9879\u76ee\u7684\u7ea6\u675f\u8bbe\u7f6e", (String)"PayNodeEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[]{var.toString()}));
            });
            if (showTip.get()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u7ec4\u7ec7\u76f8\u540c\u671f\u95f4\u7c7b\u578b\u4e0b\uff0c\u4ec5\u5141\u8bb8\u5b58\u5728\u4e00\u6761\u542f\u7528\u4e86\u5168\u90e8\u4e1a\u52a1\u9879\u76ee\u7684\u6709\u6548\u6570\u636e\u3002", (String)"PayNodeEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private String getCombineKey(DynamicObject payNode) {
        Object pkId = payNode.getDynamicObject("createorg").getPkValue();
        long periodId = payNode.getDynamicObject("paynodegrphis").getLong("calperiodtype.id");
        return String.valueOf(pkId).concat("#").concat(String.valueOf(periodId));
    }
}

