/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.paynode;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.service.WorkCalendarLoadService;
import kd.swc.hsas.business.paynode.PayNodeCacheHelper;
import kd.swc.hsas.business.paynode.PayNodeHelper;
import kd.swc.hsas.business.paysalarysetting.PaySalarySettingHelper;
import kd.swc.hsas.common.dto.PayNodeScmEntity;
import kd.swc.hsas.common.vo.PayNodeTimeConfig;
import kd.swc.hsas.formplugin.web.basedata.HisBaseDataSummaryEdit;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.SerializationUtils;

public class PayNodeScmEdit
extends HisBaseDataSummaryEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(PayNodeScmEdit.class);
    private static final String CHANGE_BRED = "changeBred";
    private static final String CHANGE_BRED_DEL_CAL_PERIOD = "changeBredDelCalPeriod";
    private static final String CHANGE_HIS_BRED = "changeHisBred";
    private static final String CAL_PERIOD_TYPE = "calperiodtype";
    private static final String PAY_NODE_GRP = "paynodegrp";
    private static final String CHANGE_PAY_NODE_GRP = "changePayNodeGrp";
    private static final String CHANGE_PAY_NODE_GRP_HIS = "changePayNodeGrpHis";
    public static final String PAY_NODE_GRP_HIS = "paynodegrphis";
    private static final String START_CAL_PERIOD = "startcalperiod";
    private static final String END_CAL_PERIOD = "endcalperiod";
    public static final String CAL_PERIOD = "calperiod";
    public static final String CAL_PERIOD_START_DATE = "startdate";
    public static final String CAL_PERIOD_END_DATE = "enddate";
    private static final String PAY_NODE = "paynode";
    private static final String DO_NOTHING_GENERATE = "donothing_generate";
    public static final String DO_NOTHING_REBUILD = "donothing_rebuild";
    private static final String DO_NOTHING_GENERATE_CALLBACK = "donothing_generate_callback";
    private static final String DO_NOTHING_GENERATE_REBUILD_CALLBACK = "donothing_generate_rebuild";
    private static final String[] MUST_INPUT_FIELD = new String[]{"paynodegrp", "paynodegrphis", "startcalperiod", "endcalperiod", "bsed"};
    public static final String START_TIME_CHECK_BOX = "starttimebox";
    public static final String PAY_NODE_GRP_HIS_ENTRIES = "payNodeGrpHisEntries";
    public static final String PAY_NODE_SCM_ENTRIES = "payNodeScmEntries";
    public static final String SUB_ENTRY_ENTITY = "subentryentity";
    public static final String SUB_ENTRY_ENTITY_START_TIME = "starttime";
    public static final String SUB_ENTRY_ENTITY_END_TIME = "endtime";
    public static final String PAY_NODE_SCM_APP_CACHE = "payNodeScm";
    public static final String START_FIELD_TYPE_MAP = "startFieldTypeMap";
    public static final String END_FIELD_TYPE_MAP = "endFieldTypeMap";
    private static final String FREQUENCY = "frequency";
    private static final String NODE_NUMBER = "nodenumber";
    private static final String CLOSE_SUB_PAGE = "subpageclose";
    private static final String TRIGGERED = "triggered";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject(PAY_NODE_GRP);
        this.getView().setEnable(Boolean.valueOf(dynamicObject != null), new String[]{PAY_NODE_GRP_HIS});
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{PAY_NODE_GRP});
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            ISWCAppCache payNodeScmAppCache = SWCAppCache.get((String)(PAY_NODE_SCM_APP_CACHE + this.getView().getFormShowParameter().getPageId()));
            payNodeScmAppCache.put("entryentity", PayNodeScmEdit.serialize((Serializable)entryEntity));
        }
        this.showDynamicEntryPage();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit endPeriod = (BasedataEdit)this.getView().getControl(END_CAL_PERIOD);
        endPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit startPeriod = (BasedataEdit)this.getView().getControl(START_CAL_PERIOD);
        startPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payNodeGrp = (BasedataEdit)this.getView().getControl(PAY_NODE_GRP);
        payNodeGrp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payNodeGrpHis = (BasedataEdit)this.getView().getControl(PAY_NODE_GRP_HIS);
        payNodeGrpHis.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "endcalperiod": 
            case "startcalperiod": {
                this.beforeSelectCalPeriodF7(event);
                break;
            }
            case "paynodegrphis": {
                this.beforeSelectPayNodeGrpHisF7(event);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "donothing_generate": {
                this.batchGeneratePayNodeScmEnt(operate);
                break;
            }
            case "donothing_rebuild": {
                this.showDynamicEntryPage();
                break;
            }
            case "submit": 
            case "audit": 
            case "unsubmit": 
            case "save": 
            case "confirmchange": {
                OperationResult operationResult = args.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.showDynamicEntryPage();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        if (args.cancel) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "donothing_generate": {
                this.beforeGeneratePayNodeScmEnt(args, operate);
                break;
            }
            case "save": 
            case "submit": 
            case "audit": 
            case "confirmchange": {
                String subPageId = this.getPageCache().get("subPageId");
                if (SWCStringUtils.isEmpty((String)subPageId)) {
                    return;
                }
                IFormView view = this.getView().getView(subPageId);
                if (view != null) {
                    IDataModel subModel = view.getModel();
                    DynamicObjectCollection subModelEntryEntity = subModel.getEntryEntity("entryentity");
                    HashMap<Long, Integer> calPeriodEntryIndexMap = new HashMap<Long, Integer>(subModelEntryEntity.size());
                    for (int index = 0; index < subModelEntryEntity.size(); ++index) {
                        DynamicObject subEntryEntities = (DynamicObject)subModelEntryEntity.get(index);
                        calPeriodEntryIndexMap.put(subEntryEntities.getLong("calperiod.id"), index + 1);
                    }
                    if (!this.entryFieldMustInput(operateKey, calPeriodEntryIndexMap) || !this.validateStartEndTime(operateKey, calPeriodEntryIndexMap)) {
                        args.setCancel(true);
                        return;
                    }
                }
                this.resetOrderPayNodeScmEntry(args);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        IDataModel dataModel = this.getModel();
        switch (fieldKey) {
            case "bsed": {
                this.bredChanged(changeData[0]);
                break;
            }
            case "startcalperiod": 
            case "endcalperiod": {
                if (!this.validateStartEndDateOrder()) break;
                dataModel.setValue(fieldKey, null);
                this.showTipNotification(fieldKey);
                break;
            }
            case "paynodegrp": {
                this.payNodeGrpChanged(changeData[0], dataModel);
                break;
            }
            case "paynodegrphis": {
                this.payNodeGrpHisChanged(changeData[0]);
                break;
            }
        }
    }

    private void payNodeGrpHisChanged(ChangeData changeData) {
        String pkValue;
        this.setFrequency();
        if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("entryentity"))) {
            return;
        }
        DynamicObject oldPayNodeGrp = (DynamicObject)changeData.getOldValue();
        String string = pkValue = Objects.nonNull(oldPayNodeGrp) ? String.valueOf(oldPayNodeGrp.getPkValue()) : "";
        if ("1".equals(this.getView().getPageCache().get(TRIGGERED))) {
            this.getView().getPageCache().put(TRIGGERED, "0");
            return;
        }
        this.showConfirm(CHANGE_PAY_NODE_GRP_HIS, ResManager.loadKDString((String)"\u5207\u6362\u65f6\u95f4\u7a97\u53e3\u6a21\u677f\u7248\u672c\u5c06\u6e05\u9664\u65f6\u95f4\u7a97\u53e3\u5217\u8868\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayNodeScmEdit_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), "", pkValue);
    }

    private void setFrequency() {
        Long oldPk;
        Long frequency;
        this.getView().updateView(CAL_PERIOD_TYPE);
        DynamicObject payNodeGrpHis = this.getModel().getDataEntity().getDynamicObject(PAY_NODE_GRP_HIS);
        if (Objects.isNull(payNodeGrpHis)) {
            this.getModel().setValue(FREQUENCY, null);
            this.getView().updateView(FREQUENCY);
            return;
        }
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsbs_calperiodtype");
        DynamicObject calPeriodType = swcDataServiceHelper.queryOne("calfrequency", (Object)this.getModel().getDataEntity().getLong("paynodegrphis.calperiodtype.id"));
        if (calPeriodType != null && !(frequency = Long.valueOf(calPeriodType.getLong("calfrequency.id"))).equals(oldPk = Long.valueOf(this.getModel().getDataEntity().getLong("frequency.id")))) {
            this.getModel().setValue(FREQUENCY, (Object)frequency);
            this.getView().updateView(FREQUENCY);
            this.clearStartEndCalPeriod();
        }
    }

    private void clearStartEndCalPeriod() {
        IDataModel dataModel = this.getModel();
        DynamicObject dataEntity = dataModel.getDataEntity();
        dataEntity.set(END_CAL_PERIOD, null);
        dataEntity.set(START_CAL_PERIOD, null);
        this.getView().updateView(END_CAL_PERIOD);
        this.getView().updateView(START_CAL_PERIOD);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String customValue = messageBoxClosedEvent.getCustomVaule();
        switch (callBackId) {
            case "changeBred": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.changeBredCallBack();
                    break;
                }
                this.setTimeFieldOldValue(customValue);
                break;
            }
            case "changeBredDelCalPeriod": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.changeBredDelCalPeriodCallBack(customValue);
                    break;
                }
                JSONObject jsonObject = JSON.parseObject((String)customValue);
                this.setTimeFieldOldValue(jsonObject.getString("oldBredTime"));
                break;
            }
            case "changeHisBred": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    IDataModel dataModel = this.getModel();
                    int rowCount = dataModel.getEntryRowCount("entryentity");
                    dataModel.deleteEntryRows("entryentity", PaySalarySettingHelper.getDeleteRowIndexes((int)rowCount));
                    this.refreshEntryEntity();
                    this.resetSubEntryPayNode(this.getModel().getEntryEntity("entryentity"));
                    this.showDynamicEntryPage();
                    IFormView view = this.getView();
                    IPageCache pageCache = view.getPageCache();
                    pageCache.remove("hasChange");
                    break;
                }
                this.setTimeFieldOldValue(customValue);
                break;
            }
            case "changePayNodeGrp": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.changePayNodeGrpCallBack();
                    break;
                }
                this.setOldValue(customValue, PAY_NODE_GRP);
                break;
            }
            case "changePayNodeGrpHis": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.setPayNodeGrpHisChanged(customValue);
                    break;
                }
                this.getView().getPageCache().put(TRIGGERED, "1");
                this.getModel().setValue(PAY_NODE_GRP_HIS, (Object)Long.valueOf(customValue));
                this.getView().updateView(PAY_NODE_GRP_HIS);
                break;
            }
            case "donothing_generate_rebuild": {
                this.rebuildRepeatEntryCallBack(messageBoxClosedEvent);
                break;
            }
        }
    }

    private void setPayNodeGrpHisChanged(String customValue) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection payNodeScmEntries = this.getModel().getEntryEntity("entryentity");
        this.resetSubEntryPayNode(payNodeScmEntries);
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            Date bredTime = dataEntity.getDate("bsed");
            for (int i = payNodeScmEntries.size() - 1; i >= 0; --i) {
                DynamicObject dyEntry = (DynamicObject)payNodeScmEntries.get(i);
                Date endTime = dyEntry.getDynamicObject(CAL_PERIOD).getDate(CAL_PERIOD_END_DATE);
                if (!endTime.after(bredTime)) continue;
                this.getModel().deleteEntryRow("entryentity", i);
            }
            DynamicObject dy = this.getModel().getDataEntity().getDynamicObject(PAY_NODE_GRP_HIS);
            if (Objects.nonNull(dy)) {
                this.showDynamicEntryPage();
            } else {
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paynodegrp");
                DynamicObject oldPayNodeGrpHis = helper.queryOne((Object)customValue);
                SWCPageCache cache = new SWCPageCache(this.getView());
                cache.put(PAY_NODE_GRP_HIS, PayNodeScmEdit.serialize((Serializable)oldPayNodeGrpHis));
                this.showDynamicEntryPage(oldPayNodeGrpHis);
            }
        } else {
            this.getModel().deleteEntryData("entryentity");
            this.getView().setVisible(Boolean.TRUE, new String[]{"nodataflex"});
            this.closeSubPage();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "donothing_generate_callback": {
                Object entrySaveReturnData = closedCallBackEvent.getReturnData();
                if (!(entrySaveReturnData instanceof Boolean)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(DO_NOTHING_GENERATE, "true");
                this.getView().invokeOperation(DO_NOTHING_GENERATE, operateOption);
                break;
            }
            case "subpageclose": {
                List returnData = (List)closedCallBackEvent.getReturnData();
                if (!Objects.nonNull(returnData)) break;
                this.reCreateEntry(returnData);
                this.showDynamicEntryPage(null, false);
                break;
            }
        }
    }

    private boolean entryFieldMustInput(String operateKey, Map<Long, Integer> calPeriodEntryIndexMap) {
        ISWCAppCache payNodeScmAppCache = SWCAppCache.get((String)(PAY_NODE_SCM_APP_CACHE + this.getView().getPageId()));
        Map startFieldTypeMap = (Map)payNodeScmAppCache.get(START_FIELD_TYPE_MAP, Map.class);
        Map endFieldTypeMap = (Map)payNodeScmAppCache.get(END_FIELD_TYPE_MAP, Map.class);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String confirmMessage = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u65f6\u95f4\u7a97\u53e3\u201d\u7b2c%s\u884c\uff1a\u65f6\u95f4\u8282\u70b9", (String)"PayNodeScmEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        ArrayList<String> errorMessages = new ArrayList<String>();
        String number = this.getModel().getDataEntity().getString("number");
        String startTimeFieldName = ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4", (String)"PayNodeScmEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String endTimeFieldName = ResManager.loadKDString((String)"\u622a\u6b62\u65f6\u95f4", (String)"PayNodeScmEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        for (DynamicObject entryDynamicObject : entryEntity) {
            DynamicObjectCollection subEntries = entryDynamicObject.getDynamicObjectCollection(SUB_ENTRY_ENTITY);
            Long calPeriodPk = entryDynamicObject.getLong("calperiod.id");
            for (DynamicObject subEntry : subEntries) {
                long payNodePk = subEntry.getLong("paynode.id");
                String name = subEntry.getString("paynode.name");
                if (((Boolean)startFieldTypeMap.get(String.valueOf(payNodePk))).booleanValue() && subEntry.getDate(SUB_ENTRY_ENTITY_START_TIME) == null) {
                    errorMessages.add(number + '\uff1a' + String.format(Locale.ROOT, confirmMessage, calPeriodEntryIndexMap.get(calPeriodPk)) + '\u201c' + name + '\u201d' + '\u201c' + startTimeFieldName + "\u201d\u3002");
                }
                if (!((Boolean)endFieldTypeMap.get(String.valueOf(payNodePk))).booleanValue() || subEntry.getDate(SUB_ENTRY_ENTITY_END_TIME) != null) continue;
                errorMessages.add(number + '\uff1a' + String.format(Locale.ROOT, confirmMessage, calPeriodEntryIndexMap.get(calPeriodPk)) + '\u201c' + name + '\u201d' + '\u201c' + endTimeFieldName + "\u201d\u3002");
            }
        }
        if (!errorMessages.isEmpty()) {
            String formId = this.getView().getFormShowParameter().getFormId();
            String operationName = this.getOperationName(operateKey, formId);
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operationName, (String)ResManager.loadKDString((String)"\u672a\u5b8c\u6210", (String)"PayNodeScmEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), errorMessages);
            this.getView().showForm(parameters);
            return false;
        }
        return true;
    }

    private String getOperationName(String operateKey, String formId) {
        switch (operateKey) {
            case "save": {
                return ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"PayNodeScmEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            }
            case "submit": {
                return ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"PayNodeScmEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            }
            case "audit": {
                return ResManager.loadKDString((String)"\u5ba1\u6838", (String)"PayNodeScmEdit_35", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            }
            case "donothing_confirmchange": {
                return ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4", (String)"PayNodeScmEdit_34", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private void refreshEntryEntity() {
        ISWCAppCache payNodeScmAppCache = SWCAppCache.get((String)(PAY_NODE_SCM_APP_CACHE + this.getView().getFormShowParameter().getPageId()));
        byte[] payNodeScmEntryBytes = (byte[])payNodeScmAppCache.get("entryentity", byte[].class);
        DynamicObjectCollection payNodeScmEntries = (DynamicObjectCollection)PayNodeScmEdit.deserialize(payNodeScmEntryBytes);
        if (payNodeScmEntries == null) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter entry = new TableValueSetter(new String[0]);
        entry.addField(CAL_PERIOD, new Object[0]);
        for (DynamicObject entryDynamicObject : payNodeScmEntries) {
            long calPeriodId = entryDynamicObject.getLong("calperiod.id");
            entry.addRow(new Object[]{calPeriodId});
        }
        model.batchCreateNewEntryRow("entryentity", entry);
        for (int index = 0; index < payNodeScmEntries.size(); ++index) {
            DynamicObject entryDynamicObject;
            entryDynamicObject = (DynamicObject)payNodeScmEntries.get(index);
            model.setEntryCurrentRowIndex("entryentity", index);
            TableValueSetter subEntryTableSetter = new TableValueSetter(new String[0]);
            subEntryTableSetter.addField(PAY_NODE, new Object[0]);
            subEntryTableSetter.addField(SUB_ENTRY_ENTITY_START_TIME, new Object[0]);
            subEntryTableSetter.addField(SUB_ENTRY_ENTITY_END_TIME, new Object[0]);
            DynamicObjectCollection subEntries = entryDynamicObject.getDynamicObjectCollection(SUB_ENTRY_ENTITY);
            for (DynamicObject subEntry : subEntries) {
                subEntryTableSetter.addRow(new Object[]{subEntry.getLong("paynode.id"), subEntry.getDate(SUB_ENTRY_ENTITY_START_TIME), subEntry.getDate(SUB_ENTRY_ENTITY_END_TIME)});
            }
            model.batchCreateNewEntryRow(SUB_ENTRY_ENTITY, subEntryTableSetter);
        }
        model.endInit();
        this.getView().updateView(SUB_ENTRY_ENTITY);
        this.getView().updateView("entryentity");
    }

    private void payNodeGrpChanged(ChangeData changeDatum, IDataModel dataModel) {
        DynamicObject newPayNodeGrp = (DynamicObject)changeDatum.getNewValue();
        if (Objects.nonNull(newPayNodeGrp)) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paynodescm");
            List filters = PayNodeHelper.getAvailableFilters();
            QFilter qFilter = new QFilter(PAY_NODE_GRP, "=", newPayNodeGrp.getPkValue());
            QFilter notSelf = new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue());
            QFilter current = new QFilter("iscurrentversion", "=", (Object)"1");
            filters.add(qFilter);
            filters.add(notSelf);
            filters.add(current);
            DynamicObject existDy = helper.queryOne(filters.toArray(new QFilter[0]));
            if (Objects.nonNull(existDy)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5df2\u5b58\u5728\u6709\u6548\u7684\u65f6\u95f4\u7a97\u53e3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayNodeScmEdit_36", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                dataModel.setValue(PAY_NODE_GRP, null);
                return;
            }
        }
        if (dataModel.getEntryEntity("entryentity").isEmpty()) {
            if (newPayNodeGrp != null) {
                DynamicObject payNodeGrpHis = this.getPayNodeGrpHis(newPayNodeGrp.getPkValue());
                if (payNodeGrpHis != null) {
                    dataModel.setValue(PAY_NODE_GRP_HIS, payNodeGrpHis.getPkValue());
                } else {
                    dataModel.setValue(PAY_NODE_GRP_HIS, null);
                }
            } else {
                dataModel.setValue(PAY_NODE_GRP_HIS, null);
            }
            this.getView().updateView(PAY_NODE_GRP_HIS);
            this.getView().setEnable(Boolean.valueOf(newPayNodeGrp != null), new String[]{PAY_NODE_GRP_HIS});
        } else {
            DynamicObject oldPayNodeGrp = (DynamicObject)changeDatum.getOldValue();
            String pkValue = Objects.nonNull(oldPayNodeGrp) ? oldPayNodeGrp.getPkValue() + "" : "";
            this.showConfirm(CHANGE_PAY_NODE_GRP, ResManager.loadKDString((String)"\u5207\u6362\u65f6\u95f4\u7a97\u53e3\u6a21\u677f\u5c06\u6e05\u9664\u5217\u8868\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayNodeScmEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]), "", pkValue);
        }
    }

    private void bredChanged(ChangeData changeDatum) {
        Date newBred = (Date)changeDatum.getNewValue();
        Date oldBred = (Date)changeDatum.getOldValue();
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity("entryentity");
        if (entryEntity.size() > 0) {
            String oldBredTime;
            String string = oldBredTime = oldBred != null ? oldBred.getTime() + "" : "";
            if (newBred == null) {
                this.showConfirm(CHANGE_BRED, ResManager.loadKDString((String)"\u4fee\u6539\u5355\u636e\u751f\u6548\u65e5\u671f\uff0c\u5c06\u6e05\u9664\u65f6\u95f4\u7a97\u53e3\u5217\u8868\u4fe1\u606f\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayNodeScmEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]), "", oldBredTime);
                return;
            }
            if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
                this.hisBredChanged(oldBredTime);
                return;
            }
            this.currBredChanged(oldBredTime);
        } else {
            DynamicObject dataEntity = dataModel.getDataEntity();
            boolean flag = newBred == null ? dataModel.getDataEntity().getDynamicObject(PAY_NODE_GRP_HIS) != null : this.validatePayNodeGrpHis(newBred);
            if (flag) {
                dataModel.beginInit();
                dataEntity.set(PAY_NODE_GRP_HIS, null);
                dataModel.endInit();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u751f\u6548\u65e5\u671f\u5df2\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65f6\u95f4\u7a97\u53e3\u6a21\u677f\u7248\u672c\u3002", (String)"PayNodeScmEdit_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                this.getView().updateView(PAY_NODE_GRP_HIS);
            }
        }
    }

    private void hisBredChanged(String oldBredTime) {
        String subPageId = this.getPageCache().get("subPageId");
        if (SWCStringUtils.isEmpty((String)subPageId)) {
            return;
        }
        IFormView view = this.getView();
        IPageCache pageCache = view.getPageCache();
        String hasChange = pageCache.get("hasChange");
        IFormView subView = view.getView(subPageId);
        if (SWCStringUtils.isNotEmpty((String)hasChange) || subView != null && subView.getModel().getDataChanged() && SWCStringUtils.isNotEmpty((String)subView.getModel().getChangeDesc())) {
            this.showConfirm(CHANGE_HIS_BRED, ResManager.loadKDString((String)"\u5355\u636e\u751f\u6548\u65e5\u671f\u53d1\u751f\u53d8\u66f4\u3002\u90e8\u5206\u66f4\u6539\u5185\u5bb9\u65e0\u6cd5\u4fdd\u5b58\uff0c\u5217\u8868\u4fe1\u606f\u5c06\u56de\u9000\u81f3\u53d8\u66f4\u524d\u7248\u672c\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayNodeScmEdit_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]), "", oldBredTime);
        } else {
            DynamicObject payNodeGrpHis = this.getModel().getDataEntity().getDynamicObject(PAY_NODE_GRP_HIS);
            if (Objects.isNull(payNodeGrpHis)) {
                SWCPageCache cache = new SWCPageCache(this.getView());
                byte[] payNodeGrpHisBytes = (byte[])cache.get(PAY_NODE_GRP_HIS, byte[].class);
                payNodeGrpHis = (DynamicObject)PayNodeScmEdit.deserialize(payNodeGrpHisBytes);
            }
            this.showDynamicEntryPage(payNodeGrpHis);
        }
    }

    private void currBredChanged(String oldBredTime) {
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity("entryentity");
        ArrayList<DynamicObject> endDateLessThanBred = new ArrayList<DynamicObject>();
        ArrayList<Integer> deleteRowList = new ArrayList<Integer>(10);
        long bredTime = this.getModel().getDataEntity().getDate("bsed").getTime();
        for (int index = 0; index < entryEntity.size(); ++index) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
            DynamicObject calPeriod = dynamicObject.getDynamicObject(CAL_PERIOD);
            if (calPeriod.getDate(CAL_PERIOD_END_DATE).getTime() >= bredTime) continue;
            endDateLessThanBred.add(calPeriod);
            deleteRowList.add(index);
        }
        if (deleteRowList.size() > 0) {
            int[] deleteRows = deleteRowList.stream().mapToInt(Integer::intValue).toArray();
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("oldBredTime", oldBredTime);
            map.put("deleteRows", deleteRows);
            this.showConfirm(CHANGE_BRED_DEL_CAL_PERIOD, ResManager.loadKDString((String)"\u4fee\u6539\u5355\u636e\u751f\u6548\u65e5\u671f\uff0c\u5c06\u5bfc\u81f4\u4ee5\u4e0b\u671f\u95f4\u53ca\u65f6\u95f4\u7a97\u53e3\u4fe1\u606f\u4e0d\u53ef\u7528\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayNodeScmEdit_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]), this.buildDelConfirmMessages(endDateLessThanBred), JSONObject.toJSONString(map));
        }
    }

    private String buildDelConfirmMessages(List<DynamicObject> endDateLessThanBred) {
        StringBuilder stringBuilder = new StringBuilder();
        for (DynamicObject dynamicObject : endDateLessThanBred) {
            stringBuilder.append(dynamicObject.getString("number"));
            stringBuilder.append(',');
            stringBuilder.append(dynamicObject.getString("name"));
            stringBuilder.append("\\r\\n");
        }
        return stringBuilder.toString();
    }

    private void showConfirm(String actionId, String title, String messages, String customValue) {
        if (SWCStringUtils.isEmpty((String)customValue)) {
            this.getView().showConfirm(title, messages, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(actionId, (IFormPlugin)this));
        } else {
            this.getView().showConfirm(title, messages, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(actionId, (IFormPlugin)this), new HashMap(2), customValue);
        }
    }

    private void rebuildRepeatEntryCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        int result = messageBoxClosedEvent.getResult().getValue();
        if (MessageBoxResult.Yes.getValue() == result) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(DO_NOTHING_GENERATE_REBUILD_CALLBACK, "true");
            this.getView().invokeOperation(DO_NOTHING_GENERATE, operateOption);
        } else if (MessageBoxResult.No.getValue() == result) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(DO_NOTHING_GENERATE_REBUILD_CALLBACK, "false");
            this.getView().invokeOperation(DO_NOTHING_GENERATE, operateOption);
        }
    }

    private void changePayNodeGrpCallBack() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.beginInit();
        Object payNodeGrp = model.getValue(PAY_NODE_GRP);
        if (payNodeGrp != null) {
            DynamicObject dynamicObject = (DynamicObject)payNodeGrp;
            DynamicObject payNodeGrpHis = this.getPayNodeGrpHis(dynamicObject.getPkValue());
            if (Objects.nonNull(payNodeGrpHis)) {
                model.setValue(PAY_NODE_GRP_HIS, payNodeGrpHis.getPkValue());
            } else {
                model.setValue(PAY_NODE_GRP_HIS, null);
            }
        } else {
            model.setValue(PAY_NODE_GRP_HIS, null);
        }
        model.endInit();
        model.deleteEntryData("entryentity");
        view.setEnable(Boolean.valueOf(payNodeGrp != null), new String[]{PAY_NODE_GRP_HIS});
        this.setNoDataFlexVisible();
        view.updateView("entryentity");
        view.updateView(PAY_NODE_GRP_HIS);
        this.closeSubPage();
        this.setFrequency();
    }

    private DynamicObject getPayNodeGrpHis(Object pkValue) {
        SWCDataServiceHelper payNodeGrpHisServiceHelper = new SWCDataServiceHelper("hsas_paynodegrp");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter boFilter = new QFilter("boid", "in", pkValue);
        BaseDataHisHelper.addHisVerFilter((QFilter)boFilter);
        qFilters.add(boFilter);
        Date bsed = this.getModel().getDataEntity().getDate("bsed");
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)bsed);
        QFilter bredFilter = new QFilter("bsed", "<=", (Object)bsed);
        bsledFilter.and(bredFilter);
        qFilters.add(bsledFilter);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        qFilters.add(dataStatusFilter);
        DynamicObject[] query = payNodeGrpHisServiceHelper.query("datastatus,bsed,paynoderule", qFilters.toArray(new QFilter[0]), "bsed desc");
        DynamicObject result = null;
        for (DynamicObject dynamicObject : query) {
            if (!"1".equals(dynamicObject.getString("datastatus"))) continue;
            result = dynamicObject;
            break;
        }
        if (result == null && query.length > 0) {
            long min = 0L;
            result = query[0];
            for (DynamicObject dynamicObject : query) {
                Date dataBsed = dynamicObject.getDate("bsed");
                long dateDiff = SWCDateTimeUtils.dateDiff((String)"d", (Date)bsed, (Date)dataBsed);
                if (min < Math.abs(dateDiff)) continue;
                min = dateDiff;
                result = dynamicObject;
            }
        }
        return result;
    }

    private void changeBredDelCalPeriodCallBack(String customValue) {
        JSONObject jsonObject = JSON.parseObject((String)customValue);
        JSONArray deleteRows = jsonObject.getJSONArray("deleteRows");
        IDataModel model = this.getModel();
        model.deleteEntryRows("entryentity", deleteRows.toJavaList(Integer.TYPE).stream().mapToInt(Integer::intValue).toArray());
        this.showDynamicEntryPage();
    }

    private void changeBredCallBack() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        model.beginInit();
        dataEntity.set(PAY_NODE_GRP_HIS, null);
        model.endInit();
        model.deleteEntryData("entryentity");
        this.setNoDataFlexVisible();
        this.getView().updateView("entryentity");
        this.getView().updateView(PAY_NODE_GRP_HIS);
        this.closeSubPage();
    }

    private void setTimeFieldOldValue(String customValue) {
        if (SWCStringUtils.isEmpty((String)customValue)) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().setValue("bsed", (Object)new Date(Long.parseLong(customValue)));
        this.getModel().endInit();
        this.getView().updateView("bsed");
    }

    private void setOldValue(String customValue, String field) {
        if (SWCStringUtils.isEmpty((String)customValue)) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().setValue(field, (Object)Long.valueOf(customValue));
        this.getModel().endInit();
        this.getView().updateView(field);
    }

    private boolean validatePayNodeGrpHis(Date newBred) {
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject(PAY_NODE_GRP_HIS);
        if (dynamicObject != null) {
            Date payNodeGrpHisBred = dynamicObject.getDate("bsed");
            return payNodeGrpHisBred.getTime() > newBred.getTime();
        }
        return false;
    }

    private boolean validateStartEndDateOrder() {
        boolean flag = false;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject startCalPeriod = dataEntity.getDynamicObject(START_CAL_PERIOD);
        DynamicObject endCalPeriod = dataEntity.getDynamicObject(END_CAL_PERIOD);
        if (startCalPeriod != null && endCalPeriod != null) {
            Date calPeriodStartDate = startCalPeriod.getDate(CAL_PERIOD_START_DATE);
            Date calPeriodEndDate = endCalPeriod.getDate(CAL_PERIOD_START_DATE);
            flag = calPeriodStartDate.after(calPeriodEndDate);
        }
        return flag;
    }

    private void showDynamicEntryPage(DynamicObject payNodeGrpHis) {
        this.showDynamicEntryPage(payNodeGrpHis, true);
    }

    private void showDynamicEntryPage(DynamicObject payNodeGrpHis, boolean closeSubPage) {
        DynamicObjectCollection payNodeScmEntries;
        if (closeSubPage) {
            this.closeSubPage();
        }
        if ((payNodeScmEntries = this.getModel().getEntryEntity("entryentity")).isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"nodataflex"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"nodataflex"});
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection payNodeGrpHisEntries = Objects.isNull(payNodeGrpHis) ? dataEntity.getDynamicObject(PAY_NODE_GRP_HIS).getDynamicObjectCollection("entryentity") : payNodeGrpHis.getDynamicObjectCollection("entryentity");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("isCurrPage", (Object)BaseDataHisHelper.isCurrPage((IFormView)this.getView()));
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("dynamicentryap");
        formShowParameter.setFormId("hsas_paynodedyent");
        formShowParameter.setShowTitle(false);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_SUB_PAGE));
        payNodeScmEntries.sort((o1, o2) -> {
            Date endTime2;
            Date endTime1 = o1.getDynamicObject(CAL_PERIOD).getDate(CAL_PERIOD_END_DATE);
            if (endTime1.before(endTime2 = o2.getDynamicObject(CAL_PERIOD).getDate(CAL_PERIOD_END_DATE))) {
                return 1;
            }
            if (endTime1.after(endTime2)) {
                return -1;
            }
            return 0;
        });
        for (int i = 0; i < payNodeScmEntries.size(); ++i) {
            DynamicObject dy = (DynamicObject)payNodeScmEntries.get(i);
            dy.set("seq", (Object)(i + 1));
        }
        PayNodeCacheHelper.putAppCache((IFormView)this.getView(), (DynamicObjectCollection)payNodeScmEntries, (DynamicObjectCollection)payNodeGrpHisEntries);
        this.getView().showForm(formShowParameter);
    }

    private void showDynamicEntryPage() {
        this.showDynamicEntryPage(null);
    }

    private void resetSubEntryPayNode(DynamicObjectCollection payNodeScmEntries) {
        if (CollectionUtils.isEmpty((Collection)payNodeScmEntries)) {
            return;
        }
        DynamicObjectCollection subEntry = this.getModel().getEntryEntity(SUB_ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)subEntry)) {
            return;
        }
        DynamicObject newPayNodeGrpHis = this.getModel().getDataEntity().getDynamicObject(PAY_NODE_GRP_HIS);
        if (Objects.nonNull(newPayNodeGrpHis)) {
            DynamicObjectCollection payNodeGrpHisEntries = newPayNodeGrpHis.getDynamicObjectCollection("entryentity");
            Map<String, Long> numberIdMap = payNodeGrpHisEntries.stream().collect(Collectors.toMap(dy -> dy.getString(NODE_NUMBER), dy -> dy.getLong("id")));
            for (int i = 0; i < subEntry.size(); ++i) {
                String oldNumber = ((DynamicObject)subEntry.get(i)).getString("paynode.number");
                Long newId = numberIdMap.get(oldNumber);
                this.getModel().setValue(PAY_NODE, (Object)newId, i);
            }
        }
        for (DynamicObject dy2 : payNodeScmEntries) {
            DynamicObjectCollection subDyCollection = dy2.getDynamicObjectCollection(SUB_ENTRY_ENTITY);
            for (int i = 0; i < subDyCollection.size(); ++i) {
                DynamicObject subDy = (DynamicObject)subDyCollection.get(i);
                subDy.set(PAY_NODE, ((DynamicObject)this.getModel().getEntryEntity(SUB_ENTRY_ENTITY).get(i)).get(PAY_NODE));
            }
        }
    }

    public static Object serialize(Serializable value) {
        return SerializationUtils.serialize((Serializable)value);
    }

    public static Serializable deserialize(byte[] value) {
        return value == null ? null : (Serializable)SerializationUtils.deserialize((byte[])value);
    }

    private void setNoDataFlexVisible() {
        DynamicObjectCollection payNodeScmEntries = this.getModel().getEntryEntity("entryentity");
        if (payNodeScmEntries.size() == 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"nodataflex"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"nodataflex"});
        }
    }

    private void closeSubPage() {
        String subPageId = this.getPageCache().get("subPageId");
        if (SWCStringUtils.isEmpty((String)subPageId)) {
            return;
        }
        IFormView view = this.getView().getView(subPageId);
        if (view != null) {
            view.close();
            this.getView().sendFormAction(view);
        }
    }

    private void beforeSelectCalPeriodF7(BeforeF7SelectEvent event) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject calPeriodType = dataEntity.getDynamicObject("paynodegrphis.calperiodtype");
        if (SWCObjectUtils.isEmpty((Object)calPeriodType)) {
            event.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65f6\u95f4\u7a97\u53e3\u6a21\u677f\u7248\u672c\u3002", (String)"PayNodeScmEdit_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        List<QFilter> qFilters = this.buildCalPeriodTypeFilters(calPeriodType);
        if (CollectionUtils.isEmpty(qFilters)) {
            return;
        }
        ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setQFilters(qFilters);
        this.getView().getPageCache().put("periodtypename", calPeriodType.getString("name"));
    }

    private List<QFilter> buildCalPeriodTypeFilters(DynamicObject calPeriodType) {
        DynamicObjectCollection collection;
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsbs_calperiodtype");
        DynamicObject calPeriodWithEntity = swcDataServiceHelper.queryOne("entryentity", calPeriodType.getPkValue());
        List<Object> ids = new ArrayList();
        if (calPeriodWithEntity != null && CollectionUtils.isNotEmpty((Collection)(collection = calPeriodWithEntity.getDynamicObjectCollection("entryentity")))) {
            ids = calPeriodWithEntity.getDynamicObjectCollection("entryentity").stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        }
        return Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "in", ids)});
    }

    private void beforeSelectPayNodeGrpHisF7(BeforeF7SelectEvent event) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date bsed = dataEntity.getDate("bsed");
        if (bsed == null) {
            event.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u5f53\u524d\u5355\u636e\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"PayNodeScmEdit_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        } else {
            List<QFilter> qFilters = this.buildPayNodeGrpHisFilters(dataEntity);
            if (CollectionUtils.isNotEmpty(qFilters)) {
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setQFilters(qFilters);
            }
        }
    }

    private List<QFilter> buildPayNodeGrpHisFilters(DynamicObject dataEntity) {
        DynamicObject payNodeGrp = dataEntity.getDynamicObject(PAY_NODE_GRP);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter boFilter = new QFilter("boid", "in", payNodeGrp.getPkValue());
        qFilters.add(boFilter);
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)dataEntity.getDate("bsed"));
        QFilter bredFilter = new QFilter("bsed", "<=", (Object)dataEntity.getDate("bsed"));
        bsledFilter.and(bredFilter);
        qFilters.add(bsledFilter);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        qFilters.add(dataStatusFilter);
        return qFilters;
    }

    private void beforeGeneratePayNodeScmEnt(BeforeDoOperationEventArgs args, FormOperate operate) {
        if (operate.getOption().tryGetVariableValue(DO_NOTHING_GENERATE, new RefObject())) {
            return;
        }
        IFormView formView = this.getView();
        List<String> mustInputCheck = this.mustInputCheck();
        if (!mustInputCheck.isEmpty()) {
            args.setCancel(true);
            String message = this.buildMustInputMessage(mustInputCheck);
            formView.showTipNotification(message);
            return;
        }
        long bredTime = this.getModel().getDataEntity().getDate("bsed").getTime();
        DynamicObject payNodeGrpHis = this.getModel().getDataEntity().getDynamicObject(PAY_NODE_GRP_HIS);
        if (payNodeGrpHis.getDate("bsed").getTime() > bredTime || payNodeGrpHis.getDate("bsled").getTime() < bredTime) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u751f\u6548\u65e5\u671f\u4e0b\uff0c\u65f6\u95f4\u7a97\u53e3\u6a21\u677f\u7248\u672c\u4e0d\u53ef\u7528\u3002\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayNodeScmEdit_21", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        List<DynamicObject> calPeriods = this.selectCalPeriods();
        if (this.getEndDateLessThanBred(calPeriods).size() == calPeriods.size()) {
            args.setCancel(true);
            this.buildAddFailMessage(calPeriods);
            return;
        }
        Map<Integer, DynamicObject> repeat = new HashMap<Integer, DynamicObject>(16);
        HashMap<Integer, DynamicObject> remainCalperiods = new HashMap<Integer, DynamicObject>(16);
        this.buildDelAndRepeatCalPeriods(calPeriods, remainCalperiods, repeat);
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            repeat = this.hisFilterEndDateLessBred(repeat, bredTime);
        }
        if (this.rebuildRepeatConfirm(args, operate, repeat)) {
            return;
        }
    }

    private boolean rebuildRepeatConfirm(BeforeDoOperationEventArgs args, FormOperate operate, Map<Integer, DynamicObject> repeat) {
        if (!operate.getOption().tryGetVariableValue(DO_NOTHING_GENERATE_REBUILD_CALLBACK, new RefObject())) {
            if (repeat.size() > 0) {
                args.setCancel(true);
                this.rebuildRepeatConfirmMessage(repeat);
                return true;
            }
        } else if (operate.getOption().getVariableValue(DO_NOTHING_GENERATE_REBUILD_CALLBACK).equals("true")) {
            operate.getOption().setVariableValue(DO_NOTHING_GENERATE_REBUILD_CALLBACK, "true");
        }
        return false;
    }

    private void batchGeneratePayNodeScmEnt(FormOperate operate) {
        List<DynamicObject> calPeriods = this.selectCalPeriods();
        int totalCount = calPeriods.size();
        HashMap<Integer, DynamicObject> remainCalperiods = new HashMap<Integer, DynamicObject>(16);
        Map<Integer, DynamicObject> repeatCalPeriods = new HashMap<Integer, DynamicObject>(16);
        List<DynamicObject> endDateLessThanBred = this.getEndDateLessThanBred(calPeriods);
        this.buildDelAndRepeatCalPeriods(calPeriods, remainCalperiods, repeatCalPeriods);
        calPeriods.removeAll(repeatCalPeriods.values());
        calPeriods.removeAll(endDateLessThanBred);
        this.sortCalPeriod(calPeriods);
        IDataModel model = this.getModel();
        DynamicObject payNodeGrpHis = model.getDataEntity().getDynamicObject(PAY_NODE_GRP_HIS);
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            long bredTime = model.getDataEntity().getDate("bsed").getTime();
            repeatCalPeriods = this.hisFilterEndDateLessBred(repeatCalPeriods, bredTime);
        }
        if (operate.getOption().tryGetVariableValue(DO_NOTHING_GENERATE_REBUILD_CALLBACK, new RefObject())) {
            if (operate.getOption().getVariableValue(DO_NOTHING_GENERATE_REBUILD_CALLBACK).equals("true")) {
                this.rebuildRepeatEntry(calPeriods, repeatCalPeriods, payNodeGrpHis);
            } else {
                this.checkSubEntryFiledType(repeatCalPeriods, model, payNodeGrpHis);
            }
        }
        this.createEntry(calPeriods, payNodeGrpHis);
        this.showDynamicEntryPage();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"PayNodeScmEdit_37", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
    }

    private void sortCalPeriod(List<DynamicObject> calPeriods) {
        calPeriods.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                long o1EndDate = o1.getDate(PayNodeScmEdit.CAL_PERIOD_END_DATE).getTime();
                long o2EndDate = o2.getDate(PayNodeScmEdit.CAL_PERIOD_END_DATE).getTime();
                return Long.compare(o2EndDate, o1EndDate);
            }
        });
    }

    private void checkSubEntryFiledType(Map<Integer, DynamicObject> repeatCalPeriods, IDataModel model, DynamicObject payNodeGrpHis) {
        DynamicObjectCollection payNodeGrpHisEntries = payNodeGrpHis.getDynamicObjectCollection("entryentity");
        HashMap<String, Boolean> startFieldTypeMap = new HashMap<String, Boolean>(16);
        HashMap<String, Boolean> endFieldTypeMap = new HashMap<String, Boolean>(16);
        for (DynamicObject dynamicObject : payNodeGrpHisEntries) {
            startFieldTypeMap.put(dynamicObject.getString(NODE_NUMBER), dynamicObject.getBoolean(START_TIME_CHECK_BOX));
            endFieldTypeMap.put(dynamicObject.getString(NODE_NUMBER), Boolean.TRUE);
        }
        model.beginInit();
        for (Map.Entry<Integer, DynamicObject> entrySet : repeatCalPeriods.entrySet()) {
            DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", entrySet.getKey().intValue());
            DynamicObjectCollection subEntryEntities = entryRowEntity.getDynamicObjectCollection(SUB_ENTRY_ENTITY);
            for (DynamicObject subEntryEntity : subEntryEntities) {
                String payNodeNumber = subEntryEntity.getString("paynode.number");
                if (!((Boolean)startFieldTypeMap.get(payNodeNumber)).booleanValue()) {
                    subEntryEntity.set(SUB_ENTRY_ENTITY_START_TIME, null);
                }
                if (((Boolean)endFieldTypeMap.get(payNodeNumber)).booleanValue()) continue;
                subEntryEntity.set(SUB_ENTRY_ENTITY_END_TIME, null);
            }
        }
        model.endInit();
    }

    private Map<Integer, DynamicObject> hisFilterEndDateLessBred(Map<Integer, DynamicObject> calPeriods, long bredTime) {
        HashMap<Integer, DynamicObject> result = new HashMap<Integer, DynamicObject>(calPeriods.size());
        for (Map.Entry<Integer, DynamicObject> entry : calPeriods.entrySet()) {
            DynamicObject calPeriod = entry.getValue();
            if (calPeriod.getDate(CAL_PERIOD_END_DATE).getTime() <= bredTime) continue;
            result.put(entry.getKey(), calPeriod);
        }
        return result;
    }

    private void rebuildRepeatEntry(List<DynamicObject> calPeriods, Map<Integer, DynamicObject> repeatCalPeriodMap, DynamicObject payNodeGrpHis) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        HashMap<Integer, List<Map<String, String>>> workDataList = new HashMap<Integer, List<Map<String, String>>>(16);
        DynamicObjectCollection payNodeGrpHisEntries = payNodeGrpHis.getDynamicObjectCollection("entryentity");
        for (DynamicObject payNodeGrpHisEntry : payNodeGrpHisEntries) {
            map.put(payNodeGrpHisEntry.getString(NODE_NUMBER), payNodeGrpHisEntry);
        }
        IDataModel model = this.getModel();
        DynamicObject createOrg = payNodeGrpHis.getDynamicObject("createorg");
        ArrayList<DynamicObject> repeatCalPeriods = new ArrayList<DynamicObject>(repeatCalPeriodMap.values());
        repeatCalPeriods.addAll(calPeriods);
        this.sortCalPeriod(repeatCalPeriods);
        for (Map.Entry<Integer, DynamicObject> entrySet : repeatCalPeriodMap.entrySet()) {
            int index = this.getCurrentCalPeriodIndex(repeatCalPeriods, entrySet);
            DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", entrySet.getKey().intValue());
            DynamicObjectCollection subEntryEntities = entryRowEntity.getDynamicObjectCollection(SUB_ENTRY_ENTITY);
            for (DynamicObject subEntryEntity : subEntryEntities) {
                DynamicObject payNodeGrpHisEntry = (DynamicObject)map.get(subEntryEntity.getDynamicObject(PAY_NODE).getString("number"));
                subEntryEntity.set(SUB_ENTRY_ENTITY_START_TIME, (Object)this.buildTimeByTimeRule(payNodeGrpHisEntry, repeatCalPeriods, index, (Long)createOrg.getPkValue(), SUB_ENTRY_ENTITY_START_TIME, workDataList));
                subEntryEntity.set(SUB_ENTRY_ENTITY_END_TIME, (Object)this.buildTimeByTimeRule(payNodeGrpHisEntry, repeatCalPeriods, index, (Long)createOrg.getPkValue(), SUB_ENTRY_ENTITY_END_TIME, workDataList));
            }
        }
    }

    private int getCurrentCalPeriodIndex(List<DynamicObject> calPeriods, Map.Entry<Integer, DynamicObject> entrySet) {
        for (int index = 0; index < calPeriods.size(); ++index) {
            if (!entrySet.getValue().equals(calPeriods.get(index))) continue;
            return index;
        }
        LOGGER.error("not find current calPeriod");
        return 0;
    }

    private void createEntry(List<DynamicObject> calPeriods, DynamicObject payNodeGrpHis) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int beforeCreateEntryRowCount = model.getEntryRowCount("entryentity");
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", this.createEntryTableSetter(calPeriods));
        HashMap<Integer, List<Map<String, String>>> workDataList = new HashMap<Integer, List<Map<String, String>>>(16);
        for (int index = 0; index < calPeriods.size(); ++index) {
            model.setEntryCurrentRowIndex("entryentity", index + beforeCreateEntryRowCount);
            TableValueSetter subEntryTableSetter = this.createSubEntryTableSetter(payNodeGrpHis, calPeriods, workDataList, index);
            model.batchCreateNewEntryRow(SUB_ENTRY_ENTITY, subEntryTableSetter);
        }
        model.endInit();
        this.getView().updateView(SUB_ENTRY_ENTITY);
        this.getView().updateView("entryentity");
    }

    private void reCreateEntry(List<PayNodeScmEntity> returnData) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int rowCount = model.getEntryRowCount("entryentity");
        model.deleteEntryRows("entryentity", PaySalarySettingHelper.getDeleteRowIndexes((int)rowCount));
        model.beginInit();
        TableValueSetter entry = new TableValueSetter(new String[0]);
        entry.addField(CAL_PERIOD, new Object[0]);
        for (PayNodeScmEntity scmEntity : returnData) {
            entry.addRow(new Object[]{scmEntity.getCalPeriodId()});
        }
        model.batchCreateNewEntryRow("entryentity", entry);
        for (int i = 0; i < returnData.size(); ++i) {
            PayNodeScmEntity scmEntity;
            scmEntity = returnData.get(i);
            model.setEntryCurrentRowIndex("entryentity", i);
            TableValueSetter subEntryTableSetter = new TableValueSetter(new String[0]);
            subEntryTableSetter.addField(PAY_NODE, new Object[0]);
            subEntryTableSetter.addField(SUB_ENTRY_ENTITY_START_TIME, new Object[0]);
            subEntryTableSetter.addField(SUB_ENTRY_ENTITY_END_TIME, new Object[0]);
            for (PayNodeScmEntity.SubEntity subEntity : scmEntity.getPayNodes()) {
                subEntryTableSetter.addRow(new Object[]{subEntity.getPayNodeId(), subEntity.getStartTime(), subEntity.getEndTime()});
            }
            model.batchCreateNewEntryRow(SUB_ENTRY_ENTITY, subEntryTableSetter);
        }
        model.endInit();
        this.getView().updateView(SUB_ENTRY_ENTITY);
        this.getView().updateView("entryentity");
    }

    private TableValueSetter createEntryTableSetter(List<DynamicObject> calPeriods) {
        TableValueSetter entry = new TableValueSetter(new String[0]);
        entry.addField(CAL_PERIOD, new Object[0]);
        for (DynamicObject dynamicObject : calPeriods) {
            long calPeriodId = dynamicObject.getLong("id");
            entry.addRow(new Object[]{calPeriodId});
        }
        return entry;
    }

    private TableValueSetter createSubEntryTableSetter(DynamicObject payNodeGrpHis, List<DynamicObject> calPeriods, Map<Integer, List<Map<String, String>>> workDataList, int index) {
        TableValueSetter subEntryEntity = new TableValueSetter(new String[0]);
        subEntryEntity.addField(PAY_NODE, new Object[0]);
        subEntryEntity.addField(SUB_ENTRY_ENTITY_START_TIME, new Object[0]);
        subEntryEntity.addField(SUB_ENTRY_ENTITY_END_TIME, new Object[0]);
        DynamicObjectCollection payNodeGrpHisEntries = payNodeGrpHis.getDynamicObjectCollection("entryentity");
        for (DynamicObject payNodeGrpHisEntry : payNodeGrpHisEntries) {
            subEntryEntity.addRow(new Object[]{payNodeGrpHisEntry.getPkValue(), this.buildTimeByTimeRule(payNodeGrpHisEntry, calPeriods, index, null, SUB_ENTRY_ENTITY_START_TIME, workDataList), this.buildTimeByTimeRule(payNodeGrpHisEntry, calPeriods, index, null, SUB_ENTRY_ENTITY_END_TIME, workDataList)});
        }
        return subEntryEntity;
    }

    private Date buildTimeByTimeRule(DynamicObject payNodeGrpHisEntry, List<DynamicObject> calPeriods, int index, Long createOrgID, String field, Map<Integer, List<Map<String, String>>> workDataList) {
        String payNodeRule;
        PayNodeTimeConfig payNodeTimeConfig = this.jsonObjectParseDynamic(payNodeGrpHisEntry, field);
        if (payNodeTimeConfig == null || !payNodeTimeConfig.getAutoCreateEnable()) {
            return null;
        }
        Date result = null;
        switch (payNodeRule = payNodeTimeConfig.getPayNodeRule()) {
            case "period": 
            case "paydate": {
                result = this.getCalPeriodTime(calPeriods.get(index), payNodeTimeConfig, workDataList);
                break;
            }
            case "workcalendar": {
                DynamicObject calPeriod = calPeriods.get(index);
                String workRule = payNodeTimeConfig.getWorkRule();
                if (SWCStringUtils.equals((String)"nextperiod", (String)workRule)) {
                    if (index == 0) {
                        DynamicObject calPeriodType = this.getModel().getDataEntity().getDynamicObject("paynodegrphis.calperiodtype");
                        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsbs_calperiodtype");
                        DynamicObject calPeriodWithEntity = swcDataServiceHelper.queryOne(calPeriodType.getPkValue());
                        ArrayList sortAllCalPeriods = Lists.newArrayList();
                        sortAllCalPeriods.addAll(calPeriodWithEntity.getDynamicObjectCollection("entryentity"));
                        this.sortCalPeriod(sortAllCalPeriods);
                        calPeriod = null;
                        for (int i = 1; i < sortAllCalPeriods.size(); ++i) {
                            if (!((DynamicObject)sortAllCalPeriods.get(i)).getPkValue().equals(calPeriods.get(0).getPkValue())) continue;
                            calPeriod = (DynamicObject)sortAllCalPeriods.get(i - 1);
                            break;
                        }
                        if (calPeriod == null) {
                            return null;
                        }
                    } else {
                        calPeriod = calPeriods.get(index - 1);
                    }
                }
                result = this.getWorkCalendarTime(calPeriod, payNodeTimeConfig);
                if (!payNodeTimeConfig.getHolidayEnable()) break;
                boolean isBiggerDays = true;
                if (SWCStringUtils.equals((String)"before", (String)payNodeTimeConfig.getHolidayWay())) {
                    isBiggerDays = false;
                }
                List<Map<String, String>> workCalendar = this.loadYearWorkCalendar(result, workDataList);
                result = WorkCalendarLoadService.getWorkDate((Date)result, (boolean)isBiggerDays, (Integer)1, workCalendar, (boolean)true);
                break;
            }
        }
        return this.replaceTime(result, payNodeTimeConfig.getSpecificTime());
    }

    private Date getWorkCalendarTime(DynamicObject calPeriod, PayNodeTimeConfig payNodeTimeConfig) {
        int workCalDay = payNodeTimeConfig.getWorkCalDay();
        Date calPeriodStartDate = calPeriod.getDate(CAL_PERIOD_START_DATE);
        Date calPeriodEndDate = calPeriod.getDate(CAL_PERIOD_END_DATE);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(calPeriodStartDate);
        calendar.set(5, workCalDay);
        if (SWCDateTimeUtils.getMonth((Date)calPeriodStartDate) == SWCDateTimeUtils.getMonth((Date)calPeriodEndDate)) {
            if (SWCDateTimeUtils.getMonth((Date)calPeriodStartDate) != calendar.get(2) + 1) {
                calendar.setTime(calPeriodStartDate);
                calendar.set(5, calendar.getActualMaximum(5));
            }
        } else if (calendar.getTime().getTime() < calPeriodStartDate.getTime()) {
            calendar.setTime(calPeriodEndDate);
            calendar.set(5, workCalDay);
        } else if (SWCDateTimeUtils.getMonth((Date)calPeriodStartDate) != calendar.get(2) + 1) {
            calendar.setTime(calPeriodStartDate);
            calendar.set(5, calendar.getActualMaximum(5));
        }
        return calendar.getTime();
    }

    private Date getCalPeriodTime(DynamicObject calPeriod, PayNodeTimeConfig payNodeTimeConfig, Map<Integer, List<Map<String, String>>> workDataList) {
        String payNodeRule = payNodeTimeConfig.getPayNodeRule();
        String calPeriodField = payNodeTimeConfig.getCalPeriodField();
        if (SWCStringUtils.equals((String)"paydate", (String)payNodeRule)) {
            calPeriodField = "paydate";
        }
        Date result = calPeriod.getDate(calPeriodField.toLowerCase());
        String dateType = payNodeTimeConfig.getDateType();
        int calPeriodDays = payNodeTimeConfig.getCalPeriodDays().intValue();
        String calPeriodWay = payNodeTimeConfig.getCalPeriodWay();
        boolean isBiggerDays = true;
        if (SWCStringUtils.equals((String)"before", (String)calPeriodWay)) {
            isBiggerDays = false;
        }
        if (SWCStringUtils.equals((String)"work", (String)dateType)) {
            List<Map<String, String>> workCalendar = this.loadYearWorkCalendar(result, workDataList);
            result = WorkCalendarLoadService.getWorkDate((Date)result, (boolean)isBiggerDays, (Integer)calPeriodDays, workCalendar, (boolean)false);
        } else if (calPeriodDays != 0) {
            result = isBiggerDays ? SWCDateTimeUtils.addDay((Date)result, (long)calPeriodDays) : SWCDateTimeUtils.addDay((Date)result, (long)(0 - calPeriodDays));
            if (payNodeTimeConfig.getHolidayEnable()) {
                List<Map<String, String>> workCalendar = this.loadYearWorkCalendar(result, workDataList);
                result = WorkCalendarLoadService.getWorkDate((Date)result, (boolean)SWCStringUtils.equals((String)"after", (String)payNodeTimeConfig.getHolidayWay()), (Integer)1, workCalendar, (boolean)true);
            }
        }
        return result;
    }

    private List<Map<String, String>> loadYearWorkCalendar(Date result, Map<Integer, List<Map<String, String>>> workDataListMap) {
        List workDataList;
        int year = SWCDateTimeUtils.getYear((Date)result);
        if (workDataListMap.get(year) != null) {
            workDataList = workDataListMap.get(year);
        } else {
            long workPlanId = this.getModel().getDataEntity().getLong("paynodegrphis.workplan.id");
            workDataList = WorkCalendarLoadService.loadThreeYearWorkCalendar((Date)result, (Long)workPlanId);
            workDataListMap.put(year, workDataList);
        }
        return workDataList;
    }

    public Date replaceTime(Date date, Integer specificTime) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int hour = specificTime / 3600;
        int second = specificTime % 60;
        int minute = (specificTime - hour * 3600 - second) / 60;
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        return calendar.getTime();
    }

    private PayNodeTimeConfig jsonObjectParseDynamic(DynamicObject payNodeGrpHisEntry, String field) {
        String cfgJSON = "";
        if (SWCStringUtils.equals((String)SUB_ENTRY_ENTITY_START_TIME, (String)field)) {
            if (payNodeGrpHisEntry.getBoolean(START_TIME_CHECK_BOX)) {
                cfgJSON = payNodeGrpHisEntry.getString("starttimecfg");
            }
        } else if (SWCStringUtils.equals((String)SUB_ENTRY_ENTITY_END_TIME, (String)field)) {
            cfgJSON = payNodeGrpHisEntry.getString("endtimecfg");
        }
        if (SWCStringUtils.isEmpty((String)cfgJSON)) {
            return null;
        }
        return (PayNodeTimeConfig)JSONObject.parseObject((String)cfgJSON, PayNodeTimeConfig.class);
    }

    private List<DynamicObject> selectCalPeriods() {
        DynamicObject payNodeScm = this.getModel().getDataEntity();
        DynamicObject startCalPeriod = payNodeScm.getDynamicObject(START_CAL_PERIOD);
        DynamicObject endCalPeriod = payNodeScm.getDynamicObject(END_CAL_PERIOD);
        if (startCalPeriod == null || endCalPeriod == null) {
            return new ArrayList<DynamicObject>(0);
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        Date startCalPeriodDate = startCalPeriod.getDate(CAL_PERIOD_START_DATE);
        Date endCalPeriodDate = endCalPeriod.getDate(CAL_PERIOD_END_DATE);
        DynamicObject calPeriodType = payNodeScm.getDynamicObject("paynodegrphis.calperiodtype");
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsbs_calperiodtype");
        DynamicObject calPeriodWithEntity = swcDataServiceHelper.queryOne(calPeriodType.getPkValue());
        DynamicObjectCollection calPeriods = calPeriodWithEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject calPeriod : calPeriods) {
            Date startDate = calPeriod.getDate(CAL_PERIOD_START_DATE);
            Date endDate = calPeriod.getDate(CAL_PERIOD_END_DATE);
            if (startCalPeriodDate.getTime() > startDate.getTime() || endCalPeriodDate.getTime() < endDate.getTime()) continue;
            result.add(calPeriod);
        }
        return result;
    }

    private List<String> buildDelEntryConfirmMessage(Map<Integer, DynamicObject> delEntry) {
        ArrayList<String> failList = new ArrayList<String>(10);
        for (Map.Entry<Integer, DynamicObject> calPeriodEntry : delEntry.entrySet()) {
            DynamicObject calPeriod = calPeriodEntry.getValue();
            failList.add(calPeriod.getString("number") + "\uff0c" + calPeriod.getString("name"));
        }
        return failList;
    }

    private boolean validateStartEndTime(String operateKey, Map<Long, Integer> calPeriodEntryIndexMap) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList<String> feedbackMessages = new ArrayList<String>(10);
        String feedbackMessage = ResManager.loadKDString((String)"\u201c\u65f6\u95f4\u7a97\u53e3\u201d\u7b2c{0}\u884c\uff1a\u65f6\u95f4\u8282\u70b9\u201c{1}\u201d\u7684\u5f00\u59cb\u65f6\u95f4\u5e94\u65e9\u4e8e\u8be5\u8282\u70b9\u7684\u622a\u6b62\u65f6\u95f4\u3002", (String)"PayNodeScmEdit_24", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        for (DynamicObject entryDynamicObject : entryEntity) {
            Long calPeriodPk = entryDynamicObject.getLong("calperiod.id");
            DynamicObjectCollection subEntryEntity = entryDynamicObject.getDynamicObjectCollection(SUB_ENTRY_ENTITY);
            for (DynamicObject subDynamicObject : subEntryEntity) {
                Date endTime = subDynamicObject.getDate(SUB_ENTRY_ENTITY_END_TIME);
                Date startTime = subDynamicObject.getDate(SUB_ENTRY_ENTITY_START_TIME);
                String name = subDynamicObject.getString("paynode.name");
                if (endTime == null || startTime == null || startTime.getTime() <= endTime.getTime()) continue;
                feedbackMessages.add(MessageFormat.format(feedbackMessage, calPeriodEntryIndexMap.get(calPeriodPk), name));
            }
        }
        if (feedbackMessages.size() == 0) {
            return true;
        }
        if (feedbackMessages.size() == 1) {
            this.getView().showTipNotification((String)feedbackMessages.get(0));
        } else {
            String formId = this.getView().getFormShowParameter().getFormId();
            String operationName = this.getOperationName(operateKey, formId);
            String str = ResManager.loadKDString((String)"\u5931\u8d25", (String)"PayNodeScmEdit_25", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operationName, (String)(operationName + str), feedbackMessages);
            this.getView().showForm(parameters);
        }
        return false;
    }

    private void resetOrderPayNodeScmEntry(BeforeDoOperationEventArgs args) {
        String subPageId = this.getPageCache().get("subPageId");
        IFormView subView = this.getView().getView(subPageId);
        if (subView == null) {
            return;
        }
        IDataModel subModel = subView.getModel();
        DynamicObjectCollection subModelEntryEntity = subModel.getEntryEntity("entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(entryEntity.size());
        for (DynamicObject subDynamicObject : subModelEntryEntity) {
            map.put((Long)subDynamicObject.getDynamicObject(CAL_PERIOD).getPkValue(), subDynamicObject.getInt("seq"));
        }
        FormOperate operate = (FormOperate)args.getSource();
        OperateOption option = operate.getOption();
        option.setVariableValue("resetOrder", JSONObject.toJSONString(map));
    }

    private void buildAddFailMessage(List<DynamicObject> calPeriods) {
        ArrayList<String> feedbackMessages = new ArrayList<String>(10);
        for (DynamicObject calPeriod : calPeriods) {
            feedbackMessages.add(calPeriod.getString("periodname") + ',' + calPeriod.getString("periodnumber"));
        }
        FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)ResManager.loadKDString((String)"\u751f\u6210\u5217\u8868", (String)"PayNodeScmEdit_22", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6dfb\u52a0\u5931\u8d25\uff0c\u671f\u95f4\u622a\u6b62\u65e5\u671f\u9700\u665a\u4e8e\u7b49\u4e8e\u5355\u636e\u751f\u6548\u65e5\u671f\u3002", (String)"PayNodeScmEdit_26", (String)"swc-hsas-formplugin", (Object[])new Object[0]), feedbackMessages);
        this.getView().showForm(parameters);
    }

    private void buildDelAndRepeatCalPeriods(List<DynamicObject> calPeriods, Map<Integer, DynamicObject> remainCalperiods, Map<Integer, DynamicObject> repeatCalPeriods) {
        DynamicObjectCollection payNodeScmEnt = this.getModel().getEntryEntity("entryentity");
        HashMap<Long, DynamicObject> calPeriodMap = new HashMap<Long, DynamicObject>(calPeriods.size());
        for (DynamicObject calPeriod : calPeriods) {
            calPeriodMap.put((Long)calPeriod.getPkValue(), calPeriod);
        }
        int size = payNodeScmEnt.size();
        for (int index = 0; index < size; ++index) {
            DynamicObject entryCalPeriod = ((DynamicObject)payNodeScmEnt.get(index)).getDynamicObject(CAL_PERIOD);
            Long entryCalPeriodID = (Long)entryCalPeriod.getPkValue();
            if (calPeriodMap.get(entryCalPeriodID) != null) {
                repeatCalPeriods.put(index, (DynamicObject)calPeriodMap.get(entryCalPeriodID));
                continue;
            }
            remainCalperiods.put(index, entryCalPeriod);
        }
    }

    private void rebuildRepeatConfirmMessage(Map<Integer, DynamicObject> repeat) {
        StringBuilder stringBuilder = new StringBuilder();
        List repeatPeriods = repeat.values().stream().sorted(Comparator.comparing(o -> o.getDate(CAL_PERIOD_END_DATE))).collect(Collectors.toList());
        for (DynamicObject calPeriod : repeatPeriods) {
            stringBuilder.append(calPeriod.getString("periodnumber"));
            stringBuilder.append(',');
            stringBuilder.append(calPeriod.getString("periodname"));
            stringBuilder.append("\\r\\n");
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>(3);
        map.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4fdd\u7559", (String)"PayNodeScmEdit_31", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        map.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u8986\u76d6", (String)"PayNodeScmEdit_32", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u4ee5\u4e0b\u671f\u95f4\u5df2\u5b58\u5728\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u662f\u5426\u4fdd\u7559\u539f\u6570\u636e\u3002", (String)"PayNodeScmEdit_33", (String)"swc-hsas-formplugin", (Object[])new Object[0]), stringBuilder.toString(), MessageBoxOptions.YesNoCancel, ConfirmTypes.Default, new ConfirmCallBackListener(DO_NOTHING_GENERATE_REBUILD_CALLBACK, (IFormPlugin)this), map);
    }

    private List<String> mustInputCheck() {
        IDataModel dataModel = this.getModel();
        DynamicObject dataEntity = dataModel.getDataEntity();
        ArrayList<String> fieldNames = new ArrayList<String>(10);
        for (String fieldName : MUST_INPUT_FIELD) {
            if (dataEntity.get(fieldName) != null) continue;
            fieldNames.add(fieldName);
        }
        return fieldNames;
    }

    private String buildMustInputMessage(List<String> mustInputCheck) {
        String message = "";
        IDataModel dataModel = this.getModel();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\uff1a", (String)"PayNodeScmEdit_27", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        for (String fieldName : mustInputCheck) {
            IDataEntityProperty property = dataModel.getProperty(fieldName);
            stringBuilder.append('\u201c');
            stringBuilder.append(property.getDisplayName().getLocaleValue());
            stringBuilder.append('\u201d');
            stringBuilder.append('\u3001');
            if (stringBuilder.length() == 0) continue;
            message = stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return message;
    }

    private List<DynamicObject> getEndDateLessThanBred(List<DynamicObject> calPeriods) {
        ArrayList<DynamicObject> failCalPeriods = new ArrayList<DynamicObject>(calPeriods.size());
        long bredTime = this.getModel().getDataEntity().getDate("bsed").getTime();
        for (DynamicObject calPeriod : calPeriods) {
            if (calPeriod.getDate(CAL_PERIOD_END_DATE).getTime() >= bredTime) continue;
            failCalPeriods.add(calPeriod);
        }
        return failCalPeriods;
    }

    private void showTipNotification(String fieldKey) {
        if (START_CAL_PERIOD.equals(fieldKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u9700\u65e9\u4e8e\u7b49\u4e8e\u622a\u6b62\u671f\u95f4\u3002", (String)"PayNodeScmEdit_28", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u671f\u95f4\u9700\u665a\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"PayNodeScmEdit_29", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        DynamicObjectCollection payNodeScmEntries = this.getModel().getEntryEntity("entryentity");
        DynamicObject grp = this.getModel().getDataEntity().getDynamicObject(PAY_NODE_GRP_HIS);
        if (grp != null) {
            DynamicObjectCollection payNodeGrpHisEntries = grp.getDynamicObjectCollection("entryentity");
            PayNodeCacheHelper.putAppCache((IFormView)this.getView(), (DynamicObjectCollection)payNodeScmEntries, (DynamicObjectCollection)payNodeGrpHisEntries);
        }
    }
}

