/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.paynode;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.paynode.PayNodeHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import org.apache.commons.collections.CollectionUtils;

public class PayNodeScmList
extends SWCDataBaseList {
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "paynodegrphis.calperiodtype.name": {
                QFilter baseDataFilter;
                HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_paynodescm", (String)"47150e89000000ac");
                if (permOrgs == null || permOrgs.hasAllOrgPerm() || (baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_calperiodtype", (List)permOrgs.getHasPermOrgs(), (boolean)true)) == null) break;
                filters.add(baseDataFilter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("enable".equals(operate.getOperateKey()) || "audit".equals(operate.getOperateKey())) {
            Object[] primaryKeyValues = args.getListSelectedData().getPrimaryKeyValues();
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paynodescm");
            DynamicObject[] payNodeScms = helper.query(primaryKeyValues);
            HashMap payNodeScmMap = Maps.newHashMap();
            for (DynamicObject payNodeScm : payNodeScms) {
                String payNodeGrpId = payNodeScm.getString("paynodegrp.id");
                List dys = (List)payNodeScmMap.get(payNodeGrpId);
                if (CollectionUtils.isEmpty((Collection)dys)) {
                    payNodeScmMap.put(payNodeGrpId, Lists.newArrayList((Object[])new DynamicObject[]{payNodeScm}));
                } else {
                    dys.add(payNodeScm);
                }
                DynamicObject existDy = this.checkIsExist(helper, payNodeGrpId);
                if (!Objects.nonNull(existDy)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5b58\u5728\u6709\u6548\u7684\u65f6\u95f4\u7a97\u53e3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayNodeEdit_8", (String)"swc-hsas-formplugin", (Object[])new Object[]{existDy.getString("paynodegrp.name")}));
                args.setCancel(true);
                return;
            }
            AtomicBoolean showTip = new AtomicBoolean(false);
            payNodeScmMap.forEach((key, val) -> {
                if (val.size() < 2) {
                    return;
                }
                showTip.set(true);
            });
            if (showTip.get()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u4e2a\u65f6\u95f4\u7a97\u53e3\u6a21\u677f\u53ea\u80fd\u5b58\u5728\u4e00\u6761\u6709\u6548\u7684\u65f6\u95f4\u7a97\u53e3\u6570\u636e\u3002", (String)"PayNodeEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private DynamicObject checkIsExist(SWCDataServiceHelper helper, String payNodeGrpId) {
        List filters = PayNodeHelper.getAvailableFilters();
        QFilter qFilter = new QFilter("paynodegrp", "=", (Object)Long.valueOf(payNodeGrpId));
        QFilter notSelf = new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue());
        QFilter current = new QFilter("iscurrentversion", "=", (Object)"1");
        filters.add(qFilter);
        filters.add(notSelf);
        filters.add(current);
        return helper.queryOne("paynodegrp.name", filters.toArray(new QFilter[0]));
    }
}

