/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.paynode.imports;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.xml.rpc.holders.BooleanWrapperHolder;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.swc.hsas.formplugin.web.cal.paynode.imports.IDataPort;
import kd.swc.hsas.formplugin.web.cal.paynode.imports.ImportConfig;
import kd.swc.hsas.formplugin.web.cal.paynode.imports.ListExporter;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.business.imports.ValidateResults;
import kd.swc.hsbp.common.constants.ImportConstants;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import kd.swc.hsbp.formplugin.imports.ProgressHandler;
import kd.swc.hsbp.formplugin.imports.event.DataImportEvent;
import kd.swc.hsbp.formplugin.imports.event.DownLoadTemplateEvent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DynamicEntryImportStartEdit
extends AbstractFormPlugin
implements UploadListener {
    private static Log log = LogFactory.getLog(DynamicEntryImportStartEdit.class);
    public static final String IMPORT_START_CLOSECALLBACK = "ImportStartCloseCallBack";
    private static final String FILEPATH = "filepath";
    private static final String FILEPANEL = "filepanel";
    private static final Integer fixHeadHeight = 3;
    private List<IDataPort> dataPortService;
    private ImportConfig importConfig;
    private final String SWC_HSBP_FORMPLUGIN = "swc-hsbp-formplugin";
    private final String IMPORT_START_ERROR = ResManager.loadKDString((String)"\u8be6\u60c5\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"DynamicEntryImportStartEdit_2", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
        this.dataPortService = this.getDataPortService();
        if (!this.dataPortService.isEmpty()) {
            this.importConfig = this.invokeGetImportConfig();
        }
        ZipSecureFile.setMinInflateRatio((double)-1.0);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"ImportProcessCallBack")) {
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FILEPANEL});
        this.getView().setEnable(Boolean.FALSE, new String[]{"keyfields"});
        Label title = (Label)this.getControl("title");
        title.setText(this.getEntryView().getModel().getDataEntityType().getDisplayName().toString());
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            final IFormView view = this.getView();
            String url = (String)urls[0];
            FileService service = FileServiceFactory.getAttachmentFileService();
            final ArrayList dataHead = Lists.newArrayListWithCapacity((int)this.importConfig.getHeadHeight());
            final ArrayList dataRow = Lists.newArrayListWithCapacity((int)this.importConfig.getHeadHeight());
            final BooleanWrapperHolder hasRowDataWhenIsPartial = new BooleanWrapperHolder(Boolean.FALSE);
            final int endHeight = this.getEntryHeadEndHeight();
            try (InputStream in = service.getInputStream(url);){
                new ExcelReader().read(in, new SheetHandler(){

                    public void handleRow(SheetHandler.ParsedRow row) {
                        if (row.getRowNum() < fixHeadHeight - 1) {
                            return;
                        }
                        if (row.getRowNum() <= endHeight) {
                            dataHead.add(row.getData());
                        } else if (DynamicEntryImportStartEdit.this.importConfig.getImportType() == ImportConfig.ImportType.Partial) {
                            if (!row.isEmpty()) {
                                hasRowDataWhenIsPartial.value = Boolean.TRUE;
                                this.setInterrupt(true);
                            }
                        } else {
                            dataRow.add(row.getData());
                        }
                    }

                    public void setRowCount(int rowCount) {
                        if (rowCount + DynamicEntryImportStartEdit.this.getEntryHeadEndHeight() > DynamicEntryImportStartEdit.this.importConfig.getMaxRowCount()) {
                            String formatString = MessageFormat.format("{0}{1}\uff0c{2}", ResManager.loadKDString((String)"\u6700\u5927\u884c\u9650\u5236", (String)"DynamicEntryImportStartEdit_0", (String)"swc-hsbp-formplugin", (Object[])new Object[0]), DynamicEntryImportStartEdit.this.importConfig.getMaxRowCount(), ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20", (String)"DynamicEntryImportStartEdit_1", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
                            view.showMessage(formatString);
                        }
                    }
                });
            }
            catch (KDBizException e) {
                ErrorCode code = e.getErrorCode();
                if (code == null || !"ValidFile".equalsIgnoreCase(code.getCode())) {
                    view.showErrorNotification(e.getMessage());
                    return;
                }
            }
            catch (Throwable e) {
                log.error(e);
                view.showMessage(ImportConstants.IMPORT_TEMPLATE_ERROR(), e instanceof KDBizException ? e.getMessage() : this.IMPORT_START_ERROR, MessageTypes.Default);
                return;
            }
            if (this.importConfig.getImportType() == ImportConfig.ImportType.Partial && !hasRowDataWhenIsPartial.value.booleanValue()) {
                view.showMessage(ImportConstants.PARSED_INVALID_DATA(), ImportConstants.LOGGING_DATA(), MessageTypes.Default);
                return;
            }
            ValidateResults validateResult = this.invokeOnValidateTemplate(dataHead, dataRow);
            if (validateResult.isSuccess()) {
                view.setVisible(Boolean.TRUE, new String[]{FILEPANEL});
                view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
                IDataModel model = this.getModel();
                model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
                model.setValue(FILEPATH, (Object)url);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                this.downloadTemplate();
                break;
            }
            case "btnresetfile": {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue(FILEPATH, (Object)"");
                this.getView().setVisible(Boolean.FALSE, new String[]{FILEPANEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
                break;
            }
        }
    }

    private void downloadTemplate() {
        this.invokeBeforeDownLoadTemplate();
        this.startExport(this.getEntryView());
        this.invokeAfterDownLoadTemplate();
    }

    private void startExport(IFormView entryView) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String entryKey = (String)showParameter.getCustomParam("entrykey");
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)entryView, (String)entryKey);
        SWCExportEntryHelper.removeIgnoreColumn((List)wrapper.getContainers(), this.importConfig.getIgnoreColumns());
        List containers = wrapper.getContainers();
        try {
            Map captions = SWCExportEntryHelper.getEntryFieldCaptions((List)containers);
            LocaleString caption = entryView.getModel().getProperty(entryKey).getDisplayName();
            String entryName = caption != null && StringUtils.isNotBlank((String)caption.toString()) ? caption.toString() : entryKey;
            EntityType entityType = (EntityType)this.getEntryView().getModel().getDataEntityType().getAllEntities().get(entryKey);
            ListExporter exporter = this.invokeGetExporterConfig(wrapper, entityType, this.importConfig);
            exporter.writeTemplate();
            int index = SWCExportEntryHelper.calcSheetHeadHeight((List)containers) + fixHeadHeight;
            if (this.importConfig.getImportType() == ImportConfig.ImportType.Complete) {
                exporter.exportEntryTemplate(entryView.getModel(), this.invokeGetRowData(), captions, index, this.importConfig);
            }
            String url = exporter.flush(entryView.getModel().getDataEntityType(), this.importConfig.getTemplateFileName());
            this.getView().download(UrlService.getAttachmentFullUrl((String)url));
            this.getView().sendFormAction(this.getView());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void importData() {
        String url = this.getModel().getDataEntity().getString(FILEPATH);
        if (StringUtils.isBlank((String)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c", (String)"DynamicEntryImportStartEdit_8", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsbp_importing");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ImportProcessCallBack"));
        this.getView().showForm(showParameter);
        FileService service = FileServiceFactory.getAttachmentFileService();
        final ArrayList dataHead = Lists.newArrayListWithCapacity((int)this.importConfig.getHeadHeight());
        final ArrayList dataRow = Lists.newArrayListWithCapacity((int)this.importConfig.getHeadHeight());
        IFormView view = this.getView();
        final int headEndHeight = this.getEntryHeadEndHeight();
        try (InputStream in = service.getInputStream(url);){
            new ExcelReader().read(in, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    if (row.getRowNum() < fixHeadHeight - 1) {
                        return;
                    }
                    if (row.getRowNum() <= headEndHeight) {
                        dataHead.add(row.getData());
                    } else {
                        dataRow.add(row.getData());
                    }
                }
            });
        }
        catch (Throwable e) {
            log.error(e);
            view.showMessage(ImportConstants.IMPORT_TEMPLATE_ERROR(), e instanceof KDBizException ? e.getMessage() : this.IMPORT_START_ERROR, MessageTypes.Default);
            return;
        }
        int total = this.invokeGetEffectiveDataRow(dataHead, dataRow);
        ProgressHandler handler = new ProgressHandler(total, this.getView().getView(showParameter.getPageId()));
        this.invokeDataImport(dataHead, dataRow, handler);
        this.invokeAfterImport(dataHead, dataRow);
        try {
            this.writeLog(handler, service, url);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog(ProgressHandler processHandler, FileService service, String url) throws IOException {
        Map logCache = processHandler.getLogCache();
        if (logCache.isEmpty()) {
            return;
        }
        OutputStream out = null;
        FileItem fileItem = null;
        FileInputStream fileInputStream = null;
        try {
            XSSFWorkbook workbook = new XSSFWorkbook(service.getInputStream(url));
            XSSFSheet sheet = workbook.getSheetAt(0);
            int fieldRowNum = this.getEntryHeadEndHeight();
            XSSFRow fieldRow = sheet.getRow(fieldRowNum);
            sheet.setColumnWidth(0, 5120);
            short lastCellNum = fieldRow.getLastCellNum();
            Iterator rowIt = sheet.rowIterator();
            CellStyle cellStyle = this.getWarnTextStyle(workbook);
            String error = ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"DynamicEntryImportStartEdit_6", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
            while (rowIt.hasNext()) {
                Row row = (Row)rowIt.next();
                Cell cell = row.createCell(0);
                int rowNum = row.getRowNum();
                if (rowNum > fixHeadHeight && rowNum <= fieldRowNum) {
                    cell.setCellStyle((CellStyle)this.setBorderStyle(workbook));
                }
                if (rowNum == fixHeadHeight) {
                    cell.setCellStyle((CellStyle)this.setBorderStyle(workbook));
                    cell.setCellValue(error);
                    continue;
                }
                List logs = (List)logCache.get(rowNum - fieldRowNum - 1);
                if (!CollectionUtils.isNotEmpty((Collection)logs)) continue;
                cell.setCellStyle(cellStyle);
                cell.setCellValue(StringUtils.join((Object[])logs.toArray(), (String)";"));
            }
            File temp = File.createTempFile(UUID.randomUUID().toString(), ".xlsx");
            out = new FileOutputStream(temp);
            out.flush();
            workbook.write(out);
            Calendar cal = Calendar.getInstance();
            String formatStr = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25_{0}_{1}\u6708{2}\u65e5.xlsx", (String)"PayNodeDynamicEntryImportEdit_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            String fileName = MessageFormat.format(formatStr, this.importConfig.getModelName(), cal.get(2) + 1, cal.get(5));
            RequestContext ctx = RequestContext.getOrCreate();
            String path = FileNameUtils.getExportFileName((String)ctx.getTenantId(), (String)ctx.getAccountId(), (String)"hsas", (String)("import" + UUID.randomUUID().toString()), (String)fileName);
            fileInputStream = new FileInputStream(temp);
            fileItem = new FileItem(FilenameUtils.getName((String)fileName), path, (InputStream)fileInputStream);
            String uploadFileUrl = service.upload(fileItem);
            processHandler.setAndCacheErrorLogFile(uploadFileUrl);
        }
        catch (Exception e) {
            log.error("\u9519\u8bef\u65e5\u5fd7\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            try {
                if (fileItem != null) {
                    fileItem.close();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    private XSSFCellStyle setBorderStyle(XSSFWorkbook workbook) {
        XSSFCellStyle style = workbook.createCellStyle();
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    private CellStyle getWarnTextStyle(XSSFWorkbook workbook) {
        XSSFFont font = workbook.createFont();
        font.setColor((short)10);
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFont((Font)font);
        return cellStyle;
    }

    private int getEntryHeadEndHeight() {
        return this.importConfig.getHeadHeight() + fixHeadHeight - 1;
    }

    private List<IDataPort> getDataPortService() {
        IFormView entryView = this.getEntryView();
        if (Objects.isNull(entryView)) {
            return Collections.emptyList();
        }
        FormViewPluginProxy service = (FormViewPluginProxy)entryView.getService(FormViewPluginProxy.class);
        ArrayList dataPortPlugins = Lists.newArrayListWithExpectedSize((int)service.getPlugIns().size());
        for (IFormPlugin plugIn : service.getPlugIns()) {
            if (!(plugIn instanceof IDataPort)) continue;
            dataPortPlugins.add((IDataPort)plugIn);
        }
        if (dataPortPlugins.size() <= 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u7ed1\u5b9a\u81f3\u5c11\u4e00\u4e2a\u5bfc\u5165\u670d\u52a1\u63d2\u4ef6", (String)"DynamicEntryImportStartEdit_7", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
        }
        return dataPortPlugins;
    }

    private IFormView getEntryView() {
        String entryViewPageId = (String)this.getView().getFormShowParameter().getCustomParam("entryview");
        return this.getView().getView(entryViewPageId);
    }

    private void invokeBeforeDownLoadTemplate() {
        DownLoadTemplateEvent event = new DownLoadTemplateEvent((Object)this);
        for (IDataPort plugin : this.dataPortService) {
            plugin.beforeDownLoadTemplate(event);
        }
    }

    private void invokeAfterDownLoadTemplate() {
        DownLoadTemplateEvent event = new DownLoadTemplateEvent((Object)this);
        for (IDataPort plugin : this.dataPortService) {
            plugin.afterDownLoadTemplate(event);
        }
    }

    private ImportConfig invokeGetImportConfig() {
        IDataPort dataPort = this.dataPortService.get(this.dataPortService.size() - 1);
        ImportConfig importConfig = dataPort.getImportConfig();
        this.setEntryHeadHeight(importConfig);
        return importConfig;
    }

    private DynamicObjectCollection invokeGetRowData() {
        IDataPort dataPort = this.dataPortService.get(this.dataPortService.size() - 1);
        return dataPort.getRowData();
    }

    private void setEntryHeadHeight(ImportConfig importConfig) {
        if (importConfig.getHeadHeight() > 0) {
            return;
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String entryKey = (String)showParameter.getCustomParam("entrykey");
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)this.getEntryView(), (String)entryKey);
        int height = SWCExportEntryHelper.calcSheetHeadHeight((List)wrapper.getContainers());
        importConfig.setHeadHeight(height);
    }

    private ValidateResults invokeOnValidateTemplate(List<Map<Integer, String>> dataHead, List<Map<Integer, String>> dataRow) {
        Map<Integer, String> map = dataHead.get(dataHead.size() - 1);
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            String value = entry.getValue();
            if (!value.contains("*")) continue;
            String trim = value.replaceFirst("\\*", "").trim();
            entry.setValue(trim);
        }
        DataImportEvent event = new DataImportEvent((Object)this, dataHead, dataRow);
        IDataPort dataPort = this.dataPortService.get(this.dataPortService.size() - 1);
        return dataPort.onValidateTemplate(event);
    }

    private void invokeDataImport(List<Map<Integer, String>> dataHead, List<Map<Integer, String>> dataRow, ProgressHandler handler) {
        DataImportEvent event = new DataImportEvent((Object)this, dataHead, dataRow);
        event.setProcessHandler(handler);
        for (IDataPort plugin : this.dataPortService) {
            plugin.dataImport(event);
        }
    }

    private void invokeAfterImport(List<Map<Integer, String>> dataHead, List<Map<Integer, String>> dataRow) {
        DataImportEvent event = new DataImportEvent((Object)this, dataHead, dataRow);
        for (IDataPort plugin : this.dataPortService) {
            plugin.afterImport(event);
        }
    }

    private int invokeGetEffectiveDataRow(List<Map<Integer, String>> dataHead, List<Map<Integer, String>> dataRow) {
        DataImportEvent event = new DataImportEvent((Object)this, dataHead, dataRow);
        IDataPort dataPort = this.dataPortService.get(this.dataPortService.size() - 1);
        return dataPort.getEffectiveDataRow(event);
    }

    private ListExporter invokeGetExporterConfig(EntryColumnWrapper wrapper, EntityType entryType, ImportConfig importConfig) {
        IDataPort dataPort = this.dataPortService.get(this.dataPortService.size() - 1);
        return dataPort.getExporterConfig(wrapper, entryType, importConfig);
    }
}

