/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.print;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.LongField;
import kd.bos.print.core.data.field.ObjectField;
import kd.bos.print.core.plugin.AbstractPrintSeniorPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.BeforeOutputGridEvent;
import kd.bos.print.core.plugin.event.BeforeOutputWidgetEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.print.core.plugin.event.DataVisitorEvent;
import kd.bos.print.core.plugin.event.bo.PWGridCellBo;
import kd.sdk.swc.hsas.common.enums.SalaryItemTypeEnum;
import kd.swc.hsas.business.cal.helper.CalResultQueryHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import org.apache.commons.collections.MapUtils;

public class DynamicSalarySlipPrintPlugin
extends AbstractPrintSeniorPlugin {
    public static final String DATASOURCE_CALPERSON = "hsas_calperson";
    public static final String DATASOURCE_CALRESULT = "calresult";
    List<Long> pkIds = new ArrayList<Long>(10);
    List<Long> itemList;
    Map<Long, Boolean> showNullMap = new HashMap<Long, Boolean>(16);
    Map<Long, Boolean> showZeroMap = new HashMap<Long, Boolean>(16);
    Map<Long, String> showNameMap = new HashMap<Long, String>(16);
    Map<Long, Map<Long, Object>> salaryResultMap;
    Map<Long, Map<String, Object>> salaryItemMap;
    Map<Long, Integer> taskCurrencyScaleMap = new HashMap<Long, Integer>(16);
    int columnSize = 0;

    public void beforeInitDataVisitor(DataVisitorEvent event) {
        DynamicObject printScheme = this.getSalarySlipPrintScheme();
        if (this.itemList == null) {
            this.itemList = this.getSchemeItemList(printScheme);
            this.salaryItemMap = new CalResultQueryHelper().getCalItemMap(SalaryItemTypeEnum.ITEMSL.getCode(), this.itemList);
        }
        int pageSize = this.getPageSize();
        event.setMaxQuerySize(pageSize);
        event.setMaxEntrySize(10000);
    }

    private int getPageSize() {
        int pageSize = this.itemList.size() <= 75 ? 1000 : (this.itemList.size() > 75 && this.itemList.size() <= 150 ? 500 : (this.itemList.size() > 150 && this.itemList.size() <= 300 ? 250 : (this.itemList.size() > 300 && this.itemList.size() <= 400 ? 200 : 100)));
        return pageSize;
    }

    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        if (StringUtils.equals((CharSequence)evt.getDataSource().getDsName(), (CharSequence)DATASOURCE_CALRESULT)) {
            Long pkId = 0L;
            if (evt.getDataSource().getPkId() instanceof Long || evt.getDataSource().getPkId() instanceof Integer) {
                pkId = Long.valueOf(evt.getDataSource().getPkId().toString());
            }
            if (this.salaryResultMap != null) {
                Map<Long, Object> dataMap = this.salaryResultMap.get(pkId);
                if (dataMap == null) {
                    dataMap = new HashMap<Long, Object>(0);
                }
                evt.getCustomDataRows().addAll(this.trancferCalResultData(dataMap));
            }
        }
    }

    public void afterLoadData(AfterLoadDataEvent evt) {
        List dataRowSets = evt.getDataRowSets();
        if (StringUtils.equals((CharSequence)evt.getDataSource().getDsName(), (CharSequence)DATASOURCE_CALPERSON)) {
            for (DataRowSet dataRowSet : dataRowSets) {
                this.pkIds.add(((LongField)dataRowSet.getField("id")).getValue());
            }
            this.salaryResultMap = new CalResultQueryHelper().getCalResult(this.pkIds, SalaryItemTypeEnum.ITEMSL.getCode(), this.itemList);
        }
    }

    private List<Long> getSchemeItemList(DynamicObject printScheme) {
        ArrayList<Long> itemList = new ArrayList<Long>();
        if (printScheme != null) {
            DynamicObjectCollection coll = printScheme.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : coll) {
                Long salaryItemId = dynamicObject.getLong("salaryitem.id");
                itemList.add(salaryItemId);
                this.showNullMap.put(salaryItemId, dynamicObject.getBoolean("isemptydisplay"));
                this.showZeroMap.put(salaryItemId, dynamicObject.getBoolean("iszerodisplay"));
                this.showNameMap.put(salaryItemId, dynamicObject.getString("displayname"));
            }
        }
        return itemList;
    }

    private List<DataRowSet> trancferCalResultData(Map<Long, Object> dataMap) {
        int index = 0;
        ArrayList<DataRowSet> dataSetList = new ArrayList<DataRowSet>(10);
        DataRowSet dataSet = null;
        for (Long itemId : this.itemList) {
            String displayName;
            Object tValue;
            Object value = dataMap.get(itemId);
            Map<String, Object> salaryItemInfo = this.salaryItemMap.get(itemId);
            if (salaryItemInfo == null || (tValue = this.tranferValue(itemId, value, salaryItemInfo)) == null) continue;
            if (index == 0) {
                dataSet = new DataRowSet();
            }
            if (StringUtils.isBlank((CharSequence)(displayName = this.showNameMap.get(itemId)))) {
                displayName = MapUtils.getString(salaryItemInfo, (Object)"name");
            }
            if (dataSet != null) {
                dataSet.put("itemname_" + index, (Field)new ObjectField((Object)displayName));
                dataSet.put("itemvalue_" + index, (Field)new ObjectField(tValue));
            }
            if (index == this.columnSize - 1) {
                dataSetList.add(dataSet);
                dataSet = null;
                index = 0;
                continue;
            }
            ++index;
        }
        if (dataSet != null) {
            dataSetList.add(dataSet);
        }
        return dataSetList;
    }

    private Object tranferValue(Long salaryItemId, Object value, Map<String, Object> stringObjectMap) {
        if (!this.showNullMap.get(salaryItemId).booleanValue() && value == null) {
            return null;
        }
        String showType = MapUtils.getString(stringObjectMap, (Object)"showType");
        int scale = MapUtils.getIntValue(stringObjectMap, (Object)"scale", (int)0);
        if ("text".equals(showType)) {
            return value == null ? "" : value.toString();
        }
        if ("int".equals(showType) || "num".equals(showType) || "amount".equals(showType)) {
            if (value == null) {
                return "";
            }
            if (!this.showZeroMap.get(salaryItemId).booleanValue() && value instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)value) == 0) {
                return null;
            }
            if ("amount".equals(showType)) {
                return new DecimalFormat(this.getDecimalFormatRule(this.getCurrencyScale(), true)).format(value);
            }
            return new DecimalFormat(this.getDecimalFormatRule(scale, true)).format(value);
        }
        if ("bool".equals(showType)) {
            if (value == null) {
                return "";
            }
            return value.equals("1") ? ResManager.loadKDString((String)"\u662f", (String)"DynamicSalarySlipPrintPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"DynamicSalarySlipPrintPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        }
        if ("date".equals(showType)) {
            Date date = null;
            if (value instanceof Date) {
                date = (Date)value;
            }
            if (date == null) {
                return "";
            }
            return SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
        }
        return value;
    }

    private String getDecimalFormatRule(int scale, boolean thousands) {
        StringBuilder builder = new StringBuilder();
        if (thousands) {
            builder.append(",##0");
        } else {
            builder.append("0");
        }
        if (scale > 0) {
            builder.append(".");
            for (int i = 0; i < scale; ++i) {
                builder.append("0");
            }
        }
        return builder.toString();
    }

    private int getCurrencyScale() {
        Object payrollGroupVidObj = this.getExtParam().get("payrollGroupVid");
        Long payrollGroupVid = Long.valueOf(payrollGroupVidObj.toString());
        Integer scale = this.taskCurrencyScaleMap.get(payrollGroupVid);
        if (scale != null) {
            return scale;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        DynamicObject calPayRollTask = helper.queryOne("currency.amtprecision", (Object)Long.valueOf(payrollGroupVid.toString()));
        scale = calPayRollTask == null ? 2 : calPayRollTask.getInt("currency.amtprecision");
        this.taskCurrencyScaleMap.put(payrollGroupVid, scale);
        return scale;
    }

    private DynamicObject getSalarySlipPrintScheme() {
        Long printSchemeId = (Long)this.getExtParam().get("printSchemeId");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salslipprint");
        DynamicObject printScheme = helper.queryOne((Object)printSchemeId);
        return printScheme;
    }

    public void beforeOutputWidget(BeforeOutputWidgetEvent evt) {
        if (evt instanceof BeforeOutputGridEvent) {
            BeforeOutputGridEvent gridEvent = (BeforeOutputGridEvent)evt;
            if (!DATASOURCE_CALRESULT.equals(gridEvent.getGrid().getDataSource())) {
                return;
            }
            if (gridEvent.getGrid().getColumnCount() == 2) {
                int firstColumnIndex = 0;
                int secondColumnIndex = 1;
                int firstColumnWidth = gridEvent.getGrid().getColumn(firstColumnIndex).getWidth();
                int secondColumnWidth = gridEvent.getGrid().getColumn(secondColumnIndex).getWidth();
                int addColumnSize = gridEvent.getRightSpace() / (firstColumnWidth + secondColumnWidth);
                this.columnSize = addColumnSize + 1;
                ((PWGridCellBo)gridEvent.getColCell(firstColumnIndex).get(0)).setCellValue(DATASOURCE_CALRESULT, "itemname_0");
                ((PWGridCellBo)gridEvent.getColCell(secondColumnIndex).get(0)).setCellValue(DATASOURCE_CALRESULT, "itemvalue_0");
                int startAddIndex = 2;
                for (int index = 0; index < addColumnSize; ++index) {
                    List cellBos1 = gridEvent.insertColumn(startAddIndex++, firstColumnWidth);
                    ((PWGridCellBo)cellBos1.get(0)).setCellValue(DATASOURCE_CALRESULT, "itemname_" + (index + 1));
                    List cellBos2 = gridEvent.insertColumn(startAddIndex++, secondColumnWidth);
                    ((PWGridCellBo)cellBos2.get(0)).setCellValue(DATASOURCE_CALRESULT, "itemvalue_" + (index + 1));
                }
            } else if (gridEvent.getGrid().getColumnCount() % 2 == 0) {
                int groupCount;
                this.columnSize = groupCount = gridEvent.getGrid().getColumnCount() / 2;
                for (int groupIndex = 0; groupIndex < groupCount; ++groupIndex) {
                    int startIndex = groupIndex * 2;
                    ((PWGridCellBo)gridEvent.getColCell(startIndex).get(0)).setCellValue(DATASOURCE_CALRESULT, "itemname_" + groupIndex);
                    ((PWGridCellBo)gridEvent.getColCell(startIndex + 1).get(0)).setCellValue(DATASOURCE_CALRESULT, "itemvalue_" + groupIndex);
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u6253\u5370\u5931\u8d25\uff1a\u7ea6\u5b9a\u6570\u636e\u6e90\u4e3a\u201c{0}\u201d\u7684\u6570\u636e\u8868\u683c\u53ea\u80fd\u5b58\u5728\u5076\u6570\u4e2a\u6570\u636e\u884c\u5355\u5143\u683c\uff0c\u8bf7\u8c03\u6574\u6253\u5370\u6a21\u677f\u3002", (String)"DynamicSalarySlipPrintPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[]{DATASOURCE_CALRESULT}));
            }
        }
    }
}

