/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.prorationresult;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.cal.export.SWCExportDataHelper;
import kd.swc.hsas.business.cal.prorationresult.ProrationResultService;
import kd.swc.hsas.common.constants.CalTableExportProgressConstants;
import kd.swc.hsas.common.enums.ProrationResultColEnum;
import kd.swc.hsas.common.utils.TaskUtil;
import kd.swc.hsas.formplugin.web.salarydetailresult.AbstractCalPersonListViewBasePlugin;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CalProrationResultExportPlugin
extends AbstractCalPersonListViewBasePlugin {
    private final Log log = LogFactory.getLog(CalProrationResultExportPlugin.class);
    private static final String EXPORT = "donothing_export";
    private static final String EXPORT_PERMID = "4730fc9f000004ae";
    private static final int EXCEL_MAX_COUNT = 1000000;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if (EXPORT.equals(opKey) && !SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)EXPORT_PERMID)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6838\u7b97\u540d\u5355\u201d\u7684\u201c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalProrationResultExportPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if (EXPORT.equals(opKey)) {
            this.doExport();
        }
    }

    private void doExport() {
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        this.log.info("doExport begin,calTaskId = {},traceId={}", (Object)calTaskId, (Object)RequestContext.get().getTraceId());
        BillList billListAp = new BillList();
        billListAp.setKey("billlistap");
        billListAp.setEntityId("hsas_prorationresult");
        ListView listView = (ListView)this.getView();
        billListAp.setBillFormId(listView.getBillFormId());
        billListAp.setView((IFormView)listView);
        ListSelectedRowCollection selectedRows = billListAp.getSelectedRows();
        Set calPersonIdSet = selectedRows.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toSet());
        int size = selectedRows.size();
        long[] selectRows = new long[size];
        int index = 0;
        for (Long id : calPersonIdSet) {
            selectRows[index] = id;
            ++index;
        }
        QFilter[] filters = this.getQueryFilters(calTaskId, selectRows);
        QFilter[] filterArr = new QFilter[filters.length + 1];
        QFilter qFilter = new QFilter("isproration", "=", (Object)Boolean.TRUE);
        qFilter.and("calstatus", "not in", (Object)new String[]{CalStateEnum.UNCAL.getCode(), CalStateEnum.CALING.getCode(), CalStateEnum.PRECAL_ERROR.getCode()});
        System.arraycopy(filters, 0, filterArr, 0, filters.length);
        filterArr[filters.length] = qFilter;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        int totalCount = helper.count(filterArr);
        if (totalCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u5bfc\u51fa\u3002", (String)"CalProrationResultExportPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        String exportTaskId = TaskUtil.getExportTaskID();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String name = ResManager.loadKDString((String)"\u5206\u6bb5\u7ed3\u679c\u660e\u7ec6\u5bfc\u51fa-%s", (String)"CalProrationResultExportPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String calTaskName = (String)this.getView().getFormShowParameter().getCustomParam("name");
        name = String.format(Locale.ROOT, name, calTaskName);
        params.put("downLoadTaskId", exportTaskId);
        params.put("totalCount", totalCount);
        params.put("status", 0);
        String bgTaskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_hsas_prorationresult_export", name, true, this.getView().getPageId(), params);
        this.log.info("calTaskId = {},exportTaskId = {}", (Object)calTaskId, (Object)exportTaskId);
        RequestContext rct = RequestContext.get();
        SWCThreadPoolFactory.getCommonExportThreadpool().execute(() -> {
            RequestContext.copyAndSet((RequestContext)rct);
            this.log.info("proration result export,calTaskId = {},traceId = {}", (Object)calTaskId, (Object)rct.getTraceId());
            this.asynExportProrationResult(filterArr, totalCount, exportTaskId, calTaskId, bgTaskId);
        });
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hsas_prorationexport");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("totalCount", (Object)totalCount);
        parameter.setCustomParam("status", (Object)0);
        parameter.setCustomParam("bgTaskId", (Object)bgTaskId);
        parameter.setCustomParam("downLoadTaskId", (Object)exportTaskId);
        this.getView().showForm(parameter);
        this.log.info("doExport end,calTaskId = {}", (Object)calTaskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asynExportProrationResult(QFilter[] filters, int totalCount, String exportTaskId, Long calTaskId, String bgTaskId) {
        this.log.info("asynExportProrationResult start,calTaskId={}", (Object)calTaskId);
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String props = "id,name,calversionno,calrulev.id,payrollgroupv.currency.amtprecision";
        QFilter idFilter = new QFilter("id", "=", (Object)calTaskId);
        DynamicObject calTaskDy = calTaskHelper.queryOriginalOne(props, new QFilter[]{idFilter});
        ISWCAppCache cache = SWCAppCache.get((String)String.format(Locale.ROOT, "prorationresult_export_%s", exportTaskId));
        cache.put("totalCount", (Object)totalCount);
        cache.put("issuccess", (Object)Boolean.TRUE);
        cache.put("bgTaskId", (Object)bgTaskId);
        int totalPages = (int)Math.ceil((double)totalCount * 1.0 / (double)CalTableExportProgressConstants.PAGE_SIZE.intValue());
        this.log.info("totalPages = {},totalCount = {},pageSize = {}", new Object[]{totalPages, totalCount, CalTableExportProgressConstants.PAGE_SIZE});
        SXSSFWorkbook wb = null;
        try {
            wb = new SXSSFWorkbook(1000);
            String exportFileName = this.getExportFileName(calTaskDy);
            SXSSFSheet sheet = wb.createSheet();
            sheet.setRandomAccessWindowSize(-1);
            wb.setSheetName(0, exportFileName);
            this.setColumnWidth(sheet);
            this.createHeadRow(sheet, wb);
            ArrayList<String> fileUrlList = new ArrayList<String>();
            int rowIndex = 1;
            int pageIndex = 0;
            while (pageIndex < totalPages) {
                int currentPage = pageIndex++;
                rowIndex = this.queryDataAndFillSheetContent(filters, currentPage, calTaskDy, sheet, cache, bgTaskId, rowIndex, fileUrlList, wb);
            }
            String fileName = null;
            if (fileUrlList.size() > 0) {
                int size = fileUrlList.size() + 1;
                fileName = exportFileName + "_" + size;
            } else {
                fileName = exportFileName;
            }
            String url = SWCExportDataHelper.writeFile((SXSSFWorkbook)sheet.getWorkbook(), (String)fileName);
            fileUrlList.add(url);
            cache.put("url", fileUrlList);
            cache.put("complete", (Object)totalCount);
        }
        catch (Exception exception) {
            this.log.error("asynExportProrationResult error,calTaskId={},msg={}", (Object)calTaskId, (Object)exception.getMessage());
            this.log.error("asynExportProrationResult  error : ", (Throwable)exception);
            cache.put("issuccess", (Object)Boolean.FALSE);
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    this.log.error("wb close error.", (Throwable)e);
                }
            }
        }
        this.log.info("asynExportProrationResult end,calTaskId={}", (Object)calTaskId);
    }

    private String getExportFileName(DynamicObject calTaskDy) {
        String dd = SWCDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
        String calTaskName = calTaskDy.getString("name");
        return ResManager.loadKDString((String)"\u5206\u6bb5\u7ed3\u679c\u8868\u5bfc\u51fa_{0}_{1}", (String)"CalProrationResultExportPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[]{calTaskName, dd});
    }

    private void setColumnWidth(SXSSFSheet sheet) {
        for (int i = 0; i < 12; ++i) {
            int columnWidth = sheet.getColumnWidth(i);
            sheet.setColumnWidth(i, columnWidth * 2);
        }
    }

    private int queryDataAndFillSheetContent(QFilter[] filters, int currentPage, DynamicObject calTaskDy, SXSSFSheet sheet, ISWCAppCache cache, String bgTaskId, int rowIndex, List<String> fileUrlList, SXSSFWorkbook wb) throws IOException {
        this.log.info("queryDataAndFillSheetContent start,currentPage = {}", (Object)currentPage);
        String calVersionNo = calTaskDy.getString("calversionno");
        Long calRuleVid = calTaskDy.getLong("calrulev.id");
        int amtPrecision = calTaskDy.getInt("payrollgroupv.currency.amtprecision");
        String fields = "id,filenumber,name,empnumber,calresultid";
        String orderBy = "empnumber asc";
        DynamicObject[] calPersonArr = BusinessDataServiceHelper.load((String)"hsas_calperson", (String)fields, (QFilter[])filters, (String)orderBy, (int)currentPage, (int)CalTableExportProgressConstants.PAGE_SIZE);
        this.log.info("calPerson size = {}", (Object)calPersonArr.length);
        List calResultIdList = Arrays.asList(calPersonArr).stream().map(obj -> obj.getLong("calresultid")).collect(Collectors.toList());
        List calPersonIdList = Arrays.asList(calPersonArr).stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        ProrationResultService prorationResultService = new ProrationResultService();
        Map prorationResultMap = prorationResultService.getProrationResult(calPersonIdList, calResultIdList, calRuleVid, calVersionNo, amtPrecision);
        List rowList = null;
        SXSSFRow row = null;
        for (DynamicObject calPerson : calPersonArr) {
            String fileNumber = calPerson.getString("filenumber");
            String name = calPerson.getString("name");
            String empNumber = calPerson.getString("empnumber");
            rowList = (List)prorationResultMap.get(calPerson.getLong("id"));
            if (rowList == null || rowList.size() == 0) continue;
            for (Map rowMap : rowList) {
                if (rowIndex > 1000000) {
                    String exportFileName = this.getExportFileName(calTaskDy);
                    int size = fileUrlList.size() + 1;
                    String fileName = exportFileName + "_" + size;
                    String url = SWCExportDataHelper.writeFile((SXSSFWorkbook)sheet.getWorkbook(), (String)fileName);
                    fileUrlList.add(url);
                    wb.close();
                    wb = new SXSSFWorkbook(1000);
                    sheet = wb.createSheet();
                    sheet.setRandomAccessWindowSize(-1);
                    wb.setSheetName(0, exportFileName);
                    this.setColumnWidth(sheet);
                    this.createHeadRow(sheet, wb);
                    rowIndex = 1;
                }
                row = sheet.createRow(rowIndex);
                this.createCell(0, fileNumber, row, null);
                this.createCell(1, name, row, null);
                this.createCell(2, empNumber, row, null);
                this.createCell(3, (String)rowMap.get(ProrationResultColEnum.ITEMTYPE.getCode()), row, null);
                this.createCell(4, (String)rowMap.get(ProrationResultColEnum.ITEMNUMBER.getCode()), row, null);
                this.createCell(5, (String)rowMap.get(ProrationResultColEnum.ITEMNAME.getCode()), row, null);
                this.createCell(6, (String)rowMap.get(ProrationResultColEnum.PRORATIONINDEX.getCode()), row, null);
                this.createCell(7, (String)rowMap.get(ProrationResultColEnum.DATATYPE.getCode()), row, null);
                this.createCell(8, (String)rowMap.get(ProrationResultColEnum.RESULTVALUE.getCode()), row, null);
                this.createCell(9, (String)rowMap.get(ProrationResultColEnum.STARTDATE.getCode()), row, null);
                this.createCell(10, (String)rowMap.get(ProrationResultColEnum.ENDDATE.getCode()), row, null);
                this.createCell(11, (String)rowMap.get(ProrationResultColEnum.CHANGEREASON.getCode()), row, null);
                ++rowIndex;
            }
        }
        Integer complete = (Integer)cache.get("complete", Integer.class);
        if (complete == null) {
            complete = 0;
        }
        complete = complete + calPersonArr.length;
        cache.put("complete", (Object)complete);
        int totalCount = (Integer)cache.get("totalCount", Integer.class);
        Double progress = Double.parseDouble(complete.toString()) / Double.parseDouble(String.valueOf(totalCount)) * 100.0;
        HRBackgroundTaskHelper.getInstance().feedbackProgress(bgTaskId, progress.intValue(), "", null);
        this.log.info("queryDataAndFillSheetContent end,currentPage = {}", (Object)currentPage);
        return rowIndex;
    }

    private void createHeadRow(SXSSFSheet sheet, SXSSFWorkbook wb) {
        SXSSFRow headRow = sheet.createRow(0);
        CellStyle headCellStyle = this.getHeadColumnStyle(wb);
        this.createCell(0, ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"CalProrationResultExportPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), headRow, headCellStyle);
        this.createCell(1, ResManager.loadKDString((String)"\u59d3\u540d", (String)"CalProrationResultExportPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), headRow, headCellStyle);
        this.createCell(2, ResManager.loadKDString((String)"\u5de5\u53f7", (String)"CalProrationResultExportPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), headRow, headCellStyle);
        this.createCell(3, ProrationResultColEnum.ITEMTYPE.getDesc(), headRow, headCellStyle);
        this.createCell(4, ProrationResultColEnum.ITEMNUMBER.getDesc(), headRow, headCellStyle);
        this.createCell(5, ProrationResultColEnum.ITEMNAME.getDesc(), headRow, headCellStyle);
        this.createCell(6, ProrationResultColEnum.PRORATIONINDEX.getDesc(), headRow, headCellStyle);
        this.createCell(7, ProrationResultColEnum.DATATYPE.getDesc(), headRow, headCellStyle);
        this.createCell(8, ProrationResultColEnum.RESULTVALUE.getDesc(), headRow, headCellStyle);
        this.createCell(9, ProrationResultColEnum.STARTDATE.getDesc(), headRow, headCellStyle);
        this.createCell(10, ProrationResultColEnum.ENDDATE.getDesc(), headRow, headCellStyle);
        this.createCell(11, ProrationResultColEnum.CHANGEREASON.getDesc(), headRow, headCellStyle);
    }

    private void createCell(int cellIndex, String name, SXSSFRow headRow, CellStyle cellStyle) {
        SXSSFCell cell = headRow.createCell(cellIndex);
        cell.setCellValue(name);
        cell.setCellType(CellType.STRING);
        if (cellStyle != null) {
            cell.setCellStyle(cellStyle);
        }
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(true);
        return headColumnStyle;
    }
}

