/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.prorationresult;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.prorationresult.ProrationResultService;
import kd.swc.hsas.common.enums.ProrationResultColEnum;
import kd.swc.hsas.formplugin.web.cal.prorationresult.ProrationResultEntityTypeBillList;
import kd.swc.hsbp.business.calrequest.CalRequestHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalProrationResultViewBillList
extends AbstractListPlugin
implements FilterContainerInitListener {
    private final Log log = LogFactory.getLog(CalProrationResultViewBillList.class);
    private static final String SWC_HSAS_FORMPLUGIN = "swc-hsas-formplugin";
    private static final String KEY_BILL_LIST_AP = "billlistap";
    private static final String LABLE_PAYROLLGRP = "payrollgroupvalue";
    private static final String LABLE_CALSCENE = "calscenevalue";
    private static final String LABLE_CALTASKTYPE = "caltasktypevalue";
    private static final String LABEL_CALPERIOD = "calperiodvalue";
    private static final String LABEL_CALTASKNAME = "caltasknamevalue";
    private static final String KEY_CALREQUESTICON = "calrequesticon";
    private static final String KEY_CALINGICON = "calingicon";
    private static final String SHOW_CURRENCY = "showcurrency";
    private static final String SMALL_K = "smallk";
    private ProrationResultEntityTypeBillList billList;
    private String calVersionNo;
    private Long calRuleVid;
    private int amtPrecision;
    private IFormView view;

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        this.getView().addCustomControls(new String[]{KEY_BILL_LIST_AP});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{LABLE_PAYROLLGRP, LABLE_CALSCENE, KEY_CALREQUESTICON});
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
        this.log.info("filterContainerInit begin");
        long startTime = System.currentTimeMillis();
        List schemeFilterColumns = filterContainerInitEvent.getSchemeFilterColumns();
        List commonFilterColumns = filterContainerInitEvent.getCommonFilterColumns();
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        Boolean enableTax = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)calTaskId);
        if (!enableTax.booleanValue()) {
            commonFilterColumns.removeIf(col -> SWCStringUtils.equals((String)col.getFieldName(), (String)"taxstatus"));
            schemeFilterColumns.removeIf(col -> SWCStringUtils.equals((String)col.getFieldName(), (String)"taxstatus"));
            for (SchemeFilterColumn filterColumn : schemeFilterColumns) {
                String filedKey = filterColumn.getFieldName();
                if (!"calstatus".equals(filedKey)) continue;
                filterColumn.getComboItems().removeIf(item -> SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.PUSHTAX_ERROR.getCode()) || SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.PRECAL_CALED.getCode()) || SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.TAXCAL_ERROR.getCode()) || SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.PULLTAX_ERROR.getCode()));
            }
            for (CommonFilterColumn filterColumn : commonFilterColumns) {
                String filedKey = filterColumn.getFieldName();
                if (!"calstatus".equals(filedKey)) continue;
                filterColumn.getComboItems().removeIf(item -> SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.PUSHTAX_ERROR.getCode()) || SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.PRECAL_CALED.getCode()) || SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.TAXCAL_ERROR.getCode()) || SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.PULLTAX_ERROR.getCode()));
            }
        }
        long costTime = System.currentTimeMillis() - startTime;
        this.log.info("filterContainerInit\u3000end,costtime {}", (Object)costTime);
    }

    public void setFilter(SetFilterEvent e) {
        Long startTime = System.currentTimeMillis();
        this.log.info("setFilter begin");
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        qFilter.and("isproration", "=", (Object)Boolean.TRUE);
        qFilter.and("calstatus", "not in", (Object)new String[]{CalStateEnum.UNCAL.getCode(), CalStateEnum.CALING.getCode(), CalStateEnum.PRECAL_ERROR.getCode()});
        e.getQFilters().add(qFilter);
        if (authorizedDataRuleQFilter != null) {
            e.getQFilters().addAll(authorizedDataRuleQFilter);
        } else {
            e.getQFilters().add(new QFilter("1", "!=", (Object)1));
        }
        this.log.info("all filters is:{}", (Object)e.getQFilters().toString());
        Long endTime = System.currentTimeMillis();
        this.log.info("setFilter end,costtime {}", (Object)(endTime - startTime));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.log.info("beforeBindData begin");
        long startTime = System.currentTimeMillis();
        String entityId = this.getView().getEntityId();
        if (entityId.contains("bos_listf7")) {
            return;
        }
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        Set calingTasks = CalRequestHelper.getCalingTask();
        this.getView().setVisible(Boolean.valueOf(calingTasks.contains(calTaskId)), new String[]{KEY_CALINGICON});
        this.getView().setVisible(Boolean.FALSE, new String[]{SHOW_CURRENCY, SMALL_K});
        String calTaskType = (String)this.getView().getFormShowParameter().getCustomParam("calTaskType");
        if (SWCStringUtils.equals((String)calTaskType, (String)"2")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
        }
        Label calTaskTypeLable = (Label)this.getControl(LABLE_CALTASKTYPE);
        Label payRollGroupLable = (Label)this.getControl(LABLE_PAYROLLGRP);
        Label calSceneLable = (Label)this.getControl(LABLE_CALSCENE);
        Label calPeriodLable = (Label)this.getControl(LABEL_CALPERIOD);
        Label calTaskNameLable = (Label)this.getControl(LABEL_CALTASKNAME);
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String props = "id,payrollgroupv.name,payrollscenev.name,period.name,isautoaddperson,name,calcount,calversionno,calrulev.id,payrollgroupv.currency.amtprecision";
        QFilter idFilter = new QFilter("id", "=", (Object)calTaskId);
        DynamicObject calTaskDy = calTaskHelper.queryOriginalOne(props, new QFilter[]{idFilter});
        if (SWCObjectUtils.isEmpty((Object)calTaskDy)) {
            return;
        }
        this.amtPrecision = calTaskDy.getInt("payrollgroupv.currency.amtprecision");
        this.calVersionNo = calTaskDy.getString("calversionno");
        this.calRuleVid = calTaskDy.getLong("calrulev.id");
        this.view = this.getView();
        payRollGroupLable.setText(calTaskDy.getString("payrollgroupv.name"));
        calSceneLable.setText(calTaskDy.getString("payrollscenev.name"));
        String countMsg = ResManager.loadKDString((String)"\u7b2c%d\u6b21", (String)"CalPersonListViewPlugin_1", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
        int count = calTaskDy.getInt("calcount");
        calPeriodLable.setText(calTaskDy.getString("period.name") + ' ' + String.format(Locale.ROOT, countMsg, count));
        calTaskNameLable.setText(calTaskDy.getString("name"));
        MainEntityType calTask = EntityMetadataCache.getDataEntityType((String)"hsas_calpayrolltask");
        ComboProp taskTypeCombo = (ComboProp)calTask.getProperties().get((Object)"tasktype");
        List comboItems = taskTypeCombo.getComboItems();
        for (ValueMapItem item : comboItems) {
            if (!item.getValue().equals(calTaskType)) continue;
            calTaskTypeLable.setText(item.getName().getLocaleValue());
            break;
        }
        long costTime = System.currentTimeMillis() - startTime;
        this.log.info("beforeBindData begin,costtime {}", (Object)costTime);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "payrollgroupvalue": {
                String payRollGroupVid = (String)this.getView().getFormShowParameter().getCustomParam("payrollgroupv");
                this.viewBaseData("hsas_payrollgrp", Long.parseLong(payRollGroupVid), "hsas_payrollgrp");
                break;
            }
            case "calscenevalue": {
                String calSceneVid = (String)this.getView().getFormShowParameter().getCustomParam("payRollSceneVId");
                this.viewBaseData("hsas_payrollscene", Long.parseLong(calSceneVid), "hsas_payrollscene");
                break;
            }
            case "calrequesticon": {
                ListShowParameter listShowParameter = CalRequestHelper.getCalRequestListForm();
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
        }
    }

    private void viewBaseData(String formId, long pkId, String premItemEntity) {
        String opName = ResManager.loadKDString((String)"\u67e5\u770b\u5386\u53f2", (String)"CalPersonListViewPlugin_0", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
        if (this.checkPermission("0=KX5+QZ1K6A", premItemEntity)) {
            this.showBaseDataPage(formId, pkId);
        } else {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)premItemEntity);
            String entityName = mainEntityType.getDisplayName().getLocaleValue();
            String msg = SWCPermissionServiceHelper.getNoPermTips((String)String.format("%s%s", entityName, opName));
            this.getView().showMessage(msg);
        }
    }

    private boolean checkPermission(String permItemId, String entryName) {
        long userId = RequestContext.get().getCurrUserId();
        return SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)entryName, (String)permItemId);
    }

    private void showBaseDataPage(String formId, long pkId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(formId);
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setPkId((Object)pkId);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        e.setNewEntityType(this.getEntityType());
    }

    private MainEntityType getEntityType() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hsas_prorationresult");
        MainEntityType mainEntityType = null;
        try {
            mainEntityType = (MainEntityType)mainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            this.log.error("getNewEntityType: ", (Throwable)e1);
        }
        if (mainEntityType == null) {
            return mainType;
        }
        this.addBillColumnProp((DynamicObjectType)mainEntityType);
        return mainEntityType;
    }

    private void addBillColumnProp(DynamicObjectType mainEntityType) {
        TextProp property = null;
        for (ProrationResultColEnum result : ProrationResultColEnum.values()) {
            if (result == ProrationResultColEnum.RESULTCOVER) continue;
            property = new TextProp();
            property.setName(result.getCode());
            property.setDisplayName(new LocaleString(result.getDesc()));
            property.setMaxLenth(200);
            mainEntityType.addProperty((DynamicProperty)property);
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        BillList customControl = null;
        if (KEY_BILL_LIST_AP.equals(key)) {
            customControl = this.createBillList(key);
        }
        if (customControl != null) {
            args.setControl((Control)customControl);
        }
    }

    private BillList createBillList(String key) {
        if (this.billList != null) {
            return this.billList;
        }
        this.billList = new ProrationResultEntityTypeBillList((EntityType)this.getEntityType());
        this.billList.setKey(key);
        this.billList.setEntityId("hsas_prorationresult");
        ListView listView = (ListView)this.getView();
        this.billList.setBillFormId(listView.getBillFormId());
        this.billList.setView((IFormView)listView);
        Container rootControl = (Container)this.getView().getRootControl();
        this.replaceBillList(rootControl.getItems(), (Control)this.billList);
        return this.billList;
    }

    private void replaceBillList(List<Control> items, Control billList) {
        for (int i = 0; i < items.size(); ++i) {
            Control control = items.get(i);
            if (control.getKey().equals(billList.getKey())) {
                items.set(i, billList);
                return;
            }
            if (!(control instanceof Container)) continue;
            this.replaceBillList(((Container)control).getItems(), billList);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columnList = args.getListColumns();
        int seq = columnList.size() + 1;
        for (ProrationResultColEnum result : ProrationResultColEnum.values()) {
            if (result == ProrationResultColEnum.RESULTCOVER) continue;
            ListColumn column = new ListColumn();
            column.setCaption(new LocaleString(result.getDesc()));
            column.setKey(result.getCode());
            column.setListFieldKey(result.getCode());
            column.setSeq(seq);
            if (result == ProrationResultColEnum.RESULTVALUE) {
                column.setTextAlign("right");
            }
            columnList.add(column);
            ++seq;
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ProrationResultImpl());
    }

    public class ProrationResultImpl
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection list = super.getData(start, limit);
            if (list == null || list.size() == 0) {
                return list;
            }
            CalProrationResultViewBillList.this.addBillColumnProp(list.getDynamicObjectType());
            ArrayList<Long> calResultIdList = new ArrayList<Long>(list.size());
            ArrayList<Long> calPersonIdList = new ArrayList<Long>(list.size());
            for (DynamicObject obj : list) {
                calResultIdList.add(obj.getLong("calresultid"));
                calPersonIdList.add(obj.getLong("id"));
            }
            ProrationResultService prorationResultService = new ProrationResultService();
            Map prorationResultMap = prorationResultService.getProrationResult(calPersonIdList, calResultIdList, CalProrationResultViewBillList.this.calRuleVid, CalProrationResultViewBillList.this.calVersionNo, CalProrationResultViewBillList.this.amtPrecision);
            DynamicObjectCollection result = new DynamicObjectCollection();
            DynamicObject calTable = null;
            List tempList = null;
            HashMap<Integer, String> indexIdStrMap = new HashMap<Integer, String>(16);
            int index = 0;
            for (DynamicObject data : list) {
                tempList = (List)prorationResultMap.get(data.getLong("id"));
                if (tempList == null) continue;
                for (Map rowMap : tempList) {
                    calTable = (DynamicObject)OrmUtils.clone((IDataEntityBase)data, (boolean)false, (boolean)false);
                    calTable.set(ProrationResultColEnum.ITEMTYPE.getCode(), rowMap.get(ProrationResultColEnum.ITEMTYPE.getCode()));
                    if (SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee", (String)"ProrationResultService_0", (String)"swc-hsas-business", (Object[])new Object[0]), (String)(rowMap.get(ProrationResultColEnum.ITEMTYPE.getCode()) + ""))) {
                        indexIdStrMap.put(index, rowMap.get("idstr") + "");
                    }
                    calTable.set(ProrationResultColEnum.ITEMNUMBER.getCode(), rowMap.get(ProrationResultColEnum.ITEMNUMBER.getCode()));
                    calTable.set(ProrationResultColEnum.ITEMNAME.getCode(), rowMap.get(ProrationResultColEnum.ITEMNAME.getCode()));
                    calTable.set(ProrationResultColEnum.PRORATIONINDEX.getCode(), rowMap.get(ProrationResultColEnum.PRORATIONINDEX.getCode()));
                    calTable.set(ProrationResultColEnum.DATATYPE.getCode(), rowMap.get(ProrationResultColEnum.DATATYPE.getCode()));
                    calTable.set(ProrationResultColEnum.RESULTVALUE.getCode(), rowMap.get(ProrationResultColEnum.RESULTVALUE.getCode()));
                    calTable.set(ProrationResultColEnum.STARTDATE.getCode(), rowMap.get(ProrationResultColEnum.STARTDATE.getCode()));
                    calTable.set(ProrationResultColEnum.ENDDATE.getCode(), rowMap.get(ProrationResultColEnum.ENDDATE.getCode()));
                    calTable.set(ProrationResultColEnum.CHANGEREASON.getCode(), rowMap.get(ProrationResultColEnum.CHANGEREASON.getCode()));
                    result.add((Object)calTable);
                    ++index;
                }
            }
            SWCPageCache swcPageCache = new SWCPageCache(CalProrationResultViewBillList.this.getView());
            swcPageCache.put("prorationListRowIndexIdStrMap", indexIdStrMap);
            if (result.size() == 0) {
                list.clear();
                return list;
            }
            return result;
        }
    }
}

