/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.prorationresult;

import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ProrationResultExportProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String MARK_TOTAL = "total";
    private static final String COMPLETE = "complete";
    private static final String PROGRESS = "progress";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String BTNCANCEL = "btncancel";

    public void initialize() {
        super.initialize();
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        progressBar.start();
        this.setExportProgressStatus("2");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Label totalTitle = (Label)this.getControl(MARK_TOTAL);
        int totalCount = (Integer)this.getView().getFormShowParameter().getCustomParam("totalCount");
        String msg = ResManager.loadKDString((String)"\u5171\u9009\u4e2d{0}\u6761\u6838\u7b97\u8bb0\u5f55", (String)"ProrationResultExportProgressPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[]{totalCount});
        totalTitle.setText(msg);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        progressBar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BTNCANCEL});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        SWCPageCache page = new SWCPageCache(this.getView());
        Boolean isOpeanBgTask = (Boolean)page.get("isOpeanBgTask", Boolean.class);
        if (isOpeanBgTask != null && !isOpeanBgTask.booleanValue()) {
            return;
        }
        String bgTaskId = (String)this.getView().getFormShowParameter().getCustomParam("bgTaskId");
        if (SWCStringUtils.isEmpty((String)bgTaskId)) {
            String exportTaskId = (String)this.getView().getFormShowParameter().getCustomParam("downLoadTaskId");
            ISWCAppCache cache = SWCAppCache.get((String)String.format(Locale.ROOT, "prorationresult_export_%s", exportTaskId));
            bgTaskId = (String)cache.get("bgTaskId", String.class);
        }
        if (SWCStringUtils.isNotEmpty((String)bgTaskId)) {
            HRBackgroundTaskHelper.getInstance().showBaskgroundTask(bgTaskId);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)BTNCANCEL, (CharSequence)source.getKey())) {
            this.setExportProgressStatus("1");
            this.stopProgressBar();
            SWCPageCache page = new SWCPageCache(this.getView());
            page.put("isOpeanBgTask", (Object)Boolean.FALSE);
            this.getView().close();
            String message = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"HSASCalTableExportProgressPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().getParentView().showSuccessNotification(message);
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        if (StringUtils.equals((CharSequence)this.getPageCache().get(this.getCurrentViewAppCacheKey()), (CharSequence)"1")) {
            this.stopProgressBar();
            SWCPageCache page = new SWCPageCache(this.getView());
            page.put("isOpeanBgTask", (Object)Boolean.FALSE);
            this.getView().close();
        }
        this.showProgress(progressEvent);
    }

    private void showProgress(ProgressEvent progressEvent) {
        String downLoadTaskId = (String)this.getView().getFormShowParameter().getCustomParam("downLoadTaskId");
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "prorationresult_export_%s", downLoadTaskId));
        int totalCount = (Integer)this.getView().getFormShowParameter().getCustomParam("totalCount");
        List urlList = (List)appCache.get("url", List.class);
        Boolean isSuccess = (Boolean)appCache.get("issuccess", Boolean.class);
        if (isSuccess != null && !isSuccess.booleanValue()) {
            this.stopProgressBar();
            SWCPageCache page = new SWCPageCache(this.getView());
            page.put("isOpeanBgTask", (Object)Boolean.FALSE);
            this.getView().close();
            String message = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u5177\u4f53\u5931\u8d25\u8be6\u60c5\u3002", (String)"ProrationResultExportProgressPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().getParentView().showErrorNotification(message);
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        if (!SWCListUtils.isEmpty((List)urlList)) {
            progressEvent.setProgress(100);
            for (String url : urlList) {
                this.downloadExecl(url);
            }
            SWCPageCache page = new SWCPageCache(this.getView());
            page.put("isOpeanBgTask", (Object)Boolean.FALSE);
            this.getView().close();
            return;
        }
        Integer complete = (Integer)appCache.get(COMPLETE, Integer.class);
        if (complete == null) {
            return;
        }
        double progress = 0.0;
        progress = complete.equals(totalCount) ? 100.0 : Double.parseDouble(complete.toString()) / Double.parseDouble(String.valueOf(totalCount)) * 100.0;
        if (progress >= 100.0) {
            progress = 100.0;
            String text = ResManager.loadKDString((String)"\u5b8c\u6210", (String)"HSASCalTableExportProgressPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            progressEvent.setText(text);
            if (!SWCListUtils.isEmpty((List)urlList)) {
                progressEvent.setProgress(100);
                for (String url : urlList) {
                    this.downloadExecl(url);
                }
                SWCPageCache page = new SWCPageCache(this.getView());
                page.put("isOpeanBgTask", (Object)Boolean.FALSE);
                this.getView().close();
                return;
            }
            progressEvent.setProgress(99);
        } else {
            this.setExportProgressStatus("2");
            progressEvent.setProgress((int)progress);
        }
        Label completeTitle = (Label)this.getControl(COMPLETE);
        completeTitle.setText(String.valueOf(complete));
        Label progressTitle = (Label)this.getControl(PROGRESS);
        progressTitle.setText((int)progress + "%");
    }

    private void stopProgressBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.stop();
    }

    private void setExportProgressStatus(String status) {
        this.getPageCache().put(this.getCurrentViewAppCacheKey(), status);
    }

    private String getCurrentViewAppCacheKey() {
        return "EXPT_SUSPEND_STATUS";
    }

    private void downloadExecl(String url) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("download", (Object)url);
    }
}

