/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.salarypay;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Html;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PaySalConfirmPlugin
extends AbstractFormPlugin {
    public static final String BTN_OK = "btnok";
    public static final String CONTENT = "content";
    public static final String TITLE = "title";
    public static final String DONOTHING_RELEASE = "donothing_release";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setTitle();
        this.setContent();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (SWCStringUtils.equals((String)DONOTHING_RELEASE, (String)operateKey)) {
            this.getPageCache().put("isClose", "1");
            HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
            returnData.put("isOk", Boolean.TRUE);
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String closeTrue = this.getPageCache().get("isClose");
        if (SWCStringUtils.isEmpty((String)closeTrue)) {
            HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
            returnData.put("isOk", Boolean.FALSE);
            this.getView().returnDataToParent((Object)returnData);
        }
    }

    private void setTitle() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        int calPersonTotalSize = (Integer)customParams.get("calPersonTotalCount");
        int payRollTaskCount = (Integer)customParams.get("payRollTaskCount");
        Label titleControl = (Label)this.getControl(TITLE);
        String title = "";
        if (SWCStringUtils.equals((String)"payRollTask", (String)((String)customParams.get("source")))) {
            title = MessageFormat.format(ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u4e2a\u6838\u7b97\u4efb\u52a1\uff0c\u6743\u9650\u5185\u6838\u7b97\u8bb0\u5f55{1}\u6761\uff0c\u5176\u4e2d\uff1a", (String)"PaySalConfirmPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), payRollTaskCount, calPersonTotalSize);
        } else if (SWCStringUtils.equals((String)"calPerson", (String)((String)customParams.get("source")))) {
            title = MessageFormat.format(ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u6838\u7b97\u8bb0\u5f55\uff0c\u5176\u4e2d\uff1a", (String)"PaySalConfirmPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), calPersonTotalSize);
        }
        titleControl.setText(title);
    }

    private void setContent() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        int calPersonTotalSize = (Integer)customParams.get("calPersonTotalCount");
        Html htmlControl = (Html)this.getControl(CONTENT);
        int unPayCount = (Integer)customParams.get("unPayCount");
        int payedCount = (Integer)customParams.get("payedCount");
        StringBuilder content = new StringBuilder();
        String startDiv = "<div><span style='font-size:14px'>";
        String endDiv = "</span></div>";
        content.append(startDiv).append("<span style='font-size:14px;color:#1BA854;font-weight:bold'>").append(unPayCount + payedCount).append(' ').append("</span>").append("<span style='font-size:14px;color:#212121'>").append(ResManager.loadKDString((String)"\u6761\u7b26\u5408\u6761\u4ef6\uff0c\u53ef\u76f4\u63a5\u53d1\u5e03\u5de5\u8d44\u6761", (String)"PaySalConfirmPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append("</span>").append(endDiv).append(startDiv).append("<span style='font-size:14px;color:#FB2323;font-weight:bold'>").append(calPersonTotalSize - unPayCount - payedCount).append(' ').append("</span>").append("<span style='font-size:14px;color:#212121'>").append(ResManager.loadKDString((String)"\u6761\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u5c06\u4e3a\u4f60\u81ea\u52a8\u6392\u9664\uff08\u5df2\u53d1\u5e03\u6216\u4e0d\u53d1\u5e03\u5de5\u8d44\u6761\u3001\u672a\u8fbe\u5230\u6216\u672a\u8bbe\u7f6e\u53d1\u5e03\u65f6\u70b9\uff09", (String)"PaySalConfirmPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append("</span>").append(endDiv);
        htmlControl.setConent(content.toString());
    }
}

