/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.task;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class CalTaskNewTemplateList
extends SWCDataBaseList {
    private static final String KEY_CHANGESTATUS = "changestatus";
    private static final String OP_VIEWLOG = "donothing_viewlog";
    private static final String ACTION_TIPS = "payrollgrp_modify_tips";
    private static final String ACTION_ERRORS = "payrollgrp_modify_errors";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "submit": {
                formOperate.getOption().setVariableValue("islist", "true");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (args.getOperationResult() != null) {
            List successPkIds = args.getOperationResult().getSuccessPkIds();
            switch (operateKey) {
                case "enable": 
                case "disable": {
                    this.updateTplChangeStatus(operateKey, successPkIds);
                    break;
                }
                case "donothing_viewlog": {
                    this.showTplLog();
                    break;
                }
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        CommonBaseDataFilterColumn filterColumn;
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        if (commonFilterColumns != null && !commonFilterColumns.isEmpty() && (filterColumn = (CommonBaseDataFilterColumn)commonFilterColumns.get(0)).getFieldName().equals("org.name")) {
            filterColumn.setDefaultValue("");
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "payrollgrp.id": 
            case "payrollgrp.name": 
            case "payrollscene.id": 
            case "payrollscene.name": {
                HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_caltasknewtpl", (String)"47150e89000000ac");
                if (permOrgs == null || permOrgs.hasAllOrgPerm()) break;
                filters.add(new QFilter("org.id", "in", (Object)permOrgs.getHasPermOrgs()));
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("enable desc,changestatus desc,status asc,number asc");
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        ColumnDesc columnDesc = (ColumnDesc)evt.getSource();
        if (KEY_CHANGESTATUS.equals(columnDesc.getFieldKey())) {
            String changeStatus = evt.getRowData().getString(KEY_CHANGESTATUS);
            String enable = evt.getRowData().getString("enable");
            if ("0".equals(changeStatus) || !"1".equals(enable)) {
                evt.setFormatValue((Object)"");
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        final BillList billList = (BillList)this.getControl("billlistap");
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows;
                block17: {
                    int isAllNoNew;
                    block18: {
                        rows = super.getData(start, limit);
                        if (rows.isEmpty()) {
                            return rows;
                        }
                        List listFieldsControlColumns = billList.getListFieldsControlColumns();
                        isAllNoNew = 10;
                        try (DataSet ds = ORM.create().queryDataSet("CalTaskNewTemplateList", "hsas_caltasknewtpl", "changestatus,enable", null, null, start, limit, (Distinctable)WithEntityEntryDistinctable.get());){
                            Iterator iterator = ds.iterator();
                            while (iterator.hasNext()) {
                                Row row = (Row)iterator.next();
                                if (!"1".equals(row.get(CalTaskNewTemplateList.KEY_CHANGESTATUS)) && (!"2".equals(row.get(CalTaskNewTemplateList.KEY_CHANGESTATUS)) || !"1".equals(row.get("enable")))) continue;
                                isAllNoNew = 11;
                                break;
                            }
                        }
                        if (listFieldsControlColumns == null || listFieldsControlColumns.size() <= 0) break block18;
                        for (Map listFieldsControlColumn : listFieldsControlColumns) {
                            if (!CalTaskNewTemplateList.KEY_CHANGESTATUS.equals(listFieldsControlColumn.get("listFieldKey"))) continue;
                            listFieldsControlColumn.put("visible", isAllNoNew);
                            break block17;
                        }
                        break block17;
                    }
                    List items = billList.getItems();
                    if (items.size() <= 0 || !(items.get(0) instanceof ListGridView)) break block17;
                    ListGridView listGridView = (ListGridView)items.get(0);
                    List listColumns = listGridView.getItems();
                    for (Control control : listColumns) {
                        ListColumn listColumn = (ListColumn)control;
                        if (!CalTaskNewTemplateList.KEY_CHANGESTATUS.equals(listColumn.getFieldName())) continue;
                        listColumn.setVisible(isAllNoNew);
                        break;
                    }
                }
                return rows;
            }
        });
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp() && "true".equals(listShowParameter.getCustomParam("calTask"))) {
            args.setCancel(true);
            return;
        }
        IListView listView = (IListView)this.getView();
        Long calTplId = Long.valueOf(String.valueOf(listView.getFocusRowPkId()));
        block3 : switch (fieldName = args.getHyperLinkClickEvent().getFieldName()) {
            case "changestatus": {
                args.setCancel(true);
                SWCDataServiceHelper calTplHelper = new SWCDataServiceHelper("hsas_caltasknewtpl");
                DynamicObject calTplDy = calTplHelper.queryOne(KEY_CHANGESTATUS, (Object)calTplId);
                switch (calTplDy.getString(KEY_CHANGESTATUS)) {
                    case "1": {
                        this.showChangeTipsConfirm(calTplId);
                        break block3;
                    }
                    case "2": {
                        this.showDisableTipsConfirm(calTplId);
                        break block3;
                    }
                }
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "payrollgrp_modify_tips": {
                this.sureCloseChangeTip(event);
                break;
            }
            case "payrollgrp_modify_errors": {
                this.sureDisableTpl(event);
                break;
            }
        }
    }

    private void sureCloseChangeTip(MessageBoxClosedEvent event) {
        if (event.getResult().equals((Object)MessageBoxResult.Yes)) {
            DynamicObject[] records;
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltasknewtpl");
            Long calTplId = Long.valueOf(event.getCustomVaule());
            QFilter calTplFilter = new QFilter("id", "=", (Object)calTplId);
            DynamicObject calTplDy = helper.queryOne(KEY_CHANGESTATUS, calTplFilter.toArray());
            calTplDy.set(KEY_CHANGESTATUS, (Object)"0");
            helper.saveOne(calTplDy);
            helper.setEntityName("hsas_payrollgrpchgrec");
            QFilter qFilter = new QFilter("caltasknewtpl", "=", (Object)calTplId);
            qFilter.and("ismark", "=", (Object)"0");
            for (DynamicObject record : records = helper.query("ismark", qFilter.toArray())) {
                record.set("ismark", (Object)"1");
            }
            helper.save(records);
            this.getView().invokeOperation("refresh");
        }
    }

    private void showChangeTipsConfirm(Long calTplId) {
        String msg = ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u6240\u4f9d\u8d56\u7684\u85aa\u8d44\u6838\u7b97\u7ec4\u53d1\u751f\u6570\u636e\u7248\u672c\u53d8\u66f4\uff0c\u8bf7\u6839\u636e\u5b9e\u9645\u60c5\u51b5\u786e\u5b9a\u662f\u5426\u8981\u5bf9\u8be5\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u8fdb\u884c\u53d8\u66f4\u3002", (String)"CalTaskNewTemplateList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ACTION_TIPS, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u4fdd\u6301\u63d0\u9192", (String)"CalTaskNewTemplateList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u4e0d\u518d\u63d0\u9192", (String)"CalTaskNewTemplateList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrpchgrec");
        String selPros = "createtime,creator.name,payrollgrp.name,payrollgrp.number,payrollgrpvbred,ismark";
        QFilter qFilter = new QFilter("caltasknewtpl", "=", (Object)calTplId);
        qFilter.and("ismark", "=", (Object)"0");
        DynamicObject[] records = helper.query(selPros, qFilter.toArray());
        StringBuilder sb = new StringBuilder();
        if (records.length > 0) {
            sb.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4%s\u65b0\u589e\u6570\u636e\u7248\u672c\u4fe1\u606f\uff1a", (String)"CalTaskNewTemplateList_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), records[0].getString("payrollgrp.number")));
            sb.append("\r\n");
            for (DynamicObject record : records) {
                String payrollgrpName = record.getString("payrollgrp.name");
                String payrollgrpvBred = HRInteDateTimeUtil.formatDate((String)"hsas_payrollgrpchgrec", (String)"payrollgrpvbred", (Date)record.getDate("payrollgrpvbred"));
                String creator = record.getString("creator.name");
                String createTime = HRInteDateTimeUtil.formatDate((String)"hsas_payrollgrpchgrec", (String)"createtime", (Date)record.getDate("createtime"));
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u751f\u6548\u65e5\u671f\u4e3a\u201c{1}\u201d\uff0c\u53d8\u66f4\u4eba\u4e3a\u201c{2}\u201d\uff0c\u53d8\u66f4\u65f6\u95f4\u4e3a\u201c{3}\u201d\uff1b", (String)"CalTaskNewTemplateList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), payrollgrpName, payrollgrpvBred, creator, createTime));
                sb.append("\r\n");
            }
        }
        String moreInfo = sb.toString();
        this.getView().showConfirm(msg, moreInfo, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, btnNameMaps, calTplId.toString());
    }

    private void sureDisableTpl(MessageBoxClosedEvent event) {
        if (event.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getView().invokeOperation("disable");
        }
    }

    private void showDisableTipsConfirm(Long calTplId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltasknewtpl");
        DynamicObject calTplDy = helper.queryOne("payrollgrp", (Object)calTplId);
        long payrollGrpId = calTplDy.getLong("payrollgrp.id");
        helper.setEntityName("hsas_payrollgrp");
        QFilter qFilter = new QFilter("id", "=", (Object)payrollGrpId);
        DynamicObject payrollGrpDy = helper.queryOne("disabledate", qFilter.toArray());
        Date disableDate = payrollGrpDy.getDate("disabledate");
        String disableDateStr = SWCObjectUtils.isEmpty((Object)disableDate) ? SWCInteDateTimeUtil.formatTimeWithUserZone((Date)new Date()) : HRInteDateTimeUtil.formatDate((String)"hsas_payrollgrp", (String)"disabledate", (Date)disableDate);
        String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u6240\u4f9d\u8d56\u7684\u85aa\u8d44\u6838\u7b97\u7ec4\u4e8e%s\u88ab\u7981\u7528\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u4efb\u52a1\u81ea\u52a8\u521b\u5efa\u5931\u8d25\uff0c\u662f\u5426\u8981\u5c06\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u7981\u7528\uff1f", (String)"CalTaskNewTemplateList_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]), disableDateStr);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ACTION_ERRORS, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"CalTaskNewTemplateList_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"CalTaskNewTemplateList_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, btnNameMaps, calTplId.toString());
    }

    private void showTplLog() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setHasRight(true);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("hsas_caltasknewlog");
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        showParameter.setCustomParam("tplnumbers", selectedRows.stream().map(ListSelectedRow::getNumber).toArray(String[]::new));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void updateTplChangeStatus(String opKey, List<Object> calTplIds) {
        DynamicObject[] calTplDys;
        SWCDataServiceHelper helper;
        if ("enable".equals(opKey)) {
            helper = new SWCDataServiceHelper("hsas_payrollgrpchgrec");
            QFilter qFilter = new QFilter("caltasknewtpl", "in", calTplIds);
            qFilter.and("ismark", "=", (Object)"0");
            DynamicObject[] records = helper.query("caltasknewtpl,ismark", qFilter.toArray());
            HashSet<Long> calTplIdSets = new HashSet<Long>(records.length);
            for (DynamicObject record : records) {
                calTplIdSets.add(record.getLong("caltasknewtpl.id"));
            }
            QFilter calTplFilter = new QFilter("id", "in", calTplIdSets);
            helper.setEntityName("hsas_caltasknewtpl");
            for (DynamicObject calTplDy : calTplDys = helper.query(KEY_CHANGESTATUS, calTplFilter.toArray())) {
                calTplDy.set(KEY_CHANGESTATUS, (Object)"1");
            }
        } else {
            helper = new SWCDataServiceHelper("hsas_caltasknewtpl");
            QFilter calTplFilter = new QFilter("id", "in", calTplIds);
            for (DynamicObject calTplDy : calTplDys = helper.query(KEY_CHANGESTATUS, calTplFilter.toArray())) {
                calTplDy.set(KEY_CHANGESTATUS, (Object)"0");
            }
        }
        helper.save(calTplDys);
    }
}

