/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.task;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.formplugin.CronStruct;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class CalTaskNewTplSchPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(CalTaskNewTplSchPlugin.class);
    private static CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    private static final String[] CKMONTH = new String[]{"ckjan", "ckfeb", "ckmar", "ckapr", "ckmay", "ckjun", "ckjul", "ckaug", "cksep", "ckoct", "cknov", "ckdec"};
    private static final String[] CKDATE = new String[]{"ckone", "cktwo", "ckthree", "ckfour", "ckfive", "cksix", "ckseven", "ckeight", "cknine", "ckten", "ckeleven", "cktwelve", "ckthirteen", "ckfourteen", "ckfifteen", "cksixteen", "ckseventeen", "ckeighteen", "cknineteen", "cktwenty", "cktwentyone", "cktwentytwo", "cktwentythree", "cktwentyfour", "cktwentyfive", "cktwentysix", "cktwentyseven", "cktwentyeight", "cktwentynine", "ckthirty", "ckthirtyone"};
    private static final String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    private static final String btnexecute = "btnexecute";
    private static final String DEFINE = "def";
    private static final String NOREPEAT = "n";
    private static final String YEAR = "y";
    private static final String MONTH = "m";
    private static final String WEEK = "w";
    private static final String DAY = "d";
    private static final String HOUR = "h";
    private static final String MINUTE = "mi";

    public void initialize() {
        super.initialize();
        Toolbar tb = (Toolbar)this.getView().getControl("toolbarap");
        tb.addItemClickListener((ItemClickListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener(tabselectevent -> {
            String key = tabselectevent.getTabKey();
            if ("tabweekpage".equals(key)) {
                this.getModel().setValue("combdorw", (Object)WEEK);
            } else {
                this.getModel().setValue("combdorw", (Object)DAY);
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        Object newReIn = formShowParameter.getCustomParam("newReIn");
        this.getView().setVisible(Boolean.FALSE, new String[]{btnexecute});
        if (!status.equals((Object)OperationStatus.ADDNEW) || "true".equals(newReIn)) {
            Object repeatmode;
            String repeatmodeStr;
            this.adjustByRepeatMode();
            String fromBiz = (String)formShowParameter.getCustomParam("frombiz");
            if (fromBiz != null && fromBiz.equals("true")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"job"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"btnconfirm"});
            }
            String cronTemp = (String)this.getModel().getValue("plan");
            Object comno = this.getModel().getValue("comno");
            Object comweek = this.getModel().getValue("comweek");
            this.getPageCache().put("loadData", "true");
            Tab tab = (Tab)this.getControl("tabap");
            Object combdorw = this.getModel().getValue("combdorw");
            if (combdorw != null && WEEK.equals(combdorw.toString())) {
                tab.activeTab("tabweekpage");
            }
            if (MONTH.equals(repeatmodeStr = (repeatmode = this.getModel().getValue("repeatmode")).toString())) {
                this.getModel().setValue("comnobyweek", comno);
                this.getModel().setValue("comweekbyweek", comweek);
            } else if (YEAR.equals(repeatmodeStr)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"comnobymonth", "comweekbymonth"});
                this.getModel().setValue("comnobymonth", comno);
                this.getModel().setValue("comweekbymonth", comweek);
            } else if (DEFINE.equals(repeatmodeStr)) {
                String cron = (String)this.getModel().getValue("plan");
                this.getModel().setValue("plan", (Object)cron);
                this.getPageCache().remove("loadData");
                this.getModel().setValue("txtdesc", (Object)this.genDefDesc(repeatmodeStr));
                this.getView().setVisible(Boolean.TRUE, new String[]{btnexecute});
                return;
            }
            if ("true".equals(newReIn)) {
                this.getModel().setValue("plan", (Object)cronTemp);
            }
            this.getPageCache().remove("loadData");
            this.adjustByCron();
            this.getModel().setValue("txtdesc", (Object)this.genDesc());
            this.getView().setVisible(Boolean.TRUE, new String[]{btnexecute});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperationResult().isSuccess() && afterDoOperationEventArgs.getObjectId().equals("save")) {
            DynamicObject dynObject = this.getView().getModel().getDataEntity();
            String fromBiz = (String)this.getView().getFormShowParameter().getCustomParam("frombiz");
            if ("true".equals(fromBiz)) {
                this.getView().returnDataToParent((Object)dynObject);
                this.getView().close();
            }
            if (dynObject.getPkValue() != null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{btnexecute});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String repeatMode;
        IDataModel dataModel = this.getView().getModel();
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if ((name.startsWith("comnoby") || name.startsWith("comweekby")) && this.getPageCache().get("loadData") == null) {
            this.getModel().setValue("comno", this.getModel().getValue(name.replace("comweek", "comno")));
            this.getModel().setValue("comweek", this.getModel().getValue(name.replace("comno", "comweek")));
            Object commo = this.getModel().getValue("comno");
            Object comweek = this.getModel().getValue("comweek");
            if (name.endsWith("bymonth")) {
                if (commo != null && comweek != null && StringUtils.isNotBlank((CharSequence)commo.toString()) && StringUtils.isNotBlank((CharSequence)comweek.toString())) {
                    this.getModel().setValue("ckbyweek", (Object)Boolean.TRUE);
                } else {
                    this.getModel().setValue("ckbyweek", (Object)Boolean.FALSE);
                }
            }
        }
        if (name.equals("plan")) {
            repeatMode = (String)this.getView().getModel().getValue("repeatmode");
            if (DEFINE.equalsIgnoreCase(repeatMode)) {
                dataModel.setValue("txtdesc", (Object)this.genDefDesc(name));
            } else {
                dataModel.setValue("txtdesc", (Object)this.genDefDesc(DEFINE));
            }
        } else if (!property.getName().equals("txtdesc")) {
            repeatMode = "";
            if (name.equals("repeatmode")) {
                this.adjustByRepeatMode();
                repeatMode = (String)this.getModel().getValue(name);
            } else if (name.equals("combdorw")) {
                this.adjustByDayOrWeek();
            }
            boolean isMonth = false;
            for (String propMonth : CKMONTH) {
                if (!name.equals(propMonth)) continue;
                isMonth = true;
                break;
            }
            if (isMonth) {
                boolean changeMonth = false;
                for (String month : CKMONTH) {
                    boolean flag = Boolean.parseBoolean(this.getModel().getValue(month).toString());
                    if (!flag) continue;
                    changeMonth = flag;
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(changeMonth), new String[]{"comnobymonth"});
                this.getView().setVisible(Boolean.valueOf(changeMonth), new String[]{"comweekbymonth"});
            }
            if (repeatMode.equals(DEFINE)) {
                dataModel.setValue("txtdesc", (Object)this.genDefDesc(repeatMode));
            } else {
                dataModel.setValue("txtdesc", (Object)this.genDesc());
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (StringUtils.equals((CharSequence)btnexecute, (CharSequence)evt.getItemKey())) {
            DynamicObject dynamicJob = (DynamicObject)this.getModel().getValue("job");
            if (dynamicJob == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8c03\u5ea6\u4f5c\u4e1a\u3002", (String)"CalTaskNewTplSchPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            JobInfo jobInfo = ScheduleService.getInstance().getObjectFactory().getJobDao().get(String.valueOf(dynamicJob.getPkValue()));
            if (!jobInfo.isEnable()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u672a\u542f\u7528\u3002", (String)"CalTaskNewTplSchPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            String appId = jobInfo.getAppId();
            if (!StringUtils.equalsIgnoreCase((CharSequence)"bos", (CharSequence)appId) && !BOSRuntime.isBOSApp((String)appId)) {
                jobInfo.setJobType(JobType.BIZ);
            } else {
                jobInfo.setJobType(JobType.REALTIME);
            }
            JobClient.dispatch((JobInfo)jobInfo);
            this.getView().showMessage(ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u5df2\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u6838\u7b97\u4efb\u52a1\u521b\u5efa\u65e5\u5fd7\u3002", (String)"CalTaskNewTplSchPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    private Calendar getStartTime() {
        Date startTime = (Date)this.getView().getModel().getValue("starttime");
        Calendar crStartTime = Calendar.getInstance();
        if (startTime != null) {
            crStartTime.setTimeInMillis(startTime.getTime());
        } else {
            this.getView().getModel().setValue("starttime", (Object)crStartTime.getTime());
        }
        return crStartTime;
    }

    private String genDefDesc(String operateType) {
        String cron = (String)this.getModel().getValue("plan");
        Calendar crStartTime = this.getStartTime();
        String startTime = HRInteDateTimeUtil.formatDate((String)"hsas_caltasknewtplschplan", (String)"starttime", (Date)crStartTime.getTime());
        String msg = MessageFormat.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e{0}\u8d77\uff0c{1}\u9884\u8ba1\u6700\u8fd1\u5341\u6b21\u6267\u884c\u65f6\u95f4\uff1a{2}", (String)"CalTaskNewTplSchPlugin_97", (String)"swc-hsas-formplugin", (Object[])new Object[0]), startTime, "\r\n\r\n", "\r\n");
        StringBuilder descBuilder = new StringBuilder();
        descBuilder.append(msg);
        if (StringUtils.isBlank((CharSequence)cron) && DEFINE.equals(operateType)) {
            return descBuilder.toString();
        }
        if ("plan".equals(operateType)) {
            this.checkCron(cron);
        }
        String recents = this.computeFireTimes(cron, crStartTime.getTime(), 10);
        descBuilder.append(recents);
        return descBuilder.toString();
    }

    private boolean checkCron(String cron) {
        try {
            parser.parse(cron);
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cron);
            List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, (org.quartz.Calendar)null, (int)2);
            long leadTime = Math.abs(((Date)dates.get(1)).getTime() - ((Date)dates.get(0)).getTime());
            if (leadTime < 60000L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201ccron\u8868\u8fbe\u5f0f\u201d\u7684\u5468\u671f\u8bbe\u7f6e\u6709\u8bef\uff0c\u53ea\u652f\u6301\u5206\u949f\u7ea7\u522b\u7684\u5468\u671f\u3002", (String)"CalTaskNewTplSchPlugin_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        catch (Exception var6) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201ccron\u8868\u8fbe\u5f0f\u201d\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CalTaskNewTplSchPlugin_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
    }

    private String genDesc() {
        Object cyclenumObj = this.getView().getModel().getValue("cyclenum");
        if (!StringUtils.isBlank((Object)cyclenumObj) && Long.parseLong(cyclenumObj.toString()) != 0L) {
            CronStruct cron = new CronStruct();
            Calendar crStartTime = this.getStartTime();
            cron.setSeconds("0");
            cron.setMinutes(String.valueOf(crStartTime.get(12)));
            cron.setHours(String.valueOf(crStartTime.get(11)));
            cron.setDayOfMonth(String.valueOf(crStartTime.get(5)));
            cron.setMonth(String.valueOf(crStartTime.get(2) + 1));
            cron.setDayOfWeek("?");
            cron.setYear(String.valueOf(crStartTime.get(1)));
            String repeatMode = (String)this.getView().getModel().getValue("repeatmode");
            int cyclenum = (Integer)this.getView().getModel().getValue("cyclenum");
            String startTime = HRInteDateTimeUtil.formatDate((String)"hsas_caltasknewtplschplan", (String)"starttime", (Date)crStartTime.getTime());
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e{0}\u8d77\uff0c{1}", (String)"CalTaskNewTplSchPlugin_98", (String)"swc-hsas-formplugin", (Object[])new Object[0]), startTime, "\r\n");
            cron.getDescBuf().append(msg);
            int var8 = -1;
            switch (repeatMode.hashCode()) {
                case 100: {
                    if (!repeatMode.equals(DAY)) break;
                    var8 = 3;
                    break;
                }
                case 104: {
                    if (!repeatMode.equals(HOUR)) break;
                    var8 = 2;
                    break;
                }
                case 109: {
                    if (!repeatMode.equals(MONTH)) break;
                    var8 = 5;
                    break;
                }
                case 110: {
                    if (!repeatMode.equals(NOREPEAT)) break;
                    var8 = 0;
                    break;
                }
                case 119: {
                    if (!repeatMode.equals(WEEK)) break;
                    var8 = 4;
                    break;
                }
                case 121: {
                    if (!repeatMode.equals(YEAR)) break;
                    var8 = 6;
                    break;
                }
                case 3484: {
                    if (!repeatMode.equals(MINUTE)) break;
                    var8 = 1;
                }
            }
            switch (var8) {
                case 0: {
                    cron.getDescBuf().setLength(0);
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e0d\u91cd\u590d", (String)"CalTaskNewTplSchPlugin_20", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    break;
                }
                case 1: {
                    cron = this.repeatByHour(cron, repeatMode);
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"CalTaskNewTplSchPlugin_21", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5206\u949f\u91cd\u590d\u3002", (String)"CalTaskNewTplSchPlugin_22", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    if (cyclenum > 1) {
                        cron.setMinutes("0/" + cyclenum);
                    } else {
                        cron.setMinutes("*");
                    }
                    cron.setDayOfMonth("*");
                    cron.setMonth("*");
                    cron.setDayOfWeek("?");
                    cron.setYear((String)null);
                    break;
                }
                case 2: {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"CalTaskNewTplSchPlugin_21", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5c0f\u65f6\u91cd\u590d\u3002", (String)"CalTaskNewTplSchPlugin_23", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    if (cyclenum > 1) {
                        if (cyclenum > 23) {
                            cyclenum = 23;
                            this.getModel().setValue("cyclenum", (Object)23);
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u6bcf23\u5c0f\u91cd\u590d\u3002", (String)"CalTaskNewTplSchPlugin_24", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                        }
                        cron.setHours("0/" + cyclenum);
                    } else {
                        cron.setHours("*");
                    }
                    cron.setDayOfMonth("*");
                    cron.setMonth("*");
                    cron.setDayOfWeek("?");
                    cron.setYear((String)null);
                    break;
                }
                case 3: {
                    if (cyclenum > 1) {
                        String month = String.valueOf(crStartTime.get(5));
                        cron.setDayOfMonth(month + "/" + cyclenum);
                        cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf\u6708", (String)"CalTaskNewTplSchPlugin_25", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append(month).append(ResManager.loadKDString((String)"\u65e5", (String)"CalTaskNewTplSchPlugin_26", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5f00\u59cb", (String)"CalTaskNewTplSchPlugin_27", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    } else {
                        cron.setDayOfMonth("*");
                    }
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"CalTaskNewTplSchPlugin_21", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5929", (String)"CalTaskNewTplSchPlugin_28", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    cron = this.repeatByHour(cron, repeatMode);
                    cron.setMonth("*");
                    cron.setDayOfWeek("?");
                    cron.setYear((String)null);
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)"CalTaskNewTplSchPlugin_29", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    break;
                }
                case 4: {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"CalTaskNewTplSchPlugin_21", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5468", (String)"CalTaskNewTplSchPlugin_30", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    cron.setDayOfMonth("*");
                    cron.setMonth("*");
                    cron.setYear((String)null);
                    cron = this.repeatByWeek(cron);
                    cron = this.repeatByHour(cron, repeatMode);
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)"CalTaskNewTplSchPlugin_29", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    break;
                }
                case 5: {
                    if (cyclenum > 1) {
                        String month = String.valueOf(crStartTime.get(2) + 1);
                        cron.setMonth(month + "/" + cyclenum);
                        cron.getDescBuf().append(ResManager.loadKDString((String)"\u4ece", (String)"CalTaskNewTplSchPlugin_31", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append(month).append(ResManager.loadKDString((String)"\u6708", (String)"CalTaskNewTplSchPlugin_32", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5f00\u59cb", (String)"CalTaskNewTplSchPlugin_27", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    } else {
                        cron.setMonth("*");
                    }
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"CalTaskNewTplSchPlugin_21", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u6708", (String)"CalTaskNewTplSchPlugin_32", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    cron.setYear((String)null);
                    cron = this.repeatByMonthDay(cron);
                    cron = this.repeatByHour(cron, repeatMode);
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)"CalTaskNewTplSchPlugin_29", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    break;
                }
                case 6: {
                    if (cyclenum > 1) {
                        this.getView().getModel().setValue("cyclenum", (Object)1);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u53ea\u652f\u6301\u5468\u671f\u4e3a\u201c\u6bcf\u5e74\u201d\u3002", (String)"CalTaskNewTplSchPlugin_33", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    }
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"CalTaskNewTplSchPlugin_21", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5e74", (String)"CalTaskNewTplSchPlugin_34", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    cron.setYear((String)null);
                    cron = this.repeatByMonthly(cron);
                    cron = this.repeatByHour(cron, repeatMode);
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)"CalTaskNewTplSchPlugin_29", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                }
            }
            String cronStr = "";
            if (DEFINE.equals(repeatMode)) {
                cronStr = (String)this.getModel().getValue("plan");
                this.checkCron(cronStr);
            } else {
                cronStr = cron.toString();
                try {
                    parser.parse(cronStr);
                }
                catch (Exception var10) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef", (String)"CalTaskNewTplSchPlugin_35", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                }
            }
            this.getModel().setValue("plan", (Object)cronStr);
            if (!NOREPEAT.equals(repeatMode)) {
                cron.getDescBuf().append("\r\n");
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u9884\u8ba1\u6700\u8fd1\u5341\u6b21\u6267\u884c\u65f6\u95f4\uff1a", (String)"CalTaskNewTplSchPlugin_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                cron.getDescBuf().append("\r\n");
                cron.getDescBuf().append(this.computeFireTimes(cronStr, crStartTime.getTime(), 10));
            }
            return cron.getDescBuf().toString();
        }
        return "";
    }

    private String computeFireTimes(String cronExp, Date startDate, Integer numTimes) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateTimeFormat);
        dateFormat.setTimeZone(KDDateUtils.getSysTimeZone());
        try {
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cronExp);
            cronTriggerImpl.setStartTime(startDate);
            List dateList = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, (org.quartz.Calendar)null, (int)numTimes);
            ArrayList<String> dateStr = new ArrayList<String>(10);
            for (Date date : dateList) {
                dateStr.add(dateFormat.format(date));
            }
            return dateStr.stream().collect(Collectors.joining(",\r\n"));
        }
        catch (ParseException var10) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201ccron\u8868\u8fbe\u5f0f\u201d\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CalTaskNewTplSchPlugin_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return "";
        }
    }

    private CronStruct repeatByHour(CronStruct cron, String repeatMode) {
        IDataModel dataModel = this.getView().getModel();
        StringBuilder cronExp = new StringBuilder();
        StringBuilder cronDesc = new StringBuilder();
        Stream.iterate(0, single -> single + 1).limit(24L).forEachOrdered(value -> {
            String hour = value < 10 ? "ckhour_0" + value : "ckhour_" + value;
            boolean checked = (Boolean)dataModel.getValue(hour);
            if (checked) {
                cronExp.append(value).append(',');
                cronDesc.append(value).append(ResManager.loadKDString((String)"\u65f6", (String)"CalTaskNewTplSchPlugin_36", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append(',');
            }
        });
        String cronExpStr = cronExp.toString();
        String cronDescStr = cronDesc.toString();
        if (cronExpStr.length() > 0) {
            if (cronExpStr.length() > 1) {
                cronExpStr = cronExpStr.substring(0, cronExpStr.length() - 1);
            }
        } else {
            String string = cronExpStr = MINUTE.equals(repeatMode) ? "*" : cron.getHours();
        }
        if (cronDescStr.length() > 1) {
            cron.getDescBuf().append(cronDescStr.substring(0, cronDescStr.length() - 1));
        }
        cron.setHours(cronExpStr);
        return cron;
    }

    private CronStruct repeatByWeek(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String conStr = ResManager.loadKDString((String)"\u7684", (String)"CalTaskNewTplSchPlugin_37", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String weekDays = "";
        if (((Boolean)dataModel.getValue("cksun")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"CalTaskNewTplSchPlugin_38", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            weekDays = "1,";
        }
        if (((Boolean)dataModel.getValue("ckmon")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"CalTaskNewTplSchPlugin_39", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "2,";
        }
        if (((Boolean)dataModel.getValue("cktues")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"CalTaskNewTplSchPlugin_40", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "3,";
        }
        if (((Boolean)dataModel.getValue("ckwed")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"CalTaskNewTplSchPlugin_41", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "4,";
        }
        if (((Boolean)dataModel.getValue("ckthur")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"CalTaskNewTplSchPlugin_42", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "5,";
        }
        if (((Boolean)dataModel.getValue("ckfri")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"CalTaskNewTplSchPlugin_43", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "6,";
        }
        if (((Boolean)dataModel.getValue("cksat")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"CalTaskNewTplSchPlugin_44", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            weekDays = weekDays + "7,";
        }
        weekDays = weekDays.length() == 0 ? (StringUtils.isEmpty((CharSequence)cron.getDayOfWeek()) ? String.valueOf(this.getStartTime().get(7)) : cron.getDayOfWeek()) : weekDays.substring(0, weekDays.length() - 1);
        if (!"?".equals(weekDays)) {
            cron.setDayOfMonth("?");
        }
        cron.setDayOfWeek(weekDays);
        return cron;
    }

    private CronStruct repeatByMonthDay(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String byDayOrWeek = (String)dataModel.getValue("combdorw");
        if (WEEK.equals(byDayOrWeek)) {
            cron = this.repeatByNoWeek(cron);
        } else {
            String conStr = ResManager.loadKDString((String)"\u7684", (String)"CalTaskNewTplSchPlugin_37", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            String days = "";
            if (((Boolean)dataModel.getValue("cklastday")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u65e5", (String)"CalTaskNewTplSchPlugin_45", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                days = "L,";
            } else {
                if (((Boolean)dataModel.getValue("ckone")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"1\u65e5", (String)"CalTaskNewTplSchPlugin_46", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "1,";
                }
                if (((Boolean)dataModel.getValue("cktwo")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"2\u65e5", (String)"CalTaskNewTplSchPlugin_47", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "2,";
                }
                if (((Boolean)dataModel.getValue("ckthree")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"3\u65e5", (String)"CalTaskNewTplSchPlugin_48", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "3,";
                }
                if (((Boolean)dataModel.getValue("ckfour")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"4\u65e5", (String)"CalTaskNewTplSchPlugin_49", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "4,";
                }
                if (((Boolean)dataModel.getValue("ckfive")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"5\u65e5", (String)"CalTaskNewTplSchPlugin_50", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "5,";
                }
                if (((Boolean)dataModel.getValue("cksix")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"6\u65e5", (String)"CalTaskNewTplSchPlugin_51", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "6,";
                }
                if (((Boolean)dataModel.getValue("ckseven")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"7\u65e5", (String)"CalTaskNewTplSchPlugin_52", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "7,";
                }
                if (((Boolean)dataModel.getValue("ckeight")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"8\u65e5", (String)"CalTaskNewTplSchPlugin_53", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "8,";
                }
                if (((Boolean)dataModel.getValue("cknine")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"9\u65e5", (String)"CalTaskNewTplSchPlugin_54", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "9,";
                }
                if (((Boolean)dataModel.getValue("ckten")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"10\u65e5", (String)"CalTaskNewTplSchPlugin_55", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "10,";
                }
                if (((Boolean)dataModel.getValue("ckeleven")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"11\u65e5", (String)"CalTaskNewTplSchPlugin_56", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "11,";
                }
                if (((Boolean)dataModel.getValue("cktwelve")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"12\u65e5", (String)"CalTaskNewTplSchPlugin_57", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "12,";
                }
                if (((Boolean)dataModel.getValue("ckthirteen")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"13\u65e5", (String)"CalTaskNewTplSchPlugin_58", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "13,";
                }
                if (((Boolean)dataModel.getValue("ckfourteen")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"14\u65e5", (String)"CalTaskNewTplSchPlugin_59", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "14,";
                }
                if (((Boolean)dataModel.getValue("ckfifteen")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"15\u65e5", (String)"CalTaskNewTplSchPlugin_60", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "15,";
                }
                if (((Boolean)dataModel.getValue("cksixteen")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"16\u65e5", (String)"CalTaskNewTplSchPlugin_61", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "16,";
                }
                if (((Boolean)dataModel.getValue("ckseventeen")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"17\u65e5", (String)"CalTaskNewTplSchPlugin_62", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "17,";
                }
                if (((Boolean)dataModel.getValue("ckeighteen")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"18\u65e5", (String)"CalTaskNewTplSchPlugin_63", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "18,";
                }
                if (((Boolean)dataModel.getValue("cknineteen")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"19\u65e5", (String)"CalTaskNewTplSchPlugin_64", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "19,";
                }
                if (((Boolean)dataModel.getValue("cktwenty")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"20\u65e5", (String)"CalTaskNewTplSchPlugin_65", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "20,";
                }
                if (((Boolean)dataModel.getValue("cktwentyone")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"21\u65e5", (String)"CalTaskNewTplSchPlugin_66", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "21,";
                }
                if (((Boolean)dataModel.getValue("cktwentytwo")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"22\u65e5", (String)"CalTaskNewTplSchPlugin_67", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "22,";
                }
                if (((Boolean)dataModel.getValue("cktwentythree")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"23\u65e5", (String)"CalTaskNewTplSchPlugin_68", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "23,";
                }
                if (((Boolean)dataModel.getValue("cktwentyfour")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"24\u65e5", (String)"CalTaskNewTplSchPlugin_69", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "24,";
                }
                if (((Boolean)dataModel.getValue("cktwentyfive")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"25\u65e5", (String)"CalTaskNewTplSchPlugin_70", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "25,";
                }
                if (((Boolean)dataModel.getValue("cktwentysix")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"26\u65e5", (String)"CalTaskNewTplSchPlugin_71", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "26,";
                }
                if (((Boolean)dataModel.getValue("cktwentyseven")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"27\u65e5", (String)"CalTaskNewTplSchPlugin_72", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "27,";
                }
                if (((Boolean)dataModel.getValue("cktwentyeight")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"28\u65e5", (String)"CalTaskNewTplSchPlugin_73", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "28,";
                }
                if (((Boolean)dataModel.getValue("cktwentynine")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"29\u65e5", (String)"CalTaskNewTplSchPlugin_74", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "29,";
                }
                if (((Boolean)dataModel.getValue("ckthirty")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"30\u65e5", (String)"CalTaskNewTplSchPlugin_75", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "30,";
                }
                if (((Boolean)dataModel.getValue("ckthirtyone")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"31\u65e5", (String)"CalTaskNewTplSchPlugin_76", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "31,";
                }
            }
            days = days.length() == 0 ? (StringUtils.isEmpty((CharSequence)cron.getDayOfMonth()) ? String.valueOf(this.getStartTime().get(5)) : cron.getDayOfMonth()) : days.substring(0, days.length() - 1);
            cron.setDayOfMonth(days);
            if (!"?".equals(days)) {
                cron.setDayOfWeek("?");
            }
        }
        return cron;
    }

    private CronStruct repeatByNoWeek(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String no = (String)dataModel.getValue("comno");
        String noWeek = (String)dataModel.getValue("comweek");
        switch (no == null ? "" : no) {
            case "1": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e00\u4e2a", (String)"CalTaskNewTplSchPlugin_77", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "2": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e8c\u4e2a", (String)"CalTaskNewTplSchPlugin_78", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "3": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e09\u4e2a", (String)"CalTaskNewTplSchPlugin_79", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "4": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u56db\u4e2a", (String)"CalTaskNewTplSchPlugin_80", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "5": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e94\u4e2a", (String)"CalTaskNewTplSchPlugin_81", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "L": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u4e2a", (String)"CalTaskNewTplSchPlugin_82", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
        }
        switch (noWeek == null ? "" : noWeek) {
            case "1": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"CalTaskNewTplSchPlugin_38", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "2": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"CalTaskNewTplSchPlugin_39", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "3": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"CalTaskNewTplSchPlugin_40", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "4": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"CalTaskNewTplSchPlugin_41", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "5": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"CalTaskNewTplSchPlugin_42", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "6": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"CalTaskNewTplSchPlugin_43", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "7": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"CalTaskNewTplSchPlugin_44", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "8": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u81ea\u7136\u65e5", (String)"CalTaskNewTplSchPlugin_83", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "9": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5", (String)"CalTaskNewTplSchPlugin_84", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
        }
        if (no != null && noWeek != null) {
            if (noWeek.compareTo("1") >= 0 && noWeek.compareTo("8") < 0) {
                if (no.compareTo("1") >= 0 && no.compareTo("5") <= 0) {
                    cron.setDayOfWeek(noWeek + "#" + no);
                } else if (no.compareTo("L") == 0) {
                    cron.setDayOfWeek(noWeek + "L");
                }
                cron.setDayOfMonth("?");
            } else if (noWeek.equals("8")) {
                if (no.compareTo("1") >= 0 && no.compareTo("5") <= 0) {
                    cron.setDayOfMonth(no);
                } else if (no.compareTo("L") == 0) {
                    cron.setDayOfMonth("1L");
                }
                cron.setDayOfWeek("?");
            } else if (noWeek.equals("9")) {
                if (no.compareTo("1") >= 0 && no.compareTo("5") <= 0) {
                    String workday = String.valueOf(Integer.parseInt(no) + 1);
                    cron.setDayOfWeek(workday + "#" + no);
                } else if (no.compareTo("L") == 0) {
                    cron.setDayOfWeek("6L");
                }
                cron.setDayOfMonth("?");
            }
        }
        return cron;
    }

    private CronStruct repeatByMonthly(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String conStr = ResManager.loadKDString((String)"\u7684", (String)"CalTaskNewTplSchPlugin_37", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String months = "";
        if (((Boolean)dataModel.getValue("ckjan")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e00\u6708", (String)"CalTaskNewTplSchPlugin_85", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "1,";
        }
        if (((Boolean)dataModel.getValue("ckfeb")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e8c\u6708", (String)"CalTaskNewTplSchPlugin_86", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "2,";
        }
        if (((Boolean)dataModel.getValue("ckmar")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e09\u6708", (String)"CalTaskNewTplSchPlugin_87", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "3,";
        }
        if (((Boolean)dataModel.getValue("ckapr")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u56db\u6708", (String)"CalTaskNewTplSchPlugin_88", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "4,";
        }
        if (((Boolean)dataModel.getValue("ckmay")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e94\u6708", (String)"CalTaskNewTplSchPlugin_89", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "5,";
        }
        if (((Boolean)dataModel.getValue("ckjun")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u516d\u6708", (String)"CalTaskNewTplSchPlugin_90", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "6,";
        }
        if (((Boolean)dataModel.getValue("ckjul")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e03\u6708", (String)"CalTaskNewTplSchPlugin_91", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "7,";
        }
        if (((Boolean)dataModel.getValue("ckaug")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u516b\u6708", (String)"CalTaskNewTplSchPlugin_92", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "8,";
        }
        if (((Boolean)dataModel.getValue("cksep")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e5d\u6708", (String)"CalTaskNewTplSchPlugin_93", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "9,";
        }
        if (((Boolean)dataModel.getValue("ckoct")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u5341\u6708", (String)"CalTaskNewTplSchPlugin_94", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "10,";
        }
        if (((Boolean)dataModel.getValue("cknov")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u5341\u4e00\u6708", (String)"CalTaskNewTplSchPlugin_95", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "11,";
        }
        if (((Boolean)dataModel.getValue("ckdec")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u5341\u4e8c\u6708", (String)"CalTaskNewTplSchPlugin_96", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "12,";
        }
        months = months.length() == 0 ? (StringUtils.isEmpty((CharSequence)cron.getMonth()) ? String.valueOf(this.getStartTime().get(2) + 1) : cron.getMonth()) : months.substring(0, months.length() - 1);
        cron.setMonth(months);
        if (((Boolean)dataModel.getValue("ckbyweek")).booleanValue()) {
            cron = this.repeatByNoWeek(cron);
        }
        return cron;
    }

    private void adjustByDayOrWeek() {
        IFormView formView = this.getView();
        String byDayOrWeek = (String)this.getModel().getValue("combdorw");
        if (WEEK.equals(byDayOrWeek)) {
            formView.setVisible(Boolean.FALSE, new String[]{"flexpdays"});
            formView.setVisible(Boolean.TRUE, new String[]{"flexpbyweek"});
        } else {
            formView.setVisible(Boolean.TRUE, new String[]{"flexpdays"});
            formView.setVisible(Boolean.FALSE, new String[]{"flexpbyweek"});
        }
    }

    private void adjustByWeek() {
        boolean byWeek = (Boolean)this.getModel().getValue("ckbyweek");
        this.getView().setVisible(Boolean.valueOf(byWeek), new String[]{"flexpbyweek"});
    }

    private void adjustByRepeatMode() {
        String repeatMode = (String)this.getModel().getValue("repeatmode");
        IFormView formView = this.getView();
        formView.updateView("cyclenum");
        formView.updateView("plan");
        formView.setVisible(Boolean.FALSE, new String[]{"flexpweek", "flexpworday", "flexpmonths", "flexpdays", "flexpbyweek", "flexphour", "plan", "cyclenum"});
        FieldEdit txtCycleNum = (FieldEdit)formView.getControl("cyclenum");
        txtCycleNum.setEnable("", true, -1);
        switch (repeatMode) {
            case "d": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexphour", "cyclenum"});
                break;
            }
            case "h": {
                formView.setVisible(Boolean.FALSE, new String[]{"flexphour"});
                formView.setVisible(Boolean.TRUE, new String[]{"cyclenum"});
                break;
            }
            case "m": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpworday", "flexpdays", "flexphour", "cyclenum"});
                this.adjustByDayOrWeek();
                break;
            }
            case "n": {
                txtCycleNum.setEnable("", false, -1);
                break;
            }
            case "w": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpweek", "flexphour", "cyclenum"});
                this.getModel().setValue("cyclenum", (Object)1);
                txtCycleNum.setEnable("", false, -1);
                break;
            }
            case "y": {
                this.getModel().setValue("cyclenum", (Object)1);
                txtCycleNum.setEnable("", true, -1);
                formView.setVisible(Boolean.TRUE, new String[]{"flexpmonths", "flexphour", "cyclenum"});
                this.adjustByWeek();
                break;
            }
            case "mi": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexphour", "cyclenum"});
                break;
            }
            case "def": {
                formView.setVisible(Boolean.TRUE, new String[]{"plan"});
                txtCycleNum.setEnable("", false, -1);
                break;
            }
        }
    }

    private void adjustByCron() {
        String[] crons;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        String repeatMode = (String)this.getModel().getValue("repeatmode");
        String cron = (String)this.getView().getModel().getValue("plan");
        if ((!status.equals((Object)OperationStatus.ADDNEW) || "true".equals(formShowParameter.getCustomParam("newReIn"))) && StringUtils.isNotEmpty((CharSequence)cron) && (crons = cron.split(" ")).length >= 6) {
            String hourCron = crons[2];
            String dayCron = crons[3];
            if (StringUtils.isNotEmpty((CharSequence)hourCron) && !HOUR.equalsIgnoreCase(repeatMode)) {
                Stream.iterate(0, single -> single + 1).limit(24L).forEachOrdered(value -> {
                    String hour = value < 10 ? "ckhour_0" + value : "ckhour_" + value;
                    this.getModel().setValue(hour, (Object)"0");
                });
                if (!"*".equals(hourCron)) {
                    String[] hours = hourCron.split(",");
                    Arrays.stream(hours).forEach(value -> {
                        String hour = Integer.parseInt(value) < 10 ? "ckhour_0" + value : "ckhour_" + value;
                        this.getModel().setValue(hour, (Object)"1");
                    });
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)dayCron) && "L".equalsIgnoreCase(dayCron)) {
                this.getModel().setValue("cklastday", (Object)"1");
                Arrays.stream(CKDATE).forEach(date -> this.getModel().setValue(date, (Object)"0"));
            }
        }
    }
}

