/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.tax;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.form.JobFormInfo;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.cal.helper.CalProcessHandler;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class CancelCalProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(CancelCalProgressPlugin.class);
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String OK = "donothing_ok";
    private static final String BTN_VIEWREPORT = "donothing_viewreport";
    private static final String KEY_BUTTONCLOSE = "buttonclose";
    private static final String KEY_ONCANCELAP = "oncancelap";
    private static final String KEY_AFTERCANCELAP = "aftercancelap";
    private static final String VIEW_CAL_REQUEST = "donothing_viewcalrequestlist";

    public void initialize() {
        super.initialize();
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        int calCount = (Integer)parameter.getCustomParam("cancelCount");
        Long calTaskId = (Long)parameter.getCustomParam("calTaskId");
        Long calRecordId = (Long)parameter.getCustomParam("calRecordId");
        logger.info("startCancel calTaskId = {} , calRecordId = {}", (Object)calTaskId, (Object)calRecordId);
        this.setCancelInfo(calCount, this.countCancelTimes(calTaskId));
        ProgressBar progress = (ProgressBar)this.getControl(PROGRESSBARAP);
        progress.start();
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_AFTERCANCELAP, KEY_BUTTONCLOSE});
    }

    private int countCancelTimes(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrecord");
        QFilter filter = new QFilter("caltask", "=", (Object)calTaskId);
        filter.and("optype", "=", (Object)"2");
        return helper.count(new QFilter[]{filter});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (SWCStringUtils.equals((String)args.getOperateKey(), (String)OK)) {
            Button btnRefresh;
            this.getView().close();
            if (this.getView().getParentView() != null && (btnRefresh = (Button)this.getView().getParentView().getControl("refresh")) != null) {
                btnRefresh.click();
                this.getView().sendFormAction(this.getView().getParentView());
            }
        } else if (SWCStringUtils.equals((String)args.getOperateKey(), (String)BTN_VIEWREPORT)) {
            this.openCalReportDetail();
        } else if (SWCStringUtils.equals((String)args.getOperateKey(), (String)VIEW_CAL_REQUEST)) {
            CalProcessHandler.openRequestList((IFormView)this.getView());
        }
    }

    private void openCalReportDetail() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long calRecordId = (Long)parameter.getCustomParam("calRecordId");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calreport");
        showParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a", (String)"CancelCalProgressPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("calReportId", (Object)calRecordId);
        if (CalProcessHandler.isParentRequestList((IFormView)this.getView())) {
            CalProcessHandler.grandfatherShow((IFormView)this.getView(), (FormShowParameter)showParameter);
            return;
        }
        this.getView().getParentView().showForm(showParameter);
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }

    private String getCalTime(String startTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = sdf.parse(startTime);
        }
        catch (ParseException e) {
            logger.error("parse date error");
            date = new Date();
        }
        Date endtime = new Date();
        long between = endtime.getTime() - date.getTime();
        long hour = between / 3600000L;
        long min = between / 60000L - hour * 60L;
        long second = between / 1000L - hour * 60L * 60L - min * 60L;
        return (hour < 10L ? "0" + hour : Long.valueOf(hour)) + ":" + (min < 10L ? "0" + min : Long.valueOf(min)) + ":" + (second < 10L ? "0" + second : Long.valueOf(second));
    }

    public void onProgress(ProgressEvent evt) {
        String startProgress = this.getPageCache().get("cachekey_startpropgress");
        this.queryAndSetProgressDetails(evt, startProgress);
    }

    private void queryAndSetProgressDetails(ProgressEvent evt, String startProgress) {
        Control control = (Control)evt.getSource();
        String progressKey = control.getKey();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String startTime = (String)parameter.getCustomParam("startTime");
        Long calTaskId = (Long)parameter.getCustomParam("calTaskId");
        Integer cancelCount = (Integer)parameter.getCustomParam("cancelCount");
        Long calRecordId = (Long)parameter.getCustomParam("calRecordId");
        String consumerTime = this.getCalTime(startTime);
        this.setText("consumetimelabe", ResManager.loadKDString((String)"\uff08\u8017\u65f6\uff1a{0}\uff09", (String)"CalProgressPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[]{consumerTime}));
        Label successLabel = (Label)this.getView().getControl("successcount");
        Label failLabel = (Label)this.getView().getControl("failcount");
        Label pendingLabel = (Label)this.getView().getControl("todocount");
        ISWCAppCache appCache = SWCAppCache.get((String)"SWC_CAL");
        Map progressMap = (Map)appCache.get(MessageFormat.format("tax_record_progress_{0}", String.valueOf(calRecordId)), Map.class);
        Integer sucesscount = 0;
        Integer failcount = 0;
        if (null != progressMap && progressMap.size() > 0) {
            sucesscount = (Integer)progressMap.get("successcount");
            failcount = (Integer)progressMap.get("failcount");
        }
        Integer pendingCount = cancelCount - sucesscount - failcount;
        int progressPercent = this.setProgress(evt, cancelCount, sucesscount, failcount);
        successLabel.setText(String.valueOf(sucesscount));
        failLabel.setText(String.valueOf(failcount));
        pendingLabel.setText(String.valueOf(pendingCount));
        if (!StringUtils.equals((CharSequence)"false", (CharSequence)startProgress)) {
            if (progressPercent == 100) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_cancelcancel", "btnok", KEY_ONCANCELAP, "viewcalrequest"});
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BUTTONCLOSE, KEY_AFTERCANCELAP});
                CalProcessHandler.changeGreenProgressColor((IFormView)this.getView(), (String)progressKey);
                PayrollTaskHelper.updateCalPayRollTaskStatus((Long)calTaskId);
            }
        } else {
            ProgressBar progress = (ProgressBar)this.getControl(PROGRESSBARAP);
            progress.stop();
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_cancelcancel"});
            PayrollTaskHelper.updateCalPayRollTaskStatus((Long)calTaskId);
        }
    }

    private void setResultDetail(Long calTaskId, Integer tatolCount, String calTaskName, int sucesscount, int failcount, int progressPercent) {
    }

    private Integer setProgress(ProgressEvent evt, Integer calCount, Integer calSuccess, Integer calFail) {
        StringBuilder calText = new StringBuilder();
        Integer progressPercent = this.calProgress(calSuccess, calFail, calCount);
        calText.append(progressPercent).append('%');
        evt.setProgress(progressPercent.intValue());
        this.setText("process", calText.toString());
        return progressPercent;
    }

    private void setText(String key, String text) {
        Label control = (Label)this.getControl(key);
        if (control != null) {
            control.setText(text);
        }
    }

    private void setCancelInfo(int cancelCount, int cancelTimes) {
        this.setText("caltaskname", (String)this.getView().getFormShowParameter().getCustomParam("calTaskName"));
        this.setText("countlabel", ResManager.loadKDString((String)"\u5171{0}\u6761\u6838\u7b97\u8bb0\u5f55", (String)"CancelCalProgressPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[]{cancelCount}));
        this.setText("canceltimeslabel", ResManager.loadKDString((String)"\uff08\u7b2c{0}\u6b21\u56de\u6eda\uff09", (String)"CancelCalProgressPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[]{cancelTimes}));
    }

    private int calProgress(Integer sucesscount, Integer failcount, Integer calCount) {
        Integer caledCount = sucesscount + failcount;
        if (caledCount.equals(calCount)) {
            return 100;
        }
        if (sucesscount + failcount == 0) {
            return 0;
        }
        BigDecimal progress = new BigDecimal(String.valueOf(caledCount)).divide(new BigDecimal(String.valueOf(calCount)), 2, 1).multiply(new BigDecimal("100"));
        return progress.intValue();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.toBackground();
    }

    private void toBackground() {
        IFormView parentView;
        Long calRecordId = (Long)this.getView().getFormShowParameter().getCustomParam("calRecordId");
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", calRecordId));
        JobFormInfo jobFormInfo = (JobFormInfo)appCache.get(String.format(Locale.ROOT, "platformTaskInfo_%s", calRecordId), JobFormInfo.class);
        ISWCAppCache progressAppCache = SWCAppCache.get((String)"SWC_CAL");
        Map progressMap = (Map)progressAppCache.get(MessageFormat.format("tax_record_progress_{0}", String.valueOf(calRecordId)), Map.class);
        Integer cancelCount = (Integer)this.getView().getFormShowParameter().getCustomParam("cancelCount");
        Integer sucesscount = 0;
        Integer failcount = 0;
        if (null != progressMap && progressMap.size() > 0) {
            sucesscount = (Integer)progressMap.get("successcount");
            failcount = (Integer)progressMap.get("failcount");
        }
        Integer pendingCount = cancelCount - sucesscount - failcount;
        if (jobFormInfo == null && pendingCount != 0) {
            this.dispatchTask(this.getView().getFormShowParameter().getCustomParams());
        }
        if ((parentView = this.getView().getParentView()) instanceof IListView) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    private JobFormInfo dispatchTask(Map<String, Object> data) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.putAll(data);
        params.put("calRecordId", data.get("calRecordId"));
        params.put("parentpageid", this.getView().getFormShowParameter().getParentPageId());
        HRBackgroundTaskHelper instance = HRBackgroundTaskHelper.getInstance();
        String taskName = (String)this.getView().getFormShowParameter().getCustomParam("calTaskName");
        String bgTaskId = instance.createBaskgroundTask("swc_hsas_cancelcal", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u56de\u6eda{0}", (String)"CancelCalProgressPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[]{taskName}), true, this.getView().getMainView().getPageId(), this.getView().getParentView().getPageId(), params);
        instance.showBaskgroundTask(bgTaskId);
        JobFormInfo jobFormInfo = instance.getJobFormInfoByTaskId(bgTaskId);
        Long calRecordId = (Long)data.get("calRecordId");
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", calRecordId));
        appCache.put(String.format(Locale.ROOT, "platformTaskInfo_%s", calRecordId), (Object)jobFormInfo);
        return jobFormInfo;
    }
}

