/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.genbizdata.DelGenBizDataTask;
import kd.swc.hsas.business.genbizdata.GenBizDataService;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsas.formplugin.web.guide.AbstractCalPersonList;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalPersonGenBizDataPlugin
extends AbstractCalPersonList {
    private static final Log logger = LogFactory.getLog(CalPersonGenBizDataPlugin.class);
    private Integer totalCnt;
    private List<Long> validIdList;
    private static final String GENED_STATUS = "2";
    private Long taskId;

    @Override
    protected List<CalPersonOperationEnum> operationKey() {
        ArrayList<CalPersonOperationEnum> calPersonOperationEnums = new ArrayList<CalPersonOperationEnum>();
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_GENBIZDATA);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_DELBIZDATA);
        return calPersonOperationEnums;
    }

    @Override
    protected boolean operationMutex() {
        switch (this.calPersonOperationEnum) {
            case OP_GENBIZDATA: 
            case OP_DELBIZDATA: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean afterOperationUpdateView(CalPersonOperationEnum calPersonOperationEnum) {
        return false;
    }

    @Override
    protected void beforeDoOperation(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        this.taskId = calPayRollTask.getCalPayRollTaskId();
        if (this.taskId != null && this.taskId > 0L) {
            SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
            DynamicObject schemeAfterCalObj = sceneService.getAfterCalObjByTask(this.taskId);
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put("taskId", this.taskId + "");
            switch (this.calPersonOperationEnum) {
                case OP_GENBIZDATA: 
                case OP_DELBIZDATA: {
                    if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)this.calPersonOperationEnum.getPermission())) {
                        String msg = ResManager.loadKDString((String)"\u65e0\u201c\u6838\u7b97\u540d\u5355\u201d\u7684\u201c{0}\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalPersonGenBizDataPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[]{this.calPersonOperationEnum.getOperationName()});
                        this.getView().showErrorNotification(msg);
                        return;
                    }
                    boolean enableCheck = this.checkGenBizDataEnable(calPayRollTask, schemeAfterCalObj);
                    if (!enableCheck) {
                        return;
                    }
                    boolean confCheck = this.checkHasGenBizDataConfig(calPayRollTask);
                    if (!confCheck) {
                        return;
                    }
                    boolean dataCheck = this.checkPersonStatus(calPayRollTask);
                    if (dataCheck) break;
                    return;
                }
            }
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
            switch (this.calPersonOperationEnum) {
                case OP_GENBIZDATA: {
                    GenBizDataService service = new GenBizDataService();
                    service.removeCacheProgress(this.taskId);
                    this.openGenBizDataForm();
                    break;
                }
                case OP_DELBIZDATA: {
                    this.openDelBizDataConfirm();
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String backKey = event.getActionId();
        Object returnData = event.getReturnData();
        if (SWCStringUtils.equals((String)"genbizdatamodal", (String)backKey)) {
            if (returnData != null) {
                Map dataMap = (Map)returnData;
                if (dataMap == null || dataMap.size() == 0) {
                    return;
                }
                Object gendate = dataMap.get("gendate");
                if (gendate == null) {
                    return;
                }
                List personIdList = (List)dataMap.get("validIdList");
                Long taskid = (Long)dataMap.get("taskId");
                GenBizDataService genBizDataService = new GenBizDataService();
                CalPayRollTask calPayRollTask = (CalPayRollTask)this.getCalPayRollTaskContext().getValidDatas().get(0);
                boolean genStatus = genBizDataService.genBizData(taskid, personIdList, (Date)gendate, Boolean.FALSE, new ArrayList(0));
                if (genStatus) {
                    this.initFloatingTask(taskid, personIdList.size(), calPayRollTask.getName());
                    this.openGenBizDataProgress(personIdList.size(), taskid);
                }
            } else {
                this.releaseDistributedLock();
            }
        } else if (SWCStringUtils.equals((String)"genbizdataprogress", (String)backKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        GenBizDataService service = new GenBizDataService();
        IPageCache pageCache = this.getView().getPageCache();
        String taskIdStr = pageCache.get("taskId");
        if (SWCStringUtils.isEmpty((String)taskIdStr)) {
            return;
        }
        Long taskid = Long.valueOf(taskIdStr);
        if (SWCStringUtils.equals((String)"confirmDelGenBizData", (String)callBackId)) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"432CBM42/J+D")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6838\u7b97\u540d\u5355\u201d\u7684\u201c\u64a4\u56de\u4e1a\u52a1\u6570\u636e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalPersonGenBizDataPlugin_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                String validPersonIdListStr = pageCache.get("validPersonIdList");
                List personIdList = (List)SerializationUtils.deSerializeFromBase64((String)validPersonIdListStr);
                List partition = Lists.partition((List)personIdList, (int)1000);
                try {
                    CountDownLatch countDownLatch = new CountDownLatch(partition.size());
                    ThreadPool threadpool = SWCThreadPoolFactory.getCommonAsyncThreadpool();
                    for (List personIds : partition) {
                        DelGenBizDataTask delTask = new DelGenBizDataTask(personIds, taskid, RequestContext.get(), countDownLatch);
                        threadpool.submit((Callable)delTask);
                    }
                    boolean await = countDownLatch.await(10L, TimeUnit.MINUTES);
                    if (await) {
                        logger.info("delgenbizdatatask success.");
                    } else {
                        logger.info("delgenbizdatatask error.");
                    }
                }
                catch (InterruptedException exception) {
                    logger.error("delgenbizdatatask call error", (Throwable)exception);
                }
                List cacheFailMsg = service.getCacheFailMsg(taskid);
                Map delBizDataCache = service.getDelBizDataProgressCache(taskid);
                Integer totalCnt = (Integer)delBizDataCache.get("total");
                Integer successCnt = (Integer)delBizDataCache.get("success");
                Integer failCnt = (Integer)delBizDataCache.get("fail");
                if (SWCListUtils.isEmpty((List)cacheFailMsg)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u56de\u6210\u529f\u3002", (String)"CalPersonGenBizDataPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                } else {
                    String msg = ResManager.loadKDString((String)"\u5171{0}\u85aa\u8d44\u6863\u6848\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"GenBizDataProgressPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[]{totalCnt, successCnt, failCnt});
                    FormShowParameter resultParameter = SWCShowFormServiceHelper.getOperationResultParameter((String)CalPersonOperationEnum.OP_DELBIZDATA.getOperationName(), (String)msg, (List)cacheFailMsg);
                    this.getView().showForm(resultParameter);
                    service.removeCacheFailMsg(taskid);
                    service.removeCacheDelGenBizDataProgress(taskid);
                }
                this.saveOpLog(true, CalPersonOperationEnum.OP_DELBIZDATA.getOperationName());
            }
            this.releaseDistributedLock();
        }
        this.getView().invokeOperation("refresh");
    }

    @Override
    public void pageRelease(EventObject eventObject) {
        super.pageRelease(eventObject);
        GenBizDataService service = new GenBizDataService();
        IPageCache pageCache = this.getView().getPageCache();
        String taskIdStr = pageCache.get("taskId");
        if (SWCStringUtils.isEmpty((String)taskIdStr)) {
            return;
        }
        Long taskid = Long.valueOf(taskIdStr);
        service.removeCacheProgress(taskid);
    }

    private void openDelBizDataConfirm() {
        String message = ResManager.loadKDString((String)"\u5bf9\u9009\u4e2d\u8bb0\u5f55\u64a4\u56de\u5728\u672c\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u4e2d\u5df2\u7ecf\u751f\u6210\u7684\u4e1a\u52a1\u6570\u636e\uff0c\u786e\u5b9a\u8981\u64a4\u56de\u5417\uff1f", (String)"CalPersonGenBizDataPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        ConfirmCallBackListener listener = new ConfirmCallBackListener("confirmDelGenBizData", (IFormPlugin)this);
        this.getView().showConfirm(message, MessageBoxOptions.OKCancel, listener);
    }

    public void saveOpLog(boolean success, String opName) {
        MultiLangEnumBridge opDescBridge = success ? new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f\u3002", "CalPersonGenBizDataPlugin_9", "swc-hsas-formplugin") : new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25\u3002", "CalPersonGenBizDataPlugin_10", "swc-hsas-formplugin");
        try {
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u64a4\u56de\u4e1a\u52a1\u6570\u636e", "CalPersonOperationEnum_41", "swc-hsbp-common");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)opName, (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
        }
        catch (Exception exception) {
            logger.info("addLog error");
        }
    }

    private void initFloatingTask(Long taskId, int total, String taskName) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String name = ResManager.loadKDString((String)"\u751f\u6210\u4e1a\u52a1\u6570\u636e-{0}", (String)"CalPersonGenBizDataPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[]{taskName});
        params.put("progressType", "22");
        params.put("taskId", taskId);
        params.put("totalcnt", total);
        params.put("starttime", SWCDateTimeUtils.format((Date)new Date()));
        String bgTaskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_hsas_genbizdata", name, true, this.getView().getPageId(), params);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "genbizdata_bggroud_taskid_%s", taskId));
        appCache.put("bgTaskId", (Object)bgTaskId);
    }

    private void openGenBizDataProgress(Integer validCnt, Long taskid) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_bizdataprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("totalcnt", (Object)validCnt);
        showParameter.setCustomParam("taskId", (Object)taskid);
        showParameter.setCustomParam("starttime", (Object)SWCDateTimeUtils.format((Date)new Date()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "genbizdataprogress");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private boolean checkPersonStatus(CalPayRollTask calPayRollTask) {
        List calPersons = calPayRollTask.getCalPersons();
        GenBizDataService genBizDataService = new GenBizDataService();
        String peritemId = CalPersonOperationEnum.OP_GENBIZDATA == this.calPersonOperationEnum ? "43+730XBEQJ9" : "432CBM42/J+D";
        List calPersonObjs = genBizDataService.getCalPersonObjs(calPersons, peritemId);
        String message = "";
        if (SWCListUtils.isEmpty((List)calPersonObjs)) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            message = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u6570\u636e\u7684\u201c{0}\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalPersonGenBizDataPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[]{this.calPersonOperationEnum.getOperationName()});
            this.getView().showTipNotification(message);
            return false;
        }
        List<String> approvedStatusList = Arrays.asList(CalStateEnum.AUDIT.getCode(), CalStateEnum.WAIT_APPROVALED.getCode(), CalStateEnum.APPROVALING.getCode(), CalStateEnum.APPROVAL.getCode(), CalStateEnum.APPROVALED_NOT_PASS.getCode(), CalStateEnum.APPROVALED.getCode());
        ArrayList genValidPersonList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList delValidPersonList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject calPersonObj : calPersonObjs) {
            String calStatus = calPersonObj.getString("calstatus");
            String bizDataGenStatus = calPersonObj.getString("bizdatagenstatus");
            if (approvedStatusList.contains(calStatus) && SWCStringUtils.equals((String)"1", (String)bizDataGenStatus)) {
                genValidPersonList.add(calPersonObj);
            }
            if (!SWCStringUtils.equals((String)GENED_STATUS, (String)bizDataGenStatus)) continue;
            delValidPersonList.add(calPersonObj);
        }
        if (CalPersonOperationEnum.OP_GENBIZDATA == this.calPersonOperationEnum) {
            if (SWCListUtils.isEmpty((List)genValidPersonList)) {
                calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                message = ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u8981\u6c42\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5df2\u7ecf\u5ba1\u6838\u540e\u4e14\u672a\u751f\u6210\u4e1a\u52a1\u6570\u636e\u7684\u6570\u636e\u3002", (String)"CalPersonGenBizDataPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            } else {
                this.validIdList = genValidPersonList.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
            }
        }
        if (CalPersonOperationEnum.OP_DELBIZDATA == this.calPersonOperationEnum) {
            if (SWCListUtils.isEmpty((List)delValidPersonList)) {
                calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                message = ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u8981\u6c42\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u4e1a\u52a1\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u751f\u6210\u201d\u7684\u6570\u636e\u3002", (String)"CalPersonGenBizDataPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            } else {
                this.validIdList = delValidPersonList.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
                if (!SWCListUtils.isEmpty((List)genValidPersonList)) {
                    ArrayList errMsgList = Lists.newArrayListWithExpectedSize((int)10);
                    for (DynamicObject personObj : genValidPersonList) {
                        String fileNumber = personObj.getString("filenumber");
                        errMsgList.add(ResManager.loadKDString((String)"{0}\uff1a\u751f\u6210\u4e1a\u52a1\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u751f\u6210\u201d\uff0c\u624d\u80fd\u8fdb\u884c\u64a4\u9500\u64cd\u4f5c\u3002", (String)"CalPersonGenBizDataPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[]{fileNumber}));
                    }
                    genBizDataService.updateFailMsgToCache((List)errMsgList, this.taskId);
                }
                genBizDataService.cacheDelBizDataProgress(this.taskId, calPersonObjs.size(), genValidPersonList.size());
            }
        }
        if (SWCStringUtils.isNotEmpty((String)message)) {
            this.getView().showTipNotification(message);
            return false;
        }
        this.totalCnt = calPersons.size();
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("totalCnt", this.totalCnt + "");
        pageCache.put("validPersonIdList", SerializationUtils.serializeToBase64(this.validIdList));
        return true;
    }

    private boolean checkGenBizDataEnable(CalPayRollTask calPayRollTask, DynamicObject schemeAfterCalObj) {
        boolean genbizdata;
        if (schemeAfterCalObj != null && !(genbizdata = schemeAfterCalObj.getBoolean("genbizdata"))) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u7684\u6838\u7b97\u540e\u5904\u7406\u65b9\u6848{0}\u4e2d\u672a\u542f\u7528\u751f\u6210\u4e1a\u52a1\u6570\u636e\u4e1a\u52a1\u3002", (String)"CalPersonGenBizDataPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[]{schemeAfterCalObj.getString("number")}));
            return false;
        }
        return true;
    }

    private boolean checkHasGenBizDataConfig(CalPayRollTask calPayRollTask) {
        GenBizDataService service = new GenBizDataService();
        DynamicObject genBizDataConfObj = service.getGenBizDataConfByTask(calPayRollTask.getCalPayRollTaskId());
        if (genBizDataConfObj == null) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u7684\u6838\u7b97\u573a\u666f\u672a\u914d\u7f6e\u751f\u6210\u4e1a\u52a1\u6570\u636e\u3002", (String)"CalPersonGenBizDataPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void openGenBizDataForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_genbizdataconf");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("totalcnt", (Object)this.totalCnt);
        showParameter.setCustomParam("validIdList", this.validIdList);
        showParameter.setCustomParam("taskId", (Object)this.taskId);
        showParameter.setCustomParam("taskName", (Object)this.taskId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "genbizdatamodal");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }
}

