/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.swc.hsas.business.cal.helper.CalPersonListHelper;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsas.business.genbizdata.GenBizDataService;
import kd.swc.hsas.business.progress.CalPersonOPProgressInfo;
import kd.swc.hsas.business.task.DeleteCalPersonTask;
import kd.swc.hsas.formplugin.web.guide.AbstractCalPersonList;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.CalPersonLockEnum;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CalPayRollTaskMutex;

public class CalPersonOperateList
extends AbstractCalPersonList {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void itemClick(ItemClickEvent evt) {
        if (SWCStringUtils.equals((String)"bar_opentax", (String)evt.getItemKey()) || SWCStringUtils.equals((String)"bar_closetax", (String)evt.getItemKey())) {
            boolean isOpen = SWCStringUtils.equals((String)"bar_opentax", (String)evt.getItemKey());
            ISWCAppCache appCache = SWCAppCache.get((String)"hsbs_tax_cal_param");
            HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>(16);
            paramMap.put("enableTaxCal", isOpen);
            appCache.put("hsbs_tax_cal_param", paramMap);
        }
    }

    @Override
    protected List<CalPersonOperationEnum> operationKey() {
        ArrayList<CalPersonOperationEnum> calPersonOperationEnums = new ArrayList<CalPersonOperationEnum>();
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_AUDIT);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_UNAUDIT);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_ADDCALPERSON);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_ADDEXCCALPERSON);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_REFRESH);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_DELCALPERSON);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_VIEWBAKINFO);
        return calPersonOperationEnums;
    }

    @Override
    protected boolean afterOperationUpdateView(CalPersonOperationEnum calPersonOperationEnum) {
        switch (calPersonOperationEnum) {
            case OP_ADDCALPERSON: 
            case OP_ADDEXCCALPERSON: 
            case OP_REFRESH: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isSelectData() {
        switch (this.calPersonOperationEnum) {
            case OP_ADDCALPERSON: 
            case OP_ADDEXCCALPERSON: 
            case OP_REFRESH: 
            case OP_VIEWBAKINFO: {
                return false;
            }
            case OP_AUDIT: 
            case OP_UNAUDIT: 
            case OP_DELCALPERSON: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean checkCalPayrollTaskState(CalPayrollTaskStateEnum calPayrollTaskStateEnum) {
        switch (this.calPersonOperationEnum) {
            case OP_ADDCALPERSON: 
            case OP_ADDEXCCALPERSON: 
            case OP_REFRESH: 
            case OP_VIEWBAKINFO: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void execute() {
        switch (this.calPersonOperationEnum) {
            case OP_AUDIT: 
            case OP_UNAUDIT: 
            case OP_DELCALPERSON: {
                this.getPageCache().put("invokeOperation", "true");
                break;
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption operateOption = formOperate.getOption();
        switch (this.calPersonOperationEnum) {
            case OP_UNAUDIT: {
                if (!this.checkPersonStatus(calPayRollTask)) {
                    return;
                }
                if (operateOption.tryGetVariableValue("CallBackInvoke", new RefObject())) break;
                this.unAuditValidator(args, calPayRollTask);
                break;
            }
            case OP_ADDCALPERSON: {
                if (!this.checkTaskStatus(calPayRollTask)) {
                    return;
                }
                CalPersonHelper.asyncGetCouldAddFileVids((Long)calPayRollTask.getCalPayRollTaskId());
                CalPersonListHelper.showGetAddProgress((IFormView)this.getView());
                break;
            }
            case OP_ADDEXCCALPERSON: {
                if (!this.checkTaskStatus(calPayRollTask)) {
                    return;
                }
                this.showAddEXCcalpersonPage();
                break;
            }
            case OP_DELCALPERSON: {
                if (CalPayrollTaskStateEnum.APPROVALED.getCode().equals(calPayRollTask.getPayRollTaskStatus())) {
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u5df2\u5ba1\u6279\u901a\u8fc7\uff0c\u4e0d\u5141\u8bb8\u518d\u5220\u9664\u6838\u7b97\u4eba\u5458\u3002", (String)"CalPersonOperateList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                String errorCode = CalPersonHelper.tryLock((Long)calPayRollTask.getCalPayRollTaskId(), (CalPersonLockEnum)CalPersonLockEnum.DELETE);
                CalPayRollTaskMutex calPayRollTaskMutex = PayrollTaskHelper.tryLock((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)this.calPersonOperationEnum.getOperationKey());
                if (calPayRollTaskMutex != null) {
                    CalPersonOperationEnum currentOperation = calPayRollTaskMutex.getCalPersonOperationEnum();
                    String errorMessage = ResManager.loadKDString((String)"\u7f16\u7801\u4e3a{0}\u7684\u6838\u7b97\u4efb\u52a1\uff1a\u6b63\u5728{1}\u4e2d\uff0c\u65e0\u6cd5{2}\u3002", (String)"AbstractCalPayRollTaskList_2", (String)"swc-hsas-formplugin", (Object[])new Object[]{calPayRollTask.getNumber(), currentOperation.getOperationName(), this.calPersonOperationEnum.getOperationName()});
                    this.getView().showTipNotification(errorMessage);
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    CalPersonHelper.releaseLock((Long)calPayRollTask.getCalPayRollTaskId());
                    return;
                }
                if (SWCStringUtils.isNotEmpty((String)errorCode)) {
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    this.getView().showErrorNotification(CalPersonLockEnum.getDesc((String)errorCode));
                    PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)CalPersonOperationEnum.OP_DELCALPERSON.getOperationKey());
                    return;
                }
                ListSelectedRowCollection selectedDelRows = ((ListView)this.getView()).getSelectedRows();
                String delTitle = ResManager.loadKDString((String)"\u5220\u9664\u9009\u62e9\u7684{0}\u6761\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\uff1f", (String)"CalPersonOperateList_9", (String)"swc-hsas-formplugin", (Object[])new Object[]{selectedDelRows.size()});
                ConfirmCallBackListener delConfirmCallBackListener = new ConfirmCallBackListener("deleteConfirm", (IFormPlugin)this);
                this.getView().showConfirm(delTitle, MessageBoxOptions.OKCancel, delConfirmCallBackListener);
                this.getPageCache().put("isDeleteConfirm", "1");
                calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
                break;
            }
            case OP_REFRESH: {
                if (CalPayrollTaskStateEnum.APPROVALED.getCode().equals(calPayRollTask.getPayRollTaskStatus())) {
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u5df2\u5ba1\u6279\u901a\u8fc7\uff0c\u4e0d\u5141\u8bb8\u518d\u66f4\u65b0\u6838\u7b97\u4eba\u5458\u3002", (String)"CalPersonOperateList_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (CalPayrollTaskStateEnum.DISUSED.getCode().equals(calPayRollTask.getPayRollTaskStatus())) {
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u5df2\u5e9f\u5f03\uff0c\u4e0d\u5141\u8bb8\u518d\u66f4\u65b0\u6838\u7b97\u4eba\u5458\u3002", (String)"CalPersonOperateList_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
                DynamicObject taskDy = taskHelper.queryOne((Object)calPayRollTask.getCalPayRollTaskId());
                DynamicObject periodDy = taskDy.getDynamicObject("period");
                DynamicObject scenevDy = taskDy.getDynamicObject("payrollscenev");
                if (periodDy == null || periodDy.getLong("id") == 0L || scenevDy == null) {
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    return;
                }
                if (!CalPersonListHelper.validateRuleVersion((Long)calPayRollTask.getCalPayRollTaskId(), (IFormView)this.getView(), (boolean)false)) {
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    return;
                }
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows.size() == 0) {
                    String title = ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6838\u7b97\u4eba\u5458\uff0c\r\n\u70b9\u51fb\u786e\u5b9a\u5c06\u5bf9\u5168\u90e8\u6838\u7b97\u4eba\u5458\u6267\u884c\u66f4\u65b0\u64cd\u4f5c\u3002", (String)"CalPersonOperateList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("chooseAllConfirm", (IFormPlugin)this);
                    this.getView().showConfirm(title, MessageBoxOptions.OKCancel, confirmCallBackListener);
                    this.getPageCache().put("isUpDataConfirm", "1");
                } else {
                    CalPersonListHelper.showGetRefreshProgress((String)"updateandadd", (IFormView)this.getView());
                }
                calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
                break;
            }
            case OP_VIEWBAKINFO: {
                Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
                ListShowParameter parameter = new ListShowParameter();
                parameter.setBillFormId("hsas_calpersonbakview");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getListFilterParameter().setFilter(new QFilter("caltask", "=", (Object)payrolltaskId));
                parameter.setPageId(this.getView().getPageId() + "viewbak");
                parameter.setCustomParam("caltaskid", (Object)payrolltaskId);
                String orderby = this.getPageCache().get("calpersonorderby");
                if (SWCStringUtils.isNotEmpty((String)orderby)) {
                    parameter.getListFilterParameter().setOrderBy(orderby);
                }
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    private boolean checkPersonStatus(CalPayRollTask calPayRollTask) {
        List calPersons = calPayRollTask.getCalPersons();
        if (SWCListUtils.isEmpty((List)calPersons)) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return false;
        }
        GenBizDataService service = new GenBizDataService();
        List calPersonObjs = service.getCalPersonObjs(calPersons, "47162f66000000ac");
        if (SWCListUtils.isEmpty((List)calPersonObjs)) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return false;
        }
        calPersonObjs.removeIf(single -> SWCStringUtils.equals((String)single.getString("bizdatagenstatus"), (String)"2"));
        if (calPersonObjs.size() == 0) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u4e1a\u52a1\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u751f\u6210\u201d\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"CalPersonOperateList_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkTaskStatus(CalPayRollTask calPayRollTask) {
        if (CalPayrollTaskStateEnum.APPROVALED.getCode().equals(calPayRollTask.getPayRollTaskStatus())) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u5df2\u5ba1\u6279\u901a\u8fc7\uff0c\u4e0d\u5141\u8bb8\u518d\u6dfb\u52a0\u6838\u7b97\u4eba\u5458\u3002", (String)"CalPersonOperateList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (CalPayrollTaskStateEnum.DISUSED.getCode().equals(calPayRollTask.getPayRollTaskStatus())) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u5df2\u5e9f\u5f03\uff0c\u4e0d\u5141\u8bb8\u518d\u6dfb\u52a0\u6838\u7b97\u4eba\u5458\u3002", (String)"CalPersonOperateList_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!CalPersonListHelper.validateRuleVersion((Long)calPayRollTask.getCalPayRollTaskId(), (IFormView)this.getView(), (boolean)true)) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return false;
        }
        calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
        return true;
    }

    @Override
    protected void afterDoOperation(AfterDoOperationEventArgs args, CalPayRollTaskContext calPayRollTaskContext) {
        switch (this.calPersonOperationEnum) {
            case OP_AUDIT: 
            case OP_UNAUDIT: {
                for (CalPayRollTask validData : calPayRollTaskContext.getValidDatas()) {
                    PayrollTaskHelper.updateCalPayRollTaskStatus((Long)validData.getCalPayRollTaskId());
                }
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String confirmKey;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (confirmKey = messageBoxClosedEvent.getCallBackId()) {
            case "chooseAllConfirm": {
                if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                    CalPersonListHelper.showGetRefreshProgress((String)"updateandadd", (IFormView)this.getView());
                    break;
                }
                this.releaseDistributedLock();
                break;
            }
            case "deleteConfirm": {
                this.getPageCache().remove("isDeleteConfirm");
                Long calPayRollTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
                if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                    ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows();
                    List selectIds = selectedRows.stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toList());
                    int total = selectIds.size();
                    if (total <= 5000) {
                        List errMsgList = new DeleteCalPersonTask().execute(selectIds, calPayRollTaskId);
                        IFormView view = this.getView();
                        CalPersonListHelper.showDelResult((int)total, (List)errMsgList, (IFormView)view);
                        IFormView parentView = view.getParentView();
                        if (parentView instanceof IListView) {
                            ((IListView)parentView).refresh();
                            this.getView().sendFormAction(parentView);
                        }
                    } else {
                        RequestContext ctx = RequestContext.get();
                        CalPersonOPProgressInfo progressinfo = new CalPersonOPProgressInfo();
                        progressinfo.setTotal(total);
                        ISWCAppCache appCache = SWCAppCache.get((String)"hsas");
                        appCache.put(String.format(Locale.ROOT, "CAL_PERSON_DEL_CACHE_KEY_%s", calPayRollTaskId), (Object)progressinfo);
                        ThreadPools.executeOnce((String)"SALARYDELPERSON_POOL_ASYNC", () -> {
                            RequestContext.copyAndSet((RequestContext)ctx);
                            new DeleteCalPersonTask().execute(selectIds, calPayRollTaskId);
                        });
                        CalPersonHelper.showDelPersonProgress((Long)calPayRollTaskId, (IFormView)this.getView());
                    }
                    String opKey = CalPersonOperationEnum.OP_DELCALPERSON.getOperationKey();
                    MultiLangEnumBridge bridge = new MultiLangEnumBridge("\u5220\u9664\u6838\u7b97\u4eba\u5458\u6210\u529f\u3002", "CalPersonOperateList_12", "swc-hsas-formplugin");
                    SWCOpLogServiceHelper.addOpLog((String)"hsas", (String)"hsas_calperson", (String)opKey, (String)"", (MultiLangEnumBridge)bridge, (String[])new String[0]);
                    break;
                }
                CalPersonHelper.releaseLock((Long)calPayRollTaskId);
                this.releaseDistributedLock();
                break;
            }
            case "donothing_unaudit": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("CallBackInvoke", "true");
                    this.getView().invokeOperation(CalPersonOperationEnum.OP_UNAUDIT.getOperationKey(), operateOption);
                    break;
                }
                this.releaseDistributedLock();
                break;
            }
        }
    }

    private void unAuditValidator(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u65f6\uff0c\u4f1a\u5220\u9664\u751f\u6210\u7684\u53d1\u653e\u660e\u7ec6\u548c\u5206\u644a\u660e\u7ec6\uff0c\u540c\u65f6\u5e9f\u5f03\u6389\u62a5\u76d8\u5931\u6548\u3001\u5df2\u89e3\u85aa\u3001\u94f6\u884c\u5361\u53d8\u66f4\u4e2d\u7684\u53d1\u653e\u660e\u7ec6\uff0c\u662f\u5426\u786e\u8ba4?", (String)"HSASCalTableList_118", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(this.calPersonOperationEnum.getOperationKey()));
        calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
        args.setCancel(true);
    }

    private void showAddEXCcalpersonPage() {
        Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        ListShowParameter form = ShowFormHelper.createShowListForm((String)"hsas_addexcpersonf7", (boolean)true);
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setFormId("hsas_addpersonlist");
        form.setCustomParam("payrolltaskdataid", (Object)payrolltaskId);
        this.getView().showForm((FormShowParameter)form);
    }

    @Override
    protected boolean operationMutex() {
        switch (this.calPersonOperationEnum) {
            case OP_VIEWBAKINFO: 
            case OP_DELCALPERSON: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void pageRelease(EventObject e) {
        String isDeleteConfirm = this.getPageCache().get("isDeleteConfirm");
        String isUpDataConfirm = this.getPageCache().get("isUpDataConfirm");
        Long calPayRollTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        if (SWCStringUtils.equals((String)isDeleteConfirm, (String)"1")) {
            CalPersonHelper.releaseLock((Long)calPayRollTaskId);
            this.releaseDistributedLock();
        } else if (SWCStringUtils.equals((String)isUpDataConfirm, (String)"1")) {
            this.releaseDistributedLock();
        }
    }
}

