/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.cal.helper.CalPersonListHelper;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.refreshperson.entity.CalPersonRefreshProgressInfo;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class CalPersonRefreshPlugin
extends SWCDataBaseEdit
implements ProgresssListener {
    private static final String SWC_HSAS_FORMPLUGIN = "swc-hsas-formplugin";
    private static final String BTN_CLOSE = "btnclose";
    private static final String PROGRESS_AP = "progressap";
    private static final String FINISH_AP = "finishap";
    private static final String IMAGE_AP = "imageap";
    private static final String IMAGE_URL = "/images/pc/emotion/jszxt_168_96.png";
    private static final String PROGRESS_NUM_LABEL = "progressnumlabel";

    public void initialize() {
        super.initialize();
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        progress.addProgressListener((ProgresssListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getView().getControl("btncancel");
        button.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FINISH_AP, BTN_CLOSE});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        ISWCAppCache appCache = SWCAppCache.get((String)"cachekey_hsas_calperson_refresh");
        Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        CalPersonRefreshProgressInfo progressInfo = (CalPersonRefreshProgressInfo)appCache.get(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", payrolltaskId), CalPersonRefreshProgressInfo.class);
        if (progressInfo == null) {
            return;
        }
        ((Label)this.getControl(PROGRESS_NUM_LABEL)).setText("0");
        progressBar.setPercent(0);
        progressInfo.getProgress();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.start();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control itemControl = (Control)evt.getSource();
        String itemKey = itemControl.getKey();
        if (SWCStringUtils.equals((String)itemKey, (String)"btnok")) {
            this.getView().close();
        } else if (SWCStringUtils.equals((String)itemKey, (String)"btncancel")) {
            ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
            progressBar.stop();
            Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
            String taskId = (String)this.getView().getFormShowParameter().getCustomParam("sch_taskid");
            if (SWCStringUtils.isNotEmpty((String)taskId)) {
                HRBackgroundTaskHelper.getInstance().confirmEndTask(taskId, "COMPLETED");
            }
            ISWCAppCache appCache = SWCAppCache.get((String)"cachekey_hsas_calperson_refresh");
            appCache.remove(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", calTaskId));
        }
    }

    private void start() {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.start();
        ISWCAppCache appCache = SWCAppCache.get((String)"cache_getrefreshlist_progress_%s");
        Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        CalPersonRefreshProgressInfo progressInfo = (CalPersonRefreshProgressInfo)appCache.get(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", payrolltaskId), CalPersonRefreshProgressInfo.class);
        Label progressNumLabel = (Label)this.getControl(PROGRESS_NUM_LABEL);
        if (progressInfo != null) {
            if (progressInfo.getProgress() != 100) {
                progressBar.setPercent(progressInfo.getProgress());
            }
            progressNumLabel.setText(String.valueOf(progressInfo.getProgress()));
            Label timeLabel = (Label)this.getControl("timelabel");
            CalPersonListHelper.setCostTime((Date)progressInfo.getStartDate(), (Label)timeLabel, (Date)progressInfo.getEndDate(), (Boolean)Boolean.FALSE);
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        ISWCAppCache appCache = SWCAppCache.get((String)"cachekey_hsas_calperson_refresh");
        Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        CalPersonRefreshProgressInfo progressInfo = (CalPersonRefreshProgressInfo)appCache.get(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", payrolltaskId), CalPersonRefreshProgressInfo.class);
        if (progressInfo == null) {
            return;
        }
        Label timeLabel = (Label)this.getControl("timelabel");
        CalPersonListHelper.setCostTime((Date)progressInfo.getStartDate(), (Label)timeLabel, (Date)progressInfo.getEndDate(), (Boolean)Boolean.FALSE);
        ((Label)this.getControl(PROGRESS_NUM_LABEL)).setText(String.valueOf(progressInfo.getProgress()));
        progressEvent.setProgress(progressInfo.getProgress());
        if (progressInfo.getProgress() == 100) {
            this.getView().getPageCache().put("isFinish", "true");
            this.finishTask(payrolltaskId, progressInfo);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String clkKey = ((Control)evt.getSource()).getKey();
        if (SWCStringUtils.equals((String)clkKey, (String)"btncancel")) {
            this.getView().getPageCache().put("cancel", "true");
        }
    }

    private void finishTask(Long payrolltaskId, CalPersonRefreshProgressInfo progressInfo) {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.stop();
        this.getView().getPageCache().put("isFinish", "1");
        int addTotal = progressInfo.getAddIds().size();
        int updateTotal = progressInfo.getUpdateIds().size();
        int delTotal = progressInfo.getDelIds().size();
        if (addTotal + updateTotal + delTotal == 0) {
            this.getView().getPageCache().put("cancel", "true");
            this.getView().setVisible(Boolean.TRUE, new String[]{FINISH_AP, BTN_CLOSE});
            this.getView().setVisible(Boolean.FALSE, new String[]{PROGRESS_AP, "btncancel", "btnok"});
        } else {
            String refreshType = (String)this.getView().getFormShowParameter().getCustomParam("refreshType");
            ListShowParameter show = ShowFormHelper.createShowListForm((String)"hsas_calrefreshlist", (boolean)true);
            show.setCustomParam("calTaskId", (Object)payrolltaskId);
            show.setCustomParam("addFileHisIds", (Object)progressInfo.getAddIds());
            show.setCustomParam("updateFileIds", (Object)progressInfo.getUpdateIds());
            show.setCustomParam("delFileIds", (Object)progressInfo.getDelIds());
            show.setCustomParam("refreshType", (Object)refreshType);
            show.setCustomParam("calTaskName", this.getView().getFormShowParameter().getCustomParam("calTaskName"));
            show.setHasRight(true);
            this.getView().getParentView().showForm((FormShowParameter)show);
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isCancel = this.getView().getPageCache().get("cancel");
        String isFinish = this.getView().getPageCache().get("isFinish");
        Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        CalPersonRefreshProgressInfo progressInfo = (CalPersonRefreshProgressInfo)SWCAppCache.get((String)"cachekey_hsas_calperson_refresh").get(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", payrolltaskId), CalPersonRefreshProgressInfo.class);
        if (isCancel != null) {
            Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
            if (SWCObjectUtils.isEmpty((Object)this.getView().getFormShowParameter().getCustomParam("sch_taskid"))) {
                ISWCAppCache appCache = SWCAppCache.get((String)"cachekey_hsas_calperson_refresh");
                appCache.remove(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", calTaskId));
            }
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_REFRESH.getOperationKey());
        } else if (isFinish == null) {
            this.toBackground();
        }
    }

    private void toBackground() {
        IFormView mainView;
        String str = (String)this.getView().getFormShowParameter().getCustomParam("sch_clientjobinfo");
        Map jobFormInfo = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        CalPersonRefreshProgressInfo progressInfo = (CalPersonRefreshProgressInfo)SWCAppCache.get((String)"cachekey_hsas_calperson_refresh").get(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", calTaskId), CalPersonRefreshProgressInfo.class);
        progressInfo.setShowInProgress(false);
        if (SWCObjectUtils.isEmpty((Object)this.getView().getFormShowParameter().getCustomParam("sch_taskid")) && (mainView = this.getView().getMainView()) != null) {
            HRBackgroundTaskHelper instance = HRBackgroundTaskHelper.getInstance();
            String bgTaskId = instance.createBaskgroundTask("swc_hsas_getrefreshlist", (String)jobFormInfo.get("taskName"), true, mainView.getPageId(), this.getView().getParentView().getPageId(), jobFormInfo);
            instance.showBaskgroundTask(bgTaskId);
        }
    }
}

