/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.entity.property.ComboProp;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.helper.HSASCalListFilterParser;
import kd.swc.hsas.formplugin.web.calpersonlist.CalRefreshListPlugin;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CalRefreshFailList
extends SWCDataBaseList
implements SetFilterListener {
    private static final String SWC_HSAS_FORMPLUGIN = "swc-hsas-formplugin";
    private static final String EXCEL_SUFFIX = ".xlsx";
    private static final Log logger = LogFactory.getLog(CalRefreshListPlugin.class);
    private final String addPerson = ResManager.loadKDString((String)"\u6dfb\u52a0\u6838\u7b97\u4eba\u5458", (String)"CalRefreshFailList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
    private final String updatePerson = ResManager.loadKDString((String)"\u66f4\u65b0\u6838\u7b97\u4eba\u5458", (String)"CalRefreshFailList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
    private final String delPerson = ResManager.loadKDString((String)"\u5220\u9664\u6838\u7b97\u4eba\u5458", (String)"CalRefreshFailList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
    private static final String FAIL_BILL = "failbill";
    private static final String FAIL_MSG = "failMsg";
    private static final List<String> salaryFileColumnFields = new ArrayList<String>(10);

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(FAIL_BILL);
        billList.addSetFilterListener((SetFilterListener)this);
        Button exportButton = (Button)this.getControl("btnok");
        exportButton.addClickListener((ClickListener)this);
        billList.addPackageDataListener(packageDataEvent -> {
            Object source = packageDataEvent.getSource();
            Map failMsgMap = (Map)this.getView().getFormShowParameter().getCustomParam(FAIL_MSG);
            if (source instanceof DynamicTextColumnDesc) {
                List addListIds = (List)failMsgMap.get("addFailIds");
                List updateListIds = (List)failMsgMap.get("updateFailIds");
                List delListIds = (List)failMsgMap.get("delFailIds");
                long id = packageDataEvent.getRowData().getLong("id");
                if (addListIds.contains(id)) {
                    packageDataEvent.setFormatValue((Object)this.addPerson);
                } else if (updateListIds.contains(id)) {
                    packageDataEvent.setFormatValue((Object)this.updatePerson);
                } else if (delListIds.contains(id)) {
                    packageDataEvent.setFormatValue((Object)this.delPerson);
                }
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.addSearchClickListener(searchClickEvent -> {
            QFilter addFilters = this.getQueryFilters();
            if (addFilters == null) {
                this.getView().getPageCache().remove("fileFilters");
            } else {
                this.getView().getPageCache().put("fileFilters", addFilters.toString());
            }
            this.getView().updateView(FAIL_BILL);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (SWCStringUtils.equals((String)key, (String)"btnok")) {
            this.doExport();
        }
    }

    private QFilter getQueryFilters() {
        QFilter[] fFilter;
        HSASCalListFilterParser parser = new HSASCalListFilterParser();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        Map filterValues = filterContainer.getCachedFilterValues().createMapFilterValues();
        List fastFilter = new ArrayList(10);
        if (filterValues.get("fastfilter") != null) {
            fastFilter = (List)filterValues.get("fastfilter");
        }
        if ((fFilter = parser.parseFastFilterUseAnd(fastFilter)) != null) {
            QFilter[] addFilters = new QFilter[]{};
            for (QFilter qf : fFilter) {
                String qfString = qf.toString();
                QFilter qFilter = QFilter.of((String)qfString, (Object[])new Object[0]);
                qFilter = this.margeFilter(qFilter, addFilters);
                addFilters = new QFilter[]{qFilter};
            }
            return addFilters[0];
        }
        return null;
    }

    private QFilter margeFilter(QFilter filter, QFilter[] filters) {
        if (filters != null) {
            for (QFilter qFilter : filters) {
                filter = filter == null ? qFilter : filter.and(qFilter);
            }
        }
        return filter;
    }

    public void setFilter(SetFilterEvent e) {
        BillList billList = (BillList)e.getSource();
        if (SWCStringUtils.equals((String)billList.getKey(), (String)FAIL_BILL)) {
            List<Long> ids = this.getAllFailIds();
            QFilter idFilter = new QFilter("id", "in", ids);
            String searchFilter = this.getView().getPageCache().get("fileFilters");
            if (searchFilter != null) {
                QFilter qFilter = QFilter.of((String)searchFilter, (Object[])new Object[0]);
                e.getQFilters().add(qFilter);
            }
            e.getQFilters().add(idFilter);
        }
    }

    private List<Long> getAllFailIds() {
        Map failMsgMap = (Map)this.getView().getFormShowParameter().getCustomParam(FAIL_MSG);
        List addListIds = (List)failMsgMap.get("addFailIds");
        List updateListIds = (List)failMsgMap.get("updateFailIds");
        List delListIds = (List)failMsgMap.get("delFailIds");
        ArrayList<Long> ids = new ArrayList<Long>(10);
        ids.addAll(addListIds);
        ids.addAll(updateListIds);
        ids.addAll(delListIds);
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport() {
        SXSSFWorkbook wb = new SXSSFWorkbook();
        SXSSFSheet addSheet = wb.createSheet(ResManager.loadKDString((String)"\u5931\u8d25\u8be6\u60c5", (String)"CalRefreshFailList_4", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
        this.writerHeader(addSheet, wb);
        List<Long> selectedRowIdList = this.getAllFailIds();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter idFilter = new QFilter("id", "in", selectedRowIdList);
        DynamicObject[] dynamicObjects = helper.query("payrollgroup.name,modifytime,modifier.name,bsled,datastatus,createtime,creator.name,managingscope.managingscope.name,startpaydate,empgroup.name,adminorg.name,depcytype.name,payrollregion.name,paystatus,hisversion,number,employee.person.name,employee.person.number,status,bsed,salarycalcstyle.name,org.name", new QFilter[]{idFilter});
        this.writerContent(addSheet, wb.createCellStyle(), dynamicObjects);
        String exportUrl = null;
        try {
            exportUrl = this.writeFile(wb);
        }
        catch (IOException e) {
            logger.error("calperson refreshfail export error", (Throwable)e);
        }
        finally {
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error("calperson refreshfail export wb close error", (Throwable)e);
            }
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        if (exportUrl != null) {
            clientViewProxy.addAction("download", (Object)exportUrl);
        }
    }

    private void writerHeader(SXSSFSheet sheet, SXSSFWorkbook wb) {
        ListGridView listGridView = (ListGridView)this.getControl("gridview1");
        List items = listGridView.getItems();
        CellStyle cellStyle = this.getHeadColumnStyle(wb);
        SXSSFRow headRow = CalRefreshFailList.getRow(sheet, 0);
        int i = 1;
        CalRefreshFailList.createCell(headRow, 0, cellStyle).setCellValue(ResManager.loadKDString((String)"\u66f4\u65b0\u7c7b\u578b", (String)"CalRefreshFailList_5", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
        sheet.setColumnWidth(0, sheet.getColumnWidth(i) * 4);
        for (Control control : items) {
            ListColumn listColumn;
            if (!(control instanceof ListColumn) || SWCStringUtils.equals((String)(listColumn = (ListColumn)control).getListFieldKey(), (String)"fseq")) continue;
            CalRefreshFailList.createCell(headRow, i, cellStyle).setCellValue(listColumn.getCaption().getLocaleValue());
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 4);
            ++i;
        }
    }

    private void writerContent(SXSSFSheet sheet, CellStyle style, DynamicObject[] dynamicObjects) {
        style.setWrapText(false);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dy = dynamicObjects[i];
            SXSSFRow contentRow = CalRefreshFailList.getRow(sheet, i + 1);
            for (int j = 0; j < salaryFileColumnFields.size(); ++j) {
                String fieldKey = salaryFileColumnFields.get(j);
                String content = "";
                MainEntityType calTask = EntityMetadataCache.getDataEntityType((String)"hsas_salaryfile");
                if (SWCStringUtils.equals((String)fieldKey, (String)"status") || SWCStringUtils.equals((String)fieldKey, (String)"datastatus") || SWCStringUtils.equalsIgnoreCase((String)fieldKey, (String)"payStatus")) {
                    ComboProp taskTypeCombo = (ComboProp)calTask.getProperties().get((Object)fieldKey);
                    List comboItems = taskTypeCombo.getComboItems();
                    for (ValueMapItem item : comboItems) {
                        if (!item.getValue().equals(dy.getString(fieldKey))) continue;
                        content = item.getName().getLocaleValue();
                    }
                } else {
                    content = dy.getString(fieldKey);
                }
                CalRefreshFailList.createCell(contentRow, j + 1, style).setCellValue(content);
            }
            Map failMsgMap = (Map)this.getView().getFormShowParameter().getCustomParam(FAIL_MSG);
            List addListIds = (List)failMsgMap.get("addFailIds");
            List updateListIds = (List)failMsgMap.get("updateFailIds");
            List delListIds = (List)failMsgMap.get("delFailIds");
            long salaryFileId = dy.getLong("id");
            String refreshType = "";
            if (addListIds.contains(salaryFileId)) {
                refreshType = this.addPerson;
            } else if (updateListIds.contains(salaryFileId)) {
                refreshType = this.updatePerson;
            } else if (delListIds.contains(salaryFileId)) {
                refreshType = this.delPerson;
            }
            CalRefreshFailList.createCell(contentRow, 0, style).setCellValue(refreshType);
        }
    }

    private static SXSSFCell createCell(SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        return cell;
    }

    private static SXSSFRow getRow(SXSSFSheet sheet, int rowIndex) {
        SXSSFRow row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(SXSSFWorkbook wb) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            LocalDate now = LocalDate.now();
            String date = String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
            String fileName = MessageFormat.format(ResManager.loadKDString((String)"\u66f4\u65b0\u6838\u7b97\u4eba\u5458\u5931\u8d25\u5217\u8868_{0}", (String)"CalRefreshFailList_3", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), date) + EXCEL_SUFFIX;
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (null != outStream) {
                outStream.close();
            }
            if (null != inStream) {
                inStream.close();
            }
        }
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setWrapText(false);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(false);
        return headColumnStyle;
    }

    static {
        salaryFileColumnFields.add("hisversion");
        salaryFileColumnFields.add("number");
        salaryFileColumnFields.add("employee.person.name");
        salaryFileColumnFields.add("employee.empnumber");
        salaryFileColumnFields.add("status");
        salaryFileColumnFields.add("paystatus");
        salaryFileColumnFields.add("salarycalcstyle.name");
        salaryFileColumnFields.add("org.name");
        salaryFileColumnFields.add("payrollregion.name");
        salaryFileColumnFields.add("payrollgroup.name");
        salaryFileColumnFields.add("depcytype.name");
        salaryFileColumnFields.add("adminorg.name");
        salaryFileColumnFields.add("empgroup.name");
        salaryFileColumnFields.add("startpaydate");
        salaryFileColumnFields.add("managingscope.managingscope.name");
        salaryFileColumnFields.add("creator.name");
        salaryFileColumnFields.add("createtime");
        salaryFileColumnFields.add("datastatus");
        salaryFileColumnFields.add("bsed");
        salaryFileColumnFields.add("bsled");
        salaryFileColumnFields.add("modifier.name");
        salaryFileColumnFields.add("modifytime");
    }
}

