/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.helper.CalPersonListHelper;
import kd.swc.hsas.business.cal.helper.HSASCalListFilterParser;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonLockEnum;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CalRefreshListPlugin
extends AbstractListPlugin
implements SetFilterListener,
SelectRowsEventListener {
    private static final String SWC_HSAS_FORMPLUGIN = "swc-hsas-formplugin";
    private static final String EXCEL_SUFFIX = ".xlsx";
    private static final Log logger = LogFactory.getLog(CalRefreshListPlugin.class);
    private final String addPerson = ResManager.loadKDString((String)"\u6dfb\u52a0\u4eba\u5458", (String)"CalRefreshListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
    private final String updatePerson = ResManager.loadKDString((String)"\u66f4\u65b0\u4eba\u5458", (String)"CalRefreshListPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
    private final String delPerson = ResManager.loadKDString((String)"\u5220\u9664\u4eba\u5458", (String)"CalRefreshListPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
    private final String TO_ADD_AP = "toaddap";
    private final String TO_UPDATE_AP = "toupdateap";
    private final String TO_DEL_AP = "todelap";
    private final String TO_ADD_LABEL = "toaddlabel";
    private final String TO_UPDATE_LABEL = "toupdatelabel";
    private final String TO_DEL_LABEL = "todellabel";
    private final String TO_ADD_NUM = "toaddnum";
    private final String TO_UPDATE_NUM = "toupdatenum";
    private final String TO_DEL_NUM = "todelnum";
    private final String TIP_LABEL = "tiplabelap";
    private final String TAB = "tabap";
    private final String TAB_ADD = "tabaddap";
    private final String TAB_UPDATE = "tabupdateap";
    private final String TAB_DEL = "tabdelap";
    private final String ADD_LIST_GRID_VIEW_AP = "addlistgridviewap";
    private final String UPDATE_LIST_GRID_VIEW_AP = "updatelistgridviewap";
    private final String DEL_LIST_GRID_VIEW_AP = "dellistgridviewap";
    private static final List<String> salaryFileColumnFields = new ArrayList<String>(10);

    public void initialize() {
        super.initialize();
        BillList addBill = (BillList)this.getControl("addbill");
        BillList updateBill = (BillList)this.getControl("updatebill");
        BillList delBill = (BillList)this.getControl("delbill");
        Container addContainer = (Container)this.getControl("toaddap");
        Container updateContainer = (Container)this.getControl("toupdateap");
        Container delContainer = (Container)this.getControl("todelap");
        addContainer.addClickListener((ClickListener)this);
        updateContainer.addClickListener((ClickListener)this);
        delContainer.addClickListener((ClickListener)this);
        addBill.addSetFilterListener((SetFilterListener)this);
        updateBill.addSetFilterListener((SetFilterListener)this);
        delBill.addSetFilterListener((SetFilterListener)this);
        addBill.addListRowClickListener((ListRowClickListener)this);
        updateBill.addListRowClickListener((ListRowClickListener)this);
        delBill.addListRowClickListener((ListRowClickListener)this);
        addBill.addListRowSelectAllListeners(evt -> {
            BillList billList = (BillList)evt.getSource();
            String billKey = billList.getKey();
            this.changeNumLabelText(billKey);
        });
        updateBill.addListRowSelectAllListeners(evt -> {
            BillList billList = (BillList)evt.getSource();
            String billKey = billList.getKey();
            this.changeNumLabelText(billKey);
        });
        delBill.addListRowSelectAllListeners(evt -> {
            BillList billList = (BillList)evt.getSource();
            String billKey = billList.getKey();
            this.changeNumLabelText(billKey);
        });
        addBill.addClearSelectionListener(evt -> {
            BillList billList = (BillList)evt.getSource();
            String billKey = billList.getKey();
            this.changeNumLabelText(billKey);
        });
        updateBill.addClearSelectionListener(evt -> {
            BillList billList = (BillList)evt.getSource();
            String billKey = billList.getKey();
            this.changeNumLabelText(billKey);
        });
        delBill.addClearSelectionListener(evt -> {
            BillList billList = (BillList)evt.getSource();
            String billKey = billList.getKey();
            this.changeNumLabelText(billKey);
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok", "btnexport"});
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.addSearchClickListener(searchClickEvent -> {
            QFilter addFilters = this.getQueryFilters(Boolean.TRUE);
            QFilter updateFilters = this.getQueryFilters(Boolean.FALSE);
            if (addFilters == null) {
                this.getView().getPageCache().remove("fileFilters");
            } else {
                this.getView().getPageCache().put("fileFilters", addFilters.toString());
            }
            if (updateFilters == null) {
                this.getView().getPageCache().remove("personFilters");
            } else {
                this.getView().getPageCache().put("personFilters", updateFilters.toString());
            }
            this.getView().updateView("tabap");
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList addBill = (BillList)this.getControl("addbill");
        BillList updateBill = (BillList)this.getControl("updatebill");
        BillList delBill = (BillList)this.getControl("delbill");
        addBill.setIndexMode(true);
        updateBill.setIndexMode(true);
        delBill.setIndexMode(true);
        ListGridView addGridView = (ListGridView)this.getControl("addlistgridviewap");
        ListGridView updateGridView = (ListGridView)this.getControl("updatelistgridviewap");
        ListGridView delGridView = (ListGridView)this.getControl("dellistgridviewap");
        addGridView.setPaginationHide(false);
        updateGridView.setPaginationHide(false);
        delGridView.setPaginationHide(false);
        addBill.setQueryType("0");
        updateBill.setQueryType("0");
        delBill.setQueryType("0");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList addBill = (BillList)this.getControl("addbill");
        BillList updateBill = (BillList)this.getControl("updatebill");
        BillList delBill = (BillList)this.getControl("delbill");
        this.selectAllRows("addbill");
        this.selectAllRows("updatebill");
        this.selectAllRows("delbill");
        updateBill.selectAllRows();
        delBill.selectAllRows();
        addBill.selectAllRows();
        int addCount = addBill.queryBillDataCount();
        int updataCount = updateBill.queryBillDataCount();
        int delCount = delBill.queryBillDataCount();
        if (addCount == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toaddap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"toaddap"});
        }
        if (updataCount == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toupdateap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"toupdateap"});
        }
        if (delCount == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"todelap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"todelap"});
        }
        if (addCount <= 0) {
            if (updataCount > 0) {
                Container updateAp = (Container)this.getControl("toupdateap");
                updateAp.click();
            } else if (delCount > 0) {
                Container delAp = (Container)this.getControl("todelap");
                delAp.click();
            }
        }
        ((Label)this.getControl("toaddnum")).setText(this.numLabelText(addCount, addCount));
        ((Label)this.getControl("toupdatenum")).setText(this.numLabelText(updataCount, updataCount));
        ((Label)this.getControl("todelnum")).setText(this.numLabelText(delCount, delCount));
    }

    public void setFilter(SetFilterEvent e) {
        BillList billList = (BillList)e.getSource();
        String billKey = billList.getKey();
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        switch (billKey) {
            case "addbill": {
                JSONArray addJsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("addFileHisIds");
                List addFileHisIds = JSONObject.parseArray((String)addJsonArray.toJSONString(), Long.class);
                QFilter fileIdFilter = new QFilter("id", "in", (Object)addFileHisIds);
                String addFilter = this.getView().getPageCache().get("fileFilters");
                if (addFilter != null) {
                    QFilter qFilter = QFilter.of((String)addFilter, (Object[])new Object[0]);
                    e.getQFilters().add(qFilter);
                }
                e.getQFilters().add(fileIdFilter);
                break;
            }
            case "updatebill": {
                JSONArray updateJsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("updateFileIds");
                List updateFileIds = JSONObject.parseArray((String)updateJsonArray.toJSONString(), Long.class);
                String updateFilters = this.getView().getPageCache().get("fileFilters");
                if (updateFilters != null) {
                    QFilter qFilter = QFilter.of((String)updateFilters, (Object[])new Object[0]);
                    e.getQFilters().add(qFilter);
                }
                QFilter updateFilter = new QFilter("id", "in", (Object)updateFileIds);
                e.getQFilters().add(updateFilter);
                break;
            }
            case "delbill": {
                JSONArray delJsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("delFileIds");
                List delFileIds = JSONObject.parseArray((String)delJsonArray.toJSONString(), Long.class);
                SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
                QFilter taskIdFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
                QFilter boIdFilter = new QFilter("salaryfile.id", "in", (Object)delFileIds);
                DynamicObject[] calPersons = calPersonHelper.query("salaryfilev.id", new QFilter[]{boIdFilter, taskIdFilter});
                List delFileHisIds = Arrays.stream(calPersons).map(o -> o.getLong("salaryfilev.id")).collect(Collectors.toList());
                QFilter delFilter = new QFilter("id", "in", delFileHisIds);
                String delFilters = this.getView().getPageCache().get("fileFilters");
                if (delFilters != null) {
                    QFilter qFilter = QFilter.of((String)delFilters, (Object[])new Object[0]);
                    e.getQFilters().add(qFilter);
                }
                e.getQFilters().add(delFilter);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String apKey = "0";
        if (evt.getSource() instanceof Button) {
            Button button = (Button)evt.getSource();
            apKey = button.getKey();
        } else if (evt.getSource() instanceof Container) {
            Container container = (Container)evt.getSource();
            apKey = container.getKey();
        }
        BillList addBill = (BillList)this.getControl("addbill");
        BillList updateBill = (BillList)this.getControl("updatebill");
        BillList delBill = (BillList)this.getControl("delbill");
        int addSelectRowSize = addBill.getSelectedRows().size();
        int updateSelectRowSize = updateBill.getSelectedRows().size();
        int delSelectRowSize = delBill.getSelectedRows().size();
        switch (apKey) {
            case "toaddap": {
                this.changeLeftStyle(apKey, "toaddlabel", "tabaddap");
                ((Label)this.getControl("tiplabelap")).setText(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4eba\u5458\u6863\u6848\u7b26\u5408\u6838\u7b97\u8303\u56f4\uff0c\u9700\u65b0\u589e\uff0c\u8bf7\u786e\u8ba4\u4eba\u5458\u3002", (String)"CalRefreshListPlugin_11", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "toupdateap": {
                this.changeLeftStyle(apKey, "toupdatelabel", "tabupdateap");
                ((Label)this.getControl("tiplabelap")).setText(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4eba\u5458\u6863\u6848\u4fe1\u606f\u6709\u8c03\u6574\uff0c\u9700\u66f4\u65b0\u5e76\u50a8\u5b58\u7248\u672c\uff0c\u8bf7\u786e\u8ba4\u4eba\u5458\u3002", (String)"CalRefreshListPlugin_12", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "todelap": {
                this.changeLeftStyle(apKey, "todellabel", "tabdelap");
                ((Label)this.getControl("tiplabelap")).setText(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4eba\u5458\u6863\u6848\u4e0d\u7b26\u5408\u6838\u7b97\u8303\u56f4\uff0c\u9700\u5220\u9664\uff0c\u8bf7\u786e\u8ba4\u4eba\u5458\u3002", (String)"CalRefreshListPlugin_13", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "btnexport": {
                if (addSelectRowSize + updateSelectRowSize + delSelectRowSize == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"CalRefreshListPlugin_3", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                this.doExport(addSelectRowSize, updateSelectRowSize, delSelectRowSize, addBill, updateBill, delBill);
                break;
            }
            case "btnok": {
                if (!SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"hsas_calperson", (String)"2B+P9JO85L/T")) {
                    this.getView().showErrorNotification(SWCPermissionServiceHelper.getNoPermTips((String)ResManager.loadKDString((String)"\u6838\u7b97\u540d\u5355", (String)"CalRefreshListPlugin_19", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u66f4\u65b0\u6838\u7b97\u4eba\u5458", (String)"CalRefreshListPlugin_16", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0])));
                    return;
                }
                if (addSelectRowSize + updateSelectRowSize + delSelectRowSize == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u66f4\u65b0\u7684\u6570\u636e\u3002", (String)"CalRefreshListPlugin_4", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                this.doRefresh();
                break;
            }
        }
    }

    public void pageRelease(EventObject e) {
        IFormView view = this.getView();
        Long calTaskId = (Long)view.getFormShowParameter().getCustomParam("calTaskId");
        ISWCAppCache appCache = SWCAppCache.get((String)"cachekey_hsas_calperson_refresh");
        appCache.remove(String.format(Locale.ROOT, "cache_getrefreshlist_progress_%s", calTaskId));
        if (SWCStringUtils.isEmpty((String)view.getPageCache().get("release"))) {
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_REFRESH.getOperationKey());
        }
        super.pageRelease(e);
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList billList = (BillList)evt.getSource();
        String billKey = billList.getKey();
        this.changeNumLabelText(billKey);
    }

    private void changeNumLabelText(String billKey) {
        BillList billList = (BillList)this.getControl(billKey);
        switch (billKey) {
            case "addbill": {
                ((Label)this.getControl("toaddnum")).setText(this.numLabelText(billList.queryBillDataCount(), billList.getSelectedRows().size()));
                this.getView().updateView("toaddnum");
                break;
            }
            case "updatebill": {
                ((Label)this.getControl("toupdatenum")).setText(this.numLabelText(billList.queryBillDataCount(), billList.getSelectedRows().size()));
                this.getView().updateView("toupdatenum");
                break;
            }
            case "delbill": {
                ((Label)this.getControl("todelnum")).setText(this.numLabelText(billList.queryBillDataCount(), billList.getSelectedRows().size()));
                this.getView().updateView("todelnum");
                break;
            }
        }
    }

    private String numLabelText(int total, int select) {
        return MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u4eba\uff0c\u5df2\u9009{1}\u4eba", (String)"CalRefreshListPlugin_14", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), total, select);
    }

    private void doRefresh() {
        CalPersonListHelper listHelper = new CalPersonListHelper();
        BillList addBill = (BillList)this.getControl("addbill");
        BillList updateBill = (BillList)this.getControl("updatebill");
        BillList delBill = (BillList)this.getControl("delbill");
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        CloseCallBack closeCallBack = new CloseCallBack("kd.swc.hsas.formplugin.web.calpersonlist.CalPersonListViewPlugin", "doRefreshBack");
        HashMap<String, Object> jobFormInfo = new HashMap<String, Object>(16);
        jobFormInfo.put("calTaskId", calTaskId);
        String calTaskName = (String)this.getView().getFormShowParameter().getCustomParam("calTaskName");
        String taskName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u66f4\u65b0\u6838\u7b97\u4eba\u5458_%s", (String)"CalRefreshListPlugin_5", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), calTaskName);
        jobFormInfo.put("taskName", taskName);
        FormShowParameter formShowParameter = listHelper.getProgressView(jobFormInfo, "hsas_caldorefreshprog", closeCallBack);
        List addSalaryFileHisIds = CalPersonListHelper.getSelectedPkid((BillList)addBill);
        List updateSalaryFileHisIds = CalPersonListHelper.getSelectedPkid((BillList)updateBill);
        List delCalPersonIds = CalPersonListHelper.getSelectedPkid((BillList)delBill);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u66f4\u65b0\u6838\u7b97\u4eba\u5458", (String)"CalRefreshListPlugin_16", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
        formShowParameter.setCustomParam("calTaskId", (Object)calTaskId);
        formShowParameter.setCustomParam("refreshTotalNum", (Object)(addSalaryFileHisIds.size() + updateSalaryFileHisIds.size() + delCalPersonIds.size()));
        String errorCode = (String)SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"ICalPersonService", (String)"updateCalPerson", (Object[])new Object[]{calTaskId, addSalaryFileHisIds, delCalPersonIds, updateSalaryFileHisIds});
        if (SWCStringUtils.isNotEmpty((String)errorCode)) {
            this.getView().showErrorNotification(CalPersonLockEnum.getDesc((String)errorCode));
            return;
        }
        this.getView().getParentView().showForm(formShowParameter);
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().getPageCache().put("release", "false");
        this.getView().close();
    }

    private Map<String, Object> inActiveCustomMap(String key) {
        HashMap<String, Object> ctl = new HashMap<String, Object>(16);
        ctl.put("id", key);
        ctl.put("cstyles", "");
        return ctl;
    }

    private Map<String, Object> activeCustomMap(String key) {
        HashMap<String, Object> ctl = new HashMap<String, Object>(16);
        ctl.put("id", key);
        ctl.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbiAgICAgIGJvcmRlci1sZWZ0OjNweCBzb2xpZCAndGhlbWVDb2xvcicgIWltcG9ydGFudDtcbiAgICAgIGJhY2tncm91bmQtY29sb3I6IHdoaXRlICFpbXBvcnRhbnQ7XG4gICAgICBib3JkZXItcmlnaHQ6MHB4ICFpbXBvcnRhbnQ7XG4gICAgICBib3JkZXItYm90dG9tOjFweCBzb2xpZCAjZDlkOWQ5ICFpbXBvcnRhbnQ7XG4gICAgICBib3JkZXItdG9wOjFweCBzb2xpZCAjZDlkOWQ5ICFpbXBvcnRhbnQ7XG59In0=");
        return ctl;
    }

    private Map<String, Object> bolderCustomMap(String key) {
        HashMap<String, Object> ctl = new HashMap<String, Object>(16);
        ctl.put("id", key);
        ctl.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbiAgZm9udC13ZWlnaHQ6ODAwO1xufSJ9");
        return ctl;
    }

    private Map<String, Object> addLabelActiveCustomMap(String key) {
        HashMap<String, Object> ctl = new HashMap<String, Object>(16);
        ctl.put("id", key);
        ctl.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbiAgXHRib3JkZXItbGVmdDozcHggc29saWQgJ3RoZW1lQ29sb3InICFpbXBvcnRhbnQ7XG5cdGJhY2tncm91bmQtY29sb3I6IHdoaXRlICFpbXBvcnRhbnQ7XG4gIFx0Ym9yZGVyLXJpZ2h0OjBweCAhaW1wb3J0YW50O1xuICAgIGJvcmRlci1ib3R0b206MXB4IHNvbGlkICNkOWQ5ZDkgIWltcG9ydGFudDtcbn0ifQ==");
        return ctl;
    }

    private void selectAllRows(String billKey) {
        BillList billList = (BillList)this.getControl(billKey);
        int rowCount = billList.queryBillDataCount();
        int[] indexs = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            indexs[i] = i;
        }
        billList.selectRows(indexs);
        logger.info("{} datacount {}", (Object)billKey, (Object)rowCount);
    }

    private QFilter getQueryFilters(Boolean isAdd) {
        QFilter[] fFilter;
        HSASCalListFilterParser parser = new HSASCalListFilterParser();
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        Map filterValues = filterContainer.getCachedFilterValues().createMapFilterValues();
        List fastFilter = new ArrayList(10);
        if (filterValues.get("fastfilter") != null) {
            fastFilter = (List)filterValues.get("fastfilter");
        }
        if ((fFilter = parser.parseFastFilterUseAnd(fastFilter)) != null) {
            if (isAdd.booleanValue()) {
                QFilter[] addFilters = new QFilter[]{};
                for (QFilter qf : fFilter) {
                    String qfString = qf.toString().replaceAll("filenumber", "number").replaceAll("name", "employee.person.name").replaceAll("empnumber", "employee.empnumber");
                    QFilter qFilter = QFilter.of((String)qfString, (Object[])new Object[0]);
                    qFilter = this.margeFilter(qFilter, addFilters);
                    addFilters = new QFilter[]{qFilter};
                }
                return addFilters[0];
            }
            QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
            filter = this.margeFilter(filter, fFilter);
            QFilter[] filters = new QFilter[]{filter};
            return filters[0];
        }
        return null;
    }

    private QFilter margeFilter(QFilter filter, QFilter[] filters) {
        if (filters != null) {
            for (QFilter qFilter : filters) {
                filter = filter == null ? qFilter : filter.and(qFilter);
            }
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport(int addSelectRowSize, int updateSelectRowSize, int delSelectRowSize, BillList addBill, BillList updateBill, BillList delBill) {
        DynamicObject[] dynamicObjects;
        QFilter idFilter;
        List selectedRowIdList;
        SXSSFSheet sheet;
        SXSSFWorkbook wb = new SXSSFWorkbook();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        if (addSelectRowSize > 0) {
            sheet = wb.createSheet(this.addPerson);
            this.writerHeader(sheet, wb);
            selectedRowIdList = CalPersonListHelper.getSelectedPkid((BillList)addBill);
            idFilter = new QFilter("id", "in", (Object)selectedRowIdList);
            dynamicObjects = helper.query("org.name,payrollgroup.name,modifytime,modifier.name,bsled,datastatus,createtime,creator.name,managingscope.managingscope.name,startpaydate,empgroup.name,adminorg.name,depcytype.name,payrollregion.name,paystatus,hisversion,number,employee.person.name,employee.person.number,status,bsed,salarycalcstyle.name", new QFilter[]{idFilter});
            this.writerContent(sheet, wb.createCellStyle(), dynamicObjects);
        }
        if (updateSelectRowSize > 0) {
            sheet = wb.createSheet(this.updatePerson);
            this.writerHeader(sheet, wb);
            selectedRowIdList = CalPersonListHelper.getSelectedPkid((BillList)updateBill);
            idFilter = new QFilter("id", "in", (Object)selectedRowIdList);
            dynamicObjects = helper.query("org.name,payrollgroup.name,modifytime,modifier.name,bsled,datastatus,createtime,creator.name,managingscope.managingscope.name,startpaydate,empgroup.name,adminorg.name,depcytype.name,payrollregion.name,paystatus,hisversion,number,employee.person.name,employee.person.number,status,bsed,salarycalcstyle.name", new QFilter[]{idFilter});
            this.writerContent(sheet, wb.createCellStyle(), dynamicObjects);
        }
        if (delSelectRowSize > 0) {
            sheet = wb.createSheet(this.delPerson);
            this.writerHeader(sheet, wb);
            selectedRowIdList = CalPersonListHelper.getSelectedPkid((BillList)delBill);
            idFilter = new QFilter("id", "in", (Object)selectedRowIdList);
            dynamicObjects = helper.query("org.name,payrollgroup.name,modifytime,modifier.name,bsled,datastatus,createtime,creator.name,managingscope.managingscope.name,startpaydate,empgroup.name,adminorg.name,depcytype.name,payrollregion.name,paystatus,hisversion,number,employee.person.name,employee.person.number,status,bsed,salarycalcstyle.name", new QFilter[]{idFilter});
            this.writerContent(sheet, wb.createCellStyle(), dynamicObjects);
        }
        String exportUrl = null;
        try {
            exportUrl = this.writeFile(wb);
        }
        catch (IOException e) {
            logger.error("calperson refreshlist export error", (Throwable)e);
        }
        finally {
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error("calperson refreshlist export wb close error", (Throwable)e);
            }
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        if (exportUrl != null) {
            clientViewProxy.addAction("download", (Object)exportUrl);
            MultiLangEnumBridge opbridge = new MultiLangEnumBridge("\u5bfc\u51fa", "CalRefreshListPlugin_17", SWC_HSAS_FORMPLUGIN);
            MultiLangEnumBridge bridge = new MultiLangEnumBridge("\u5bfc\u51fa\u66f4\u65b0\u5185\u5bb9\u6210\u529f\u3002", "CalRefreshListPlugin_18", SWC_HSAS_FORMPLUGIN);
            SWCOpLogServiceHelper.addOpLog((String)"hsas", (String)"hsas_calperson", (String)"export", (MultiLangEnumBridge)opbridge, (String)"", (MultiLangEnumBridge)bridge, (String[])new String[0]);
        }
    }

    private void writerHeader(SXSSFSheet sheet, SXSSFWorkbook wb) {
        ListGridView listGridView = (ListGridView)this.getControl("addlistgridviewap");
        List items = listGridView.getItems();
        CellStyle cellStyle = this.getHeadColumnStyle(wb);
        SXSSFRow headRow = CalRefreshListPlugin.getRow(sheet, 0);
        int i = 0;
        for (Control control : items) {
            ListColumn listColumn = (ListColumn)control;
            if (SWCStringUtils.equals((String)listColumn.getListFieldKey(), (String)"fseq")) continue;
            CalRefreshListPlugin.createCell(headRow, i, cellStyle).setCellValue(listColumn.getCaption().getLocaleValue());
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 4);
            ++i;
        }
    }

    private void writerContent(SXSSFSheet sheet, CellStyle style, DynamicObject[] dynamicObjects) {
        style.setWrapText(false);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dy = dynamicObjects[i];
            SXSSFRow contentRow = CalRefreshListPlugin.getRow(sheet, i + 1);
            List<String> columnFields = salaryFileColumnFields;
            for (int j = 0; j < columnFields.size(); ++j) {
                Date date;
                String fieldKey = columnFields.get(j);
                String content = "";
                MainEntityType calTask = EntityMetadataCache.getDataEntityType((String)"hsas_salaryfile");
                if (SWCStringUtils.equals((String)fieldKey, (String)"status") || SWCStringUtils.equals((String)fieldKey, (String)"datastatus") || SWCStringUtils.equalsIgnoreCase((String)fieldKey, (String)"payStatus")) {
                    ComboProp taskTypeCombo = (ComboProp)calTask.getProperties().get((Object)fieldKey);
                    List comboItems = taskTypeCombo.getComboItems();
                    for (ValueMapItem item : comboItems) {
                        if (!item.getValue().equals(dy.getString(fieldKey))) continue;
                        content = item.getName().getLocaleValue();
                    }
                } else if (SWCStringUtils.equals((String)fieldKey, (String)"bsed") || SWCStringUtils.equals((String)fieldKey, (String)"bsled")) {
                    date = dy.getDate(fieldKey);
                    if (date != null) {
                        content = SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
                    }
                } else if (SWCStringUtils.equals((String)fieldKey, (String)"startpaydate")) {
                    date = dy.getDate(fieldKey);
                    if (date != null) {
                        content = SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM");
                    }
                } else {
                    content = dy.getString(fieldKey);
                }
                CalRefreshListPlugin.createCell(contentRow, j, style).setCellValue(content);
            }
        }
    }

    private static SXSSFCell createCell(SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        return cell;
    }

    private static SXSSFRow getRow(SXSSFSheet sheet, int rowIndex) {
        SXSSFRow row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    private void makeSheet(SXSSFWorkbook wb, CellStyle style, BillList billList, String sheetName) {
        SXSSFSheet sheet = wb.createSheet(sheetName);
        this.writerHeader(sheet, wb);
        List selectedRowIdList = CalPersonListHelper.getSelectedPkid((BillList)billList);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter idFilter = new QFilter("id", "in", (Object)selectedRowIdList);
        DynamicObject[] dynamicObjects = helper.query("filenumber,name,empnumber,salaryfilev.bsed,salaryfilev.salarycalcstyle.name", new QFilter[]{idFilter});
        this.writerContent(sheet, style, dynamicObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(SXSSFWorkbook wb) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String calTaskName = this.getView().getParentView().getPageCache().get("calTaskName");
            LocalDate now = LocalDate.now();
            String date = String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
            String fileName = MessageFormat.format(ResManager.loadKDString((String)"\u6838\u7b97\u540d\u5355\u66f4\u65b0\u5185\u5bb9\u5bfc\u51fa_{0}_{1}", (String)"CalRefreshListPlugin_10", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), calTaskName, date) + EXCEL_SUFFIX;
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (null != outStream) {
                outStream.close();
            }
            if (null != inStream) {
                inStream.close();
            }
        }
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setWrapText(false);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(false);
        return headColumnStyle;
    }

    private void changeLeftStyle(String apKey, String labelKey, String tabKey) {
        this.getView().updateControlMetadata("toaddap", this.inActiveCustomMap("toaddap"));
        this.getView().updateControlMetadata("toupdateap", this.inActiveCustomMap("toupdateap"));
        this.getView().updateControlMetadata("todelap", this.inActiveCustomMap("todelap"));
        if (SWCStringUtils.equals((String)apKey, (String)"toaddap")) {
            this.getView().updateControlMetadata(apKey, this.addLabelActiveCustomMap(apKey));
        } else {
            this.getView().updateControlMetadata(apKey, this.activeCustomMap(apKey));
        }
        this.getView().updateControlMetadata("toaddlabel", this.inActiveCustomMap("toaddlabel"));
        this.getView().updateControlMetadata("toupdatelabel", this.inActiveCustomMap("toupdatelabel"));
        this.getView().updateControlMetadata("todellabel", this.inActiveCustomMap("todellabel"));
        this.getView().updateControlMetadata(labelKey, this.bolderCustomMap(labelKey));
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab(tabKey);
    }

    static {
        salaryFileColumnFields.add("hisversion");
        salaryFileColumnFields.add("number");
        salaryFileColumnFields.add("employee.person.name");
        salaryFileColumnFields.add("employee.empnumber");
        salaryFileColumnFields.add("status");
        salaryFileColumnFields.add("paystatus");
        salaryFileColumnFields.add("salarycalcstyle.name");
        salaryFileColumnFields.add("org.name");
        salaryFileColumnFields.add("payrollregion.name");
        salaryFileColumnFields.add("payrollgroup.name");
        salaryFileColumnFields.add("depcytype.name");
        salaryFileColumnFields.add("adminorg.name");
        salaryFileColumnFields.add("empgroup.name");
        salaryFileColumnFields.add("startpaydate");
        salaryFileColumnFields.add("managingscope.managingscope.name");
        salaryFileColumnFields.add("creator.name");
        salaryFileColumnFields.add("createtime");
        salaryFileColumnFields.add("datastatus");
        salaryFileColumnFields.add("bsed");
        salaryFileColumnFields.add("bsled");
        salaryFileColumnFields.add("modifier.name");
        salaryFileColumnFields.add("modifytime");
    }
}

