/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.cal.helper.CalResultCoverHelper;
import kd.swc.hsas.business.cal.service.ResultCoverService;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalResultCoverImportViewPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BTN_DOWNLOAD = "btndownload";
    private static final String KEY_BTN_RESETFILE = "btnresetfile";
    private static final String KEY_BTN_UPLOAD = "btnupload";

    public void initialize() {
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_DOWNLOAD, KEY_BTN_RESETFILE});
        Image label = (Image)this.getControl(KEY_BTN_UPLOAD);
        label.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"keyfields"});
        Label title = (Label)this.getControl("title");
        String coverType = this.getCoverType();
        String titleStr = SWCStringUtils.equals((String)"2", (String)coverType) ? ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6", (String)"CalResultCoverImportViewPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5206\u6bb5\u8986\u76d6\u6570\u636e", (String)"CalResultCoverImportViewPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        title.setText(titleStr);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        if ("importtype".equalsIgnoreCase(propertyName)) {
            this.getView().setEnable(Boolean.valueOf(!"new".equalsIgnoreCase((String)args.getChangeSet()[0].getNewValue())), new String[]{"keyfields"});
        }
    }

    public void click(EventObject evt) {
        if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"4730fc9f000003ae")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6838\u7b97\u540d\u5355\u201d\u7684\u201c\u5bfc\u5165\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalResultCoverImportViewPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                Long taskId = this.getTaskId();
                String coverType = this.getCoverType();
                ResultCoverService resultCoverService = CalResultCoverHelper.getResultCoverService((String)coverType);
                Boolean taxCalEnable = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)taskId);
                resultCoverService.exportExcelTemplate(this.getView(), taxCalEnable);
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f\u3002", "CalResultCoverImportViewPlugin_14", "swc-hsas-formplugin");
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f", "CalResultCoverImportViewPlugin_12", "swc-hsas-formplugin");
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)KEY_BTN_DOWNLOAD, (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
                break;
            }
            case "btnresetfile": {
                this.resetFileInfo();
                break;
            }
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            IFormView view = this.getView();
            String url = (String)urls[0];
            view.setVisible(Boolean.TRUE, new String[]{"filepanel"});
            view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
            IDataModel model = this.getModel();
            String fileName = url.substring(url.lastIndexOf(47) + 1);
            model.setValue("filename", (Object)fileName);
            String fullUrl = UrlService.getAttachmentFullUrl((String)url);
            model.setValue("filepath", (Object)url);
            model.setValue("fullpath", (Object)fullUrl);
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u6587\u4ef6{0}\u5df2\u6210\u529f\u4e0a\u4f20\u3002", "CalResultCoverImportViewPlugin_11", "swc-hsas-formplugin");
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4e0a\u4f20\u6587\u4ef6", "CalResultCoverImportViewPlugin_13", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)KEY_BTN_DOWNLOAD, (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{fileName});
        }
    }

    private String getCoverType() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        return (String)parameter.getCustomParam("coverType");
    }

    private Long getTaskId() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taskId = (Long)parameter.getCustomParam("taskId");
        return taskId;
    }

    private String getTaskName() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String taskId = (String)parameter.getCustomParam("taskName");
        return taskId;
    }

    private String getPageId() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String pageId = (String)parameter.getCustomParam("pageId");
        return pageId;
    }

    private void resetFileInfo() {
        this.getModel().setValue("filename", (Object)"");
        this.getModel().setValue("filepath", (Object)"");
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
    }

    private void importData() {
        String url = this.getModel().getDataEntity().getString("filepath");
        String fullPath = (String)this.getModel().getValue("fullpath");
        String coverType = this.getCoverType();
        ArrayList dataHead = Lists.newArrayListWithCapacity((int)10);
        ArrayList dataRow = Lists.newArrayListWithCapacity((int)10);
        CalResultCoverHelper.readExcelData((String)url, (List)dataHead, (List)dataRow);
        ResultCoverService service = CalResultCoverHelper.getResultCoverService((String)coverType);
        boolean check = service.checkExcelTemplate((List)dataHead, this.getTaskId());
        if (!check) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u6709\u8bef\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684\u6a21\u677f\u586b\u5199\u5e76\u5bfc\u5165\u3002", (String)"CalResultCoverImportViewPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean duplicate = service.checkItemDuplicate((Map)dataHead.get(2));
        if (!duplicate) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u5b58\u5728\u91cd\u590d\u7684\u85aa\u916c\u9879\u76ee\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"CalResultCoverImportViewPlugin_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"CalResultCoverImportViewPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.initFloatingTask(dataRow.size());
        HashMap returnData = Maps.newHashMapWithExpectedSize((int)3);
        returnData.put("isOk", Boolean.TRUE);
        returnData.put("url", url);
        returnData.put("fullPath", fullPath);
        returnData.put("coverType", coverType);
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }

    private void initFloatingTask(int total) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String name = ResManager.loadKDString((String)"\u7ed3\u679c\u8986\u76d6\u6570\u636e\u5bfc\u5165-{0}", (String)"CalResultCoverImportViewPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[]{this.getTaskName()});
        Long taskId = this.getTaskId();
        String pageId = this.getPageId();
        params.put("progressType", "22");
        params.put("taskId", taskId);
        params.put("total", total);
        params.put("coverType", this.getCoverType());
        String bgTaskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_hsas_resultcover_import", name, true, pageId, params);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "resultcoverimport_bggroud_taskid_%s", taskId));
        appCache.put("bgTaskId", (Object)bgTaskId);
    }
}

